/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.windows.wgl;

import com.jogamp.nativewindow.AbstractGraphicsScreen;
import com.jogamp.nativewindow.DefaultGraphicsScreen;
import com.jogamp.nativewindow.NativeSurface;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import jogamp.nativewindow.WrappedSurface;
import jogamp.nativewindow.windows.GDI;
import jogamp.opengl.windows.wgl.WGL;
import jogamp.opengl.windows.wgl.WGLUtil;
import jogamp.opengl.windows.wgl.WindowsWGLContext;
import jogamp.opengl.windows.wgl.WindowsWGLDrawable;
import jogamp.opengl.windows.wgl.WindowsWGLGraphicsConfiguration;

public class WindowsExternalWGLDrawable
extends WindowsWGLDrawable {
    private WindowsExternalWGLDrawable(GLDrawableFactory gLDrawableFactory, NativeSurface nativeSurface) {
        super(gLDrawableFactory, nativeSurface, true);
    }

    protected static WindowsExternalWGLDrawable create(GLDrawableFactory gLDrawableFactory, GLProfile gLProfile) {
        long l2 = WGL.wglGetCurrentDC();
        if (0L == l2) {
            throw new GLException("Error: attempted to make an external GLDrawable without a drawable current, werr " + GDI.GetLastError());
        }
        int n2 = WGLUtil.GetPixelFormat(l2);
        if (n2 == 0) {
            throw new GLException("Error: attempted to make an external GLContext without a valid pixelformat, werr " + GDI.GetLastError());
        }
        AbstractGraphicsScreen abstractGraphicsScreen = DefaultGraphicsScreen.createDefault(".windows");
        WindowsWGLGraphicsConfiguration windowsWGLGraphicsConfiguration = WindowsWGLGraphicsConfiguration.createFromExternal(gLDrawableFactory, l2, n2, gLProfile, abstractGraphicsScreen, true);
        return new WindowsExternalWGLDrawable(gLDrawableFactory, new WrappedSurface(windowsWGLGraphicsConfiguration, l2, 64, 64, true));
    }

    @Override
    public GLContext createContext(GLContext gLContext) {
        return new WindowsWGLContext(this, gLContext);
    }

    public void setSize(int n2, int n3) {
        throw new GLException("Should not call this");
    }

    @Override
    public int getSurfaceWidth() {
        throw new GLException("Should not call this");
    }

    @Override
    public int getSurfaceHeight() {
        throw new GLException("Should not call this");
    }
}

