/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.windows.wgl;

import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.MutableSurface;
import com.jogamp.nativewindow.NativeSurface;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import jogamp.nativewindow.windows.BITMAPINFO;
import jogamp.nativewindow.windows.BITMAPINFOHEADER;
import jogamp.nativewindow.windows.GDI;
import jogamp.opengl.GLGraphicsConfigurationUtil;
import jogamp.opengl.windows.wgl.WindowsWGLContext;
import jogamp.opengl.windows.wgl.WindowsWGLDrawable;
import jogamp.opengl.windows.wgl.WindowsWGLGraphicsConfiguration;

public class WindowsBitmapWGLDrawable
extends WindowsWGLDrawable {
    private long origbitmap;
    private long hbitmap;

    private WindowsBitmapWGLDrawable(GLDrawableFactory gLDrawableFactory, NativeSurface nativeSurface) {
        super(gLDrawableFactory, nativeSurface, false);
    }

    protected static WindowsBitmapWGLDrawable create(GLDrawableFactory gLDrawableFactory, NativeSurface nativeSurface) {
        GLCapabilitiesImmutable gLCapabilitiesImmutable;
        GLCapabilitiesImmutable gLCapabilitiesImmutable2;
        WindowsWGLGraphicsConfiguration windowsWGLGraphicsConfiguration = (WindowsWGLGraphicsConfiguration)nativeSurface.getGraphicsConfiguration();
        AbstractGraphicsDevice abstractGraphicsDevice = windowsWGLGraphicsConfiguration.getScreen().getDevice();
        if (!GLProfile.isAvailable(abstractGraphicsDevice, "GL2")) {
            throw new GLException("GLProfile GL2 n/a on " + abstractGraphicsDevice + " but required for Windows BITMAP");
        }
        GLProfile gLProfile = GLProfile.get("GL2");
        GLCapabilitiesImmutable gLCapabilitiesImmutable3 = (GLCapabilitiesImmutable)windowsWGLGraphicsConfiguration.getChosenCapabilities();
        if (gLCapabilitiesImmutable3 != (gLCapabilitiesImmutable2 = GLGraphicsConfigurationUtil.fixGLProfile(gLCapabilitiesImmutable = GLGraphicsConfigurationUtil.clipRGBAGLCapabilities(gLCapabilitiesImmutable3, false, false), gLProfile))) {
            windowsWGLGraphicsConfiguration.setChosenCapabilities(gLCapabilitiesImmutable2);
            if (DEBUG) {
                System.err.println("WindowsBitmapWGLDrawable: " + gLCapabilitiesImmutable3 + " -> " + gLCapabilitiesImmutable2);
            }
        }
        return new WindowsBitmapWGLDrawable(gLDrawableFactory, nativeSurface);
    }

    @Override
    protected void setRealizedImpl() {
        if (this.realized) {
            this.createBitmap();
        } else {
            this.destroyBitmap();
        }
    }

    @Override
    public GLContext createContext(GLContext gLContext) {
        return new WindowsWGLContext(this, gLContext);
    }

    @Override
    public boolean isGLOriented() {
        return false;
    }

    private void createBitmap() {
        long l2;
        NativeSurface nativeSurface = this.getNativeSurface();
        if (DEBUG) {
            System.err.println(WindowsBitmapWGLDrawable.getThreadName() + ": WindowsBitmapWGLDrawable (1): " + nativeSurface);
        }
        WindowsWGLGraphicsConfiguration windowsWGLGraphicsConfiguration = (WindowsWGLGraphicsConfiguration)nativeSurface.getGraphicsConfiguration();
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)windowsWGLGraphicsConfiguration.getChosenCapabilities();
        int n2 = this.getSurfaceWidth();
        int n3 = this.getSurfaceHeight();
        BITMAPINFO bITMAPINFO = BITMAPINFO.create();
        BITMAPINFOHEADER bITMAPINFOHEADER = bITMAPINFO.getBmiHeader();
        int n4 = gLCapabilitiesImmutable.getRedBits() + gLCapabilitiesImmutable.getGreenBits() + gLCapabilitiesImmutable.getBlueBits();
        int n5 = 24;
        bITMAPINFOHEADER.setBiSize(BITMAPINFOHEADER.size());
        bITMAPINFOHEADER.setBiWidth(n2);
        bITMAPINFOHEADER.setBiHeight(-1 * n3);
        bITMAPINFOHEADER.setBiPlanes((short)1);
        bITMAPINFOHEADER.setBiBitCount((short)n5);
        bITMAPINFOHEADER.setBiXPelsPerMeter(0);
        bITMAPINFOHEADER.setBiYPelsPerMeter(0);
        bITMAPINFOHEADER.setBiClrUsed(0);
        bITMAPINFOHEADER.setBiClrImportant(0);
        bITMAPINFOHEADER.setBiCompression(0);
        int n6 = n2 * n3 * (n5 >> 3);
        bITMAPINFOHEADER.setBiSizeImage(n6);
        PointerBuffer pointerBuffer = PointerBuffer.allocateDirect(1);
        this.hbitmap = GDI.CreateDIBSection(0L, bITMAPINFO, 0, pointerBuffer, 0L, 0);
        int n7 = GDI.GetLastError();
        if (DEBUG) {
            l2 = pointerBuffer.capacity() > 0 ? pointerBuffer.get(0) : 0L;
            System.err.println("WindowsBitmapWGLDrawable: pb sz/ptr " + pointerBuffer.capacity() + ", " + WindowsBitmapWGLDrawable.toHexString(l2));
            System.err.println("WindowsBitmapWGLDrawable: " + n2 + "x" + n3 + ", bpp " + n4 + " -> " + n5 + ", bytes " + n6 + ", header sz " + BITMAPINFOHEADER.size() + ", DIB ptr num " + pointerBuffer.capacity() + ", " + gLCapabilitiesImmutable + ", werr " + n7);
        }
        if (this.hbitmap == 0L) {
            throw new GLException("Error creating offscreen bitmap of " + nativeSurface + ", werr " + n7);
        }
        l2 = GDI.CreateCompatibleDC(0L);
        n7 = GDI.GetLastError();
        if (l2 == 0L) {
            GDI.DeleteObject(this.hbitmap);
            this.hbitmap = 0L;
            throw new GLException("Error creating device context for offscreen OpenGL context, werr " + n7);
        }
        ((MutableSurface)nativeSurface).setSurfaceHandle(l2);
        if (DEBUG) {
            System.err.println(WindowsBitmapWGLDrawable.getThreadName() + ": WindowsBitmapWGLDrawable (2): " + nativeSurface);
        }
        if ((this.origbitmap = GDI.SelectObject(l2, this.hbitmap)) == 0L) {
            GDI.DeleteObject(this.hbitmap);
            this.hbitmap = 0L;
            GDI.DeleteDC(l2);
            l2 = 0L;
            throw new GLException("Error selecting bitmap into new device context");
        }
        windowsWGLGraphicsConfiguration.updateGraphicsConfiguration(this.getFactory(), nativeSurface, null);
    }

    protected void destroyBitmap() {
        NativeSurface nativeSurface = this.getNativeSurface();
        if (nativeSurface.getSurfaceHandle() != 0L) {
            GDI.SelectObject(nativeSurface.getSurfaceHandle(), this.origbitmap);
            GDI.DeleteObject(this.hbitmap);
            GDI.DeleteDC(nativeSurface.getSurfaceHandle());
            this.origbitmap = 0L;
            this.hbitmap = 0L;
            ((MutableSurface)nativeSurface).setSurfaceHandle(0L);
        }
    }
}

