/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.pngj.chunks;

import jogamp.opengl.util.pngj.ImageInfo;
import jogamp.opengl.util.pngj.PngHelperInternal;
import jogamp.opengl.util.pngj.PngjException;
import jogamp.opengl.util.pngj.chunks.ChunkRaw;
import jogamp.opengl.util.pngj.chunks.PngChunk;
import jogamp.opengl.util.pngj.chunks.PngChunkSingle;

public class PngChunkSBIT
extends PngChunkSingle {
    public static final String ID = "sBIT";
    private int graysb;
    private int alphasb;
    private int redsb;
    private int greensb;
    private int bluesb;

    public PngChunkSBIT(ImageInfo imageInfo) {
        super(ID, imageInfo);
    }

    @Override
    public PngChunk.ChunkOrderingConstraint getOrderingConstraint() {
        return PngChunk.ChunkOrderingConstraint.BEFORE_PLTE_AND_IDAT;
    }

    private int getLen() {
        int n2;
        int n3 = n2 = this.imgInfo.greyscale ? 1 : 3;
        if (this.imgInfo.alpha) {
            ++n2;
        }
        return n2;
    }

    @Override
    public void parseFromRaw(ChunkRaw chunkRaw) {
        if (chunkRaw.len != this.getLen()) {
            throw new PngjException("bad chunk length " + chunkRaw);
        }
        if (this.imgInfo.greyscale) {
            this.graysb = PngHelperInternal.readInt1fromByte(chunkRaw.data, 0);
            if (this.imgInfo.alpha) {
                this.alphasb = PngHelperInternal.readInt1fromByte(chunkRaw.data, 1);
            }
        } else {
            this.redsb = PngHelperInternal.readInt1fromByte(chunkRaw.data, 0);
            this.greensb = PngHelperInternal.readInt1fromByte(chunkRaw.data, 1);
            this.bluesb = PngHelperInternal.readInt1fromByte(chunkRaw.data, 2);
            if (this.imgInfo.alpha) {
                this.alphasb = PngHelperInternal.readInt1fromByte(chunkRaw.data, 3);
            }
        }
    }

    @Override
    public ChunkRaw createRawChunk() {
        ChunkRaw chunkRaw = null;
        chunkRaw = this.createEmptyChunk(this.getLen(), true);
        if (this.imgInfo.greyscale) {
            chunkRaw.data[0] = (byte)this.graysb;
            if (this.imgInfo.alpha) {
                chunkRaw.data[1] = (byte)this.alphasb;
            }
        } else {
            chunkRaw.data[0] = (byte)this.redsb;
            chunkRaw.data[1] = (byte)this.greensb;
            chunkRaw.data[2] = (byte)this.bluesb;
            if (this.imgInfo.alpha) {
                chunkRaw.data[3] = (byte)this.alphasb;
            }
        }
        return chunkRaw;
    }

    @Override
    public void cloneDataFromRead(PngChunk pngChunk) {
        PngChunkSBIT pngChunkSBIT = (PngChunkSBIT)pngChunk;
        this.graysb = pngChunkSBIT.graysb;
        this.redsb = pngChunkSBIT.redsb;
        this.greensb = pngChunkSBIT.greensb;
        this.bluesb = pngChunkSBIT.bluesb;
        this.alphasb = pngChunkSBIT.alphasb;
    }

    public void setGraysb(int n2) {
        if (!this.imgInfo.greyscale) {
            throw new PngjException("only greyscale images support this");
        }
        this.graysb = n2;
    }

    public int getGraysb() {
        if (!this.imgInfo.greyscale) {
            throw new PngjException("only greyscale images support this");
        }
        return this.graysb;
    }

    public void setAlphasb(int n2) {
        if (!this.imgInfo.alpha) {
            throw new PngjException("only images with alpha support this");
        }
        this.alphasb = n2;
    }

    public int getAlphasb() {
        if (!this.imgInfo.alpha) {
            throw new PngjException("only images with alpha support this");
        }
        return this.alphasb;
    }

    public void setRGB(int n2, int n3, int n4) {
        if (this.imgInfo.greyscale || this.imgInfo.indexed) {
            throw new PngjException("only rgb or rgba images support this");
        }
        this.redsb = n2;
        this.greensb = n3;
        this.bluesb = n4;
    }

    public int[] getRGB() {
        if (this.imgInfo.greyscale || this.imgInfo.indexed) {
            throw new PngjException("only rgb or rgba images support this");
        }
        return new int[]{this.redsb, this.greensb, this.bluesb};
    }
}

