/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.pngj.chunks;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import jogamp.opengl.util.pngj.ImageInfo;
import jogamp.opengl.util.pngj.PngHelperInternal;
import jogamp.opengl.util.pngj.PngjException;
import jogamp.opengl.util.pngj.chunks.ChunkHelper;
import jogamp.opengl.util.pngj.chunks.ChunkRaw;
import jogamp.opengl.util.pngj.chunks.PngChunk;
import jogamp.opengl.util.pngj.chunks.PngChunkTextVar;

public class PngChunkITXT
extends PngChunkTextVar {
    public static final String ID = "iTXt";
    private boolean compressed = false;
    private String langTag = "";
    private String translatedTag = "";

    public PngChunkITXT(ImageInfo imageInfo) {
        super(ID, imageInfo);
    }

    @Override
    public ChunkRaw createRawChunk() {
        if (this.key.isEmpty()) {
            throw new PngjException("Text chunk key must be non empty");
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(ChunkHelper.toBytes(this.key));
            byteArrayOutputStream.write(0);
            byteArrayOutputStream.write(this.compressed ? 1 : 0);
            byteArrayOutputStream.write(0);
            byteArrayOutputStream.write(ChunkHelper.toBytes(this.langTag));
            byteArrayOutputStream.write(0);
            byteArrayOutputStream.write(ChunkHelper.toBytesUTF8(this.translatedTag));
            byteArrayOutputStream.write(0);
            byte[] byArray = ChunkHelper.toBytesUTF8(this.val);
            if (this.compressed) {
                byArray = ChunkHelper.compressBytes(byArray, true);
            }
            byteArrayOutputStream.write(byArray);
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            ChunkRaw chunkRaw = this.createEmptyChunk(byArray2.length, false);
            chunkRaw.data = byArray2;
            return chunkRaw;
        }
        catch (IOException iOException) {
            throw new PngjException(iOException);
        }
    }

    @Override
    public void parseFromRaw(ChunkRaw chunkRaw) {
        int n2;
        int n3 = 0;
        int[] nArray = new int[3];
        for (n2 = 0; n2 < chunkRaw.data.length; ++n2) {
            if (chunkRaw.data[n2] != 0) continue;
            nArray[n3] = n2;
            if (++n3 == 1) {
                n2 += 2;
            }
            if (n3 == 3) break;
        }
        if (n3 != 3) {
            throw new PngjException("Bad formed PngChunkITXT chunk");
        }
        this.key = ChunkHelper.toString(chunkRaw.data, 0, nArray[0]);
        n2 = nArray[0] + 1;
        this.compressed = chunkRaw.data[n2] != 0;
        if (this.compressed && chunkRaw.data[++n2] != 0) {
            throw new PngjException("Bad formed PngChunkITXT chunk - bad compression method ");
        }
        this.langTag = new String(chunkRaw.data, n2, nArray[1] - n2, PngHelperInternal.charsetLatin1);
        this.translatedTag = new String(chunkRaw.data, nArray[1] + 1, nArray[2] - nArray[1] - 1, PngHelperInternal.charsetUTF8);
        n2 = nArray[2] + 1;
        if (this.compressed) {
            byte[] byArray = ChunkHelper.compressBytes(chunkRaw.data, n2, chunkRaw.data.length - n2, false);
            this.val = ChunkHelper.toStringUTF8(byArray);
        } else {
            this.val = ChunkHelper.toStringUTF8(chunkRaw.data, n2, chunkRaw.data.length - n2);
        }
    }

    @Override
    public void cloneDataFromRead(PngChunk pngChunk) {
        PngChunkITXT pngChunkITXT = (PngChunkITXT)pngChunk;
        this.key = pngChunkITXT.key;
        this.val = pngChunkITXT.val;
        this.compressed = pngChunkITXT.compressed;
        this.langTag = pngChunkITXT.langTag;
        this.translatedTag = pngChunkITXT.translatedTag;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public void setCompressed(boolean bl) {
        this.compressed = bl;
    }

    public String getLangtag() {
        return this.langTag;
    }

    public void setLangtag(String string) {
        this.langTag = string;
    }

    public String getTranslatedTag() {
        return this.translatedTag;
    }

    public void setTranslatedTag(String string) {
        this.translatedTag = string;
    }
}

