/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.pngj.chunks;

import jogamp.opengl.util.pngj.ImageInfo;
import jogamp.opengl.util.pngj.PngHelperInternal;
import jogamp.opengl.util.pngj.PngjException;
import jogamp.opengl.util.pngj.chunks.ChunkRaw;
import jogamp.opengl.util.pngj.chunks.PngChunk;
import jogamp.opengl.util.pngj.chunks.PngChunkSingle;

public class PngChunkGAMA
extends PngChunkSingle {
    public static final String ID = "gAMA";
    private double gamma;

    public PngChunkGAMA(ImageInfo imageInfo) {
        super(ID, imageInfo);
    }

    @Override
    public PngChunk.ChunkOrderingConstraint getOrderingConstraint() {
        return PngChunk.ChunkOrderingConstraint.BEFORE_PLTE_AND_IDAT;
    }

    @Override
    public ChunkRaw createRawChunk() {
        ChunkRaw chunkRaw = this.createEmptyChunk(4, true);
        int n2 = (int)(this.gamma * 100000.0 + 0.5);
        PngHelperInternal.writeInt4tobytes(n2, chunkRaw.data, 0);
        return chunkRaw;
    }

    @Override
    public void parseFromRaw(ChunkRaw chunkRaw) {
        if (chunkRaw.len != 4) {
            throw new PngjException("bad chunk " + chunkRaw);
        }
        int n2 = PngHelperInternal.readInt4fromBytes(chunkRaw.data, 0);
        this.gamma = (double)n2 / 100000.0;
    }

    @Override
    public void cloneDataFromRead(PngChunk pngChunk) {
        this.gamma = ((PngChunkGAMA)pngChunk).gamma;
    }

    public double getGamma() {
        return this.gamma;
    }

    public void setGamma(double d2) {
        this.gamma = d2;
    }
}

