/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.pngj.chunks;

import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import jogamp.opengl.util.pngj.ImageInfo;
import jogamp.opengl.util.pngj.PngjExceptionInternal;
import jogamp.opengl.util.pngj.chunks.ChunkHelper;
import jogamp.opengl.util.pngj.chunks.ChunkRaw;
import jogamp.opengl.util.pngj.chunks.PngChunkBKGD;
import jogamp.opengl.util.pngj.chunks.PngChunkCHRM;
import jogamp.opengl.util.pngj.chunks.PngChunkGAMA;
import jogamp.opengl.util.pngj.chunks.PngChunkHIST;
import jogamp.opengl.util.pngj.chunks.PngChunkICCP;
import jogamp.opengl.util.pngj.chunks.PngChunkIDAT;
import jogamp.opengl.util.pngj.chunks.PngChunkIEND;
import jogamp.opengl.util.pngj.chunks.PngChunkIHDR;
import jogamp.opengl.util.pngj.chunks.PngChunkITXT;
import jogamp.opengl.util.pngj.chunks.PngChunkOFFS;
import jogamp.opengl.util.pngj.chunks.PngChunkPHYS;
import jogamp.opengl.util.pngj.chunks.PngChunkPLTE;
import jogamp.opengl.util.pngj.chunks.PngChunkSBIT;
import jogamp.opengl.util.pngj.chunks.PngChunkSPLT;
import jogamp.opengl.util.pngj.chunks.PngChunkSRGB;
import jogamp.opengl.util.pngj.chunks.PngChunkSTER;
import jogamp.opengl.util.pngj.chunks.PngChunkTEXT;
import jogamp.opengl.util.pngj.chunks.PngChunkTIME;
import jogamp.opengl.util.pngj.chunks.PngChunkTRNS;
import jogamp.opengl.util.pngj.chunks.PngChunkUNKNOWN;
import jogamp.opengl.util.pngj.chunks.PngChunkZTXT;

public abstract class PngChunk {
    public final String id;
    public final boolean crit;
    public final boolean pub;
    public final boolean safe;
    protected final ImageInfo imgInfo;
    private boolean priority = false;
    protected int chunkGroup = -1;
    protected int length = -1;
    protected long offset = 0L;
    private static final Map<String, Class<? extends PngChunk>> factoryMap = new HashMap<String, Class<? extends PngChunk>>();

    public static void factoryRegister(String string, Class<? extends PngChunk> clazz) {
        factoryMap.put(string, clazz);
    }

    public static boolean isKnown(String string) {
        return factoryMap.containsKey(string);
    }

    protected PngChunk(String string, ImageInfo imageInfo) {
        this.id = string;
        this.imgInfo = imageInfo;
        this.crit = ChunkHelper.isCritical(string);
        this.pub = ChunkHelper.isPublic(string);
        this.safe = ChunkHelper.isSafeToCopy(string);
    }

    public static PngChunk factory(ChunkRaw chunkRaw, ImageInfo imageInfo) {
        PngChunk pngChunk = PngChunk.factoryFromId(ChunkHelper.toString(chunkRaw.idbytes), imageInfo);
        pngChunk.length = chunkRaw.len;
        pngChunk.parseFromRaw(chunkRaw);
        return pngChunk;
    }

    public static PngChunk factoryFromId(String string, ImageInfo imageInfo) {
        PngChunk pngChunk = null;
        try {
            Class<? extends PngChunk> clazz = factoryMap.get(string);
            if (clazz != null) {
                Constructor<? extends PngChunk> constructor = clazz.getConstructor(ImageInfo.class);
                pngChunk = constructor.newInstance(imageInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (pngChunk == null) {
            pngChunk = new PngChunkUNKNOWN(string, imageInfo);
        }
        return pngChunk;
    }

    protected final ChunkRaw createEmptyChunk(int n2, boolean bl) {
        ChunkRaw chunkRaw = new ChunkRaw(n2, ChunkHelper.toBytes(this.id), bl);
        return chunkRaw;
    }

    public static <T extends PngChunk> T cloneChunk(T t2, ImageInfo imageInfo) {
        PngChunk pngChunk = PngChunk.factoryFromId(t2.id, imageInfo);
        if (pngChunk.getClass() != t2.getClass()) {
            throw new PngjExceptionInternal("bad class cloning chunk: " + pngChunk.getClass() + " " + t2.getClass());
        }
        pngChunk.cloneDataFromRead(t2);
        return (T)pngChunk;
    }

    public final int getChunkGroup() {
        return this.chunkGroup;
    }

    public final void setChunkGroup(int n2) {
        this.chunkGroup = n2;
    }

    public boolean hasPriority() {
        return this.priority;
    }

    public void setPriority(boolean bl) {
        this.priority = bl;
    }

    final void write(OutputStream outputStream) {
        ChunkRaw chunkRaw = this.createRawChunk();
        if (chunkRaw == null) {
            throw new PngjExceptionInternal("null chunk ! creation failed for " + this);
        }
        chunkRaw.writeChunk(outputStream);
    }

    public int getLength() {
        return this.length;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long l2) {
        this.offset = l2;
    }

    public abstract ChunkRaw createRawChunk();

    public abstract void parseFromRaw(ChunkRaw var1);

    public abstract void cloneDataFromRead(PngChunk var1);

    public abstract boolean allowsMultiple();

    public abstract ChunkOrderingConstraint getOrderingConstraint();

    public String toString() {
        return "chunk id= " + this.id + " (len=" + this.length + " offset=" + this.offset + ") c=" + this.getClass().getSimpleName();
    }

    static {
        factoryMap.put("IDAT", PngChunkIDAT.class);
        factoryMap.put("IHDR", PngChunkIHDR.class);
        factoryMap.put("PLTE", PngChunkPLTE.class);
        factoryMap.put("IEND", PngChunkIEND.class);
        factoryMap.put("tEXt", PngChunkTEXT.class);
        factoryMap.put("iTXt", PngChunkITXT.class);
        factoryMap.put("zTXt", PngChunkZTXT.class);
        factoryMap.put("bKGD", PngChunkBKGD.class);
        factoryMap.put("gAMA", PngChunkGAMA.class);
        factoryMap.put("pHYs", PngChunkPHYS.class);
        factoryMap.put("iCCP", PngChunkICCP.class);
        factoryMap.put("tIME", PngChunkTIME.class);
        factoryMap.put("tRNS", PngChunkTRNS.class);
        factoryMap.put("cHRM", PngChunkCHRM.class);
        factoryMap.put("sBIT", PngChunkSBIT.class);
        factoryMap.put("sRGB", PngChunkSRGB.class);
        factoryMap.put("hIST", PngChunkHIST.class);
        factoryMap.put("sPLT", PngChunkSPLT.class);
        factoryMap.put("oFFs", PngChunkOFFS.class);
        factoryMap.put("sTER", PngChunkSTER.class);
    }

    public static enum ChunkOrderingConstraint {
        NONE,
        BEFORE_PLTE_AND_IDAT,
        AFTER_PLTE_BEFORE_IDAT,
        BEFORE_IDAT,
        NA;


        public boolean mustGoBeforePLTE() {
            return this == BEFORE_PLTE_AND_IDAT;
        }

        public boolean mustGoBeforeIDAT() {
            return this == BEFORE_IDAT || this == BEFORE_PLTE_AND_IDAT || this == AFTER_PLTE_BEFORE_IDAT;
        }

        public boolean mustGoAfterPLTE() {
            return this == AFTER_PLTE_BEFORE_IDAT;
        }
    }
}

