/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.pngj;

import jogamp.opengl.util.pngj.ImageInfo;
import jogamp.opengl.util.pngj.ImageLine;
import jogamp.opengl.util.pngj.PngjException;
import jogamp.opengl.util.pngj.PngjExceptionInternal;

public class ImageLines {
    public final ImageInfo imgInfo;
    public final int channels;
    public final int bitDepth;
    public final ImageLine.SampleType sampleType;
    public final boolean samplesUnpacked;
    public final int elementsPerRow;
    public final int rowOffset;
    public final int nRows;
    public final int rowStep;
    public final int[][] scanlines;
    public final byte[][] scanlinesb;

    public ImageLines(ImageInfo imageInfo, ImageLine.SampleType sampleType, boolean bl, int n2, int n3, int n4) {
        this.imgInfo = imageInfo;
        this.channels = imageInfo.channels;
        this.bitDepth = imageInfo.bitDepth;
        this.sampleType = sampleType;
        this.samplesUnpacked = bl || !imageInfo.packed;
        this.elementsPerRow = bl ? imageInfo.samplesPerRow : imageInfo.samplesPerRowPacked;
        this.rowOffset = n2;
        this.nRows = n3;
        this.rowStep = n4;
        if (sampleType == ImageLine.SampleType.INT) {
            this.scanlines = new int[n3][this.elementsPerRow];
            this.scanlinesb = null;
        } else if (sampleType == ImageLine.SampleType.BYTE) {
            this.scanlinesb = new byte[n3][this.elementsPerRow];
            this.scanlines = null;
        } else {
            throw new PngjExceptionInternal("bad ImageLine initialization");
        }
    }

    public int imageRowToMatrixRow(int n2) {
        int n3 = (n2 - this.rowOffset) / this.rowStep;
        return n3 < 0 ? 0 : (n3 < this.nRows ? n3 : this.nRows - 1);
    }

    public int imageRowToMatrixRowStrict(int n2) {
        int n3 = (n2 -= this.rowOffset) >= 0 && n2 % this.rowStep == 0 ? n2 / this.rowStep : -1;
        return n3 < this.nRows ? n3 : -1;
    }

    public int matrixRowToImageRow(int n2) {
        return n2 * this.rowStep + this.rowOffset;
    }

    public ImageLine getImageLineAtMatrixRow(int n2) {
        if (n2 < 0 || n2 > this.nRows) {
            throw new PngjException("Bad row " + n2 + ". Should be positive and less than " + this.nRows);
        }
        ImageLine imageLine = this.sampleType == ImageLine.SampleType.INT ? new ImageLine(this.imgInfo, this.sampleType, this.samplesUnpacked, this.scanlines[n2], null) : new ImageLine(this.imgInfo, this.sampleType, this.samplesUnpacked, null, this.scanlinesb[n2]);
        imageLine.setRown(this.matrixRowToImageRow(n2));
        return imageLine;
    }
}

