/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.pngj;

import jogamp.opengl.util.pngj.PngjException;

public class ImageInfo {
    private static final int MAX_COLS_ROWS_VAL = 1000000;
    public final int cols;
    public final int rows;
    public final int bitDepth;
    public final int channels;
    public final boolean alpha;
    public final boolean greyscale;
    public final boolean indexed;
    public final boolean packed;
    public final int bitspPixel;
    public final int bytesPixel;
    public final int bytesPerRow;
    public final int samplesPerRow;
    public final int samplesPerRowPacked;

    public ImageInfo(int n2, int n3, int n4, boolean bl) {
        this(n2, n3, n4, bl, false, false);
    }

    public ImageInfo(int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3) {
        this.cols = n2;
        this.rows = n3;
        this.alpha = bl;
        this.indexed = bl3;
        this.greyscale = bl2;
        if (this.greyscale && bl3) {
            throw new PngjException("palette and greyscale are mutually exclusive");
        }
        this.channels = bl2 || bl3 ? (bl ? 2 : 1) : (bl ? 4 : 3);
        this.bitDepth = n4;
        this.packed = n4 < 8;
        this.bitspPixel = this.channels * this.bitDepth;
        this.bytesPixel = (this.bitspPixel + 7) / 8;
        this.bytesPerRow = (this.bitspPixel * n2 + 7) / 8;
        this.samplesPerRow = this.channels * this.cols;
        this.samplesPerRowPacked = this.packed ? this.bytesPerRow : this.samplesPerRow;
        switch (this.bitDepth) {
            case 1: 
            case 2: 
            case 4: {
                if (this.indexed || this.greyscale) break;
                throw new PngjException("only indexed or grayscale can have bitdepth=" + this.bitDepth);
            }
            case 8: {
                break;
            }
            case 16: {
                if (!this.indexed) break;
                throw new PngjException("indexed can't have bitdepth=" + this.bitDepth);
            }
            default: {
                throw new PngjException("invalid bitdepth=" + this.bitDepth);
            }
        }
        if (n2 < 1 || n2 > 1000000) {
            throw new PngjException("invalid cols=" + n2 + " ???");
        }
        if (n3 < 1 || n3 > 1000000) {
            throw new PngjException("invalid rows=" + n3 + " ???");
        }
    }

    public String toString() {
        return "ImageInfo [cols=" + this.cols + ", rows=" + this.rows + ", bitDepth=" + this.bitDepth + ", channels=" + this.channels + ", bitspPixel=" + this.bitspPixel + ", bytesPixel=" + this.bytesPixel + ", bytesPerRow=" + this.bytesPerRow + ", samplesPerRow=" + this.samplesPerRow + ", samplesPerRowP=" + this.samplesPerRowPacked + ", alpha=" + this.alpha + ", greyscale=" + this.greyscale + ", indexed=" + this.indexed + ", packed=" + this.packed + "]";
    }

    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + (this.alpha ? 1231 : 1237);
        n2 = 31 * n2 + this.bitDepth;
        n2 = 31 * n2 + this.channels;
        n2 = 31 * n2 + this.cols;
        n2 = 31 * n2 + (this.greyscale ? 1231 : 1237);
        n2 = 31 * n2 + (this.indexed ? 1231 : 1237);
        n2 = 31 * n2 + this.rows;
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ImageInfo imageInfo = (ImageInfo)object;
        if (this.alpha != imageInfo.alpha) {
            return false;
        }
        if (this.bitDepth != imageInfo.bitDepth) {
            return false;
        }
        if (this.channels != imageInfo.channels) {
            return false;
        }
        if (this.cols != imageInfo.cols) {
            return false;
        }
        if (this.greyscale != imageInfo.greyscale) {
            return false;
        }
        if (this.indexed != imageInfo.indexed) {
            return false;
        }
        return this.rows == imageInfo.rows;
    }
}

