/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.glu.mipmap;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GL;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import jogamp.opengl.glu.mipmap.Extract;
import jogamp.opengl.glu.mipmap.HalveImage;
import jogamp.opengl.glu.mipmap.Image;
import jogamp.opengl.glu.mipmap.Mipmap;
import jogamp.opengl.glu.mipmap.PixelStorageModes;

public class ScaleInternal {
    public static final float UINT_MAX = -1.0f;

    public static void scale_internal(int n2, int n3, int n4, ShortBuffer shortBuffer, int n5, int n6, ShortBuffer shortBuffer2) {
        float[] fArray = new float[4];
        if (n3 == n5 * 2 && n4 == n6 * 2) {
            HalveImage.halveImage(n2, n3, n4, shortBuffer, shortBuffer2);
            return;
        }
        float f2 = (float)n4 / (float)n6;
        float f3 = (float)n3 / (float)n5;
        float f4 = f3 / 2.0f;
        float f5 = f2 / 2.0f;
        for (int i2 = 0; i2 < n6; ++i2) {
            float f6;
            float f7;
            float f8 = f2 * ((float)i2 + 0.5f);
            if (n4 > n6) {
                f7 = f8 + f5;
                f6 = f8 - f5;
            } else {
                f7 = f8 + 0.5f;
                f6 = f8 - 0.5f;
            }
            for (int i3 = 0; i3 < n5; ++i3) {
                int n7;
                int n8;
                float f9;
                float f10;
                float f11 = f3 * ((float)i3 + 0.5f);
                if (n3 > n5) {
                    f10 = f11 + f4;
                    f9 = f11 - f4;
                } else {
                    f10 = f11 + 0.5f;
                    f9 = f11 - 0.5f;
                }
                fArray[3] = 0.0f;
                fArray[2] = 0.0f;
                fArray[1] = 0.0f;
                fArray[0] = 0.0f;
                float f12 = 0.0f;
                f8 = f6;
                int n9 = (int)Math.floor(f8);
                while (f8 < f7) {
                    int n10 = (n9 + n4) % n4;
                    float f13 = f7 < (float)(n9 + 1) ? f7 - f8 : (float)(n9 + 1) - f8;
                    f11 = f9;
                    int n11 = (int)Math.floor(f11);
                    while (f11 < f10) {
                        int n12 = (n11 + n3) % n3;
                        float f14 = f10 < (float)(n11 + 1) ? f10 - f11 : (float)(n11 + 1) - f11;
                        float f15 = f14 * f13;
                        f12 += f15;
                        n8 = (n12 + n10 * n3) * n2;
                        for (n7 = 0; n7 < n2; ++n7) {
                            int n13 = n7;
                            fArray[n13] = fArray[n13] + (float)shortBuffer.get(n8 + n7) * f15;
                        }
                        f11 = ++n11;
                    }
                    f8 = ++n9;
                }
                n8 = (i3 + i2 * n5) * n2;
                for (n7 = 0; n7 < n2; ++n7) {
                    shortBuffer2.put(n8 + n7, (short)((fArray[n7] + 0.5f) / f12));
                }
            }
        }
    }

    public static void scale_internal_ubyte(int n2, int n3, int n4, ByteBuffer byteBuffer, int n5, int n6, ByteBuffer byteBuffer2, int n7, int n8, int n9) {
        float[] fArray = new float[4];
        if (n3 == n5 * 2 && n4 == n6 * 2) {
            HalveImage.halveImage_ubyte(n2, n3, n4, byteBuffer, byteBuffer2, n7, n8, n9);
            return;
        }
        float f2 = (float)n4 / (float)n6;
        float f3 = (float)n3 / (float)n5;
        int n10 = (int)Math.floor(f2);
        float f4 = f2 - (float)n10;
        int n11 = (int)Math.floor(f3);
        float f5 = f3 - (float)n11;
        float f6 = f3 * f2;
        int n12 = 0;
        float f7 = 0.0f;
        int n13 = n10;
        float f8 = f4;
        for (int i2 = 0; i2 < n6; ++i2) {
            float f9;
            int n14;
            if (n13 >= n4) {
                n13 = n4 - 1;
            }
            int n15 = 0;
            float f10 = 0.0f;
            if (n3 == 1 && n5 == 1) {
                n14 = 0;
                f9 = 0.0f;
            } else {
                n14 = n11;
                f9 = f5;
            }
            for (int i3 = 0; i3 < n5; ++i3) {
                int n16;
                int n17;
                int n18;
                int n19;
                float f11;
                int n20;
                float f12;
                fArray[3] = 0.0f;
                fArray[2] = 0.0f;
                fArray[1] = 0.0f;
                fArray[0] = 0.0f;
                int n21 = n15 * n9;
                if (n13 > n12 && n14 > n15) {
                    f12 = 1.0f - f7;
                    n20 = n21 + n12 * n8;
                    f11 = f12 * (1.0f - f10);
                    n19 = 0;
                    n18 = n20;
                    while (n19 < n2) {
                        byteBuffer.position(n18);
                        int n22 = n19++;
                        fArray[n22] = fArray[n22] + (float)(0xFF & byteBuffer.get()) * f11;
                        n18 += n7;
                    }
                    int n23 = n20;
                    for (n17 = n15 + 1; n17 < n14; ++n17) {
                        n19 = 0;
                        n18 = n20 += n9;
                        while (n19 < n2) {
                            byteBuffer.position(n18);
                            int n24 = n19++;
                            fArray[n24] = fArray[n24] + (float)(0xFF & byteBuffer.get()) * f12;
                            n18 += n7;
                        }
                    }
                    int n25 = n20 += n9;
                    f11 = f12 * f9;
                    n19 = 0;
                    n18 = n20;
                    while (n19 < n2) {
                        byteBuffer.position(n18);
                        int n26 = n19++;
                        fArray[n26] = fArray[n26] + (float)(0xFF & byteBuffer.get()) * f11;
                        n18 += n7;
                    }
                    f12 = f8;
                    f11 = f12 * (1.0f - f10);
                    n20 = n21 + n13 * n8;
                    n19 = 0;
                    n18 = n20;
                    while (n19 < n2) {
                        byteBuffer.position(n18);
                        int n27 = n19++;
                        fArray[n27] = fArray[n27] + (float)(0xFF & byteBuffer.get()) * f11;
                        n18 += n7;
                    }
                    for (n17 = n15 + 1; n17 < n14; ++n17) {
                        n19 = 0;
                        n18 = n20 += n9;
                        while (n19 < n2) {
                            byteBuffer.position(n18);
                            int n28 = n19++;
                            fArray[n28] = fArray[n28] + (float)(0xFF & byteBuffer.get()) * f12;
                            n18 += n7;
                        }
                    }
                    f11 = f12 * f9;
                    n19 = 0;
                    n18 = n20 += n9;
                    while (n19 < n2) {
                        byteBuffer.position(n18);
                        int n29 = n19++;
                        fArray[n29] = fArray[n29] + (float)(0xFF & byteBuffer.get()) * f11;
                        n18 += n7;
                    }
                    for (n16 = n12 + 1; n16 < n13; ++n16) {
                        n23 += n8;
                        n25 += n8;
                        n19 = 0;
                        while (n19 < n2) {
                            float f13 = 0.0f;
                            byteBuffer.position(n23);
                            f13 = (float)(0xFF & byteBuffer.get()) * (1.0f - f10);
                            byteBuffer.position(n25);
                            int n30 = n19++;
                            fArray[n30] = fArray[n30] + (f13 += (float)(0xFF & byteBuffer.get()) * f9);
                            n23 += n7;
                            n25 += n7;
                        }
                    }
                } else if (n13 > n12) {
                    float f14 = f9 - f10;
                    f11 = (1.0f - f7) * f14;
                    n20 = n21 + n12 * n8;
                    n19 = 0;
                    n18 = n20;
                    while (n19 < n2) {
                        byteBuffer.position(n18);
                        int n31 = n19++;
                        fArray[n31] = fArray[n31] + (float)(0xFF & byteBuffer.get()) * f11;
                        n18 += n7;
                    }
                    for (n16 = n12 + 1; n16 < n13; ++n16) {
                        n19 = 0;
                        n18 = n20 += n8;
                        while (n19 < n2) {
                            byteBuffer.position(n18);
                            int n32 = n19++;
                            fArray[n32] = fArray[n32] + (float)(0xFF & byteBuffer.get()) * f14;
                            n18 += n7;
                        }
                    }
                    f11 = f14 * f8;
                    n19 = 0;
                    n18 = n20 += n8;
                    while (n19 < n2) {
                        byteBuffer.position(n18);
                        int n33 = n19++;
                        fArray[n33] = fArray[n33] + (float)(0xFF & byteBuffer.get()) * f11;
                        n18 += n7;
                    }
                } else if (n14 > n15) {
                    f12 = f8 - f7;
                    f11 = (1.0f - f10) * f12;
                    n20 = n21 + n12 * n8;
                    n19 = 0;
                    n18 = n20;
                    while (n19 < n2) {
                        byteBuffer.position(n18);
                        int n34 = n19++;
                        fArray[n34] = fArray[n34] + (float)(0xFF & byteBuffer.get()) * f11;
                        n18 += n7;
                    }
                    for (n17 = n15 + 1; n17 < n14; ++n17) {
                        n19 = 0;
                        n18 = n20 += n9;
                        while (n19 < n2) {
                            byteBuffer.position(n18);
                            int n35 = n19++;
                            fArray[n35] = fArray[n35] + (float)(0xFF & byteBuffer.get()) * f12;
                            n18 += n7;
                        }
                    }
                    f11 = f12 * f9;
                    n19 = 0;
                    n18 = n20 += n9;
                    while (n19 < n2) {
                        byteBuffer.position(n18);
                        int n36 = n19++;
                        fArray[n36] = fArray[n36] + (float)(0xFF & byteBuffer.get()) * f11;
                        n18 += n7;
                    }
                } else {
                    f11 = (f8 - f7) * (f9 - f10);
                    n20 = n21 + n12 * n8;
                    n19 = 0;
                    n18 = n20;
                    while (n19 < n2) {
                        byteBuffer.position(n18);
                        int n37 = n19++;
                        fArray[n37] = fArray[n37] + (float)(0xFF & byteBuffer.get()) * f11;
                        n18 += n7;
                    }
                }
                int n38 = n21 + n9 + (n12 + 1) * n8;
                for (n16 = n12 + 1; n16 < n13; ++n16) {
                    n20 = n38;
                    for (n17 = n15 + 1; n17 < n14; ++n17) {
                        n19 = 0;
                        n18 = n20;
                        while (n19 < n2) {
                            byteBuffer.position(n18);
                            int n39 = n19++;
                            fArray[n39] = fArray[n39] + (float)(0xFF & byteBuffer.get());
                            n18 += n7;
                        }
                        n20 += n9;
                    }
                    n38 += n8;
                }
                int n40 = (i3 + i2 * n5) * n2;
                for (n19 = 0; n19 < n2; ++n19) {
                    byteBuffer2.position(n40 + n19);
                    byteBuffer2.put((byte)(fArray[n19] / f6));
                }
                n15 = n14;
                f10 = f9;
                n14 += n11;
                if ((f9 += f5) > 1.0f) {
                    f9 -= 1.0f;
                    ++n14;
                }
                if (n14 <= n3 - 1) continue;
                int n41 = n14 - n3 + 1;
                n15 -= n41;
                n14 -= n41;
            }
            n12 = n13;
            f7 = f8;
            n13 += n10;
            if (!((f8 += f4) > 1.0f)) continue;
            f8 -= 1.0f;
            ++n13;
        }
    }

    public static void scale_internal_byte(int n2, int n3, int n4, ByteBuffer byteBuffer, int n5, int n6, ByteBuffer byteBuffer2, int n7, int n8, int n9) {
        float[] fArray = new float[4];
        if (n3 == n5 * 2 && n4 == n6 * 2) {
            HalveImage.halveImage_byte(n2, n3, n4, byteBuffer, byteBuffer2, n7, n8, n9);
            return;
        }
        float f2 = (float)n4 / (float)n6;
        float f3 = (float)n3 / (float)n5;
        int n10 = (int)Math.floor(f2);
        float f4 = f2 - (float)n10;
        int n11 = (int)Math.floor(f3);
        float f5 = f3 - (float)n11;
        float f6 = f3 * f2;
        int n12 = 0;
        float f7 = 0.0f;
        int n13 = n10;
        float f8 = f4;
        for (int i2 = 0; i2 < n6; ++i2) {
            float f9;
            int n14;
            if (n13 >= n4) {
                n13 = n4 - 1;
            }
            int n15 = 0;
            float f10 = 0.0f;
            if (n3 == 1 && n5 == 1) {
                n14 = 0;
                f9 = 0.0f;
            } else {
                n14 = n11;
                f9 = f5;
            }
            for (int i3 = 0; i3 < n5; ++i3) {
                int n16;
                int n17;
                int n18;
                int n19;
                float f11;
                int n20;
                float f12;
                fArray[3] = 0.0f;
                fArray[2] = 0.0f;
                fArray[1] = 0.0f;
                fArray[0] = 0.0f;
                int n21 = n15 * n9;
                if (n13 > n12 && n14 > n15) {
                    f12 = 1.0f - f7;
                    n20 = n21 + n12 * n8;
                    f11 = f12 * (1.0f - f10);
                    n19 = 0;
                    n18 = n20;
                    while (n19 < n2) {
                        byteBuffer.position(n18);
                        int n22 = n19++;
                        fArray[n22] = fArray[n22] + (float)byteBuffer.get() * f11;
                        n18 += n7;
                    }
                    int n23 = n20;
                    for (n17 = n15 + 1; n17 < n14; ++n17) {
                        n19 = 0;
                        n18 = n20 += n9;
                        while (n19 < n2) {
                            byteBuffer.position(n18);
                            int n24 = n19++;
                            fArray[n24] = fArray[n24] + (float)byteBuffer.get() * f12;
                            n18 += n7;
                        }
                    }
                    int n25 = n20 += n9;
                    f11 = f12 * f9;
                    n19 = 0;
                    n18 = n20;
                    while (n19 < n2) {
                        byteBuffer.position(n18);
                        int n26 = n19++;
                        fArray[n26] = fArray[n26] + (float)byteBuffer.get() * f11;
                        n18 += n7;
                    }
                    f12 = f8;
                    f11 = f12 * (1.0f - f10);
                    n20 = n21 + n13 * n8;
                    n19 = 0;
                    n18 = n20;
                    while (n19 < n2) {
                        byteBuffer.position(n18);
                        int n27 = n19++;
                        fArray[n27] = fArray[n27] + (float)byteBuffer.get() * f11;
                        n18 += n7;
                    }
                    for (n17 = n15 + 1; n17 < n14; ++n17) {
                        n19 = 0;
                        n18 = n20 += n9;
                        while (n19 < n2) {
                            byteBuffer.position(n18);
                            int n28 = n19++;
                            fArray[n28] = fArray[n28] + (float)byteBuffer.get() * f12;
                            n18 += n7;
                        }
                    }
                    f11 = f12 * f9;
                    n19 = 0;
                    n18 = n20 += n9;
                    while (n19 < n2) {
                        byteBuffer.position(n18);
                        int n29 = n19++;
                        fArray[n29] = fArray[n29] + (float)byteBuffer.get() * f11;
                        n18 += n7;
                    }
                    for (n16 = n12 + 1; n16 < n13; ++n16) {
                        n23 += n8;
                        n25 += n8;
                        n19 = 0;
                        while (n19 < n2) {
                            float f13 = 0.0f;
                            byteBuffer.position(n23);
                            f13 = (float)byteBuffer.get() * (1.0f - f10);
                            byteBuffer.position(n25);
                            int n30 = n19++;
                            fArray[n30] = fArray[n30] + (f13 += (float)byteBuffer.get() * f9);
                            n23 += n7;
                            n25 += n7;
                        }
                    }
                } else if (n13 > n12) {
                    float f14 = f9 - f10;
                    f11 = (1.0f - f7) * f14;
                    n20 = n21 + n12 * n8;
                    n19 = 0;
                    n18 = n20;
                    while (n19 < n2) {
                        byteBuffer.position(n18);
                        int n31 = n19++;
                        fArray[n31] = fArray[n31] + (float)byteBuffer.get() * f11;
                        n18 += n7;
                    }
                    for (n16 = n12 + 1; n16 < n13; ++n16) {
                        n19 = 0;
                        n18 = n20 += n8;
                        while (n19 < n2) {
                            byteBuffer.position(n18);
                            int n32 = n19++;
                            fArray[n32] = fArray[n32] + (float)byteBuffer.get() * f14;
                            n18 += n7;
                        }
                    }
                    f11 = f14 * f8;
                    n19 = 0;
                    n18 = n20 += n8;
                    while (n19 < n2) {
                        byteBuffer.position(n18);
                        int n33 = n19++;
                        fArray[n33] = fArray[n33] + (float)byteBuffer.get() * f11;
                        n18 += n7;
                    }
                } else if (n14 > n15) {
                    f12 = f8 - f7;
                    f11 = (1.0f - f10) * f12;
                    n20 = n21 + n12 * n8;
                    n19 = 0;
                    n18 = n20;
                    while (n19 < n2) {
                        byteBuffer.position(n18);
                        int n34 = n19++;
                        fArray[n34] = fArray[n34] + (float)byteBuffer.get() * f11;
                        n18 += n7;
                    }
                    for (n17 = n15 + 1; n17 < n14; ++n17) {
                        n19 = 0;
                        n18 = n20 += n9;
                        while (n19 < n2) {
                            byteBuffer.position(n18);
                            int n35 = n19++;
                            fArray[n35] = fArray[n35] + (float)byteBuffer.get() * f12;
                            n18 += n7;
                        }
                    }
                    f11 = f12 * f9;
                    n19 = 0;
                    n18 = n20 += n9;
                    while (n19 < n2) {
                        byteBuffer.position(n18);
                        int n36 = n19++;
                        fArray[n36] = fArray[n36] + (float)byteBuffer.get() * f11;
                        n18 += n7;
                    }
                } else {
                    f11 = (f8 - f7) * (f9 - f10);
                    n20 = n21 + n12 * n8;
                    n19 = 0;
                    n18 = n20;
                    while (n19 < n2) {
                        byteBuffer.position(n18);
                        int n37 = n19++;
                        fArray[n37] = fArray[n37] + (float)byteBuffer.get() * f11;
                        n18 += n7;
                    }
                }
                int n38 = n21 + n9 + (n12 + 1) * n8;
                for (n16 = n12 + 1; n16 < n13; ++n16) {
                    n20 = n38;
                    for (n17 = n15 + 1; n17 < n14; ++n17) {
                        n19 = 0;
                        n18 = n20;
                        while (n19 < n2) {
                            byteBuffer.position(n18);
                            int n39 = n19++;
                            fArray[n39] = fArray[n39] + (float)byteBuffer.get();
                            n18 += n7;
                        }
                        n20 += n9;
                    }
                    n38 += n8;
                }
                int n40 = (i3 + i2 * n5) * n2;
                for (n19 = 0; n19 < n2; ++n19) {
                    byteBuffer2.position(n40 + n19);
                    byteBuffer2.put((byte)(fArray[n19] / f6));
                }
                n15 = n14;
                f10 = f9;
                n14 += n11;
                if ((f9 += f5) > 1.0f) {
                    f9 -= 1.0f;
                    ++n14;
                }
                if (n14 <= n3 - 1) continue;
                int n41 = n14 - n3 + 1;
                n15 -= n41;
                n14 -= n41;
            }
            n12 = n13;
            f7 = f8;
            n13 += n10;
            if (!((f8 += f4) > 1.0f)) continue;
            f8 -= 1.0f;
            ++n13;
        }
    }

    public static void scale_internal_ushort(int n2, int n3, int n4, ByteBuffer byteBuffer, int n5, int n6, ShortBuffer shortBuffer, int n7, int n8, int n9, boolean bl) {
        float[] fArray = new float[4];
        if (n3 == n5 * 2 && n4 == n6 * 2) {
            HalveImage.halveImage_ushort(n2, n3, n4, byteBuffer, shortBuffer, n7, n8, n9, bl);
            return;
        }
        float f2 = (float)n4 / (float)n6;
        float f3 = (float)n3 / (float)n5;
        int n10 = (int)Math.floor(f2);
        float f4 = f2 - (float)n10;
        int n11 = (int)Math.floor(f3);
        float f5 = f3 - (float)n11;
        float f6 = f3 * f2;
        int n12 = 0;
        float f7 = 0.0f;
        int n13 = n10;
        float f8 = f4;
        for (int i2 = 0; i2 < n6; ++i2) {
            float f9;
            int n14;
            if (n13 >= n4) {
                n13 = n4 - 1;
            }
            int n15 = 0;
            float f10 = 0.0f;
            if (n3 == 1 && n5 == 1) {
                n14 = 0;
                f9 = 0.0f;
            } else {
                n14 = n11;
                f9 = f5;
            }
            for (int i3 = 0; i3 < n5; ++i3) {
                int n16;
                int n17;
                int n18;
                int n19;
                float f11;
                int n20;
                float f12;
                fArray[3] = 0.0f;
                fArray[2] = 0.0f;
                fArray[1] = 0.0f;
                fArray[0] = 0.0f;
                int n21 = n15 * n9;
                if (n13 > n12 && n14 > n15) {
                    f12 = 1.0f - f7;
                    n20 = n21 + n12 * n8;
                    f11 = f12 * (1.0f - f10);
                    n19 = 0;
                    n18 = n20;
                    while (n19 < n2) {
                        byteBuffer.position(n18);
                        if (bl) {
                            int n22 = n19;
                            fArray[n22] = fArray[n22] + (float)(0xFFFF & Mipmap.GLU_SWAP_2_BYTES(byteBuffer.getShort())) * f11;
                        } else {
                            int n23 = n19;
                            fArray[n23] = fArray[n23] + (float)(0xFFFF & byteBuffer.getShort()) * f11;
                        }
                        ++n19;
                        n18 += n7;
                    }
                    int n24 = n20;
                    for (n17 = n15 + 1; n17 < n14; ++n17) {
                        n19 = 0;
                        n18 = n20 += n9;
                        while (n19 < n2) {
                            byteBuffer.position(n18);
                            if (bl) {
                                int n25 = n19;
                                fArray[n25] = fArray[n25] + (float)(0xFFFF & Mipmap.GLU_SWAP_2_BYTES(byteBuffer.getShort())) * f12;
                            } else {
                                int n26 = n19;
                                fArray[n26] = fArray[n26] + (float)(0xFFFF & byteBuffer.getShort()) * f12;
                            }
                            ++n19;
                            n18 += n7;
                        }
                    }
                    int n27 = n20 += n9;
                    f11 = f12 * f9;
                    n19 = 0;
                    n18 = n20;
                    while (n19 < n2) {
                        byteBuffer.position(n18);
                        if (bl) {
                            int n28 = n19;
                            fArray[n28] = fArray[n28] + (float)(0xFFFF & Mipmap.GLU_SWAP_2_BYTES(byteBuffer.getShort())) * f11;
                        } else {
                            int n29 = n19;
                            fArray[n29] = fArray[n29] + (float)(0xFFFF & byteBuffer.getShort()) * f11;
                        }
                        ++n19;
                        n18 += n7;
                    }
                    f12 = f8;
                    f11 = f12 * (1.0f - f10);
                    n20 = n21 + n13 * n8;
                    n19 = 0;
                    n18 = n20;
                    while (n19 < n2) {
                        byteBuffer.position(n18);
                        if (bl) {
                            int n30 = n19;
                            fArray[n30] = fArray[n30] + (float)(0xFFFF & Mipmap.GLU_SWAP_2_BYTES(byteBuffer.getShort())) * f11;
                        } else {
                            int n31 = n19;
                            fArray[n31] = fArray[n31] + (float)(0xFFFF & byteBuffer.getShort()) * f11;
                        }
                        ++n19;
                        n18 += n7;
                    }
                    for (n17 = n15 + 1; n17 < n14; ++n17) {
                        n19 = 0;
                        n18 = n20 += n9;
                        while (n19 < n2) {
                            byteBuffer.position(n18);
                            if (bl) {
                                int n32 = n19;
                                fArray[n32] = fArray[n32] + (float)(0xFFFF & Mipmap.GLU_SWAP_2_BYTES(byteBuffer.getShort())) * f12;
                            } else {
                                int n33 = n19;
                                fArray[n33] = fArray[n33] + (float)(0xFFFF & byteBuffer.getShort()) * f12;
                            }
                            ++n19;
                            n18 += n7;
                        }
                    }
                    f11 = f12 * f9;
                    n19 = 0;
                    n18 = n20 += n9;
                    while (n19 < n2) {
                        byteBuffer.position(n18);
                        if (bl) {
                            int n34 = n19;
                            fArray[n34] = fArray[n34] + (float)(0xFFFF & Mipmap.GLU_SWAP_2_BYTES(byteBuffer.getShort())) * f11;
                        } else {
                            int n35 = n19;
                            fArray[n35] = fArray[n35] + (float)(0xFFFF & byteBuffer.getShort()) * f11;
                        }
                        ++n19;
                        n18 += n7;
                    }
                    for (n16 = n12 + 1; n16 < n13; ++n16) {
                        n24 += n8;
                        n27 += n8;
                        n19 = 0;
                        while (n19 < n2) {
                            float f13;
                            if (bl) {
                                byteBuffer.position(n24);
                                f13 = (float)(0xFFFF & Mipmap.GLU_SWAP_2_BYTES(byteBuffer.getShort())) * (1.0f - f10);
                                byteBuffer.position(n27);
                                int n36 = n19;
                                fArray[n36] = fArray[n36] + (f13 += (float)(0xFFFF & Mipmap.GLU_SWAP_2_BYTES(byteBuffer.getShort())) * f9);
                            } else {
                                byteBuffer.position(n24);
                                f13 = (float)(0xFFFF & byteBuffer.getShort()) * (1.0f - f10);
                                byteBuffer.position(n27);
                                int n37 = n19;
                                fArray[n37] = fArray[n37] + (f13 += (float)(0xFFFF & byteBuffer.getShort()) * f9);
                            }
                            ++n19;
                            n24 += n7;
                            n27 += n7;
                        }
                    }
                } else if (n13 > n12) {
                    float f14 = f9 - f10;
                    f11 = (1.0f - f7) * f14;
                    n20 = n21 + n12 * n8;
                    n19 = 0;
                    n18 = n20;
                    while (n19 < n2) {
                        byteBuffer.position(n18);
                        if (bl) {
                            int n38 = n19;
                            fArray[n38] = fArray[n38] + (float)(0xFFFF & Mipmap.GLU_SWAP_2_BYTES(byteBuffer.getShort())) * f11;
                        } else {
                            int n39 = n19;
                            fArray[n39] = fArray[n39] + (float)(0xFFFF & byteBuffer.getShort()) * f11;
                        }
                        ++n19;
                        n18 += n7;
                    }
                    for (n16 = n12 + 1; n16 < n13; ++n16) {
                        n19 = 0;
                        n18 = n20 += n8;
                        while (n19 < n2) {
                            byteBuffer.position(n18);
                            if (bl) {
                                int n40 = n19;
                                fArray[n40] = fArray[n40] + (float)(0xFFFF & Mipmap.GLU_SWAP_2_BYTES(byteBuffer.getShort())) * f14;
                            } else {
                                int n41 = n19;
                                fArray[n41] = fArray[n41] + (float)(0xFFFF & byteBuffer.getShort()) * f14;
                            }
                            ++n19;
                            n18 += n7;
                        }
                    }
                    f11 = f14 * f8;
                    n19 = 0;
                    n18 = n20 += n8;
                    while (n19 < n2) {
                        byteBuffer.position(n18);
                        if (bl) {
                            int n42 = n19;
                            fArray[n42] = fArray[n42] + (float)(0xFFFF & Mipmap.GLU_SWAP_2_BYTES(byteBuffer.getShort())) * f11;
                        } else {
                            int n43 = n19;
                            fArray[n43] = fArray[n43] + (float)(0xFFFF & byteBuffer.getShort()) * f11;
                        }
                        ++n19;
                        n18 += n7;
                    }
                } else if (n14 > n15) {
                    f12 = f8 - f7;
                    f11 = (1.0f - f10) * f12;
                    n20 = n21 + n12 * n8;
                    n19 = 0;
                    n18 = n20;
                    while (n19 < n2) {
                        byteBuffer.position(n18);
                        if (bl) {
                            int n44 = n19;
                            fArray[n44] = fArray[n44] + (float)(0xFFFF & Mipmap.GLU_SWAP_2_BYTES(byteBuffer.getShort())) * f11;
                        } else {
                            int n45 = n19;
                            fArray[n45] = fArray[n45] + (float)(0xFFFF & byteBuffer.getShort()) * f11;
                        }
                        ++n19;
                        n18 += n7;
                    }
                    for (n17 = n15 + 1; n17 < n14; ++n17) {
                        n19 = 0;
                        n18 = n20 += n9;
                        while (n19 < n2) {
                            byteBuffer.position(n18);
                            if (bl) {
                                int n46 = n19;
                                fArray[n46] = fArray[n46] + (float)(0xFFFF & Mipmap.GLU_SWAP_2_BYTES(byteBuffer.getShort())) * f12;
                            } else {
                                int n47 = n19;
                                fArray[n47] = fArray[n47] + (float)(0xFFFF & byteBuffer.getShort()) * f12;
                            }
                            ++n19;
                            n18 += n7;
                        }
                    }
                    f11 = f12 * f9;
                    n19 = 0;
                    n18 = n20 += n9;
                    while (n19 < n2) {
                        byteBuffer.position(n18);
                        if (bl) {
                            int n48 = n19;
                            fArray[n48] = fArray[n48] + (float)(0xFFFF & Mipmap.GLU_SWAP_2_BYTES(byteBuffer.getShort())) * f11;
                        } else {
                            int n49 = n19;
                            fArray[n49] = fArray[n49] + (float)(0xFFFF & byteBuffer.getShort()) * f11;
                        }
                        ++n19;
                        n18 += n7;
                    }
                } else {
                    f11 = (f8 - f7) * (f9 - f10);
                    n20 = n21 + n12 * n8;
                    n19 = 0;
                    n18 = n20;
                    while (n19 < n2) {
                        byteBuffer.position(n18);
                        if (bl) {
                            int n50 = n19;
                            fArray[n50] = fArray[n50] + (float)(0xFFFF & Mipmap.GLU_SWAP_2_BYTES(byteBuffer.getShort())) * f11;
                        } else {
                            int n51 = n19;
                            fArray[n51] = fArray[n51] + (float)(0xFFFF & byteBuffer.getShort()) * f11;
                        }
                        ++n19;
                        n18 += n7;
                    }
                }
                int n52 = n21 + n9 + (n12 + 1) * n8;
                for (n16 = n12 + 1; n16 < n13; ++n16) {
                    n20 = n52;
                    for (n17 = n15 + 1; n17 < n14; ++n17) {
                        n19 = 0;
                        n18 = n20;
                        while (n19 < n2) {
                            byteBuffer.position(n18);
                            if (bl) {
                                int n53 = n19;
                                fArray[n53] = fArray[n53] + (float)(0xFFFF & Mipmap.GLU_SWAP_2_BYTES(byteBuffer.getShort()));
                            } else {
                                int n54 = n19;
                                fArray[n54] = fArray[n54] + (float)(0xFFFF & byteBuffer.getShort());
                            }
                            ++n19;
                            n18 += n7;
                        }
                        n20 += n9;
                    }
                    n52 += n8;
                }
                int n55 = (i3 + i2 * n5) * n2;
                for (n19 = 0; n19 < n2; ++n19) {
                    shortBuffer.position(n55 + n19);
                    shortBuffer.put((short)(fArray[n19] / f6));
                }
                n15 = n14;
                f10 = f9;
                n14 += n11;
                if ((f9 += f5) > 1.0f) {
                    f9 -= 1.0f;
                    ++n14;
                }
                if (n14 <= n3 - 1) continue;
                int n56 = n14 - n3 + 1;
                n15 -= n56;
                n14 -= n56;
            }
            n12 = n13;
            f7 = f8;
            n13 += n10;
            if (!((f8 += f4) > 1.0f)) continue;
            f8 -= 1.0f;
            ++n13;
        }
    }

    public static void scale_internal_short(int n2, int n3, int n4, ByteBuffer byteBuffer, int n5, int n6, ShortBuffer shortBuffer, int n7, int n8, int n9, boolean bl) {
        float[] fArray = new float[4];
        if (n3 == n5 * 2 && n4 == n6 * 2) {
            HalveImage.halveImage_short(n2, n3, n4, byteBuffer, shortBuffer, n7, n8, n9, bl);
            return;
        }
        float f2 = (float)n4 / (float)n6;
        float f3 = (float)n3 / (float)n5;
        int n10 = (int)Math.floor(f2);
        float f4 = f2 - (float)n10;
        int n11 = (int)Math.floor(f3);
        float f5 = f3 - (float)n11;
        float f6 = f3 * f2;
        int n12 = 0;
        float f7 = 0.0f;
        int n13 = n10;
        float f8 = f4;
        for (int i2 = 0; i2 < n6; ++i2) {
            float f9;
            int n14;
            if (n13 >= n4) {
                n13 = n4 - 1;
            }
            int n15 = 0;
            float f10 = 0.0f;
            if (n3 == 1 && n5 == 1) {
                n14 = 0;
                f9 = 0.0f;
            } else {
                n14 = n11;
                f9 = f5;
            }
            for (int i3 = 0; i3 < n5; ++i3) {
                int n16;
                int n17;
                short s2;
                int n18;
                int n19;
                float f11;
                int n20;
                float f12;
                fArray[3] = 0.0f;
                fArray[2] = 0.0f;
                fArray[1] = 0.0f;
                fArray[0] = 0.0f;
                int n21 = n15 * n9;
                if (n13 > n12 && n14 > n15) {
                    f12 = 1.0f - f7;
                    n20 = n21 + n12 * n8;
                    f11 = f12 * (1.0f - f10);
                    n19 = 0;
                    n18 = n20;
                    while (n19 < n2) {
                        byteBuffer.position(n18);
                        if (bl) {
                            s2 = Mipmap.GLU_SWAP_2_BYTES(byteBuffer.getShort());
                            int n22 = n19;
                            fArray[n22] = fArray[n22] + (float)s2 * f11;
                        } else {
                            int n23 = n19;
                            fArray[n23] = fArray[n23] + (float)byteBuffer.getShort() * f11;
                        }
                        ++n19;
                        n18 += n7;
                    }
                    int n24 = n20;
                    for (n17 = n15 + 1; n17 < n14; ++n17) {
                        n19 = 0;
                        n18 = n20 += n9;
                        while (n19 < n2) {
                            byteBuffer.position(n18);
                            if (bl) {
                                s2 = Mipmap.GLU_SWAP_2_BYTES(byteBuffer.getShort());
                                int n25 = n19;
                                fArray[n25] = fArray[n25] + (float)s2 * f12;
                            } else {
                                int n26 = n19;
                                fArray[n26] = fArray[n26] + (float)byteBuffer.getShort() * f12;
                            }
                            ++n19;
                            n18 += n7;
                        }
                    }
                    int n27 = n20 += n9;
                    f11 = f12 * f9;
                    n19 = 0;
                    n18 = n20;
                    while (n19 < n2) {
                        byteBuffer.position(n18);
                        if (bl) {
                            s2 = Mipmap.GLU_SWAP_2_BYTES(byteBuffer.getShort());
                            int n28 = n19;
                            fArray[n28] = fArray[n28] + (float)s2 * f11;
                        } else {
                            int n29 = n19;
                            fArray[n29] = fArray[n29] + (float)byteBuffer.getShort() * f11;
                        }
                        ++n19;
                        n18 += n7;
                    }
                    f12 = f8;
                    f11 = f12 * (1.0f - f10);
                    n20 = n21 + n13 * n8;
                    n19 = 0;
                    n18 = n20;
                    while (n19 < n2) {
                        byteBuffer.position(n18);
                        if (bl) {
                            s2 = Mipmap.GLU_SWAP_2_BYTES(byteBuffer.getShort());
                            int n30 = n19;
                            fArray[n30] = fArray[n30] + (float)s2 * f11;
                        } else {
                            int n31 = n19;
                            fArray[n31] = fArray[n31] + (float)byteBuffer.getShort() * f11;
                        }
                        ++n19;
                        n18 += n7;
                    }
                    for (n17 = n15 + 1; n17 < n14; ++n17) {
                        n19 = 0;
                        n18 = n20 += n9;
                        while (n19 < n2) {
                            byteBuffer.position(n18);
                            if (bl) {
                                s2 = Mipmap.GLU_SWAP_2_BYTES(byteBuffer.getShort());
                                int n32 = n19;
                                fArray[n32] = fArray[n32] + (float)s2 * f12;
                            } else {
                                int n33 = n19;
                                fArray[n33] = fArray[n33] + (float)byteBuffer.getShort() * f12;
                            }
                            ++n19;
                            n18 += n7;
                        }
                    }
                    f11 = f12 * f9;
                    n19 = 0;
                    n18 = n20 += n9;
                    while (n19 < n2) {
                        byteBuffer.position(n18);
                        if (bl) {
                            s2 = Mipmap.GLU_SWAP_2_BYTES(byteBuffer.getShort());
                            int n34 = n19;
                            fArray[n34] = fArray[n34] + (float)s2 * f11;
                        } else {
                            int n35 = n19;
                            fArray[n35] = fArray[n35] + (float)byteBuffer.getShort() * f11;
                        }
                        ++n19;
                        n18 += n7;
                    }
                    for (n16 = n12 + 1; n16 < n13; ++n16) {
                        n24 += n8;
                        n27 += n8;
                        n19 = 0;
                        while (n19 < n2) {
                            if (bl) {
                                byteBuffer.position(n24);
                                s2 = Mipmap.GLU_SWAP_2_BYTES(byteBuffer.getShort());
                                int n36 = n19;
                                fArray[n36] = fArray[n36] + (float)s2 * (1.0f - f10);
                                byteBuffer.position(n27);
                                s2 = Mipmap.GLU_SWAP_2_BYTES(byteBuffer.getShort());
                                int n37 = n19;
                                fArray[n37] = fArray[n37] + (float)s2 * f9;
                            } else {
                                byteBuffer.position(n24);
                                int n38 = n19;
                                fArray[n38] = fArray[n38] + (float)byteBuffer.getShort() * (1.0f - f10);
                                byteBuffer.position(n27);
                                int n39 = n19;
                                fArray[n39] = fArray[n39] + (float)byteBuffer.getShort() * f9;
                            }
                            ++n19;
                            n24 += n7;
                            n27 += n7;
                        }
                    }
                } else if (n13 > n12) {
                    float f13 = f9 - f10;
                    f11 = (1.0f - f7) * f13;
                    n20 = n21 + n12 * n8;
                    n19 = 0;
                    n18 = n20;
                    while (n19 < n2) {
                        byteBuffer.position(n18);
                        if (bl) {
                            s2 = Mipmap.GLU_SWAP_2_BYTES(byteBuffer.getShort());
                            int n40 = n19;
                            fArray[n40] = fArray[n40] + (float)s2 * f11;
                        } else {
                            int n41 = n19;
                            fArray[n41] = fArray[n41] + (float)byteBuffer.getShort() * f11;
                        }
                        ++n19;
                        n18 += n7;
                    }
                    for (n16 = n12 + 1; n16 < n13; ++n16) {
                        n19 = 0;
                        n18 = n20 += n8;
                        while (n19 < n2) {
                            byteBuffer.position(n18);
                            if (bl) {
                                s2 = Mipmap.GLU_SWAP_2_BYTES(byteBuffer.getShort());
                                int n42 = n19;
                                fArray[n42] = fArray[n42] + (float)s2 * f13;
                            } else {
                                int n43 = n19;
                                fArray[n43] = fArray[n43] + (float)byteBuffer.getShort() * f13;
                            }
                            ++n19;
                            n18 += n7;
                        }
                    }
                    f11 = f13 * f8;
                    n19 = 0;
                    n18 = n20 += n8;
                    while (n19 < n2) {
                        byteBuffer.position(n18);
                        if (bl) {
                            s2 = Mipmap.GLU_SWAP_2_BYTES(byteBuffer.getShort());
                            int n44 = n19;
                            fArray[n44] = fArray[n44] + (float)s2 * f11;
                        } else {
                            int n45 = n19;
                            fArray[n45] = fArray[n45] + (float)byteBuffer.getShort() * f11;
                        }
                        ++n19;
                        n18 += n7;
                    }
                } else if (n14 > n15) {
                    f12 = f8 - f7;
                    f11 = (1.0f - f10) * f12;
                    n20 = n21 + n12 * n8;
                    n19 = 0;
                    n18 = n20;
                    while (n19 < n2) {
                        byteBuffer.position(n18);
                        if (bl) {
                            s2 = Mipmap.GLU_SWAP_2_BYTES(byteBuffer.getShort());
                            int n46 = n19;
                            fArray[n46] = fArray[n46] + (float)s2 * f11;
                        } else {
                            int n47 = n19;
                            fArray[n47] = fArray[n47] + (float)byteBuffer.getShort() * f11;
                        }
                        ++n19;
                        n18 += n7;
                    }
                    for (n17 = n15 + 1; n17 < n14; ++n17) {
                        n19 = 0;
                        n18 = n20 += n9;
                        while (n19 < n2) {
                            byteBuffer.position(n18);
                            if (bl) {
                                s2 = Mipmap.GLU_SWAP_2_BYTES(byteBuffer.getShort());
                                int n48 = n19;
                                fArray[n48] = fArray[n48] + (float)s2 * f12;
                            } else {
                                int n49 = n19;
                                fArray[n49] = fArray[n49] + (float)byteBuffer.getShort() * f12;
                            }
                            ++n19;
                            n18 += n7;
                        }
                    }
                    f11 = f12 * f9;
                    n19 = 0;
                    n18 = n20 += n9;
                    while (n19 < n2) {
                        byteBuffer.position(n18);
                        if (bl) {
                            s2 = Mipmap.GLU_SWAP_2_BYTES(byteBuffer.getShort());
                            int n50 = n19;
                            fArray[n50] = fArray[n50] + (float)s2 * f11;
                        } else {
                            int n51 = n19;
                            fArray[n51] = fArray[n51] + (float)byteBuffer.getShort() * f11;
                        }
                        ++n19;
                        n18 += n7;
                    }
                } else {
                    f11 = (f8 - f7) * (f9 - f10);
                    n20 = n21 + n12 * n8;
                    n19 = 0;
                    n18 = n20;
                    while (n19 < n2) {
                        byteBuffer.position(n18);
                        if (bl) {
                            s2 = Mipmap.GLU_SWAP_2_BYTES(byteBuffer.getShort());
                            int n52 = n19;
                            fArray[n52] = fArray[n52] + (float)s2 * f11;
                        } else {
                            int n53 = n19;
                            fArray[n53] = fArray[n53] + (float)byteBuffer.getShort() * f11;
                        }
                        ++n19;
                        n18 += n7;
                    }
                }
                int n54 = n21 + n9 + (n12 + 1) * n8;
                for (n16 = n12 + 1; n16 < n13; ++n16) {
                    n20 = n54;
                    for (n17 = n15 + 1; n17 < n14; ++n17) {
                        n19 = 0;
                        n18 = n20;
                        while (n19 < n2) {
                            byteBuffer.position(n18);
                            if (bl) {
                                s2 = Mipmap.GLU_SWAP_2_BYTES(byteBuffer.getShort());
                                int n55 = n19;
                                fArray[n55] = fArray[n55] + (float)s2;
                            } else {
                                int n56 = n19;
                                fArray[n56] = fArray[n56] + (float)byteBuffer.getShort();
                            }
                            ++n19;
                            n18 += n7;
                        }
                        n20 += n9;
                    }
                    n54 += n8;
                }
                int n57 = (i3 + i2 * n5) * n2;
                for (n19 = 0; n19 < n2; ++n19) {
                    shortBuffer.position(n57 + n19);
                    shortBuffer.put((short)(fArray[n19] / f6));
                }
                n15 = n14;
                f10 = f9;
                n14 += n11;
                if ((f9 += f5) > 1.0f) {
                    f9 -= 1.0f;
                    ++n14;
                }
                if (n14 <= n3 - 1) continue;
                int n58 = n14 - n3 + 1;
                n15 -= n58;
                n14 -= n58;
            }
            n12 = n13;
            f7 = f8;
            n13 += n10;
            if (!((f8 += f4) > 1.0f)) continue;
            f8 -= 1.0f;
            ++n13;
        }
    }

    public static void scale_internal_uint(int n2, int n3, int n4, ByteBuffer byteBuffer, int n5, int n6, IntBuffer intBuffer, int n7, int n8, int n9, boolean bl) {
        float[] fArray = new float[4];
        if (n3 == n5 * 2 && n4 == n6 * 2) {
            HalveImage.halveImage_uint(n2, n3, n4, byteBuffer, intBuffer, n7, n8, n9, bl);
            return;
        }
        float f2 = (float)n4 / (float)n6;
        float f3 = (float)n3 / (float)n5;
        int n10 = (int)Math.floor(f2);
        float f4 = f2 - (float)n10;
        int n11 = (int)Math.floor(f3);
        float f5 = f3 - (float)n11;
        float f6 = f3 * f2;
        int n12 = 0;
        float f7 = 0.0f;
        int n13 = n10;
        float f8 = f4;
        for (int i2 = 0; i2 < n6; ++i2) {
            float f9;
            int n14;
            if (n13 >= n4) {
                n13 = n4 - 1;
            }
            int n15 = 0;
            float f10 = 0.0f;
            if (n3 == 1 && n5 == 1) {
                n14 = 0;
                f9 = 0.0f;
            } else {
                n14 = n11;
                f9 = f5;
            }
            for (int i3 = 0; i3 < n5; ++i3) {
                int n16;
                int n17;
                int n18;
                int n19;
                float f11;
                int n20;
                float f12;
                fArray[3] = 0.0f;
                fArray[2] = 0.0f;
                fArray[1] = 0.0f;
                fArray[0] = 0.0f;
                int n21 = n15 * n9;
                if (n13 > n12 && n14 > n15) {
                    f12 = 1.0f - f7;
                    n20 = n21 + n12 * n8;
                    f11 = f12 * (1.0f - f10);
                    n19 = 0;
                    n18 = n20;
                    while (n19 < n2) {
                        byteBuffer.position(n18);
                        if (bl) {
                            int n22 = n19;
                            fArray[n22] = fArray[n22] + (float)(0xFFFFFFFF & Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getInt())) * f11;
                        } else {
                            int n23 = n19;
                            fArray[n23] = fArray[n23] + (float)(0xFFFFFFFF & byteBuffer.getInt()) * f11;
                        }
                        ++n19;
                        n18 += n7;
                    }
                    int n24 = n20;
                    for (n17 = n15 + 1; n17 < n14; ++n17) {
                        n19 = 0;
                        n18 = n20 += n9;
                        while (n19 < n2) {
                            byteBuffer.position(n18);
                            if (bl) {
                                int n25 = n19;
                                fArray[n25] = fArray[n25] + (float)(0xFFFFFFFF & Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getInt())) * f12;
                            } else {
                                int n26 = n19;
                                fArray[n26] = fArray[n26] + (float)(0xFFFFFFFF & byteBuffer.getInt()) * f12;
                            }
                            ++n19;
                            n18 += n7;
                        }
                    }
                    int n27 = n20 += n9;
                    f11 = f12 * f9;
                    n19 = 0;
                    n18 = n20;
                    while (n19 < n2) {
                        byteBuffer.position(n18);
                        if (bl) {
                            int n28 = n19;
                            fArray[n28] = fArray[n28] + (float)(0xFFFFFFFF & Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getInt())) * f11;
                        } else {
                            int n29 = n19;
                            fArray[n29] = fArray[n29] + (float)(0xFFFFFFFF & byteBuffer.getInt()) * f11;
                        }
                        ++n19;
                        n18 += n7;
                    }
                    f12 = f8;
                    f11 = f12 * (1.0f - f10);
                    n20 = n21 + n13 * n8;
                    n19 = 0;
                    n18 = n20;
                    while (n19 < n2) {
                        byteBuffer.position(n18);
                        if (bl) {
                            int n30 = n19;
                            fArray[n30] = fArray[n30] + (float)(0xFFFFFFFF & Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getInt())) * f11;
                        } else {
                            int n31 = n19;
                            fArray[n31] = fArray[n31] + (float)(0xFFFFFFFF & byteBuffer.getInt()) * f11;
                        }
                        ++n19;
                        n18 += n7;
                    }
                    for (n17 = n15 + 1; n17 < n14; ++n17) {
                        n19 = 0;
                        n18 = n20 += n9;
                        while (n19 < n2) {
                            byteBuffer.position(n18);
                            if (bl) {
                                int n32 = n19;
                                fArray[n32] = fArray[n32] + (float)(0xFFFFFFFF & Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getInt())) * f12;
                            } else {
                                int n33 = n19;
                                fArray[n33] = fArray[n33] + (float)(0xFFFFFFFF & byteBuffer.getInt()) * f12;
                            }
                            ++n19;
                            n18 += n7;
                        }
                    }
                    f11 = f12 * f9;
                    n19 = 0;
                    n18 = n20 += n9;
                    while (n19 < n2) {
                        byteBuffer.position(n18);
                        if (bl) {
                            int n34 = n19;
                            fArray[n34] = fArray[n34] + (float)(0xFFFFFFFF & Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getInt())) * f11;
                        } else {
                            int n35 = n19;
                            fArray[n35] = fArray[n35] + (float)(0xFFFFFFFF & byteBuffer.getInt()) * f11;
                        }
                        ++n19;
                        n18 += n7;
                    }
                    for (n16 = n12 + 1; n16 < n13; ++n16) {
                        n24 += n8;
                        n27 += n8;
                        n19 = 0;
                        while (n19 < n2) {
                            if (bl) {
                                byteBuffer.position(n24);
                                int n36 = n19;
                                fArray[n36] = fArray[n36] + (float)(0xFFFFFFFF & Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getInt())) * (1.0f - f10);
                                byteBuffer.position(n27);
                                int n37 = n19;
                                fArray[n37] = fArray[n37] + (float)(0xFFFFFFFF & Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getInt())) * f9;
                            } else {
                                byteBuffer.position(n24);
                                int n38 = n19;
                                fArray[n38] = fArray[n38] + (float)(0xFFFFFFFF & byteBuffer.getInt()) * (1.0f - f10);
                                byteBuffer.position(n27);
                                int n39 = n19;
                                fArray[n39] = fArray[n39] + (float)(0xFFFFFFFF & byteBuffer.getInt()) * f9;
                            }
                            ++n19;
                            n24 += n7;
                            n27 += n7;
                        }
                    }
                } else if (n13 > n12) {
                    float f13 = f9 - f10;
                    f11 = (1.0f - f7) * f13;
                    n20 = n21 + n12 * n8;
                    n19 = 0;
                    n18 = n20;
                    while (n19 < n2) {
                        byteBuffer.position(n18);
                        if (bl) {
                            int n40 = n19;
                            fArray[n40] = fArray[n40] + (float)(0xFFFFFFFF & Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getInt())) * f11;
                        } else {
                            int n41 = n19;
                            fArray[n41] = fArray[n41] + (float)(0xFFFFFFFF & byteBuffer.getInt()) * f11;
                        }
                        ++n19;
                        n18 += n7;
                    }
                    for (n16 = n12 + 1; n16 < n13; ++n16) {
                        n19 = 0;
                        n18 = n20 += n8;
                        while (n19 < n2) {
                            byteBuffer.position(n18);
                            if (bl) {
                                int n42 = n19;
                                fArray[n42] = fArray[n42] + (float)(0xFFFFFFFF & Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getInt())) * f13;
                            } else {
                                int n43 = n19;
                                fArray[n43] = fArray[n43] + (float)(0xFFFFFFFF & byteBuffer.getInt()) * f13;
                            }
                            ++n19;
                            n18 += n7;
                        }
                    }
                    f11 = f13 * f8;
                    n19 = 0;
                    n18 = n20 += n8;
                    while (n19 < n2) {
                        byteBuffer.position(n18);
                        if (bl) {
                            int n44 = n19;
                            fArray[n44] = fArray[n44] + (float)(0xFFFFFFFF & Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getInt())) * f11;
                        } else {
                            int n45 = n19;
                            fArray[n45] = fArray[n45] + (float)(0xFFFFFFFF & byteBuffer.getInt()) * f11;
                        }
                        ++n19;
                        n18 += n7;
                    }
                } else if (n14 > n15) {
                    f12 = f8 - f7;
                    f11 = (1.0f - f10) * f12;
                    n20 = n21 + n12 * n8;
                    n19 = 0;
                    n18 = n20;
                    while (n19 < n2) {
                        byteBuffer.position(n18);
                        if (bl) {
                            int n46 = n19;
                            fArray[n46] = fArray[n46] + (float)(0xFFFFFFFF & Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getInt())) * f11;
                        } else {
                            int n47 = n19;
                            fArray[n47] = fArray[n47] + (float)(0xFFFFFFFF & byteBuffer.getInt()) * f11;
                        }
                        ++n19;
                        n18 += n7;
                    }
                    for (n17 = n15 + 1; n17 < n14; ++n17) {
                        n19 = 0;
                        n18 = n20 += n9;
                        while (n19 < n2) {
                            byteBuffer.position(n18);
                            if (bl) {
                                int n48 = n19;
                                fArray[n48] = fArray[n48] + (float)(0xFFFFFFFF & Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getInt())) * f12;
                            } else {
                                int n49 = n19;
                                fArray[n49] = fArray[n49] + (float)(0xFFFFFFFF & byteBuffer.getInt()) * f12;
                            }
                            ++n19;
                            n18 += n7;
                        }
                    }
                    f11 = f12 * f9;
                    n19 = 0;
                    n18 = n20 += n9;
                    while (n19 < n2) {
                        byteBuffer.position(n18);
                        if (bl) {
                            int n50 = n19;
                            fArray[n50] = fArray[n50] + (float)(0xFFFFFFFF & Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getInt())) * f11;
                        } else {
                            int n51 = n19;
                            fArray[n51] = fArray[n51] + (float)(0xFFFFFFFF & byteBuffer.getInt()) * f11;
                        }
                        ++n19;
                        n18 += n7;
                    }
                } else {
                    f11 = (f8 - f7) * (f9 - f10);
                    n20 = n21 + n12 * n8;
                    n19 = 0;
                    n18 = n20;
                    while (n19 < n2) {
                        long l2 = 0xFFFFFFFFL & (long)byteBuffer.getInt(n18);
                        byteBuffer.position(n18);
                        long l3 = 0xFFFFFFFFL & (long)byteBuffer.getInt();
                        byteBuffer.position(n18);
                        if (bl) {
                            int n52 = n19;
                            fArray[n52] = fArray[n52] + (float)(0xFFFFFFFF & Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getInt())) * f11;
                        } else {
                            int n53 = n19;
                            fArray[n53] = fArray[n53] + (float)(0xFFFFFFFF & byteBuffer.getInt()) * f11;
                        }
                        ++n19;
                        n18 += n7;
                    }
                }
                int n54 = n21 + n9 + (n12 + 1) * n8;
                for (n16 = n12 + 1; n16 < n13; ++n16) {
                    n20 = n54;
                    for (n17 = n15 + 1; n17 < n14; ++n17) {
                        n19 = 0;
                        n18 = n20;
                        while (n19 < n2) {
                            byteBuffer.position(n18);
                            if (bl) {
                                int n55 = n19;
                                fArray[n55] = fArray[n55] + (float)(0xFFFFFFFF & Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getInt()));
                            } else {
                                int n56 = n19;
                                fArray[n56] = fArray[n56] + (float)(0xFFFFFFFF & byteBuffer.getInt());
                            }
                            ++n19;
                            n18 += n7;
                        }
                        n20 += n9;
                    }
                    n54 += n8;
                }
                int n57 = (i3 + i2 * n5) * n2;
                float f14 = 0.0f;
                for (n19 = 0; n19 < n2; ++n19) {
                    f14 = fArray[n19] / f6;
                    intBuffer.position(n57 + n19);
                    if (f14 >= -1.0f) {
                        intBuffer.put((int)f14);
                        continue;
                    }
                    intBuffer.put((int)(fArray[n19] / f6));
                }
                n15 = n14;
                f10 = f9;
                n14 += n11;
                if ((f9 += f5) > 1.0f) {
                    f9 -= 1.0f;
                    ++n14;
                }
                if (n14 <= n3 - 1) continue;
                int n58 = n14 - n3 + 1;
                n15 -= n58;
                n14 -= n58;
            }
            n12 = n13;
            f7 = f8;
            n13 += n10;
            if (!((f8 += f4) > 1.0f)) continue;
            f8 -= 1.0f;
            ++n13;
        }
    }

    public static void scale_internal_int(int n2, int n3, int n4, ByteBuffer byteBuffer, int n5, int n6, IntBuffer intBuffer, int n7, int n8, int n9, boolean bl) {
        float[] fArray = new float[4];
        if (n3 == n5 * 2 && n4 == n6 * 2) {
            HalveImage.halveImage_int(n2, n3, n4, byteBuffer, intBuffer, n7, n8, n9, bl);
            return;
        }
        float f2 = (float)n4 / (float)n6;
        float f3 = (float)n3 / (float)n5;
        int n10 = (int)Math.floor(f2);
        float f4 = f2 - (float)n10;
        int n11 = (int)Math.floor(f3);
        float f5 = f3 - (float)n11;
        float f6 = f3 * f2;
        int n12 = 0;
        float f7 = 0.0f;
        int n13 = n10;
        float f8 = f4;
        for (int i2 = 0; i2 < n6; ++i2) {
            float f9;
            int n14;
            if (n13 >= n4) {
                n13 = n4 - 1;
            }
            int n15 = 0;
            float f10 = 0.0f;
            if (n3 == 1 && n5 == 1) {
                n14 = 0;
                f9 = 0.0f;
            } else {
                n14 = n11;
                f9 = f5;
            }
            for (int i3 = 0; i3 < n5; ++i3) {
                int n16;
                int n17;
                long l2;
                int n18;
                int n19;
                float f11;
                int n20;
                float f12;
                fArray[3] = 0.0f;
                fArray[2] = 0.0f;
                fArray[1] = 0.0f;
                fArray[0] = 0.0f;
                int n21 = n15 * n9;
                if (n13 > n12 && n14 > n15) {
                    f12 = 1.0f - f7;
                    n20 = n21 + n12 * n8;
                    f11 = f12 * (1.0f - f10);
                    n19 = 0;
                    n18 = n20;
                    while (n19 < n2) {
                        byteBuffer.position(n18);
                        if (bl) {
                            l2 = Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getInt());
                            int n22 = n19;
                            fArray[n22] = fArray[n22] + (float)l2 * f11;
                        } else {
                            int n23 = n19;
                            fArray[n23] = fArray[n23] + (float)byteBuffer.getInt() * f11;
                        }
                        ++n19;
                        n18 += n7;
                    }
                    int n24 = n20;
                    for (n17 = n15 + 1; n17 < n14; ++n17) {
                        n19 = 0;
                        n18 = n20 += n9;
                        while (n19 < n2) {
                            byteBuffer.position(n18);
                            if (bl) {
                                l2 = Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getInt());
                                int n25 = n19;
                                fArray[n25] = fArray[n25] + (float)l2 * f12;
                            } else {
                                int n26 = n19;
                                fArray[n26] = fArray[n26] + (float)byteBuffer.getInt() * f12;
                            }
                            ++n19;
                            n18 += n7;
                        }
                    }
                    int n27 = n20 += n9;
                    f11 = f12 * f9;
                    n19 = 0;
                    n18 = n20;
                    while (n19 < n2) {
                        byteBuffer.position(n18);
                        if (bl) {
                            l2 = Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getInt());
                            int n28 = n19;
                            fArray[n28] = fArray[n28] + (float)l2 * f11;
                        } else {
                            int n29 = n19;
                            fArray[n29] = fArray[n29] + (float)byteBuffer.getInt() * f11;
                        }
                        ++n19;
                        n18 += n7;
                    }
                    f12 = f8;
                    f11 = f12 * (1.0f - f10);
                    n20 = n21 + n13 * n8;
                    n19 = 0;
                    n18 = n20;
                    while (n19 < n2) {
                        byteBuffer.position(n18);
                        if (bl) {
                            l2 = Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getInt());
                            int n30 = n19;
                            fArray[n30] = fArray[n30] + (float)l2 * f11;
                        } else {
                            int n31 = n19;
                            fArray[n31] = fArray[n31] + (float)byteBuffer.getInt() * f11;
                        }
                        ++n19;
                        n18 += n7;
                    }
                    for (n17 = n15 + 1; n17 < n14; ++n17) {
                        n19 = 0;
                        n18 = n20 += n9;
                        while (n19 < n2) {
                            byteBuffer.position(n18);
                            if (bl) {
                                l2 = Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getInt());
                                int n32 = n19;
                                fArray[n32] = fArray[n32] + (float)l2 * f12;
                            } else {
                                int n33 = n19;
                                fArray[n33] = fArray[n33] + (float)byteBuffer.getInt() * f12;
                            }
                            ++n19;
                            n18 += n7;
                        }
                    }
                    f11 = f12 * f9;
                    n19 = 0;
                    n18 = n20 += n9;
                    while (n19 < n2) {
                        byteBuffer.position(n18);
                        if (bl) {
                            l2 = Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getInt());
                            int n34 = n19;
                            fArray[n34] = fArray[n34] + (float)l2 * f11;
                        } else {
                            int n35 = n19;
                            fArray[n35] = fArray[n35] + (float)byteBuffer.getInt() * f11;
                        }
                        ++n19;
                        n18 += n7;
                    }
                    for (n16 = n12 + 1; n16 < n13; ++n16) {
                        n24 += n8;
                        n27 += n8;
                        n19 = 0;
                        while (n19 < n2) {
                            if (bl) {
                                byteBuffer.position(n24);
                                l2 = Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getInt());
                                int n36 = n19;
                                fArray[n36] = fArray[n36] + (float)l2 * (1.0f - f10);
                                byteBuffer.position(n27);
                                l2 = Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getInt());
                                int n37 = n19;
                                fArray[n37] = fArray[n37] + (float)l2 * f9;
                            } else {
                                byteBuffer.position(n24);
                                int n38 = n19;
                                fArray[n38] = fArray[n38] + (float)byteBuffer.getInt() * (1.0f - f10);
                                byteBuffer.position(n27);
                                int n39 = n19;
                                fArray[n39] = fArray[n39] + (float)byteBuffer.getInt() * f9;
                            }
                            ++n19;
                            n24 += n7;
                            n27 += n7;
                        }
                    }
                } else if (n13 > n12) {
                    float f13 = f9 - f10;
                    f11 = (1.0f - f7) * f13;
                    n20 = n21 + n12 * n8;
                    n19 = 0;
                    n18 = n20;
                    while (n19 < n2) {
                        byteBuffer.position(n18);
                        if (bl) {
                            l2 = Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getInt());
                            int n40 = n19;
                            fArray[n40] = fArray[n40] + (float)l2 * f11;
                        } else {
                            int n41 = n19;
                            fArray[n41] = fArray[n41] + (float)byteBuffer.getInt() * f11;
                        }
                        ++n19;
                        n18 += n7;
                    }
                    for (n16 = n12 + 1; n16 < n13; ++n16) {
                        n19 = 0;
                        n18 = n20 += n8;
                        while (n19 < n2) {
                            byteBuffer.position(n18);
                            if (bl) {
                                l2 = Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getInt());
                                int n42 = n19;
                                fArray[n42] = fArray[n42] + (float)l2 * f13;
                            } else {
                                int n43 = n19;
                                fArray[n43] = fArray[n43] + (float)byteBuffer.getInt() * f13;
                            }
                            ++n19;
                            n18 += n7;
                        }
                    }
                    f11 = f13 * f8;
                    n19 = 0;
                    n18 = n20 += n8;
                    while (n19 < n2) {
                        byteBuffer.position(n18);
                        if (bl) {
                            l2 = Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getInt());
                            int n44 = n19;
                            fArray[n44] = fArray[n44] + (float)l2 * f11;
                        } else {
                            int n45 = n19;
                            fArray[n45] = fArray[n45] + (float)byteBuffer.getInt() * f11;
                        }
                        ++n19;
                        n18 += n7;
                    }
                } else if (n14 > n15) {
                    f12 = f8 - f7;
                    f11 = (1.0f - f10) * f12;
                    n20 = n21 + n12 * n8;
                    n19 = 0;
                    n18 = n20;
                    while (n19 < n2) {
                        byteBuffer.position(n18);
                        if (bl) {
                            l2 = Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getInt());
                            int n46 = n19;
                            fArray[n46] = fArray[n46] + (float)l2 * f11;
                        } else {
                            int n47 = n19;
                            fArray[n47] = fArray[n47] + (float)byteBuffer.getInt() * f11;
                        }
                        ++n19;
                        n18 += n7;
                    }
                    for (n17 = n15 + 1; n17 < n14; ++n17) {
                        n19 = 0;
                        n18 = n20 += n9;
                        while (n19 < n2) {
                            byteBuffer.position(n18);
                            if (bl) {
                                l2 = Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getInt());
                                int n48 = n19;
                                fArray[n48] = fArray[n48] + (float)l2 * f12;
                            } else {
                                int n49 = n19;
                                fArray[n49] = fArray[n49] + (float)byteBuffer.getInt() * f12;
                            }
                            ++n19;
                            n18 += n7;
                        }
                    }
                    f11 = f12 * f9;
                    n19 = 0;
                    n18 = n20 += n9;
                    while (n19 < n2) {
                        byteBuffer.position(n18);
                        if (bl) {
                            l2 = Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getInt());
                            int n50 = n19;
                            fArray[n50] = fArray[n50] + (float)l2 * f11;
                        } else {
                            int n51 = n19;
                            fArray[n51] = fArray[n51] + (float)byteBuffer.getInt() * f11;
                        }
                        ++n19;
                        n18 += n7;
                    }
                } else {
                    f11 = (f8 - f7) * (f9 - f10);
                    n20 = n21 + n12 * n8;
                    n19 = 0;
                    n18 = n20;
                    while (n19 < n2) {
                        byteBuffer.position(n18);
                        if (bl) {
                            l2 = Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getInt());
                            int n52 = n19;
                            fArray[n52] = fArray[n52] + (float)l2 * f11;
                        } else {
                            int n53 = n19;
                            fArray[n53] = fArray[n53] + (float)byteBuffer.getInt() * f11;
                        }
                        ++n19;
                        n18 += n7;
                    }
                }
                int n54 = n21 + n9 + (n12 + 1) * n8;
                for (n16 = n12 + 1; n16 < n13; ++n16) {
                    n20 = n54;
                    for (n17 = n15 + 1; n17 < n14; ++n17) {
                        n19 = 0;
                        n18 = n20;
                        while (n19 < n2) {
                            byteBuffer.position(n18);
                            if (bl) {
                                l2 = Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getInt());
                                int n55 = n19;
                                fArray[n55] = fArray[n55] + (float)l2;
                            } else {
                                int n56 = n19;
                                fArray[n56] = fArray[n56] + (float)byteBuffer.getInt();
                            }
                            ++n19;
                            n18 += n7;
                        }
                        n20 += n9;
                    }
                    n54 += n8;
                }
                int n57 = (i3 + i2 * n5) * n2;
                for (n19 = 0; n19 < n2; ++n19) {
                    intBuffer.position(n57 + n19);
                    intBuffer.put((int)(fArray[n19] / f6));
                }
                n15 = n14;
                f10 = f9;
                n14 += n11;
                if ((f9 += f5) > 1.0f) {
                    f9 -= 1.0f;
                    ++n14;
                }
                if (n14 <= n3 - 1) continue;
                int n58 = n14 - n3 + 1;
                n15 -= n58;
                n14 -= n58;
            }
            n12 = n13;
            f7 = f8;
            n13 += n10;
            if (!((f8 += f4) > 1.0f)) continue;
            f8 -= 1.0f;
            ++n13;
        }
    }

    public static void scale_internal_float(int n2, int n3, int n4, ByteBuffer byteBuffer, int n5, int n6, FloatBuffer floatBuffer, int n7, int n8, int n9, boolean bl) {
        float[] fArray = new float[4];
        if (n3 == n5 * 2 && n4 == n6 * 2) {
            HalveImage.halveImage_float(n2, n3, n4, byteBuffer, floatBuffer, n7, n8, n9, bl);
            return;
        }
        float f2 = (float)n4 / (float)n6;
        float f3 = (float)n3 / (float)n5;
        int n10 = (int)Math.floor(f2);
        float f4 = f2 - (float)n10;
        int n11 = (int)Math.floor(f3);
        float f5 = f3 - (float)n11;
        float f6 = f3 * f2;
        int n12 = 0;
        float f7 = 0.0f;
        int n13 = n10;
        float f8 = f4;
        for (int i2 = 0; i2 < n6; ++i2) {
            float f9;
            int n14;
            if (n13 >= n4) {
                n13 = n4 - 1;
            }
            int n15 = 0;
            float f10 = 0.0f;
            if (n3 == 1 && n5 == 1) {
                n14 = 0;
                f9 = 0.0f;
            } else {
                n14 = n11;
                f9 = f5;
            }
            for (int i3 = 0; i3 < n5; ++i3) {
                int n16;
                int n17;
                float f11;
                int n18;
                int n19;
                float f12;
                int n20;
                float f13;
                fArray[3] = 0.0f;
                fArray[2] = 0.0f;
                fArray[1] = 0.0f;
                fArray[0] = 0.0f;
                int n21 = n15 * n9;
                if (n13 > n12 && n14 > n15) {
                    f13 = 1.0f - f7;
                    n20 = n21 + n12 * n8;
                    f12 = f13 * (1.0f - f10);
                    n19 = 0;
                    n18 = n20;
                    while (n19 < n2) {
                        byteBuffer.position(n18);
                        if (bl) {
                            f11 = Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getFloat());
                            int n22 = n19;
                            fArray[n22] = fArray[n22] + f11 * f12;
                        } else {
                            int n23 = n19;
                            fArray[n23] = fArray[n23] + byteBuffer.getFloat() * f12;
                        }
                        ++n19;
                        n18 += n7;
                    }
                    int n24 = n20;
                    for (n17 = n15 + 1; n17 < n14; ++n17) {
                        n19 = 0;
                        n18 = n20 += n9;
                        while (n19 < n2) {
                            byteBuffer.position(n18);
                            if (bl) {
                                f11 = Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getFloat());
                                int n25 = n19;
                                fArray[n25] = fArray[n25] + f11 * f13;
                            } else {
                                int n26 = n19;
                                fArray[n26] = fArray[n26] + byteBuffer.getFloat() * f13;
                            }
                            ++n19;
                            n18 += n7;
                        }
                    }
                    int n27 = n20 += n9;
                    f12 = f13 * f9;
                    n19 = 0;
                    n18 = n20;
                    while (n19 < n2) {
                        byteBuffer.position(n18);
                        if (bl) {
                            f11 = Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getFloat());
                            int n28 = n19;
                            fArray[n28] = fArray[n28] + f11 * f12;
                        } else {
                            int n29 = n19;
                            fArray[n29] = fArray[n29] + byteBuffer.getFloat() * f12;
                        }
                        ++n19;
                        n18 += n7;
                    }
                    f13 = f8;
                    f12 = f13 * (1.0f - f10);
                    n20 = n21 + n13 * n8;
                    n19 = 0;
                    n18 = n20;
                    while (n19 < n2) {
                        byteBuffer.position(n18);
                        if (bl) {
                            f11 = Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getFloat());
                            int n30 = n19;
                            fArray[n30] = fArray[n30] + f11 * f12;
                        } else {
                            int n31 = n19;
                            fArray[n31] = fArray[n31] + byteBuffer.getFloat() * f12;
                        }
                        ++n19;
                        n18 += n7;
                    }
                    for (n17 = n15 + 1; n17 < n14; ++n17) {
                        n19 = 0;
                        n18 = n20 += n9;
                        while (n19 < n2) {
                            byteBuffer.position(n18);
                            if (bl) {
                                f11 = Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getFloat());
                                int n32 = n19;
                                fArray[n32] = fArray[n32] + f11 * f13;
                            } else {
                                int n33 = n19;
                                fArray[n33] = fArray[n33] + byteBuffer.getFloat() * f13;
                            }
                            ++n19;
                            n18 += n7;
                        }
                    }
                    f12 = f13 * f9;
                    n19 = 0;
                    n18 = n20 += n9;
                    while (n19 < n2) {
                        byteBuffer.position(n18);
                        if (bl) {
                            f11 = Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getFloat());
                            int n34 = n19;
                            fArray[n34] = fArray[n34] + f11 * f12;
                        } else {
                            int n35 = n19;
                            fArray[n35] = fArray[n35] + byteBuffer.getFloat() * f12;
                        }
                        ++n19;
                        n18 += n7;
                    }
                    for (n16 = n12 + 1; n16 < n13; ++n16) {
                        n24 += n8;
                        n27 += n8;
                        n19 = 0;
                        while (n19 < n2) {
                            if (bl) {
                                byteBuffer.position(n24);
                                f11 = Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getFloat());
                                int n36 = n19;
                                fArray[n36] = fArray[n36] + f11 * (1.0f - f10);
                                byteBuffer.position(n27);
                                f11 = Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getFloat());
                                int n37 = n19;
                                fArray[n37] = fArray[n37] + f11 * f9;
                            } else {
                                byteBuffer.position(n24);
                                int n38 = n19;
                                fArray[n38] = fArray[n38] + byteBuffer.getFloat() * (1.0f - f10);
                                byteBuffer.position(n27);
                                int n39 = n19;
                                fArray[n39] = fArray[n39] + byteBuffer.getFloat() * f9;
                            }
                            ++n19;
                            n24 += n7;
                            n27 += n7;
                        }
                    }
                } else if (n13 > n12) {
                    float f14 = f9 - f10;
                    f12 = (1.0f - f7) * f14;
                    n20 = n21 + n12 * n8;
                    n19 = 0;
                    n18 = n20;
                    while (n19 < n2) {
                        byteBuffer.position(n18);
                        if (bl) {
                            f11 = Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getFloat());
                            int n40 = n19;
                            fArray[n40] = fArray[n40] + f11 * f12;
                        } else {
                            int n41 = n19;
                            fArray[n41] = fArray[n41] + byteBuffer.getFloat() * f12;
                        }
                        ++n19;
                        n18 += n7;
                    }
                    for (n16 = n12 + 1; n16 < n13; ++n16) {
                        n19 = 0;
                        n18 = n20 += n8;
                        while (n19 < n2) {
                            byteBuffer.position(n18);
                            if (bl) {
                                f11 = Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getFloat());
                                int n42 = n19;
                                fArray[n42] = fArray[n42] + f11 * f14;
                            } else {
                                int n43 = n19;
                                fArray[n43] = fArray[n43] + byteBuffer.getFloat() * f14;
                            }
                            ++n19;
                            n18 += n7;
                        }
                    }
                    f12 = f14 * f8;
                    n19 = 0;
                    n18 = n20 += n8;
                    while (n19 < n2) {
                        byteBuffer.position(n18);
                        if (bl) {
                            f11 = Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getFloat());
                            int n44 = n19;
                            fArray[n44] = fArray[n44] + f11 * f12;
                        } else {
                            int n45 = n19;
                            fArray[n45] = fArray[n45] + byteBuffer.getFloat() * f12;
                        }
                        ++n19;
                        n18 += n7;
                    }
                } else if (n14 > n15) {
                    f13 = f8 - f7;
                    f12 = (1.0f - f10) * f13;
                    n20 = n21 + n12 * n8;
                    n19 = 0;
                    n18 = n20;
                    while (n19 < n2) {
                        byteBuffer.position(n18);
                        if (bl) {
                            f11 = Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getFloat());
                            int n46 = n19;
                            fArray[n46] = fArray[n46] + f11 * f12;
                        } else {
                            int n47 = n19;
                            fArray[n47] = fArray[n47] + byteBuffer.getFloat() * f12;
                        }
                        ++n19;
                        n18 += n7;
                    }
                    for (n17 = n15 + 1; n17 < n14; ++n17) {
                        n19 = 0;
                        n18 = n20 += n9;
                        while (n19 < n2) {
                            byteBuffer.position(n18);
                            if (bl) {
                                f11 = Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getFloat());
                                int n48 = n19;
                                fArray[n48] = fArray[n48] + f11 * f13;
                            } else {
                                int n49 = n19;
                                fArray[n49] = fArray[n49] + byteBuffer.getFloat() * f13;
                            }
                            ++n19;
                            n18 += n7;
                        }
                    }
                    f12 = f13 * f9;
                    n19 = 0;
                    n18 = n20 += n9;
                    while (n19 < n2) {
                        byteBuffer.position(n18);
                        if (bl) {
                            f11 = Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getFloat());
                            int n50 = n19;
                            fArray[n50] = fArray[n50] + f11 * f12;
                        } else {
                            int n51 = n19;
                            fArray[n51] = fArray[n51] + byteBuffer.getFloat() * f12;
                        }
                        ++n19;
                        n18 += n7;
                    }
                } else {
                    f12 = (f8 - f7) * (f9 - f10);
                    n20 = n21 + n12 * n8;
                    n19 = 0;
                    n18 = n20;
                    while (n19 < n2) {
                        byteBuffer.position(n18);
                        if (bl) {
                            f11 = Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getFloat());
                            int n52 = n19;
                            fArray[n52] = fArray[n52] + f11 * f12;
                        } else {
                            int n53 = n19;
                            fArray[n53] = fArray[n53] + byteBuffer.getFloat() * f12;
                        }
                        ++n19;
                        n18 += n7;
                    }
                }
                int n54 = n21 + n9 + (n12 + 1) * n8;
                for (n16 = n12 + 1; n16 < n13; ++n16) {
                    n20 = n54;
                    for (n17 = n15 + 1; n17 < n14; ++n17) {
                        n19 = 0;
                        n18 = n20;
                        while (n19 < n2) {
                            byteBuffer.position(n18);
                            if (bl) {
                                f11 = Mipmap.GLU_SWAP_4_BYTES(byteBuffer.getFloat());
                                int n55 = n19;
                                fArray[n55] = fArray[n55] + f11;
                            } else {
                                int n56 = n19;
                                fArray[n56] = fArray[n56] + byteBuffer.getFloat();
                            }
                            ++n19;
                            n18 += n7;
                        }
                        n20 += n9;
                    }
                    n54 += n8;
                }
                int n57 = (i3 + i2 * n5) * n2;
                for (n19 = 0; n19 < n2; ++n19) {
                    floatBuffer.position(n57 + n19);
                    floatBuffer.put(fArray[n19] / f6);
                }
                n15 = n14;
                f10 = f9;
                n14 += n11;
                if ((f9 += f5) > 1.0f) {
                    f9 -= 1.0f;
                    ++n14;
                }
                if (n14 <= n3 - 1) continue;
                int n58 = n14 - n3 + 1;
                n15 -= n58;
                n14 -= n58;
            }
            n12 = n13;
            f7 = f8;
            n13 += n10;
            if (!((f8 += f4) > 1.0f)) continue;
            f8 -= 1.0f;
            ++n13;
        }
    }

    public static void scaleInternalPackedPixel(int n2, Extract extract, int n3, int n4, ByteBuffer byteBuffer, int n5, int n6, ByteBuffer byteBuffer2, int n7, int n8, boolean bl) {
        float[] fArray = new float[4];
        float[] fArray2 = new float[4];
        float[] fArray3 = new float[4];
        float[] fArray4 = new float[4];
        int n9 = 0;
        if (n3 == n5 * 2 && n4 == n6 * 2) {
            HalveImage.halveImagePackedPixel(n2, extract, n3, n4, byteBuffer, byteBuffer2, n7, n8, bl);
            return;
        }
        float f2 = (float)n4 / (float)n6;
        float f3 = (float)n3 / (float)n5;
        int n10 = (int)Math.floor(f2);
        float f4 = f2 - (float)n10;
        int n11 = (int)Math.floor(f3);
        float f5 = f3 - (float)n11;
        float f6 = f3 * f2;
        int n12 = 0;
        float f7 = 0.0f;
        int n13 = n10;
        float f8 = f5;
        for (int i2 = 0; i2 < n6; ++i2) {
            if (n13 >= n4) {
                n13 = n4 - 1;
            }
            int n14 = 0;
            float f9 = 0.0f;
            int n15 = n11;
            float f10 = f5;
            for (int i3 = 0; i3 < n5; ++i3) {
                int n16;
                int n17;
                int n18;
                float f11;
                int n19;
                float f12;
                fArray[3] = 0.0f;
                fArray[2] = 0.0f;
                fArray[1] = 0.0f;
                fArray[0] = 0.0f;
                int n20 = n14 * n7;
                if (n13 > n12 && n15 > n14) {
                    f12 = 1.0f - f7;
                    n19 = n20 + n12 * n8;
                    f11 = f12 * (1.0f - f9);
                    byteBuffer.position(n19);
                    extract.extract(bl, byteBuffer, fArray2);
                    for (n18 = 0; n18 < n2; ++n18) {
                        int n21 = n18;
                        fArray[n21] = fArray[n21] + fArray2[n18] * f11;
                    }
                    int n22 = n19;
                    for (n17 = n14 + 1; n17 < n15; ++n17) {
                        byteBuffer.position(n19 += n7);
                        extract.extract(bl, byteBuffer, fArray2);
                        for (n18 = 0; n18 < n2; ++n18) {
                            int n23 = n18;
                            fArray[n23] = fArray[n23] + fArray2[n18] * f12;
                        }
                    }
                    int n24 = n19 += n7;
                    f11 = f12 * f10;
                    byteBuffer.position(n19);
                    extract.extract(bl, byteBuffer, fArray2);
                    for (n18 = 0; n18 < n2; ++n18) {
                        int n25 = n18;
                        fArray[n25] = fArray[n25] + fArray2[n18] * f11;
                    }
                    f12 = f8;
                    f11 = f12 * (1.0f - f9);
                    n19 = n20 + n13 * n8;
                    byteBuffer.position(n19);
                    extract.extract(bl, byteBuffer, fArray2);
                    for (n18 = 0; n18 < n2; ++n18) {
                        int n26 = n18;
                        fArray[n26] = fArray[n26] + fArray2[n18] * f11;
                    }
                    for (n17 = n14 + 1; n17 < n15; ++n17) {
                        byteBuffer.position(n19 += n7);
                        extract.extract(bl, byteBuffer, fArray2);
                        for (n18 = 0; n18 < n2; ++n18) {
                            int n27 = n18;
                            fArray[n27] = fArray[n27] + fArray2[n18] * f12;
                        }
                    }
                    f11 = f12 * f10;
                    byteBuffer.position(n19 += n7);
                    for (n18 = 0; n18 < n2; ++n18) {
                        int n28 = n18;
                        fArray[n28] = fArray[n28] + fArray2[n18] * f11;
                    }
                    for (n16 = n12 + 1; n16 < n13; ++n16) {
                        byteBuffer.position(n22 += n8);
                        extract.extract(bl, byteBuffer, fArray2);
                        byteBuffer.position(n24 += n8);
                        extract.extract(bl, byteBuffer, fArray3);
                        for (n18 = 0; n18 < n2; ++n18) {
                            int n29 = n18;
                            fArray[n29] = fArray[n29] + (fArray2[n18] * (1.0f - f9) + fArray3[n18] * f10);
                        }
                    }
                } else if (n13 > n12) {
                    float f13 = f10 - f9;
                    f11 = (1.0f - f7) * f13;
                    n19 = n20 + n12 * n8;
                    byteBuffer.position(n19);
                    extract.extract(bl, byteBuffer, fArray2);
                    for (n18 = 0; n18 < n2; ++n18) {
                        int n30 = n18;
                        fArray[n30] = fArray[n30] + fArray2[n18] * f11;
                    }
                    for (n16 = n12 + 1; n16 < n13; ++n16) {
                        byteBuffer.position(n19 += n8);
                        extract.extract(bl, byteBuffer, fArray2);
                        for (n18 = 0; n18 < n2; ++n18) {
                            int n31 = n18;
                            fArray[n31] = fArray[n31] + fArray2[n18] * f13;
                        }
                    }
                    f11 = f13 * f8;
                    byteBuffer.position(n19 += n8);
                    extract.extract(bl, byteBuffer, fArray2);
                    for (n18 = 0; n18 < n2; ++n18) {
                        int n32 = n18;
                        fArray[n32] = fArray[n32] + fArray2[n18] * f11;
                    }
                } else if (n15 > n14) {
                    f12 = f8 - f7;
                    f11 = (1.0f - f9) * f12;
                    n19 = n20 + n12 * n8;
                    byteBuffer.position(n19);
                    extract.extract(bl, byteBuffer, fArray2);
                    for (n18 = 0; n18 < n2; ++n18) {
                        int n33 = n18;
                        fArray[n33] = fArray[n33] + fArray2[n18] * f11;
                    }
                    for (n17 = n14 + 1; n17 < n15; ++n17) {
                        byteBuffer.position(n19 += n7);
                        extract.extract(bl, byteBuffer, fArray2);
                        for (n18 = 0; n18 < n2; ++n18) {
                            int n34 = n18;
                            fArray[n34] = fArray[n34] + fArray2[n18] * f12;
                        }
                    }
                    f11 = f12 * f10;
                    byteBuffer.position(n19 += n7);
                    extract.extract(bl, byteBuffer, fArray2);
                    for (n18 = 0; n18 < n2; ++n18) {
                        int n35 = n18;
                        fArray[n35] = fArray[n35] + fArray2[n18] * f11;
                    }
                } else {
                    f11 = (f8 - f7) * (f10 - f9);
                    n19 = n20 + n12 * n8;
                    byteBuffer.position(n19);
                    extract.extract(bl, byteBuffer, fArray2);
                    for (n18 = 0; n18 < n2; ++n18) {
                        int n36 = n18;
                        fArray[n36] = fArray[n36] + fArray2[n18] * f11;
                    }
                }
                int n37 = n20 + n7 + (n12 + 1) * n8;
                for (n16 = n12 + 1; n16 < n13; ++n16) {
                    n19 = n37;
                    for (n17 = n14 + 1; n17 < n15; ++n17) {
                        byteBuffer.position(n19);
                        extract.extract(bl, byteBuffer, fArray2);
                        for (n18 = 0; n18 < n2; ++n18) {
                            int n38 = n18;
                            fArray[n38] = fArray[n38] + fArray2[n18] * f11;
                        }
                        n19 += n7;
                    }
                    n37 += n8;
                }
                n9 = i3 + i2 * n5;
                for (n18 = 0; n18 < n2; ++n18) {
                    fArray4[n18] = fArray[n18] / f6;
                }
                extract.shove(fArray4, n9, byteBuffer2);
                n14 = n15;
                f9 = f10;
                n15 += n11;
                f10 += f5;
                if (f10 > 1.0f) {
                    f10 -= 1.0f;
                    ++n15;
                }
                if (n15 <= n3 - 1) continue;
                int n39 = n15 - n3 + 1;
                n14 -= n39;
                n15 -= n39;
            }
            n12 = n13;
            f7 = f8;
            n13 += n10;
            if (!((f8 += f4) > 1.0f)) continue;
            f8 -= 1.0f;
            ++n13;
        }
        assert (n9 == n5 * n6 - 1);
    }

    public static void scaleInternal3D(int n2, int n3, int n4, int n5, ShortBuffer shortBuffer, int n6, int n7, int n8, ShortBuffer shortBuffer2) {
        float[] fArray = new float[4];
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = (float)n5 / (float)n8;
        float f7 = (float)n4 / (float)n7;
        float f8 = (float)n3 / (float)n6;
        float f9 = f6 / 2.0f;
        float f10 = f7 / 2.0f;
        float f11 = f8 / 2.0f;
        for (int i2 = 0; i2 < n8; ++i2) {
            float f12;
            float f13;
            float f14 = f6 * ((float)i2 + 0.5f);
            if (n5 > n8) {
                f13 = f14 + f9;
                f12 = f14 - f9;
            } else {
                f13 = f14 + 0.5f;
                f12 = f14 - 0.5f;
            }
            for (int i3 = 0; i3 < n7; ++i3) {
                float f15 = f7 * ((float)i3 + 0.5f);
                if (n4 > n7) {
                    f13 = f15 + f10;
                    f12 = f15 - f10;
                } else {
                    f13 = f15 + 0.5f;
                    f12 = f15 - 0.5f;
                }
                for (int i4 = 0; i4 < n6; ++i4) {
                    int n9;
                    int n10;
                    float f16 = f8 * ((float)i4 + 0.5f);
                    if (n5 > n8) {
                        f13 = f16 + f11;
                        f12 = f16 - f11;
                    } else {
                        f13 = f16 + 0.5f;
                        f12 = f16 - 0.5f;
                    }
                    fArray[3] = 0.0f;
                    fArray[2] = 0.0f;
                    fArray[1] = 0.0f;
                    fArray[0] = 0.0f;
                    float f17 = 0.0f;
                    f14 = f12;
                    int n11 = (int)Math.floor(f14);
                    while (f14 < f13) {
                        int n12 = (n11 + n5) % n5;
                        float f18 = f13 < (float)(n11 + 1) ? f13 - f14 : (float)(n11 + 1) - f14;
                        f15 = f5;
                        int n13 = (int)Math.floor(f15);
                        while (f15 < f4) {
                            int n14 = (n13 + n4) % n4;
                            float f19 = f4 < (float)(n13 + 1) ? f4 - f15 : (float)(n13 + 1) - f15;
                            f16 = f3;
                            int n15 = (int)Math.floor(f16);
                            while (f16 < f2) {
                                int n16 = (n15 + n3) % n3;
                                float f20 = f2 < (float)(n15 + 1) ? f2 - f16 : (float)(n15 + 1) - f16;
                                float f21 = f20 * f19 * f18;
                                f17 += f21;
                                n10 = (n16 + n14 * n3 + n12 * n3 * n4) * n2;
                                for (n9 = 0; n9 < n2; ++n9) {
                                    assert (0 <= n10 + n9 && n10 + n9 < n3 * n4 * n5 * n2);
                                    int n17 = n9;
                                    fArray[n17] = fArray[n17] + (float)shortBuffer.get(n10 + n9) * f21;
                                }
                                f16 = ++n15;
                            }
                            f15 = ++n13;
                        }
                        f14 = ++n11;
                    }
                    n10 = (i4 + i3 * n6 + i2 * n6 * n7) * n2;
                    for (n9 = 0; n9 < n2; ++n9) {
                        assert (0 <= n10 + n9 && n10 + n9 < n6 * n7 * n8 * n2);
                        shortBuffer2.put(n10 + n9, (short)((fArray[n9] + 0.5f) / f17));
                    }
                }
            }
        }
    }

    public static int gluScaleImage3D(GL gL, int n2, int n3, int n4, int n5, int n6, ByteBuffer byteBuffer, int n7, int n8, int n9, int n10, ByteBuffer byteBuffer2) {
        ShortBuffer shortBuffer;
        ShortBuffer shortBuffer2;
        PixelStorageModes pixelStorageModes = new PixelStorageModes();
        if (n3 == 0 || n4 == 0 || n5 == 0 || n7 == 0 || n8 == 0 || n9 == 0) {
            return 0;
        }
        if (n3 < 0 || n4 < 0 || n5 < 0 || n7 < 0 || n8 < 0 || n9 < 0) {
            return 100901;
        }
        if (!(Mipmap.legalFormat(n2) && Mipmap.legalType(n6) && Mipmap.legalType(n10) && n6 != 6656 && n10 != 6656)) {
            return 100900;
        }
        if (!Mipmap.isLegalFormatForPackedPixelType(n2, n6)) {
            return 100904;
        }
        if (!Mipmap.isLegalFormatForPackedPixelType(n2, n10)) {
            return 100904;
        }
        try {
            shortBuffer2 = Buffers.newDirectByteBuffer(Mipmap.imageSize3D(n3, n4, n5, n2, 5123)).asShortBuffer();
            shortBuffer = Buffers.newDirectByteBuffer(Mipmap.imageSize3D(n3, n4, n5, n2, 5123)).asShortBuffer();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            return 100902;
        }
        Mipmap.retrieveStoreModes3D(gL, pixelStorageModes);
        Image.fillImage3D(pixelStorageModes, n3, n4, n5, n2, n6, Mipmap.is_index(n2), byteBuffer, shortBuffer2);
        int n11 = Mipmap.elements_per_group(n2, 0);
        ScaleInternal.scaleInternal3D(n11, n3, n4, n5, shortBuffer2, n7, n8, n9, shortBuffer);
        Image.emptyImage3D(pixelStorageModes, n7, n8, n9, n2, n10, Mipmap.is_index(n2), shortBuffer, byteBuffer2);
        return 0;
    }
}

