/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.glu;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.glu.GLUquadric;
import com.jogamp.opengl.util.ImmModeSink;
import com.jogamp.opengl.util.glsl.ShaderState;

public class GLUquadricImpl
implements GLUquadric {
    private final boolean useGLSL;
    private int drawStyle;
    private int orientation;
    private boolean textureFlag;
    private int normals;
    private boolean immModeSinkEnabled;
    private boolean immModeSinkImmediate;
    public int normalType;
    public GL gl;
    public ShaderState shaderState;
    public int shaderProgram;
    public static final boolean USE_NORM = true;
    public static final boolean USE_TEXT = false;
    private ImmModeSink immModeSink = null;
    private static final float PI = (float)Math.PI;
    private static final float PI_2 = (float)Math.PI * 2;
    private static final int CACHE_SIZE = 240;

    public GLUquadricImpl(GL gL, boolean bl, ShaderState shaderState, int n2) {
        this.gl = gL;
        this.useGLSL = bl;
        this.drawStyle = 100012;
        this.orientation = 100020;
        this.textureFlag = false;
        this.normals = 100000;
        this.normalType = gL.isGLES1() ? 5120 : 5126;
        this.immModeSinkImmediate = true;
        this.immModeSinkEnabled = !gL.isGL2();
        this.shaderState = shaderState;
        this.shaderProgram = n2;
        this.replaceImmModeSink();
    }

    @Override
    public void enableImmModeSink(boolean bl) {
        this.immModeSinkEnabled = this.gl.isGL2() ? bl : true;
        if (null == this.immModeSink && this.immModeSinkEnabled) {
            this.replaceImmModeSink();
        }
    }

    @Override
    public boolean isImmModeSinkEnabled() {
        return this.immModeSinkEnabled;
    }

    @Override
    public void setImmMode(boolean bl) {
        this.immModeSinkImmediate = this.immModeSinkEnabled ? bl : true;
    }

    @Override
    public boolean getImmMode() {
        return this.immModeSinkImmediate;
    }

    @Override
    public ImmModeSink replaceImmModeSink() {
        if (!this.immModeSinkEnabled) {
            return null;
        }
        ImmModeSink immModeSink = this.immModeSink;
        this.immModeSink = this.useGLSL ? (null != this.shaderState ? ImmModeSink.createGLSL(32, 3, 5126, 0, 5126, 3, this.normalType, 0, 5126, 35044, this.shaderState) : ImmModeSink.createGLSL(32, 3, 5126, 0, 5126, 3, this.normalType, 0, 5126, 35044, this.shaderProgram)) : ImmModeSink.createFixed(32, 3, 5126, 0, 5126, 3, this.normalType, 0, 5126, 35044);
        return immModeSink;
    }

    @Override
    public void resetImmModeSink(GL gL) {
        if (this.immModeSinkEnabled) {
            this.immModeSink.reset(gL);
        }
    }

    public void setDrawStyle(int n2) {
        this.drawStyle = n2;
    }

    public void setNormals(int n2) {
        this.normals = n2;
    }

    public void setOrientation(int n2) {
        this.orientation = n2;
    }

    public void setTextureFlag(boolean bl) {
        this.textureFlag = bl;
    }

    public int getDrawStyle() {
        return this.drawStyle;
    }

    public int getNormals() {
        return this.normals;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public boolean getTextureFlag() {
        return this.textureFlag;
    }

    public void drawCylinder(GL gL, float f2, float f3, float f4, int n2, int n3) {
        float f5 = this.orientation == 100021 ? -1.0f : 1.0f;
        float f6 = (float)Math.PI * 2 / (float)n2;
        float f7 = (f3 - f2) / (float)n3;
        float f8 = f4 / (float)n3;
        float f9 = (f2 - f3) / f4;
        if (this.drawStyle == 100010) {
            this.glBegin(gL, 0);
            for (int i2 = 0; i2 < n2; ++i2) {
                float f10 = this.cos((float)i2 * f6);
                float f11 = this.sin((float)i2 * f6);
                this.normal3f(gL, f10 * f5, f11 * f5, f9 * f5);
                float f12 = 0.0f;
                float f13 = f2;
                for (int i3 = 0; i3 <= n3; ++i3) {
                    this.glVertex3f(gL, f10 * f13, f11 * f13, f12);
                    f12 += f8;
                    f13 += f7;
                }
            }
            this.glEnd(gL);
        } else if (this.drawStyle == 100011 || this.drawStyle == 100013) {
            float f14;
            float f15;
            int n4;
            if (this.drawStyle == 100011) {
                float f16 = 0.0f;
                float f17 = f2;
                for (int i4 = 0; i4 <= n3; ++i4) {
                    this.glBegin(gL, 2);
                    for (n4 = 0; n4 < n2; ++n4) {
                        f15 = this.cos((float)n4 * f6);
                        f14 = this.sin((float)n4 * f6);
                        this.normal3f(gL, f15 * f5, f14 * f5, f9 * f5);
                        this.glVertex3f(gL, f15 * f17, f14 * f17, f16);
                    }
                    this.glEnd(gL);
                    f16 += f8;
                    f17 += f7;
                }
            } else if ((double)f2 != 0.0) {
                this.glBegin(gL, 2);
                for (n4 = 0; n4 < n2; ++n4) {
                    f15 = this.cos((float)n4 * f6);
                    f14 = this.sin((float)n4 * f6);
                    this.normal3f(gL, f15 * f5, f14 * f5, f9 * f5);
                    this.glVertex3f(gL, f15 * f2, f14 * f2, 0.0f);
                }
                this.glEnd(gL);
                this.glBegin(gL, 2);
                for (n4 = 0; n4 < n2; ++n4) {
                    f15 = this.cos((float)n4 * f6);
                    f14 = this.sin((float)n4 * f6);
                    this.normal3f(gL, f15 * f5, f14 * f5, f9 * f5);
                    this.glVertex3f(gL, f15 * f3, f14 * f3, f4);
                }
                this.glEnd(gL);
            }
            this.glBegin(gL, 1);
            for (n4 = 0; n4 < n2; ++n4) {
                f15 = this.cos((float)n4 * f6);
                f14 = this.sin((float)n4 * f6);
                this.normal3f(gL, f15 * f5, f14 * f5, f9 * f5);
                this.glVertex3f(gL, f15 * f2, f14 * f2, 0.0f);
                this.glVertex3f(gL, f15 * f3, f14 * f3, f4);
            }
            this.glEnd(gL);
        } else if (this.drawStyle == 100012) {
            float f18 = 1.0f / (float)n2;
            float f19 = 1.0f / (float)n3;
            float f20 = 0.0f;
            float f21 = 0.0f;
            float f22 = f2;
            for (int i5 = 0; i5 < n3; ++i5) {
                float f23 = 0.0f;
                this.glBegin(gL, 8);
                for (int i6 = 0; i6 <= n2; ++i6) {
                    float f24;
                    float f25;
                    if (i6 == n2) {
                        f25 = this.sin(0.0f);
                        f24 = this.cos(0.0f);
                    } else {
                        f25 = this.sin((float)i6 * f6);
                        f24 = this.cos((float)i6 * f6);
                    }
                    this.normal3f(gL, f25 * f5, f24 * f5, f9 * f5);
                    this.TXTR_COORD(gL, f23, f20);
                    this.glVertex3f(gL, f25 * f22, f24 * f22, f21);
                    this.normal3f(gL, f25 * f5, f24 * f5, f9 * f5);
                    this.TXTR_COORD(gL, f23, f20 + f19);
                    this.glVertex3f(gL, f25 * (f22 + f7), f24 * (f22 + f7), f21 + f8);
                    f23 += f18;
                }
                this.glEnd(gL);
                f22 += f7;
                f20 += f19;
                f21 += f8;
            }
        }
    }

    public void drawDisk(GL gL, float f2, float f3, int n2, int n3) {
        if (this.normals != 100002) {
            if (this.orientation == 100020) {
                this.glNormal3f(gL, 0.0f, 0.0f, 1.0f);
            } else {
                this.glNormal3f(gL, 0.0f, 0.0f, -1.0f);
            }
        }
        float f4 = (float)Math.PI * 2 / (float)n2;
        float f5 = (f3 - f2) / (float)n3;
        switch (this.drawStyle) {
            case 100012: {
                float f6 = 2.0f * f3;
                float f7 = f2;
                for (int i2 = 0; i2 < n3; ++i2) {
                    float f8;
                    float f9;
                    float f10;
                    int n4;
                    float f11 = f7 + f5;
                    if (this.orientation == 100020) {
                        this.glBegin(gL, 8);
                        for (n4 = 0; n4 <= n2; ++n4) {
                            f10 = n4 == n2 ? 0.0f : (float)n4 * f4;
                            f9 = this.sin(f10);
                            f8 = this.cos(f10);
                            this.TXTR_COORD(gL, 0.5f + f9 * f11 / f6, 0.5f + f8 * f11 / f6);
                            this.glVertex2f(gL, f11 * f9, f11 * f8);
                            this.TXTR_COORD(gL, 0.5f + f9 * f7 / f6, 0.5f + f8 * f7 / f6);
                            this.glVertex2f(gL, f7 * f9, f7 * f8);
                        }
                        this.glEnd(gL);
                    } else {
                        this.glBegin(gL, 8);
                        for (n4 = n2; n4 >= 0; --n4) {
                            f10 = n4 == n2 ? 0.0f : (float)n4 * f4;
                            f9 = this.sin(f10);
                            f8 = this.cos(f10);
                            this.TXTR_COORD(gL, 0.5f - f9 * f11 / f6, 0.5f + f8 * f11 / f6);
                            this.glVertex2f(gL, f11 * f9, f11 * f8);
                            this.TXTR_COORD(gL, 0.5f - f9 * f7 / f6, 0.5f + f8 * f7 / f6);
                            this.glVertex2f(gL, f7 * f9, f7 * f8);
                        }
                        this.glEnd(gL);
                    }
                    f7 = f11;
                }
                break;
            }
            case 100011: {
                float f12;
                int n5;
                float f13;
                int n6;
                for (n6 = 0; n6 <= n3; ++n6) {
                    f13 = f2 + (float)n6 * f5;
                    this.glBegin(gL, 2);
                    for (n5 = 0; n5 < n2; ++n5) {
                        f12 = (float)n5 * f4;
                        this.glVertex2f(gL, f13 * this.sin(f12), f13 * this.cos(f12));
                    }
                    this.glEnd(gL);
                }
                for (n5 = 0; n5 < n2; ++n5) {
                    f13 = (float)n5 * f4;
                    f12 = this.sin(f13);
                    float f14 = this.cos(f13);
                    this.glBegin(gL, 3);
                    for (n6 = 0; n6 <= n3; ++n6) {
                        float f15 = f2 + (float)n6 * f5;
                        this.glVertex2f(gL, f15 * f12, f15 * f14);
                    }
                    this.glEnd(gL);
                }
                break;
            }
            case 100010: {
                this.glBegin(gL, 0);
                for (int i3 = 0; i3 < n2; ++i3) {
                    float f16 = (float)i3 * f4;
                    float f17 = this.sin(f16);
                    float f18 = this.cos(f16);
                    for (int i4 = 0; i4 <= n3; ++i4) {
                        float f19 = f2 * (float)i4 * f5;
                        this.glVertex2f(gL, f19 * f17, f19 * f18);
                    }
                }
                this.glEnd(gL);
                break;
            }
            case 100013: {
                float f20;
                float f21;
                float f22;
                if ((double)f2 != 0.0) {
                    this.glBegin(gL, 2);
                    for (f22 = 0.0f; f22 < (float)Math.PI * 2; f22 += f4) {
                        f21 = f2 * this.sin(f22);
                        f20 = f2 * this.cos(f22);
                        this.glVertex2f(gL, f21, f20);
                    }
                    this.glEnd(gL);
                }
                this.glBegin(gL, 2);
                for (f22 = 0.0f; f22 < (float)Math.PI * 2; f22 += f4) {
                    f21 = f3 * this.sin(f22);
                    f20 = f3 * this.cos(f22);
                    this.glVertex2f(gL, f21, f20);
                }
                this.glEnd(gL);
                break;
            }
            default: {
                return;
            }
        }
    }

    public void drawPartialDisk(GL gL, float f2, float f3, int n2, int n3, float f4, float f5) {
        int n4;
        float[] fArray = new float[240];
        float[] fArray2 = new float[240];
        float f6 = 0.0f;
        float f7 = 0.0f;
        if (n2 >= 240) {
            n2 = 239;
        }
        if (n2 < 2 || n3 < 1 || f3 <= 0.0f || f2 < 0.0f || f2 > f3) {
            System.err.println("PartialDisk: GLU_INVALID_VALUE");
            return;
        }
        if (f5 < -360.0f) {
            f5 = 360.0f;
        }
        if (f5 > 360.0f) {
            f5 = 360.0f;
        }
        if (f5 < 0.0f) {
            f4 += f5;
            f5 = -f5;
        }
        int n5 = f5 == 360.0f ? n2 : n2 + 1;
        float f8 = f3 - f2;
        float f9 = f4 / 180.0f * (float)Math.PI;
        for (n4 = 0; n4 <= n2; ++n4) {
            float f10 = f9 + (float)Math.PI * f5 / 180.0f * (float)n4 / (float)n2;
            fArray[n4] = this.sin(f10);
            fArray2[n4] = this.cos(f10);
        }
        if (f5 == 360.0f) {
            fArray[n2] = fArray[0];
            fArray2[n2] = fArray2[0];
        }
        switch (this.normals) {
            case 100000: 
            case 100001: {
                if (this.orientation == 100020) {
                    this.glNormal3f(gL, 0.0f, 0.0f, 1.0f);
                    break;
                }
                this.glNormal3f(gL, 0.0f, 0.0f, -1.0f);
                break;
            }
        }
        block3 : switch (this.drawStyle) {
            case 100012: {
                float f11;
                int n6;
                if (f2 == 0.0f) {
                    n6 = n3 - 1;
                    this.glBegin(gL, 6);
                    if (this.textureFlag) {
                        this.glTexCoord2f(gL, 0.5f, 0.5f);
                    }
                    this.glVertex3f(gL, 0.0f, 0.0f, 0.0f);
                    f11 = f3 - f8 * ((float)(n3 - 1) / (float)n3);
                    if (this.textureFlag) {
                        f6 = f11 / f3 / 2.0f;
                    }
                    if (this.orientation == 100020) {
                        for (n4 = n2; n4 >= 0; --n4) {
                            if (this.textureFlag) {
                                this.glTexCoord2f(gL, f6 * fArray[n4] + 0.5f, f6 * fArray2[n4] + 0.5f);
                            }
                            this.glVertex3f(gL, f11 * fArray[n4], f11 * fArray2[n4], 0.0f);
                        }
                    } else {
                        for (n4 = 0; n4 <= n2; ++n4) {
                            if (this.textureFlag) {
                                this.glTexCoord2f(gL, f6 * fArray[n4] + 0.5f, f6 * fArray2[n4] + 0.5f);
                            }
                            this.glVertex3f(gL, f11 * fArray[n4], f11 * fArray2[n4], 0.0f);
                        }
                    }
                    this.glEnd(gL);
                } else {
                    n6 = n3;
                }
                for (int i2 = 0; i2 < n6; ++i2) {
                    f11 = f3 - f8 * ((float)i2 / (float)n3);
                    float f12 = f3 - f8 * ((float)(i2 + 1) / (float)n3);
                    if (this.textureFlag) {
                        f6 = f11 / f3 / 2.0f;
                        f7 = f12 / f3 / 2.0f;
                    }
                    this.glBegin(gL, 8);
                    for (n4 = 0; n4 <= n2; ++n4) {
                        if (this.orientation == 100020) {
                            if (this.textureFlag) {
                                this.glTexCoord2f(gL, f6 * fArray[n4] + 0.5f, f6 * fArray2[n4] + 0.5f);
                            }
                            this.glVertex3f(gL, f11 * fArray[n4], f11 * fArray2[n4], 0.0f);
                            if (this.textureFlag) {
                                this.glTexCoord2f(gL, f7 * fArray[n4] + 0.5f, f7 * fArray2[n4] + 0.5f);
                            }
                            this.glVertex3f(gL, f12 * fArray[n4], f12 * fArray2[n4], 0.0f);
                            continue;
                        }
                        if (this.textureFlag) {
                            this.glTexCoord2f(gL, f7 * fArray[n4] + 0.5f, f7 * fArray2[n4] + 0.5f);
                        }
                        this.glVertex3f(gL, f12 * fArray[n4], f12 * fArray2[n4], 0.0f);
                        if (this.textureFlag) {
                            this.glTexCoord2f(gL, f6 * fArray[n4] + 0.5f, f6 * fArray2[n4] + 0.5f);
                        }
                        this.glVertex3f(gL, f11 * fArray[n4], f11 * fArray2[n4], 0.0f);
                    }
                    this.glEnd(gL);
                }
                break;
            }
            case 100010: {
                this.glBegin(gL, 0);
                for (n4 = 0; n4 < n5; ++n4) {
                    float f13 = fArray[n4];
                    float f14 = fArray2[n4];
                    for (int i3 = 0; i3 <= n3; ++i3) {
                        float f15 = f3 - f8 * ((float)i3 / (float)n3);
                        if (this.textureFlag) {
                            f6 = f15 / f3 / 2.0f;
                            this.glTexCoord2f(gL, f6 * fArray[n4] + 0.5f, f6 * fArray2[n4] + 0.5f);
                        }
                        this.glVertex3f(gL, f15 * f13, f15 * f14, 0.0f);
                    }
                }
                this.glEnd(gL);
                break;
            }
            case 100011: {
                float f16;
                int n7;
                if (f2 == f3) {
                    this.glBegin(gL, 3);
                    for (n4 = 0; n4 <= n2; ++n4) {
                        if (this.textureFlag) {
                            this.glTexCoord2f(gL, fArray[n4] / 2.0f + 0.5f, fArray2[n4] / 2.0f + 0.5f);
                        }
                        this.glVertex3f(gL, f2 * fArray[n4], f2 * fArray2[n4], 0.0f);
                    }
                    this.glEnd(gL);
                    break;
                }
                for (n7 = 0; n7 <= n3; ++n7) {
                    f16 = f3 - f8 * ((float)n7 / (float)n3);
                    if (this.textureFlag) {
                        f6 = f16 / f3 / 2.0f;
                    }
                    this.glBegin(gL, 3);
                    for (n4 = 0; n4 <= n2; ++n4) {
                        if (this.textureFlag) {
                            this.glTexCoord2f(gL, f6 * fArray[n4] + 0.5f, f6 * fArray2[n4] + 0.5f);
                        }
                        this.glVertex3f(gL, f16 * fArray[n4], f16 * fArray2[n4], 0.0f);
                    }
                    this.glEnd(gL);
                }
                for (n4 = 0; n4 < n5; ++n4) {
                    float f17 = fArray[n4];
                    float f18 = fArray2[n4];
                    this.glBegin(gL, 3);
                    for (n7 = 0; n7 <= n3; ++n7) {
                        f16 = f3 - f8 * ((float)n7 / (float)n3);
                        if (this.textureFlag) {
                            f6 = f16 / f3 / 2.0f;
                        }
                        if (this.textureFlag) {
                            this.glTexCoord2f(gL, f6 * fArray[n4] + 0.5f, f6 * fArray2[n4] + 0.5f);
                        }
                        this.glVertex3f(gL, f16 * f17, f16 * f18, 0.0f);
                    }
                    this.glEnd(gL);
                }
                break;
            }
            case 100013: {
                float f19;
                int n8;
                if (f5 < 360.0f) {
                    for (n4 = 0; n4 <= n2; n4 += n2) {
                        float f20 = fArray[n4];
                        float f21 = fArray2[n4];
                        this.glBegin(gL, 3);
                        for (n8 = 0; n8 <= n3; ++n8) {
                            f19 = f3 - f8 * ((float)n8 / (float)n3);
                            if (this.textureFlag) {
                                f6 = f19 / f3 / 2.0f;
                                this.glTexCoord2f(gL, f6 * fArray[n4] + 0.5f, f6 * fArray2[n4] + 0.5f);
                            }
                            this.glVertex3f(gL, f19 * f20, f19 * f21, 0.0f);
                        }
                        this.glEnd(gL);
                    }
                }
                for (n8 = 0; n8 <= n3; n8 += n3) {
                    f19 = f3 - f8 * ((float)n8 / (float)n3);
                    if (this.textureFlag) {
                        f6 = f19 / f3 / 2.0f;
                    }
                    this.glBegin(gL, 3);
                    for (n4 = 0; n4 <= n2; ++n4) {
                        if (this.textureFlag) {
                            this.glTexCoord2f(gL, f6 * fArray[n4] + 0.5f, f6 * fArray2[n4] + 0.5f);
                        }
                        this.glVertex3f(gL, f19 * fArray[n4], f19 * fArray2[n4], 0.0f);
                    }
                    this.glEnd(gL);
                    if (f2 == f3) break block3;
                }
                break;
            }
        }
    }

    public void drawSphere(GL gL, float f2, int n2, int n3) {
        boolean bl = this.normals != 100002;
        float f3 = this.orientation == 100021 ? -1.0f : 1.0f;
        float f4 = (float)Math.PI / (float)n3;
        float f5 = (float)Math.PI * 2 / (float)n2;
        if (this.drawStyle == 100012) {
            float f6;
            float f7;
            int n4;
            int n5;
            float f8;
            float f9;
            float f10;
            float f11;
            int n6;
            if (!this.textureFlag) {
                this.glBegin(gL, 6);
                this.glNormal3f(gL, 0.0f, 0.0f, 1.0f);
                this.glVertex3f(gL, 0.0f, 0.0f, f3 * f2);
                for (n6 = 0; n6 <= n2; ++n6) {
                    f11 = n6 == n2 ? 0.0f : (float)n6 * f5;
                    f10 = -this.sin(f11) * this.sin(f4);
                    f9 = this.cos(f11) * this.sin(f4);
                    f8 = f3 * this.cos(f4);
                    if (bl) {
                        this.glNormal3f(gL, f10 * f3, f9 * f3, f8 * f3);
                    }
                    this.glVertex3f(gL, f10 * f2, f9 * f2, f8 * f2);
                }
                this.glEnd(gL);
            }
            float f12 = 1.0f / (float)n2;
            float f13 = 1.0f / (float)n3;
            float f14 = 1.0f;
            if (this.textureFlag) {
                n5 = 0;
                n4 = n3;
            } else {
                n5 = 1;
                n4 = n3 - 1;
            }
            for (int i2 = n5; i2 < n4; ++i2) {
                f7 = (float)i2 * f4;
                this.glBegin(gL, 8);
                f6 = 0.0f;
                for (n6 = 0; n6 <= n2; ++n6) {
                    f11 = n6 == n2 ? 0.0f : (float)n6 * f5;
                    f10 = -this.sin(f11) * this.sin(f7);
                    f9 = this.cos(f11) * this.sin(f7);
                    f8 = f3 * this.cos(f7);
                    if (bl) {
                        this.glNormal3f(gL, f10 * f3, f9 * f3, f8 * f3);
                    }
                    this.TXTR_COORD(gL, f6, f14);
                    this.glVertex3f(gL, f10 * f2, f9 * f2, f8 * f2);
                    f10 = -this.sin(f11) * this.sin(f7 + f4);
                    f9 = this.cos(f11) * this.sin(f7 + f4);
                    f8 = f3 * this.cos(f7 + f4);
                    if (bl) {
                        this.glNormal3f(gL, f10 * f3, f9 * f3, f8 * f3);
                    }
                    this.TXTR_COORD(gL, f6, f14 - f13);
                    f6 += f12;
                    this.glVertex3f(gL, f10 * f2, f9 * f2, f8 * f2);
                }
                this.glEnd(gL);
                f14 -= f13;
            }
            if (!this.textureFlag) {
                this.glBegin(gL, 6);
                this.glNormal3f(gL, 0.0f, 0.0f, -1.0f);
                this.glVertex3f(gL, 0.0f, 0.0f, -f2 * f3);
                f7 = (float)Math.PI - f4;
                f6 = 1.0f;
                for (n6 = n2; n6 >= 0; --n6) {
                    f11 = n6 == n2 ? 0.0f : (float)n6 * f5;
                    f10 = -this.sin(f11) * this.sin(f7);
                    f9 = this.cos(f11) * this.sin(f7);
                    f8 = f3 * this.cos(f7);
                    if (bl) {
                        this.glNormal3f(gL, f10 * f3, f9 * f3, f8 * f3);
                    }
                    f6 -= f12;
                    this.glVertex3f(gL, f10 * f2, f9 * f2, f8 * f2);
                }
                this.glEnd(gL);
            }
        } else if (this.drawStyle == 100011 || this.drawStyle == 100013) {
            float f15;
            float f16;
            float f17;
            float f18;
            int n7;
            float f19;
            int n8;
            for (n8 = 1; n8 < n3; ++n8) {
                f19 = (float)n8 * f4;
                this.glBegin(gL, 2);
                for (n7 = 0; n7 < n2; ++n7) {
                    f18 = (float)n7 * f5;
                    f17 = this.cos(f18) * this.sin(f19);
                    f16 = this.sin(f18) * this.sin(f19);
                    f15 = this.cos(f19);
                    if (bl) {
                        this.glNormal3f(gL, f17 * f3, f16 * f3, f15 * f3);
                    }
                    this.glVertex3f(gL, f17 * f2, f16 * f2, f15 * f2);
                }
                this.glEnd(gL);
            }
            for (n7 = 0; n7 < n2; ++n7) {
                f18 = (float)n7 * f5;
                this.glBegin(gL, 3);
                for (n8 = 0; n8 <= n3; ++n8) {
                    f19 = (float)n8 * f4;
                    f17 = this.cos(f18) * this.sin(f19);
                    f16 = this.sin(f18) * this.sin(f19);
                    f15 = this.cos(f19);
                    if (bl) {
                        this.glNormal3f(gL, f17 * f3, f16 * f3, f15 * f3);
                    }
                    this.glVertex3f(gL, f17 * f2, f16 * f2, f15 * f2);
                }
                this.glEnd(gL);
            }
        } else if (this.drawStyle == 100010) {
            this.glBegin(gL, 0);
            if (bl) {
                this.glNormal3f(gL, 0.0f, 0.0f, f3);
            }
            this.glVertex3f(gL, 0.0f, 0.0f, f2);
            if (bl) {
                this.glNormal3f(gL, 0.0f, 0.0f, -f3);
            }
            this.glVertex3f(gL, 0.0f, 0.0f, -f2);
            for (int i3 = 1; i3 < n3 - 1; ++i3) {
                float f20 = (float)i3 * f4;
                for (int i4 = 0; i4 < n2; ++i4) {
                    float f21 = (float)i4 * f5;
                    float f22 = this.cos(f21) * this.sin(f20);
                    float f23 = this.sin(f21) * this.sin(f20);
                    float f24 = this.cos(f20);
                    if (bl) {
                        this.glNormal3f(gL, f22 * f3, f23 * f3, f24 * f3);
                    }
                    this.glVertex3f(gL, f22 * f2, f23 * f2, f24 * f2);
                }
            }
            this.glEnd(gL);
        }
    }

    private final void glBegin(GL gL, int n2) {
        if (this.immModeSinkEnabled) {
            this.immModeSink.glBegin(n2);
        } else {
            gL.getGL2().glBegin(n2);
        }
    }

    private final void glEnd(GL gL) {
        if (this.immModeSinkEnabled) {
            this.immModeSink.glEnd(gL, this.immModeSinkImmediate);
        } else {
            gL.getGL2().glEnd();
        }
    }

    private final void glVertex2f(GL gL, float f2, float f3) {
        if (this.immModeSinkEnabled) {
            this.immModeSink.glVertex2f(f2, f3);
        } else {
            gL.getGL2().glVertex2f(f2, f3);
        }
    }

    private final void glVertex3f(GL gL, float f2, float f3, float f4) {
        if (this.immModeSinkEnabled) {
            this.immModeSink.glVertex3f(f2, f3, f4);
        } else {
            gL.getGL2().glVertex3f(f2, f3, f4);
        }
    }

    private final void glNormal3f_s(GL gL, float f2, float f3, float f4) {
        short s2 = (short)(f2 * 65535.0f);
        short s3 = (short)(f3 * 65535.0f);
        short s4 = (short)(f4 * 65535.0f);
        if (this.immModeSinkEnabled) {
            this.immModeSink.glNormal3s(s2, s3, s4);
        } else {
            gL.getGL2().glNormal3s(s2, s3, s4);
        }
    }

    private final void glNormal3f_b(GL gL, float f2, float f3, float f4) {
        byte by = (byte)(f2 * 255.0f);
        byte by2 = (byte)(f3 * 255.0f);
        byte by3 = (byte)(f4 * 255.0f);
        if (this.immModeSinkEnabled) {
            this.immModeSink.glNormal3b(by, by2, by3);
        } else {
            gL.getGL2().glNormal3b(by, by2, by3);
        }
    }

    private final void glNormal3f(GL gL, float f2, float f3, float f4) {
        switch (this.normalType) {
            case 5126: {
                if (this.immModeSinkEnabled) {
                    this.immModeSink.glNormal3f(f2, f3, f4);
                    break;
                }
                gL.getGL2().glNormal3f(f2, f3, f4);
                break;
            }
            case 5122: {
                this.glNormal3f_s(gL, f2, f3, f4);
                break;
            }
            case 5120: {
                this.glNormal3f_b(gL, f2, f3, f4);
            }
        }
    }

    private final void glTexCoord2f(GL gL, float f2, float f3) {
        if (this.immModeSinkEnabled) {
            this.immModeSink.glTexCoord2f(f2, f3);
        } else {
            gL.getGL2().glTexCoord2f(f2, f3);
        }
    }

    private void normal3f(GL gL, float f2, float f3, float f4) {
        float f5 = (float)Math.sqrt(f2 * f2 + f3 * f3 + f4 * f4);
        if (f5 > 1.0E-5f) {
            f2 /= f5;
            f3 /= f5;
            f4 /= f5;
        }
        this.glNormal3f(gL, f2, f3, f4);
    }

    private final void TXTR_COORD(GL gL, float f2, float f3) {
        if (this.textureFlag) {
            this.glTexCoord2f(gL, f2, f3);
        }
    }

    private float sin(float f2) {
        return (float)Math.sin(f2);
    }

    private float cos(float f2) {
        return (float)Math.cos(f2);
    }
}

