/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.gl2;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GL2;
import java.nio.DoubleBuffer;
import java.nio.IntBuffer;

public class ProjectDouble {
    private static final double[] IDENTITY_MATRIX = new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0};
    private final double[] matrix = new double[16];
    private final double[][] tempMatrix = new double[4][4];
    private final double[] in = new double[4];
    private final double[] out = new double[4];
    private final DoubleBuffer matrixBuf;
    private final DoubleBuffer tempMatrixBuf;
    private final DoubleBuffer inBuf;
    private final DoubleBuffer outBuf;
    private final DoubleBuffer forwardBuf;
    private final DoubleBuffer sideBuf;
    private final DoubleBuffer upBuf;

    public ProjectDouble() {
        DoubleBuffer doubleBuffer = Buffers.newDirectDoubleBuffer(128);
        int n2 = 0;
        int n3 = 16;
        this.matrixBuf = ProjectDouble.slice(doubleBuffer, n2, n3);
        this.tempMatrixBuf = ProjectDouble.slice(doubleBuffer, n2 += n3, n3);
        n2 += n3;
        n3 = 4;
        this.inBuf = ProjectDouble.slice(doubleBuffer, n2, n3);
        this.outBuf = ProjectDouble.slice(doubleBuffer, n2 += n3, n3);
        n2 += n3;
        n3 = 3;
        this.forwardBuf = ProjectDouble.slice(doubleBuffer, n2, n3);
        this.sideBuf = ProjectDouble.slice(doubleBuffer, n2 += n3, n3);
        this.upBuf = ProjectDouble.slice(doubleBuffer, n2 += n3, n3);
    }

    private static DoubleBuffer slice(DoubleBuffer doubleBuffer, int n2, int n3) {
        doubleBuffer.position(n2);
        doubleBuffer.limit(n2 + n3);
        return doubleBuffer.slice();
    }

    private void __gluMakeIdentityd(DoubleBuffer doubleBuffer) {
        int n2 = doubleBuffer.position();
        doubleBuffer.put(IDENTITY_MATRIX);
        doubleBuffer.position(n2);
    }

    private void __gluMakeIdentityd(double[] dArray) {
        for (int i2 = 0; i2 < 16; ++i2) {
            dArray[i2] = IDENTITY_MATRIX[i2];
        }
    }

    private void __gluMultMatrixVecd(double[] dArray, int n2, double[] dArray2, double[] dArray3) {
        for (int i2 = 0; i2 < 4; ++i2) {
            dArray3[i2] = dArray2[0] * dArray[0 + i2 + n2] + dArray2[1] * dArray[4 + i2 + n2] + dArray2[2] * dArray[8 + i2 + n2] + dArray2[3] * dArray[12 + i2 + n2];
        }
    }

    private void __gluMultMatrixVecd(DoubleBuffer doubleBuffer, DoubleBuffer doubleBuffer2, DoubleBuffer doubleBuffer3) {
        int n2 = doubleBuffer2.position();
        int n3 = doubleBuffer3.position();
        int n4 = doubleBuffer.position();
        for (int i2 = 0; i2 < 4; ++i2) {
            doubleBuffer3.put(i2 + n3, doubleBuffer2.get(0 + n2) * doubleBuffer.get(0 + i2 + n4) + doubleBuffer2.get(1 + n2) * doubleBuffer.get(4 + i2 + n4) + doubleBuffer2.get(2 + n2) * doubleBuffer.get(8 + i2 + n4) + doubleBuffer2.get(3 + n2) * doubleBuffer.get(12 + i2 + n4));
        }
    }

    private boolean __gluInvertMatrixd(double[] dArray, double[] dArray2) {
        int n2;
        int n3;
        double[][] dArray3 = this.tempMatrix;
        for (n3 = 0; n3 < 4; ++n3) {
            for (n2 = 0; n2 < 4; ++n2) {
                dArray3[n3][n2] = dArray[n3 * 4 + n2];
            }
        }
        this.__gluMakeIdentityd(dArray2);
        for (n3 = 0; n3 < 4; ++n3) {
            double d2;
            int n4;
            int n5 = n3;
            for (n2 = n3 + 1; n2 < 4; ++n2) {
                if (!(Math.abs(dArray3[n2][n3]) > Math.abs(dArray3[n3][n3]))) continue;
                n5 = n2;
            }
            if (n5 != n3) {
                for (n4 = 0; n4 < 4; ++n4) {
                    d2 = dArray3[n3][n4];
                    dArray3[n3][n4] = dArray3[n5][n4];
                    dArray3[n5][n4] = d2;
                    d2 = dArray2[n3 * 4 + n4];
                    dArray2[n3 * 4 + n4] = dArray2[n5 * 4 + n4];
                    dArray2[n5 * 4 + n4] = d2;
                }
            }
            if (dArray3[n3][n3] == 0.0) {
                return false;
            }
            d2 = dArray3[n3][n3];
            for (n4 = 0; n4 < 4; ++n4) {
                double[] dArray4 = dArray3[n3];
                int n6 = n4;
                dArray4[n6] = dArray4[n6] / d2;
                int n7 = n3 * 4 + n4;
                dArray2[n7] = dArray2[n7] / d2;
            }
            for (n2 = 0; n2 < 4; ++n2) {
                if (n2 == n3) continue;
                d2 = dArray3[n2][n3];
                for (n4 = 0; n4 < 4; ++n4) {
                    double[] dArray5 = dArray3[n2];
                    int n8 = n4;
                    dArray5[n8] = dArray5[n8] - dArray3[n3][n4] * d2;
                    int n9 = n2 * 4 + n4;
                    dArray2[n9] = dArray2[n9] - dArray2[n3 * 4 + n4] * d2;
                }
            }
        }
        return true;
    }

    private boolean __gluInvertMatrixd(DoubleBuffer doubleBuffer, DoubleBuffer doubleBuffer2) {
        int n2;
        int n3;
        int n4 = doubleBuffer.position();
        int n5 = doubleBuffer2.position();
        DoubleBuffer doubleBuffer3 = this.tempMatrixBuf;
        for (n3 = 0; n3 < 4; ++n3) {
            for (n2 = 0; n2 < 4; ++n2) {
                doubleBuffer3.put(n3 * 4 + n2, doubleBuffer.get(n3 * 4 + n2 + n4));
            }
        }
        this.__gluMakeIdentityd(doubleBuffer2);
        for (n3 = 0; n3 < 4; ++n3) {
            double d2;
            int n6;
            int n7 = n3;
            for (n2 = n3 + 1; n2 < 4; ++n2) {
                if (!(Math.abs(doubleBuffer3.get(n2 * 4 + n3)) > Math.abs(doubleBuffer3.get(n3 * 4 + n3)))) continue;
                n7 = n2;
            }
            if (n7 != n3) {
                for (n6 = 0; n6 < 4; ++n6) {
                    d2 = doubleBuffer3.get(n3 * 4 + n6);
                    doubleBuffer3.put(n3 * 4 + n6, doubleBuffer3.get(n7 * 4 + n6));
                    doubleBuffer3.put(n7 * 4 + n6, d2);
                    d2 = doubleBuffer2.get(n3 * 4 + n6 + n5);
                    doubleBuffer2.put(n3 * 4 + n6 + n5, doubleBuffer2.get(n7 * 4 + n6 + n5));
                    doubleBuffer2.put(n7 * 4 + n6 + n5, d2);
                }
            }
            if (doubleBuffer3.get(n3 * 4 + n3) == 0.0) {
                return false;
            }
            d2 = doubleBuffer3.get(n3 * 4 + n3);
            for (n6 = 0; n6 < 4; ++n6) {
                doubleBuffer3.put(n3 * 4 + n6, doubleBuffer3.get(n3 * 4 + n6) / d2);
                doubleBuffer2.put(n3 * 4 + n6 + n5, doubleBuffer2.get(n3 * 4 + n6 + n5) / d2);
            }
            for (n2 = 0; n2 < 4; ++n2) {
                if (n2 == n3) continue;
                d2 = doubleBuffer3.get(n2 * 4 + n3);
                for (n6 = 0; n6 < 4; ++n6) {
                    doubleBuffer3.put(n2 * 4 + n6, doubleBuffer3.get(n2 * 4 + n6) - doubleBuffer3.get(n3 * 4 + n6) * d2);
                    doubleBuffer2.put(n2 * 4 + n6 + n5, doubleBuffer2.get(n2 * 4 + n6 + n5) - doubleBuffer2.get(n3 * 4 + n6 + n5) * d2);
                }
            }
        }
        return true;
    }

    private void __gluMultMatricesd(double[] dArray, int n2, double[] dArray2, int n3, double[] dArray3) {
        for (int i2 = 0; i2 < 4; ++i2) {
            for (int i3 = 0; i3 < 4; ++i3) {
                dArray3[i2 * 4 + i3] = dArray[i2 * 4 + 0 + n2] * dArray2[0 + i3 + n3] + dArray[i2 * 4 + 1 + n2] * dArray2[4 + i3 + n3] + dArray[i2 * 4 + 2 + n2] * dArray2[8 + i3 + n3] + dArray[i2 * 4 + 3 + n2] * dArray2[12 + i3 + n3];
            }
        }
    }

    private void __gluMultMatricesd(DoubleBuffer doubleBuffer, DoubleBuffer doubleBuffer2, DoubleBuffer doubleBuffer3) {
        int n2 = doubleBuffer.position();
        int n3 = doubleBuffer2.position();
        int n4 = doubleBuffer3.position();
        for (int i2 = 0; i2 < 4; ++i2) {
            for (int i3 = 0; i3 < 4; ++i3) {
                doubleBuffer3.put(i2 * 4 + i3 + n4, doubleBuffer.get(i2 * 4 + 0 + n2) * doubleBuffer2.get(0 + i3 + n3) + doubleBuffer.get(i2 * 4 + 1 + n2) * doubleBuffer2.get(4 + i3 + n3) + doubleBuffer.get(i2 * 4 + 2 + n2) * doubleBuffer2.get(8 + i3 + n3) + doubleBuffer.get(i2 * 4 + 3 + n2) * doubleBuffer2.get(12 + i3 + n3));
            }
        }
    }

    private static void normalize(DoubleBuffer doubleBuffer) {
        int n2 = doubleBuffer.position();
        double d2 = Math.sqrt(doubleBuffer.get(0 + n2) * doubleBuffer.get(0 + n2) + doubleBuffer.get(1 + n2) * doubleBuffer.get(1 + n2) + doubleBuffer.get(2 + n2) * doubleBuffer.get(2 + n2));
        if (d2 == 0.0) {
            return;
        }
        d2 = 1.0 / d2;
        doubleBuffer.put(0 + n2, doubleBuffer.get(0 + n2) * d2);
        doubleBuffer.put(1 + n2, doubleBuffer.get(1 + n2) * d2);
        doubleBuffer.put(2 + n2, doubleBuffer.get(2 + n2) * d2);
    }

    private static void cross(DoubleBuffer doubleBuffer, DoubleBuffer doubleBuffer2, DoubleBuffer doubleBuffer3) {
        int n2 = doubleBuffer.position();
        int n3 = doubleBuffer2.position();
        int n4 = doubleBuffer3.position();
        doubleBuffer3.put(0 + n4, doubleBuffer.get(1 + n2) * doubleBuffer2.get(2 + n3) - doubleBuffer.get(2 + n2) * doubleBuffer2.get(1 + n3));
        doubleBuffer3.put(1 + n4, doubleBuffer.get(2 + n2) * doubleBuffer2.get(0 + n3) - doubleBuffer.get(0 + n2) * doubleBuffer2.get(2 + n3));
        doubleBuffer3.put(2 + n4, doubleBuffer.get(0 + n2) * doubleBuffer2.get(1 + n3) - doubleBuffer.get(1 + n2) * doubleBuffer2.get(0 + n3));
    }

    public void gluOrtho2D(GL2 gL2, double d2, double d3, double d4, double d5) {
        gL2.glOrtho(d2, d3, d4, d5, -1.0, 1.0);
    }

    public void gluPerspective(GL2 gL2, double d2, double d3, double d4, double d5) {
        double d6 = d2 / 2.0 * Math.PI / 180.0;
        double d7 = d5 - d4;
        double d8 = Math.sin(d6);
        if (d7 == 0.0 || d8 == 0.0 || d3 == 0.0) {
            return;
        }
        double d9 = Math.cos(d6) / d8;
        this.__gluMakeIdentityd(this.matrixBuf);
        this.matrixBuf.put(0, d9 / d3);
        this.matrixBuf.put(5, d9);
        this.matrixBuf.put(10, -(d5 + d4) / d7);
        this.matrixBuf.put(11, -1.0);
        this.matrixBuf.put(14, -2.0 * d4 * d5 / d7);
        this.matrixBuf.put(15, 0.0);
        gL2.glMultMatrixd(this.matrixBuf);
    }

    public void gluLookAt(GL2 gL2, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10) {
        DoubleBuffer doubleBuffer = this.forwardBuf;
        DoubleBuffer doubleBuffer2 = this.sideBuf;
        DoubleBuffer doubleBuffer3 = this.upBuf;
        doubleBuffer.put(0, d5 - d2);
        doubleBuffer.put(1, d6 - d3);
        doubleBuffer.put(2, d7 - d4);
        doubleBuffer3.put(0, d8);
        doubleBuffer3.put(1, d9);
        doubleBuffer3.put(2, d10);
        ProjectDouble.normalize(doubleBuffer);
        ProjectDouble.cross(doubleBuffer, doubleBuffer3, doubleBuffer2);
        ProjectDouble.normalize(doubleBuffer2);
        ProjectDouble.cross(doubleBuffer2, doubleBuffer, doubleBuffer3);
        this.__gluMakeIdentityd(this.matrixBuf);
        this.matrixBuf.put(0, doubleBuffer2.get(0));
        this.matrixBuf.put(4, doubleBuffer2.get(1));
        this.matrixBuf.put(8, doubleBuffer2.get(2));
        this.matrixBuf.put(1, doubleBuffer3.get(0));
        this.matrixBuf.put(5, doubleBuffer3.get(1));
        this.matrixBuf.put(9, doubleBuffer3.get(2));
        this.matrixBuf.put(2, -doubleBuffer.get(0));
        this.matrixBuf.put(6, -doubleBuffer.get(1));
        this.matrixBuf.put(10, -doubleBuffer.get(2));
        gL2.glMultMatrixd(this.matrixBuf);
        gL2.glTranslated(-d2, -d3, -d4);
    }

    public boolean gluProject(double d2, double d3, double d4, double[] dArray, int n2, double[] dArray2, int n3, int[] nArray, int n4, double[] dArray3, int n5) {
        double[] dArray4 = this.in;
        double[] dArray5 = this.out;
        dArray4[0] = d2;
        dArray4[1] = d3;
        dArray4[2] = d4;
        dArray4[3] = 1.0;
        this.__gluMultMatrixVecd(dArray, n2, dArray4, dArray5);
        this.__gluMultMatrixVecd(dArray2, n3, dArray5, dArray4);
        if (dArray4[3] == 0.0) {
            return false;
        }
        dArray4[3] = 1.0 / dArray4[3] * 0.5;
        dArray4[0] = dArray4[0] * dArray4[3] + 0.5;
        dArray4[1] = dArray4[1] * dArray4[3] + 0.5;
        dArray4[2] = dArray4[2] * dArray4[3] + 0.5;
        dArray3[0 + n5] = dArray4[0] * (double)nArray[2 + n4] + (double)nArray[0 + n4];
        dArray3[1 + n5] = dArray4[1] * (double)nArray[3 + n4] + (double)nArray[1 + n4];
        dArray3[2 + n5] = dArray4[2];
        return true;
    }

    public boolean gluProject(double d2, double d3, double d4, DoubleBuffer doubleBuffer, DoubleBuffer doubleBuffer2, IntBuffer intBuffer, DoubleBuffer doubleBuffer3) {
        DoubleBuffer doubleBuffer4 = this.inBuf;
        DoubleBuffer doubleBuffer5 = this.outBuf;
        doubleBuffer4.put(0, d2);
        doubleBuffer4.put(1, d3);
        doubleBuffer4.put(2, d4);
        doubleBuffer4.put(3, 1.0);
        this.__gluMultMatrixVecd(doubleBuffer, doubleBuffer4, doubleBuffer5);
        this.__gluMultMatrixVecd(doubleBuffer2, doubleBuffer5, doubleBuffer4);
        if (doubleBuffer4.get(3) == 0.0) {
            return false;
        }
        doubleBuffer4.put(3, 1.0 / doubleBuffer4.get(3) * 0.5);
        doubleBuffer4.put(0, doubleBuffer4.get(0) * doubleBuffer4.get(3) + 0.5);
        doubleBuffer4.put(1, doubleBuffer4.get(1) * doubleBuffer4.get(3) + 0.5);
        doubleBuffer4.put(2, doubleBuffer4.get(2) * doubleBuffer4.get(3) + 0.5);
        int n2 = intBuffer.position();
        int n3 = doubleBuffer3.position();
        doubleBuffer3.put(0 + n3, doubleBuffer4.get(0) * (double)intBuffer.get(2 + n2) + (double)intBuffer.get(0 + n2));
        doubleBuffer3.put(1 + n3, doubleBuffer4.get(1) * (double)intBuffer.get(3 + n2) + (double)intBuffer.get(1 + n2));
        doubleBuffer3.put(2 + n3, doubleBuffer4.get(2));
        return true;
    }

    public boolean gluUnProject(double d2, double d3, double d4, double[] dArray, int n2, double[] dArray2, int n3, int[] nArray, int n4, double[] dArray3, int n5) {
        double[] dArray4 = this.in;
        double[] dArray5 = this.out;
        this.__gluMultMatricesd(dArray, n2, dArray2, n3, this.matrix);
        if (!this.__gluInvertMatrixd(this.matrix, this.matrix)) {
            return false;
        }
        dArray4[0] = d2;
        dArray4[1] = d3;
        dArray4[2] = d4;
        dArray4[3] = 1.0;
        dArray4[0] = (dArray4[0] - (double)nArray[0 + n4]) / (double)nArray[2 + n4];
        dArray4[1] = (dArray4[1] - (double)nArray[1 + n4]) / (double)nArray[3 + n4];
        dArray4[0] = dArray4[0] * 2.0 - 1.0;
        dArray4[1] = dArray4[1] * 2.0 - 1.0;
        dArray4[2] = dArray4[2] * 2.0 - 1.0;
        this.__gluMultMatrixVecd(this.matrix, 0, dArray4, dArray5);
        if (dArray5[3] == 0.0) {
            return false;
        }
        dArray5[3] = 1.0 / dArray5[3];
        dArray3[0 + n5] = dArray5[0] * dArray5[3];
        dArray3[1 + n5] = dArray5[1] * dArray5[3];
        dArray3[2 + n5] = dArray5[2] * dArray5[3];
        return true;
    }

    public boolean gluUnProject(double d2, double d3, double d4, DoubleBuffer doubleBuffer, DoubleBuffer doubleBuffer2, IntBuffer intBuffer, DoubleBuffer doubleBuffer3) {
        DoubleBuffer doubleBuffer4 = this.inBuf;
        DoubleBuffer doubleBuffer5 = this.outBuf;
        this.__gluMultMatricesd(doubleBuffer, doubleBuffer2, this.matrixBuf);
        if (!this.__gluInvertMatrixd(this.matrixBuf, this.matrixBuf)) {
            return false;
        }
        doubleBuffer4.put(0, d2);
        doubleBuffer4.put(1, d3);
        doubleBuffer4.put(2, d4);
        doubleBuffer4.put(3, 1.0);
        int n2 = intBuffer.position();
        int n3 = doubleBuffer3.position();
        doubleBuffer4.put(0, (doubleBuffer4.get(0) - (double)intBuffer.get(0 + n2)) / (double)intBuffer.get(2 + n2));
        doubleBuffer4.put(1, (doubleBuffer4.get(1) - (double)intBuffer.get(1 + n2)) / (double)intBuffer.get(3 + n2));
        doubleBuffer4.put(0, doubleBuffer4.get(0) * 2.0 - 1.0);
        doubleBuffer4.put(1, doubleBuffer4.get(1) * 2.0 - 1.0);
        doubleBuffer4.put(2, doubleBuffer4.get(2) * 2.0 - 1.0);
        this.__gluMultMatrixVecd(this.matrixBuf, doubleBuffer4, doubleBuffer5);
        if (doubleBuffer5.get(3) == 0.0) {
            return false;
        }
        doubleBuffer5.put(3, 1.0 / doubleBuffer5.get(3));
        doubleBuffer3.put(0 + n3, doubleBuffer5.get(0) * doubleBuffer5.get(3));
        doubleBuffer3.put(1 + n3, doubleBuffer5.get(1) * doubleBuffer5.get(3));
        doubleBuffer3.put(2 + n3, doubleBuffer5.get(2) * doubleBuffer5.get(3));
        return true;
    }

    public boolean gluUnProject4(double d2, double d3, double d4, double d5, double[] dArray, int n2, double[] dArray2, int n3, int[] nArray, int n4, double d6, double d7, double[] dArray3, int n5) {
        double[] dArray4 = this.in;
        double[] dArray5 = this.out;
        this.__gluMultMatricesd(dArray, n2, dArray2, n3, this.matrix);
        if (!this.__gluInvertMatrixd(this.matrix, this.matrix)) {
            return false;
        }
        dArray4[0] = d2;
        dArray4[1] = d3;
        dArray4[2] = d4;
        dArray4[3] = d5;
        dArray4[0] = (dArray4[0] - (double)nArray[0 + n4]) / (double)nArray[2 + n4];
        dArray4[1] = (dArray4[1] - (double)nArray[1 + n4]) / (double)nArray[3 + n4];
        dArray4[2] = (dArray4[2] - d6) / (d7 - d6);
        dArray4[0] = dArray4[0] * 2.0 - 1.0;
        dArray4[1] = dArray4[1] * 2.0 - 1.0;
        dArray4[2] = dArray4[2] * 2.0 - 1.0;
        this.__gluMultMatrixVecd(this.matrix, 0, dArray4, dArray5);
        if (dArray5[3] == 0.0) {
            return false;
        }
        dArray3[0 + n5] = dArray5[0];
        dArray3[1 + n5] = dArray5[1];
        dArray3[2 + n5] = dArray5[2];
        dArray3[3 + n5] = dArray5[3];
        return true;
    }

    public boolean gluUnProject4(double d2, double d3, double d4, double d5, DoubleBuffer doubleBuffer, DoubleBuffer doubleBuffer2, IntBuffer intBuffer, double d6, double d7, DoubleBuffer doubleBuffer3) {
        DoubleBuffer doubleBuffer4 = this.inBuf;
        DoubleBuffer doubleBuffer5 = this.outBuf;
        this.__gluMultMatricesd(doubleBuffer, doubleBuffer2, this.matrixBuf);
        if (!this.__gluInvertMatrixd(this.matrixBuf, this.matrixBuf)) {
            return false;
        }
        doubleBuffer4.put(0, d2);
        doubleBuffer4.put(1, d3);
        doubleBuffer4.put(2, d4);
        doubleBuffer4.put(3, d5);
        int n2 = intBuffer.position();
        doubleBuffer4.put(0, (doubleBuffer4.get(0) - (double)intBuffer.get(0 + n2)) / (double)intBuffer.get(2 + n2));
        doubleBuffer4.put(1, (doubleBuffer4.get(1) - (double)intBuffer.get(1 + n2)) / (double)intBuffer.get(3 + n2));
        doubleBuffer4.put(2, (doubleBuffer4.get(2) - d6) / (d7 - d6));
        doubleBuffer4.put(0, doubleBuffer4.get(0) * 2.0 - 1.0);
        doubleBuffer4.put(1, doubleBuffer4.get(1) * 2.0 - 1.0);
        doubleBuffer4.put(2, doubleBuffer4.get(2) * 2.0 - 1.0);
        this.__gluMultMatrixVecd(this.matrixBuf, doubleBuffer4, doubleBuffer5);
        if (doubleBuffer5.get(3) == 0.0) {
            return false;
        }
        int n3 = doubleBuffer3.position();
        doubleBuffer3.put(0 + n3, doubleBuffer5.get(0));
        doubleBuffer3.put(1 + n3, doubleBuffer5.get(1));
        doubleBuffer3.put(2 + n3, doubleBuffer5.get(2));
        doubleBuffer3.put(3 + n3, doubleBuffer5.get(3));
        return true;
    }

    public void gluPickMatrix(GL2 gL2, double d2, double d3, double d4, double d5, IntBuffer intBuffer) {
        if (d4 <= 0.0 || d5 <= 0.0) {
            return;
        }
        int n2 = intBuffer.position();
        gL2.glTranslated(((double)intBuffer.get(2 + n2) - 2.0 * (d2 - (double)intBuffer.get(0 + n2))) / d4, ((double)intBuffer.get(3 + n2) - 2.0 * (d3 - (double)intBuffer.get(1 + n2))) / d5, 0.0);
        gL2.glScaled((double)intBuffer.get(2) / d4, (double)intBuffer.get(3) / d5, 1.0);
    }

    public void gluPickMatrix(GL2 gL2, double d2, double d3, double d4, double d5, int[] nArray, int n2) {
        if (d4 <= 0.0 || d5 <= 0.0) {
            return;
        }
        gL2.glTranslated(((double)nArray[2 + n2] - 2.0 * (d2 - (double)nArray[0 + n2])) / d4, ((double)nArray[3 + n2] - 2.0 * (d3 - (double)nArray[1 + n2])) / d5, 0.0);
        gL2.glScaled((double)nArray[2 + n2] / d4, (double)nArray[3 + n2] / d5, 1.0);
    }
}

