/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.awt;

import com.jogamp.common.GlueGenVersion;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.VersionUtil;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.JoglVersion;
import com.jogamp.opengl.awt.GLCanvas;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.TextArea;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;

public class VersionApplet
extends Applet {
    TextArea tareaVersion;
    TextArea tareaCaps;
    GLCanvas canvas;

    public static void main(String[] stringArray) {
        Frame frame = new Frame("JOGL Version Applet");
        frame.setSize(800, 600);
        frame.setLayout(new BorderLayout());
        VersionApplet versionApplet = new VersionApplet();
        frame.addWindowListener(new ClosingWindowAdapter(frame, versionApplet));
        versionApplet.init();
        frame.add((Component)versionApplet, "Center");
        frame.validate();
        frame.setVisible(true);
        versionApplet.start();
    }

    private synchronized void my_init() {
        if (null != this.canvas) {
            return;
        }
        this.setEnabled(true);
        GLProfile gLProfile = GLProfile.getDefault();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.setLayout(new BorderLayout());
        this.tareaVersion = new TextArea(120, 60);
        String string = VersionUtil.getPlatformInfo().toString();
        System.err.println(string);
        this.tareaVersion.append(string);
        string = GlueGenVersion.getInstance().toString();
        System.err.println(string);
        this.tareaVersion.append(string);
        string = JoglVersion.getInstance().toString();
        System.err.println(string);
        this.tareaVersion.append(string);
        this.tareaCaps = new TextArea(120, 20);
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory(gLProfile);
        List<GLCapabilitiesImmutable> list = gLDrawableFactory.getAvailableCapabilities(null);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            string = list.get(i2).toString();
            System.err.println(string);
            this.tareaCaps.append(string);
            this.tareaCaps.append(Platform.getNewline());
        }
        Container container = new Container();
        container.setLayout(new GridLayout(2, 1));
        container.add(this.tareaVersion);
        container.add(this.tareaCaps);
        this.add((Component)container, "Center");
        this.canvas = new GLCanvas(gLCapabilities);
        this.canvas.addGLEventListener(new GLInfo());
        this.canvas.setSize(10, 10);
        this.add((Component)this.canvas, "South");
        this.validate();
    }

    private synchronized void my_release() {
        if (null != this.canvas) {
            this.remove(this.canvas);
            this.canvas.destroy();
            this.canvas = null;
            this.remove(this.tareaVersion.getParent());
            this.tareaVersion = null;
            this.tareaCaps = null;
            this.setEnabled(false);
        }
    }

    @Override
    public void init() {
        System.err.println("VersionApplet: init() - begin");
        this.my_init();
        System.err.println("VersionApplet: init() - end");
    }

    @Override
    public void start() {
        System.err.println("VersionApplet: start() - begin");
        this.canvas.setVisible(true);
        System.err.println("VersionApplet: start() - end");
    }

    @Override
    public void stop() {
        System.err.println("VersionApplet: stop() - begin");
        this.canvas.setVisible(false);
        System.err.println("VersionApplet: stop() - end");
    }

    @Override
    public void destroy() {
        System.err.println("VersionApplet: destroy() - start");
        this.my_release();
        System.err.println("VersionApplet: destroy() - end");
    }

    class GLInfo
    implements GLEventListener {
        GLInfo() {
        }

        @Override
        public void init(GLAutoDrawable gLAutoDrawable) {
            GL gL = gLAutoDrawable.getGL();
            String string = JoglVersion.getGLInfo(gL, null).toString();
            System.err.println(string);
            VersionApplet.this.tareaVersion.append(string);
        }

        @Override
        public void reshape(GLAutoDrawable gLAutoDrawable, int n2, int n3, int n4, int n5) {
        }

        @Override
        public void display(GLAutoDrawable gLAutoDrawable) {
        }

        @Override
        public void dispose(GLAutoDrawable gLAutoDrawable) {
        }
    }

    static class ClosingWindowAdapter
    extends WindowAdapter {
        Frame f;
        VersionApplet va;

        public ClosingWindowAdapter(Frame frame, VersionApplet versionApplet) {
            this.f = frame;
            this.va = versionApplet;
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            this.f.setVisible(false);
            this.va.stop();
            this.va.destroy();
            this.f.remove(this.va);
            this.f.dispose();
            System.exit(0);
        }
    }
}

