/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl;

import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.GLRendererQuirks;

public class GLGraphicsConfigurationUtil {
    public static final String NV_coverage_sample = "NV_coverage_sample";
    public static final int WINDOW_BIT = 1;
    public static final int BITMAP_BIT = 2;
    public static final int PBUFFER_BIT = 4;
    public static final int FBO_BIT = 8;
    public static final int ALL_BITS = 15;

    public static final StringBuilder winAttributeBits2String(StringBuilder stringBuilder, int n2) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        boolean bl = false;
        if (0 != (1 & n2)) {
            stringBuilder.append("WINDOW");
            bl = true;
        }
        if (0 != (2 & n2)) {
            if (bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("BITMAP");
            bl = true;
        }
        if (0 != (4 & n2)) {
            if (bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("PBUFFER");
            bl = true;
        }
        if (0 != (8 & n2)) {
            if (bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("FBO");
        }
        return stringBuilder;
    }

    public static final int getExclusiveWinAttributeBits(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        int n2;
        if (bl) {
            n2 = 1;
        } else if (bl2) {
            n2 = 8;
        } else if (bl3) {
            n2 = 4;
        } else if (bl4) {
            n2 = 2;
        } else {
            throw new InternalError("Empty bitmask");
        }
        return n2;
    }

    public static final int getExclusiveWinAttributeBits(GLCapabilitiesImmutable gLCapabilitiesImmutable) {
        return GLGraphicsConfigurationUtil.getExclusiveWinAttributeBits(gLCapabilitiesImmutable.isOnscreen(), gLCapabilitiesImmutable.isFBO(), gLCapabilitiesImmutable.isPBuffer(), gLCapabilitiesImmutable.isBitmap());
    }

    public static final GLCapabilities fixWinAttribBitsAndHwAccel(AbstractGraphicsDevice abstractGraphicsDevice, int n2, GLCapabilities gLCapabilities) {
        gLCapabilities.setBitmap(0 != (2 & n2));
        gLCapabilities.setPBuffer(0 != (4 & n2));
        gLCapabilities.setFBO(0 != (8 & n2));
        gLCapabilities.setOnscreen(0 != (1 & n2));
        int n3 = GLContext.isHardwareRasterizer(abstractGraphicsDevice, gLCapabilities.getGLProfile());
        if (0 == n3 && gLCapabilities.getHardwareAccelerated()) {
            gLCapabilities.setHardwareAccelerated(false);
        }
        return gLCapabilities;
    }

    public static GLCapabilitiesImmutable fixGLCapabilities(GLCapabilitiesImmutable gLCapabilitiesImmutable, GLDrawableFactory gLDrawableFactory, AbstractGraphicsDevice abstractGraphicsDevice) {
        if (!gLCapabilitiesImmutable.isOnscreen()) {
            return GLGraphicsConfigurationUtil.fixOffscreenGLCapabilities(gLCapabilitiesImmutable, gLDrawableFactory, abstractGraphicsDevice);
        }
        return gLCapabilitiesImmutable;
    }

    public static GLCapabilitiesImmutable fixOnscreenGLCapabilities(GLCapabilitiesImmutable gLCapabilitiesImmutable) {
        if (!gLCapabilitiesImmutable.isOnscreen() || gLCapabilitiesImmutable.isFBO() || gLCapabilitiesImmutable.isPBuffer() || gLCapabilitiesImmutable.isBitmap()) {
            GLCapabilities gLCapabilities = (GLCapabilities)gLCapabilitiesImmutable.cloneMutable();
            gLCapabilities.setBitmap(false);
            gLCapabilities.setPBuffer(false);
            gLCapabilities.setFBO(false);
            gLCapabilities.setOnscreen(true);
            return gLCapabilities;
        }
        return gLCapabilitiesImmutable;
    }

    public static GLCapabilitiesImmutable fixOffscreenBitOnly(GLCapabilitiesImmutable gLCapabilitiesImmutable) {
        if (gLCapabilitiesImmutable.isOnscreen()) {
            GLCapabilities gLCapabilities = (GLCapabilities)gLCapabilitiesImmutable.cloneMutable();
            gLCapabilities.setOnscreen(false);
            return gLCapabilities;
        }
        return gLCapabilitiesImmutable;
    }

    public static GLCapabilitiesImmutable fixOffscreenGLCapabilities(GLCapabilitiesImmutable gLCapabilitiesImmutable, GLDrawableFactory gLDrawableFactory, AbstractGraphicsDevice abstractGraphicsDevice) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        if (null == abstractGraphicsDevice) {
            abstractGraphicsDevice = gLDrawableFactory.getDefaultDevice();
        }
        GLProfile gLProfile = gLCapabilitiesImmutable.getGLProfile();
        boolean bl4 = GLContext.isFBOAvailable(abstractGraphicsDevice, gLProfile);
        boolean bl5 = gLDrawableFactory.canCreateGLPbuffer(abstractGraphicsDevice, gLProfile);
        GLRendererQuirks gLRendererQuirks = gLDrawableFactory.getRendererQuirks(abstractGraphicsDevice, gLProfile);
        if (null != gLRendererQuirks) {
            boolean bl6 = bl3 = !gLRendererQuirks.exist(3);
            bl2 = !(gLCapabilitiesImmutable.getDoubleBuffered() && gLCapabilitiesImmutable.isPBuffer() && gLRendererQuirks.exist(0) || gLCapabilitiesImmutable.isBitmap() && gLRendererQuirks.exist(1));
        } else {
            bl3 = true;
            bl2 = true;
        }
        boolean bl7 = !(bl4 && gLCapabilitiesImmutable.isFBO() || bl5 && gLCapabilitiesImmutable.isPBuffer() || bl3 && gLCapabilitiesImmutable.isBitmap());
        boolean bl8 = bl4 && (bl7 || gLCapabilitiesImmutable.isFBO());
        boolean bl9 = !bl8 && bl5 && (bl7 || gLCapabilitiesImmutable.isPBuffer());
        boolean bl10 = bl = !bl8 && !bl9 && bl3 && (bl7 || gLCapabilitiesImmutable.isBitmap());
        if (gLCapabilitiesImmutable.isOnscreen() || bl8 != gLCapabilitiesImmutable.isFBO() || bl9 != gLCapabilitiesImmutable.isPBuffer() || bl != gLCapabilitiesImmutable.isBitmap() || !bl2 && gLCapabilitiesImmutable.getDoubleBuffered()) {
            GLCapabilities gLCapabilities = (GLCapabilities)gLCapabilitiesImmutable.cloneMutable();
            gLCapabilities.setOnscreen(false);
            gLCapabilities.setFBO(bl8);
            gLCapabilities.setPBuffer(bl9);
            gLCapabilities.setBitmap(bl);
            if (!bl2) {
                gLCapabilities.setDoubleBuffered(false);
            }
            return gLCapabilities;
        }
        return gLCapabilitiesImmutable;
    }

    public static GLCapabilitiesImmutable fixGLPBufferGLCapabilities(GLCapabilitiesImmutable gLCapabilitiesImmutable) {
        if (gLCapabilitiesImmutable.isOnscreen() || !gLCapabilitiesImmutable.isPBuffer() || gLCapabilitiesImmutable.isFBO()) {
            GLCapabilities gLCapabilities = (GLCapabilities)gLCapabilitiesImmutable.cloneMutable();
            gLCapabilities.setOnscreen(false);
            gLCapabilities.setFBO(false);
            gLCapabilities.setPBuffer(true);
            gLCapabilities.setBitmap(false);
            return gLCapabilities;
        }
        return gLCapabilitiesImmutable;
    }

    public static GLCapabilities fixOpaqueGLCapabilities(GLCapabilities gLCapabilities, boolean bl) {
        if (gLCapabilities.isBackgroundOpaque() != bl) {
            int n2 = gLCapabilities.getAlphaBits();
            gLCapabilities.setBackgroundOpaque(bl);
            gLCapabilities.setAlphaBits(n2);
        }
        return gLCapabilities;
    }

    public static GLCapabilitiesImmutable fixDoubleBufferedGLCapabilities(GLCapabilitiesImmutable gLCapabilitiesImmutable, boolean bl) {
        if (gLCapabilitiesImmutable.getDoubleBuffered() != bl) {
            GLCapabilities gLCapabilities = (GLCapabilities)gLCapabilitiesImmutable.cloneMutable();
            gLCapabilities.setDoubleBuffered(bl);
            return gLCapabilities;
        }
        return gLCapabilitiesImmutable;
    }

    public static GLCapabilitiesImmutable clipRGBAGLCapabilities(GLCapabilitiesImmutable gLCapabilitiesImmutable, boolean bl, boolean bl2) {
        int n2;
        int n3 = gLCapabilitiesImmutable.getRedBits();
        int n4 = gLCapabilitiesImmutable.getGreenBits();
        int n5 = gLCapabilitiesImmutable.getBlueBits();
        int n6 = gLCapabilitiesImmutable.getAlphaBits();
        int n7 = GLGraphicsConfigurationUtil.clipColor(n3, bl);
        int n8 = GLGraphicsConfigurationUtil.clipColor(n4, bl);
        int n9 = GLGraphicsConfigurationUtil.clipColor(n5, bl);
        int n10 = n2 = bl2 && 0 < n6 ? n7 : 0;
        if (n3 != n7 || n4 != n8 || n5 != n9 || n6 != n2) {
            GLCapabilities gLCapabilities = (GLCapabilities)gLCapabilitiesImmutable.cloneMutable();
            gLCapabilities.setRedBits(n7);
            gLCapabilities.setGreenBits(n8);
            gLCapabilities.setBlueBits(n9);
            gLCapabilities.setAlphaBits(n2);
            return gLCapabilities;
        }
        return gLCapabilitiesImmutable;
    }

    public static int clipColor(int n2, boolean bl) {
        int n3 = 5 < n2 || !bl ? 8 : 5;
        return n3;
    }

    public static GLCapabilitiesImmutable fixGLProfile(GLCapabilitiesImmutable gLCapabilitiesImmutable, GLProfile gLProfile) {
        if (gLCapabilitiesImmutable.getGLProfile() != gLProfile) {
            GLCapabilities gLCapabilities = (GLCapabilities)gLCapabilitiesImmutable.cloneMutable();
            gLCapabilities.setGLProfile(gLProfile);
            return gLCapabilities;
        }
        return gLCapabilitiesImmutable;
    }
}

