/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.util.PropertyAccess;
import com.jogamp.common.util.VersionUtil;
import com.jogamp.nativewindow.MutableGraphicsConfiguration;
import com.jogamp.nativewindow.NativeSurface;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.ProxySurface;
import com.jogamp.nativewindow.UpstreamSurfaceHook;
import com.jogamp.opengl.FBObject;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLFBODrawable;
import com.jogamp.opengl.JoglVersion;
import jogamp.opengl.Debug;
import jogamp.opengl.GLDrawableFactoryImpl;
import jogamp.opengl.GLDrawableImpl;

public class GLFBODrawableImpl
extends GLDrawableImpl
implements GLFBODrawable {
    protected static final boolean DEBUG;
    protected static final boolean DEBUG_SWAP;
    private final GLDrawableImpl parent;
    private GLCapabilitiesImmutable origParentChosenCaps;
    private boolean initialized = false;
    private int maxSamples;
    private int fboModeBits;
    private int texUnit;
    private int samples;
    private boolean fboResetQuirk;
    private FBObject[] fbos;
    private int fboIBack;
    private int fboIFront;
    private int pendingFBOReset = -1;
    private boolean fboBound;
    private boolean fboSwapped;
    private static volatile boolean resetQuirkInfoDumped;
    private static final int bufferCount = 2;
    private FBObject.Attachment.StorageDefinition colorRenderbufferStorageDef;
    private SwapBufferContext swapBufferContext;
    private static final String illegalBufferName = "Only GL_FRONT and GL_BACK buffer are allowed, passed ";

    protected GLFBODrawableImpl(GLDrawableFactoryImpl gLDrawableFactoryImpl, GLDrawableImpl gLDrawableImpl, NativeSurface nativeSurface, GLCapabilitiesImmutable gLCapabilitiesImmutable, int n2) {
        super(gLDrawableFactoryImpl, nativeSurface, gLCapabilitiesImmutable, false);
        this.fboModeBits = n2 >= 0 ? 1 : 0;
        this.parent = gLDrawableImpl;
        this.origParentChosenCaps = this.getChosenGLCapabilities();
        this.texUnit = n2 >= 0 ? n2 : 0;
        this.samples = gLCapabilitiesImmutable.getNumSamples();
        this.fboResetQuirk = false;
        this.colorRenderbufferStorageDef = null;
        this.swapBufferContext = null;
    }

    private final void setupFBO(GL gL, int n2, int n3, int n4, int n5, boolean bl, int n6, int n7, boolean bl2, boolean bl3, boolean bl4) {
        Object object;
        FBObject fBObject;
        this.fbos[n2] = fBObject = new FBObject();
        boolean bl5 = n6 > 0;
        boolean bl6 = n7 > 0;
        FBObject.ColorAttachment colorAttachment = null;
        fBObject.init(gL, n3, n4, n5);
        if (fBObject.getNumSamples() != n5) {
            throw new InternalError("Sample number mismatch: " + n5 + ", fbos[" + n2 + "] " + fBObject);
        }
        if (n5 > 0 || !bl2) {
            object = fBObject.createColorAttachment(bl);
            if (null != this.colorRenderbufferStorageDef) {
                ((FBObject.Attachment)object).setStorageDefinition(this.colorRenderbufferStorageDef);
                colorAttachment = object;
            }
            fBObject.attachColorbuffer(gL, 0, (FBObject.Colorbuffer)object);
        } else {
            fBObject.attachTexture2D(gL, 0, bl);
        }
        if (bl6) {
            if (bl5) {
                fBObject.attachRenderbuffer(gL, FBObject.Attachment.Type.DEPTH_STENCIL, n6);
            } else {
                fBObject.attachRenderbuffer(gL, FBObject.Attachment.Type.STENCIL, n7);
            }
        } else if (bl5) {
            fBObject.attachRenderbuffer(gL, FBObject.Attachment.Type.DEPTH, n6);
        }
        if (n5 > 0) {
            object = new FBObject();
            ((FBObject)object).init(gL, n3, n4, 0);
            if (!bl2) {
                FBObject.ColorAttachment colorAttachment2 = ((FBObject)object).createColorAttachment(bl);
                if (null != this.colorRenderbufferStorageDef) {
                    colorAttachment2.setStorageDefinition(this.colorRenderbufferStorageDef);
                }
                ((FBObject)object).attachColorbuffer(gL, 0, colorAttachment2);
            } else {
                ((FBObject)object).attachTexture2D(gL, 0, bl);
            }
            if (bl6) {
                if (bl5) {
                    ((FBObject)object).attachRenderbuffer(gL, FBObject.Attachment.Type.DEPTH_STENCIL, n6);
                } else {
                    ((FBObject)object).attachRenderbuffer(gL, FBObject.Attachment.Type.STENCIL, n7);
                }
            } else if (bl5) {
                ((FBObject)object).attachRenderbuffer(gL, FBObject.Attachment.Type.DEPTH, n6);
            }
            fBObject.setSamplingSink((FBObject)object);
            fBObject.resetSamplingSink(gL);
        }
        fBObject.bind(gL);
        if (null != colorAttachment) {
            gL.glBindRenderbuffer(36161, colorAttachment.getName());
        }
        if (bl3) {
            gL.glViewport(0, 0, n3, n4);
            gL.glScissor(0, 0, n3, n4);
        }
        if (bl5) {
            gL.glClear(16640);
        } else {
            gL.glClear(16384);
        }
        if (bl4) {
            fBObject.unbind(gL);
        } else {
            fBObject.markUnbound();
        }
    }

    private final void initialize(boolean bl, GL gL) {
        if (!this.initialized && !bl) {
            if (DEBUG) {
                System.err.println("GLFBODrawableImpl.initialize(): WARNING - Already unrealized!");
                ExceptionUtils.dumpStack(System.err);
            }
            return;
        }
        if (this.initialized == bl) {
            throw new IllegalStateException("initialize already in state " + bl + ": " + this);
        }
        if (bl) {
            int n2;
            GLCapabilities gLCapabilities = (GLCapabilities)this.getChosenGLCapabilities();
            this.maxSamples = gL.getMaxRenderbufferSamples();
            int n3 = n2 = this.samples <= this.maxSamples ? this.samples : this.maxSamples;
            if (DEBUG) {
                System.err.println("GLFBODrawableImpl.initialize(): samples " + this.samples + " -> " + n2 + "/" + this.maxSamples);
            }
            this.samples = n2;
            n2 = this.samples > 0 ? 1 : (gLCapabilities.getDoubleBuffered() ? 2 : 1);
            this.fbos = new FBObject[n2];
            this.fboIBack = 0;
            this.fboIFront = this.fbos.length - 1;
            if (0 == (1 & this.fboModeBits) && gL.getContext().hasRendererQuirk(18)) {
                this.fboModeBits |= 1;
            }
            boolean bl2 = 0 != (1 & this.fboModeBits);
            boolean bl3 = gLCapabilities.getAlphaBits() > 0;
            int n4 = this.getSurfaceWidth();
            int n5 = this.getSurfaceHeight();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.setupFBO(gL, i2, n4, n5, this.samples, bl3, gLCapabilities.getDepthBits(), gLCapabilities.getStencilBits(), bl2, 0 == i2 && 0L == this.parent.getHandle(), n2 - 1 == i2);
            }
            this.fbos[0].formatToGLCapabilities(gLCapabilities);
            gLCapabilities.setDoubleBuffered(gLCapabilities.getDoubleBuffered() || this.samples > 0);
        } else {
            for (int i3 = 0; i3 < this.fbos.length; ++i3) {
                this.fbos[i3].destroy(gL);
            }
            this.fbos = null;
        }
        this.fboBound = false;
        this.fboSwapped = false;
        this.pendingFBOReset = -1;
        this.initialized = bl;
        if (DEBUG) {
            System.err.println("GLFBODrawableImpl.initialize(" + bl + "): " + this);
            ExceptionUtils.dumpStack(System.err);
        }
    }

    public final void setSwapBufferContext(SwapBufferContext swapBufferContext) {
        this.swapBufferContext = swapBufferContext;
    }

    public final void setColorRenderbufferStorageDef(FBObject.Attachment.StorageDefinition storageDefinition) {
        this.colorRenderbufferStorageDef = storageDefinition;
        if (DEBUG) {
            System.err.println("EAGL.FBODrawable: setColorRenderbufferStorageDef");
        }
    }

    public final boolean hasColorRenderbufferStorageDef(FBObject.Attachment.StorageDefinition storageDefinition) {
        return storageDefinition == this.colorRenderbufferStorageDef;
    }

    private final void reset(GL gL, int n2, int n3, int n4, int n5, boolean bl, int n6, int n7) {
        block4: {
            if (!this.fboResetQuirk) {
                try {
                    this.fbos[n2].reset(gL, n3, n4, n5);
                    if (this.fbos[n2].getNumSamples() != n5) {
                        throw new InternalError("Sample number mismatch: " + n5 + ", fbos[" + n2 + "] " + this.fbos[n2]);
                    }
                    return;
                }
                catch (GLException gLException) {
                    this.fboResetQuirk = true;
                    if (!DEBUG || resetQuirkInfoDumped) break block4;
                    resetQuirkInfoDumped = true;
                    System.err.println("GLFBODrawable: FBO Reset failed: " + gLException.getMessage());
                    System.err.println("GLFBODrawable: Enabling FBOResetQuirk, due to GL driver bug.");
                    JoglVersion joglVersion = JoglVersion.getInstance();
                    System.err.println(VersionUtil.getPlatformInfo());
                    System.err.println(joglVersion.toString());
                    System.err.println(JoglVersion.getGLInfo(gL, null));
                    gLException.printStackTrace();
                }
            }
        }
        this.fbos[n2].destroy(gL);
        boolean bl2 = 0 != (1 & this.fboModeBits);
        this.setupFBO(gL, n2, n3, n4, n5, bl, n6, n7, bl2, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void reset(GL gL, int n2) throws GLException {
        boolean bl;
        if (!this.initialized) {
            return;
        }
        GLContext gLContext = GLContext.getCurrent();
        GLContext gLContext2 = gL.getContext();
        boolean bl2 = bl = null != gLContext && gLContext != gLContext2;
        if (DEBUG) {
            System.err.println("GLFBODrawableImpl.reset(newSamples " + n2 + "): BEGIN - ctxSwitch " + bl + ", " + this);
            ExceptionUtils.dumpStack(System.err);
        }
        Throwable throwable = null;
        Throwable throwable2 = null;
        gLContext2.makeCurrent();
        gL.glFinish();
        this.fboBound = false;
        this.fboSwapped = false;
        try {
            int n3 = n2 = n2 <= this.maxSamples ? n2 : this.maxSamples;
            if (0 == this.samples && 0 < n2 || 0 < this.samples && 0 == n2) {
                if (DEBUG) {
                    System.err.println("GLFBODrawableImpl.reset(): samples [on/off] reconfig: " + this.samples + " -> " + n2 + "/" + this.maxSamples);
                }
                this.initialize(false, gL);
                this.samples = n2;
                this.initialize(true, gL);
            } else {
                if (DEBUG) {
                    System.err.println("GLFBODrawableImpl.reset(): simple reconfig: " + this.samples + " -> " + n2 + "/" + this.maxSamples);
                }
                int n4 = this.getSurfaceWidth();
                int n5 = this.getSurfaceHeight();
                this.samples = n2;
                this.pendingFBOReset = 1 < this.fbos.length ? this.fboIFront : -1;
                GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)this.surface.getGraphicsConfiguration().getChosenCapabilities();
                for (int i2 = 0; i2 < this.fbos.length; ++i2) {
                    if (this.pendingFBOReset == i2) continue;
                    this.reset(gL, i2, n4, n5, this.samples, gLCapabilitiesImmutable.getAlphaBits() > 0, gLCapabilitiesImmutable.getDepthBits(), gLCapabilitiesImmutable.getStencilBits());
                }
                GLCapabilities gLCapabilities = (GLCapabilities)this.surface.getGraphicsConfiguration().getChosenCapabilities();
                this.fbos[0].formatToGLCapabilities(gLCapabilities);
            }
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
        }
        finally {
            try {
                gLContext2.release();
                if (bl) {
                    gLContext.makeCurrent();
                }
            }
            catch (Throwable throwable4) {
                throwable2 = throwable4;
            }
        }
        if (null != throwable) {
            throw GLException.newGLException(throwable);
        }
        if (null != throwable2) {
            throw GLException.newGLException(throwable2);
        }
        if (DEBUG) {
            System.err.println("GLFBODrawableImpl.reset(newSamples " + n2 + "): END " + this);
        }
    }

    @Override
    public final GLContext createContext(GLContext gLContext) {
        GLContext gLContext2 = this.parent.createContext(gLContext);
        gLContext2.setGLDrawable(this, false);
        return gLContext2;
    }

    @Override
    protected final int getDefaultDrawFramebuffer() {
        return this.initialized ? this.fbos[this.fboIBack].getWriteFramebuffer() : 0;
    }

    @Override
    protected final int getDefaultReadFramebuffer() {
        return this.initialized ? this.fbos[this.fboIFront].getReadFramebuffer() : 0;
    }

    @Override
    protected final int getDefaultReadBuffer(GL gL, boolean bl) {
        return this.initialized ? this.fbos[this.fboIFront].getDefaultReadBuffer() : 36064;
    }

    @Override
    protected final void setRealizedImpl() {
        MutableGraphicsConfiguration mutableGraphicsConfiguration = (MutableGraphicsConfiguration)this.surface.getGraphicsConfiguration();
        if (this.realized) {
            this.parent.setRealized(true);
            this.origParentChosenCaps = (GLCapabilitiesImmutable)mutableGraphicsConfiguration.getChosenCapabilities();
            GLCapabilities gLCapabilities = (GLCapabilities)this.origParentChosenCaps.cloneMutable();
            gLCapabilities.copyFrom(this.getRequestedGLCapabilities());
            mutableGraphicsConfiguration.setChosenCapabilities(gLCapabilities);
        } else {
            mutableGraphicsConfiguration.setChosenCapabilities(this.origParentChosenCaps);
            this.parent.setRealized(false);
        }
    }

    @Override
    protected void associateContext(GLContext gLContext, boolean bl) {
        this.initialize(bl, gLContext.getGL());
    }

    @Override
    protected final void contextMadeCurrent(GLContext gLContext, boolean bl) {
        GL gL = gLContext.getGL();
        if (bl) {
            if (!this.initialized) {
                throw new GLException("Not initialized: " + this);
            }
            this.fbos[this.fboIBack].bind(gL);
            this.fboBound = true;
            this.fboSwapped = false;
        } else if (this.fboBound && !this.fboSwapped) {
            this.swapFBOImpl(gLContext);
            this.swapFBOImplPost(gLContext);
            this.fboBound = false;
            this.fboSwapped = true;
            if (DEBUG_SWAP) {
                System.err.println("Post FBO swap(@release): done");
            }
        }
    }

    @Override
    protected void swapBuffersImpl(boolean bl) {
        boolean bl2;
        GLContext gLContext = GLContext.getCurrent();
        if (null != gLContext && gLContext.getGLDrawable() == this && this.fboBound) {
            this.swapFBOImpl(gLContext);
            bl2 = true;
            this.fboSwapped = true;
            if (DEBUG_SWAP) {
                System.err.println("Post FBO swap(@swap): done");
            }
        } else {
            bl2 = false;
        }
        if (null != this.swapBufferContext) {
            this.swapBufferContext.swapBuffers(bl);
        }
        if (bl2) {
            this.swapFBOImplPost(gLContext);
        }
    }

    private final void swapFBOImplPost(GLContext gLContext) {
        if (0 <= this.pendingFBOReset) {
            GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)this.surface.getGraphicsConfiguration().getChosenCapabilities();
            this.reset(gLContext.getGL(), this.pendingFBOReset, this.getSurfaceWidth(), this.getSurfaceHeight(), this.samples, gLCapabilitiesImmutable.getAlphaBits() > 0, gLCapabilitiesImmutable.getDepthBits(), gLCapabilitiesImmutable.getStencilBits());
            this.pendingFBOReset = -1;
        }
    }

    private final void swapFBOImpl(GLContext gLContext) {
        FBObject.TextureAttachment textureAttachment;
        FBObject.Colorbuffer colorbuffer;
        int n2;
        GL gL = gLContext.getGL();
        this.fbos[this.fboIBack].markUnbound();
        if (DEBUG && (n2 = (this.fboIFront + 1) % this.fbos.length) != this.fboIBack) {
            throw new InternalError("XXX: " + n2 + "!=" + this.fboIBack);
        }
        this.fboIFront = this.fboIBack;
        this.fboIBack = (this.fboIBack + 1) % this.fbos.length;
        FBObject.Colorbuffer colorbuffer2 = colorbuffer = this.samples > 0 ? this.fbos[this.fboIFront].getSamplingSink() : this.fbos[this.fboIFront].getColorbuffer(0);
        if (null == colorbuffer) {
            throw new GLException("Front colorbuffer is null: samples " + this.samples + ", " + this);
        }
        if (colorbuffer.isTextureAttachment()) {
            textureAttachment = colorbuffer.getTextureAttachment();
            gL.glActiveTexture(33984 + this.texUnit);
        } else {
            textureAttachment = null;
        }
        this.fbos[this.fboIFront].use(gL, textureAttachment);
        if (DEBUG_SWAP) {
            System.err.println("Post FBO swap(X): fboI back " + this.fboIBack + ", front " + this.fboIFront + ", num " + this.fbos.length);
        }
    }

    @Override
    public final boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public final void setFBOMode(int n2) throws IllegalStateException {
        if (this.isInitialized()) {
            throw new IllegalStateException("Already initialized: " + this);
        }
        this.fboModeBits = n2;
    }

    @Override
    public final int getFBOMode() {
        return this.fboModeBits;
    }

    @Override
    public final void resetSize(GL gL) throws GLException {
        this.reset(gL, this.samples);
    }

    @Override
    public final int getTextureUnit() {
        return this.texUnit;
    }

    @Override
    public final void setTextureUnit(int n2) {
        this.texUnit = n2;
    }

    @Override
    public final int getNumSamples() {
        return this.samples;
    }

    @Override
    public void setNumSamples(GL gL, int n2) throws GLException {
        if (this.samples != n2) {
            this.reset(gL, n2);
        }
    }

    @Override
    public final int setNumBuffers(int n2) throws IllegalStateException, GLException {
        if (this.isInitialized()) {
            throw new IllegalStateException("Already initialized: " + this);
        }
        return 2;
    }

    @Override
    public final int getNumBuffers() {
        return 2;
    }

    @Override
    public FBObject getFBObject(int n2) throws IllegalArgumentException {
        FBObject fBObject;
        if (!this.initialized) {
            return null;
        }
        switch (n2) {
            case 1028: {
                if (this.samples > 0) {
                    fBObject = this.fbos[0].getSamplingSinkFBO();
                    break;
                }
                fBObject = this.fbos[this.fboIFront];
                break;
            }
            case 1029: {
                fBObject = this.fbos[this.fboIBack];
                break;
            }
            default: {
                throw new IllegalArgumentException(illegalBufferName + GLFBODrawableImpl.toHexString(n2));
            }
        }
        return fBObject;
    }

    @Override
    public final FBObject.Colorbuffer getColorbuffer(int n2) throws IllegalArgumentException {
        FBObject.Colorbuffer colorbuffer;
        if (!this.initialized) {
            return null;
        }
        switch (n2) {
            case 1028: {
                if (this.samples > 0) {
                    colorbuffer = this.fbos[0].getSamplingSink();
                    break;
                }
                colorbuffer = this.fbos[this.fboIFront].getColorbuffer(0);
                break;
            }
            case 1029: {
                if (this.samples > 0) {
                    throw new IllegalArgumentException("Cannot access GL_BACK buffer of MSAA FBO: " + this);
                }
                colorbuffer = this.fbos[this.fboIBack].getColorbuffer(0);
                break;
            }
            default: {
                throw new IllegalArgumentException(illegalBufferName + GLFBODrawableImpl.toHexString(n2));
            }
        }
        return colorbuffer;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[Initialized " + this.initialized + ", realized " + this.isRealized() + ", texUnit " + this.texUnit + ", samples " + this.samples + ",\n\tFactory   " + this.getFactory() + ",\n\tHandle    " + GLFBODrawableImpl.toHexString(this.getHandle()) + ",\n\tCaps      " + this.surface.getGraphicsConfiguration().getChosenCapabilities() + ",\n\tfboI back " + this.fboIBack + ", front " + this.fboIFront + ", num " + (this.initialized ? this.fbos.length : 0) + ",\n\tFBO front read " + this.getDefaultReadFramebuffer() + ", " + this.getFBObject(1028) + ",\n\tFBO back  write " + this.getDefaultDrawFramebuffer() + ", " + this.getFBObject(1029) + ",\n\tSurface   " + this.surface + "]";
    }

    static {
        Debug.initSingleton();
        DEBUG = GLDrawableImpl.DEBUG || Debug.debug("FBObject");
        DEBUG_SWAP = PropertyAccess.isPropertyDefined("jogl.debug.FBObject.Swap", true);
        resetQuirkInfoDumped = false;
    }

    public static class ResizeableImpl
    extends GLFBODrawableImpl
    implements GLFBODrawable.Resizeable {
        protected ResizeableImpl(GLDrawableFactoryImpl gLDrawableFactoryImpl, GLDrawableImpl gLDrawableImpl, ProxySurface proxySurface, GLCapabilitiesImmutable gLCapabilitiesImmutable, int n2) {
            super(gLDrawableFactoryImpl, gLDrawableImpl, proxySurface, gLCapabilitiesImmutable, n2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void setSurfaceSize(GLContext gLContext, int n2, int n3) throws NativeWindowException, GLException {
            int n4;
            if (DEBUG) {
                System.err.println("GLFBODrawableImpl.ResizeableImpl setSize: (" + ResizeableImpl.getThreadName() + "): " + n2 + "x" + n3 + " - surfaceHandle 0x" + Long.toHexString(this.getNativeSurface().getSurfaceHandle()));
            }
            if (1 >= (n4 = this.lockSurface())) {
                throw new NativeWindowException("Could not lock surface: " + this);
            }
            try {
                ProxySurface proxySurface = (ProxySurface)this.getNativeSurface();
                UpstreamSurfaceHook upstreamSurfaceHook = proxySurface.getUpstreamSurfaceHook();
                if (!(upstreamSurfaceHook instanceof UpstreamSurfaceHook.MutableSize)) {
                    throw new InternalError("GLFBODrawableImpl.ResizableImpl's ProxySurface doesn't hold a UpstreamSurfaceHookMutableSize but " + upstreamSurfaceHook.getClass().getName() + ", " + proxySurface + ", ush");
                }
                ((UpstreamSurfaceHook.MutableSize)upstreamSurfaceHook).setSurfaceSize(n2, n3);
                if (null != gLContext && gLContext.isCreated()) {
                    this.resetSize(gLContext.getGL());
                }
            }
            finally {
                this.unlockSurface();
            }
        }
    }

    public static interface SwapBufferContext {
        public void swapBuffers(boolean var1);
    }
}

