/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.Bitfield;
import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.common.util.VersionNumber;
import com.jogamp.common.util.VersionNumberString;
import com.jogamp.gluegen.runtime.ProcAddressTable;
import com.jogamp.gluegen.runtime.opengl.GLNameResolver;
import com.jogamp.gluegen.runtime.opengl.GLProcAddressResolver;
import com.jogamp.nativewindow.AbstractGraphicsConfiguration;
import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.NativeWindowFactory;
import com.jogamp.nativewindow.ProxySurface;
import com.jogamp.nativewindow.egl.EGLGraphicsDevice;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES3;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDebugListener;
import com.jogamp.opengl.GLDebugMessage;
import com.jogamp.opengl.GLDrawable;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLPipelineFactory;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.GLRendererQuirks;
import java.lang.reflect.Method;
import java.nio.IntBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import jogamp.common.os.PlatformPropsImpl;
import jogamp.nativewindow.x11.X11Util;
import jogamp.opengl.ExtensionAvailabilityCache;
import jogamp.opengl.GLBufferObjectTracker;
import jogamp.opengl.GLBufferStateTracker;
import jogamp.opengl.GLContextShareSet;
import jogamp.opengl.GLDebugMessageHandler;
import jogamp.opengl.GLDrawableFactoryImpl;
import jogamp.opengl.GLDrawableImpl;
import jogamp.opengl.GLDynamicLookupHelper;
import jogamp.opengl.GLStateTracker;
import jogamp.opengl.GLVersionNumber;

public abstract class GLContextImpl
extends GLContext {
    private String contextFQN;
    private int additionalCtxCreationFlags;
    protected ExtensionAvailabilityCache extensionAvailability;
    private ProcAddressTable glProcAddressTable;
    private String glVendor;
    private String glRenderer;
    private String glRendererLowerCase;
    private String glVersion;
    private boolean glGetPtrInit = false;
    private long glGetStringPtr = 0L;
    private long glGetIntegervPtr = 0L;
    private long glGetStringiPtr = 0L;
    private final GLBufferObjectTracker bufferObjectTracker;
    private final GLBufferStateTracker bufferStateTracker;
    private final GLStateTracker glStateTracker = new GLStateTracker();
    private GLDebugMessageHandler glDebugHandler = null;
    private final int[] boundFBOTarget = new int[]{0, 0};
    private int defaultVAO = 0;
    protected GLDrawableImpl drawable;
    protected GLDrawableImpl drawableRead;
    private boolean isSurfaceless = false;
    private boolean pixelDataEvaluated;
    private int pixelDataFormat;
    private int pixelDataType;
    private int currentSwapInterval;
    protected GL gl;
    protected static final Object mappedContextTypeObjectLock = new Object();
    protected static final HashMap<String, ExtensionAvailabilityCache> mappedExtensionAvailabilityCache = new HashMap();
    protected static final HashMap<String, ProcAddressTable> mappedGLProcAddress = new HashMap();
    protected static final HashMap<String, ProcAddressTable> mappedGLXProcAddress = new HashMap();
    private Throwable lastCtxReleaseStack = null;
    private static MappedGLVersionListener mapGLVersionListener = null;

    public static void shutdownImpl() {
        mappedExtensionAvailabilityCache.clear();
        mappedGLProcAddress.clear();
        mappedGLXProcAddress.clear();
    }

    public GLContextImpl(GLDrawableImpl gLDrawableImpl, GLContext gLContext) {
        if (null == gLDrawableImpl) {
            throw new IllegalArgumentException("Null drawable");
        }
        this.bufferStateTracker = new GLBufferStateTracker();
        if (null != gLContext) {
            GLContextShareSet.registerSharing(this, gLContext);
            this.bufferObjectTracker = ((GLContextImpl)gLContext).getBufferObjectTracker();
            if (null == this.bufferObjectTracker) {
                throw new InternalError("shared-master context hash null GLBufferObjectTracker: " + GLContextImpl.toHexString(gLContext.hashCode()));
            }
        } else {
            this.bufferObjectTracker = new GLBufferObjectTracker();
        }
        this.drawable = gLDrawableImpl;
        this.drawableRead = gLDrawableImpl;
        this.glDebugHandler = new GLDebugMessageHandler(this);
    }

    private final void clearStates() {
        if (!GLContextShareSet.hasCreatedSharesLeft(this)) {
            this.bufferObjectTracker.clear();
        }
        this.bufferStateTracker.clear();
        this.glStateTracker.setEnabled(false);
        this.glStateTracker.clearStates();
    }

    @Override
    protected void resetStates(boolean bl) {
        if (!bl) {
            this.clearStates();
        }
        this.extensionAvailability = null;
        this.glProcAddressTable = null;
        this.gl = null;
        this.contextFQN = null;
        this.additionalCtxCreationFlags = 0;
        this.glRendererLowerCase = this.glRenderer = (this.glVendor = "");
        this.glVersion = this.glVendor;
        this.glGetPtrInit = false;
        this.glGetStringPtr = 0L;
        this.glGetIntegervPtr = 0L;
        this.glGetStringiPtr = 0L;
        if (!bl && null != this.boundFBOTarget) {
            this.boundFBOTarget[0] = 0;
            this.boundFBOTarget[1] = 0;
        }
        this.isSurfaceless = false;
        this.pixelDataEvaluated = false;
        this.currentSwapInterval = 0;
        super.resetStates(bl);
    }

    @Override
    public final GLDrawable setGLReadDrawable(GLDrawable gLDrawable) {
        if (!this.isGLReadDrawableAvailable()) {
            throw new GLException("Setting read drawable feature not available");
        }
        Thread thread = Thread.currentThread();
        if (this.lock.isLockedByOtherThread()) {
            throw new GLException("GLContext current by other thread " + this.lock.getOwner().getName() + ", operation not allowed on this thread " + thread.getName());
        }
        boolean bl = this.lock.isOwner(thread);
        if (bl && this.lock.getHoldCount() > 1) {
            throw new GLException("GLContext is recursively locked - unsupported for setGLDrawable(..)");
        }
        if (bl) {
            this.release(false);
        }
        GLDrawableImpl gLDrawableImpl = this.drawableRead;
        GLDrawableImpl gLDrawableImpl2 = this.drawableRead = null != gLDrawable ? (GLDrawableImpl)gLDrawable : this.drawable;
        if (bl) {
            this.makeCurrent();
        }
        return gLDrawableImpl;
    }

    @Override
    public final GLDrawable getGLReadDrawable() {
        return this.drawableRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final GLDrawable setGLDrawable(GLDrawable gLDrawable, boolean bl) {
        Thread thread = Thread.currentThread();
        if (this.lock.isLockedByOtherThread()) {
            throw new GLException("GLContext current by other thread " + this.lock.getOwner().getName() + ", operation not allowed on this thread " + thread.getName());
        }
        boolean bl2 = this.lock.isOwner(thread);
        if (bl2 && this.lock.getHoldCount() > 1) {
            throw new GLException("GLContext is recursively locked - unsupported for setGLDrawable(..)");
        }
        if (this.drawable == gLDrawable && (bl || this.drawableRead == gLDrawable)) {
            return this.drawable;
        }
        GLDrawableImpl gLDrawableImpl = this.drawable;
        GLDrawableImpl gLDrawableImpl2 = this.drawableRead;
        if (this.isCreated() && null != gLDrawableImpl && gLDrawableImpl.isRealized()) {
            if (!bl2) {
                this.makeCurrent();
            }
            this.gl.glFinish();
            this.associateDrawable(false);
            if (!bl2) {
                this.release(false);
            }
        }
        if (bl2) {
            this.release(false);
        }
        if (!bl || this.drawableRead == this.drawable) {
            this.drawableRead = (GLDrawableImpl)gLDrawable;
        }
        this.drawableRetargeted |= null != this.drawable && gLDrawable != this.drawable;
        this.drawable = (GLDrawableImpl)gLDrawable;
        if (this.isCreated() && null != this.drawable && this.drawable.isRealized()) {
            int n2 = 0;
            Throwable throwable = null;
            try {
                n2 = this.makeCurrent(true);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                return throwable;
            }
            finally {
                if (0 == n2) {
                    this.drawableRead = gLDrawableImpl2;
                    this.drawable = gLDrawableImpl;
                    if (this.drawable.isRealized()) {
                        this.makeCurrent(true);
                    }
                    if (!bl2) {
                        this.release(false);
                    }
                    String string = "Error: makeCurrent() failed with new drawable " + gLDrawable;
                    if (null != throwable) {
                        throw new GLException(string, throwable);
                    }
                    throw new GLException(string);
                }
            }
            if (!bl2) {
                this.release(false);
            }
        }
        return gLDrawableImpl;
    }

    @Override
    public final GLDrawable getGLDrawable() {
        return this.drawable;
    }

    public final GLDrawableImpl getDrawableImpl() {
        return this.drawable;
    }

    @Override
    public final GL getRootGL() {
        GL gL = this.gl;
        GL gL2 = gL.getDownstreamGL();
        while (null != gL2) {
            gL = gL2;
            gL2 = gL.getDownstreamGL();
        }
        return gL;
    }

    @Override
    public final GL getGL() {
        return this.gl;
    }

    @Override
    public GL setGL(GL gL) {
        if (DEBUG) {
            String string = null != this.gl ? this.gl.getClass().getSimpleName() + ", " + this.gl.toString() : "<null>";
            String string2 = null != gL ? gL.getClass().getSimpleName() + ", " + gL.toString() : "<null>";
            System.err.println("Info: setGL (OpenGL " + this.getGLVersion() + "): " + GLContextImpl.getThreadName() + ", " + string + " -> " + string2);
            ExceptionUtils.dumpStack(System.err);
        }
        this.gl = gL;
        return gL;
    }

    @Override
    public final int getDefaultVAO() {
        return this.defaultVAO;
    }

    protected void drawableUpdatedNotify() throws GLException {
    }

    public abstract Object getPlatformGLExtensions();

    @Override
    public void release() throws GLException {
        this.release(false);
    }

    private String getTraceSwitchMsg() {
        long l2 = null != this.drawable ? this.drawable.getHandle() : 0L;
        return "obj " + GLContextImpl.toHexString(this.hashCode()) + ", ctx " + GLContextImpl.toHexString(this.contextHandle) + ", isShared " + GLContextShareSet.isShared(this) + ", surf " + (null != this.drawable) + " " + GLContextImpl.toHexString(l2) + ", " + this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release(boolean bl) throws GLException {
        boolean bl2;
        Throwable throwable;
        block17: {
            if (TRACE_SWITCH) {
                System.err.println(GLContextImpl.getThreadName() + ": GLContext.ContextSwitch[release.0, inDestruction: " + bl + "]: " + this.getTraceSwitchMsg());
            }
            if (!this.lock.isOwner(Thread.currentThread())) {
                String string = GLContextImpl.getThreadName() + ": Context not current on thread, inDestruction: " + bl + ", " + this.getTraceSwitchMsg();
                if (DEBUG_TRACE_SWITCH) {
                    System.err.println(string);
                    if (null != this.lastCtxReleaseStack) {
                        System.err.print("Last release call: ");
                        this.lastCtxReleaseStack.printStackTrace();
                    } else {
                        System.err.println("Last release call: NONE");
                    }
                }
                throw new GLException(string);
            }
            throwable = null;
            bl2 = (bl || this.lock.getHoldCount() == 1) && 0L != this.contextHandle;
            try {
                if (bl2) {
                    if (!bl) {
                        try {
                            this.contextMadeCurrent(false);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                        }
                    }
                    this.releaseImpl();
                }
                if (!bl2) break block17;
            }
            catch (Throwable throwable3) {
                if (bl2) {
                    GLContextImpl.setCurrent(null);
                }
                this.lock.unlock();
                this.drawable.unlockSurface();
                if (DEBUG_TRACE_SWITCH) {
                    String string = GLContextImpl.getThreadName() + ": GLContext.ContextSwitch[release.X]: " + (bl2 ? "switch" : "keep  ") + " - " + this.getTraceSwitchMsg();
                    this.lastCtxReleaseStack = new Throwable(string);
                    if (TRACE_SWITCH) {
                        System.err.println(string);
                    }
                }
                throw throwable3;
            }
            GLContextImpl.setCurrent(null);
        }
        this.lock.unlock();
        this.drawable.unlockSurface();
        if (DEBUG_TRACE_SWITCH) {
            String string = GLContextImpl.getThreadName() + ": GLContext.ContextSwitch[release.X]: " + (bl2 ? "switch" : "keep  ") + " - " + this.getTraceSwitchMsg();
            this.lastCtxReleaseStack = new Throwable(string);
            if (TRACE_SWITCH) {
                System.err.println(string);
            }
        }
        if (null != throwable) {
            throw new GLException("GLContext.release(false) during GLDrawableImpl.contextMadeCurrent(this, false)", throwable);
        }
    }

    protected abstract void releaseImpl() throws GLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void destroy() {
        if (DEBUG_TRACE_SWITCH) {
            System.err.println(GLContextImpl.getThreadName() + ": GLContextImpl.destroy.0: " + this.getTraceSwitchMsg());
        }
        if (0L != this.contextHandle) {
            if (null == this.drawable) {
                throw new GLException("GLContext created but drawable is null: " + this.toString());
            }
            int n2 = this.drawable.lockSurface();
            if (1 >= n2) {
                throw new GLException("Surface not ready to lock: " + this.drawable);
            }
            Throwable throwable = null;
            try {
                if (!this.drawable.isRealized()) {
                    throw new GLException("GLContext created but drawable not realized: " + this.toString());
                }
                this.lock.lock();
                if (DEBUG_TRACE_SWITCH && this.lock.getHoldCount() > 2) {
                    System.err.println(GLContextImpl.getThreadName() + ": GLContextImpl.destroy: Lock was hold more than once - makeCurrent/release imbalance: " + this.getTraceSwitchMsg());
                    ExceptionUtils.dumpStack(System.err);
                }
                try {
                    if (this.lock.getHoldCount() == 1 && 0 == this.makeCurrent()) {
                        throw new GLException("GLContext.makeCurrent() failed: " + this.toString());
                    }
                    try {
                        this.associateDrawable(false);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                    }
                    if (0 != this.defaultVAO) {
                        int[] nArray = new int[]{this.defaultVAO};
                        GL2ES3 gL2ES3 = this.gl.getRootGL().getGL2ES3();
                        gL2ES3.glBindVertexArray(0);
                        gL2ES3.glDeleteVertexArrays(1, nArray, 0);
                        this.defaultVAO = 0;
                    }
                    this.glDebugHandler.enable(false);
                    if (this.lock.getHoldCount() > 1) {
                        this.release(true);
                    }
                    this.destroyImpl();
                    this.contextHandle = 0L;
                    this.glDebugHandler = null;
                    if (GLContextShareSet.contextDestroyed(this) && !GLContextShareSet.hasCreatedSharesLeft(this)) {
                        GLContextShareSet.unregisterSharing(this);
                    }
                    this.resetStates(false);
                }
                finally {
                    this.lock.unlock();
                    if (DEBUG_TRACE_SWITCH) {
                        System.err.println(GLContextImpl.getThreadName() + ": GLContextImpl.destroy.X: " + this.getTraceSwitchMsg());
                    }
                }
            }
            finally {
                this.drawable.unlockSurface();
            }
            if (null != throwable) {
                throw new GLException("Exception @ destroy's associateDrawable(false)", throwable);
            }
        } else {
            this.resetStates(false);
        }
    }

    protected abstract void destroyImpl() throws GLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void copy(GLContext gLContext, int n2) throws GLException {
        if (gLContext.getHandle() == 0L) {
            throw new GLException("Source OpenGL context has not been created");
        }
        if (this.getHandle() == 0L) {
            throw new GLException("Destination OpenGL context has not been created");
        }
        int n3 = this.drawable.lockSurface();
        if (1 >= n3) {
            throw new GLException("Surface not ready to lock");
        }
        try {
            this.copyImpl(gLContext, n2);
        }
        finally {
            this.drawable.unlockSurface();
        }
    }

    protected abstract void copyImpl(GLContext var1, int var2) throws GLException;

    protected final boolean isSurfaceless() {
        return this.isSurfaceless;
    }

    @Override
    public final int makeCurrent() throws GLException {
        return this.makeCurrent(false);
    }

    protected final int makeCurrent(boolean bl) throws GLException {
        int n2;
        block37: {
            boolean bl2;
            boolean bl3 = bl2 = null != this.drawable;
            if (TRACE_SWITCH) {
                System.err.println(GLContextImpl.getThreadName() + ": GLContext.ContextSwitch[makeCurrent.0]: " + this.getTraceSwitchMsg());
            }
            if (!bl2) {
                if (DEBUG_TRACE_SWITCH) {
                    System.err.println(GLContextImpl.getThreadName() + ": GLContext.ContextSwitch[makeCurrent.X0]: NULL Drawable - CONTEXT_NOT_CURRENT - " + this.getTraceSwitchMsg());
                }
                return 0;
            }
            int n3 = this.drawable.lockSurface();
            if (1 >= n3) {
                if (DEBUG_TRACE_SWITCH) {
                    System.err.println(GLContextImpl.getThreadName() + ": GLContext.ContextSwitch[makeCurrent.X1]: Surface Not Ready - CONTEXT_NOT_CURRENT - " + this.getTraceSwitchMsg());
                }
                return 0;
            }
            boolean bl4 = true;
            n2 = 0;
            try {
                if (!this.drawable.isRealized()) break block37;
                this.lock.lock();
                try {
                    Object object;
                    if (0L == this.drawable.getHandle() && !this.isSurfaceless) {
                        if (DEBUG) {
                            System.err.println(GLContextImpl.getThreadName() + ": GLContext.makeCurrent: Surfaceless evaluate");
                        }
                        if (this.hasRendererQuirk(22)) {
                            throw new GLException(String.format("Surfaceless not supported due to quirk %s: %s", GLRendererQuirks.toString(22), this.toString()));
                        }
                        object = this.drawable.getNativeSurface();
                        if (!(object instanceof ProxySurface) || !((ProxySurface)object).containsUpstreamOptionBits(512)) {
                            throw new GLException(String.format("non-surfaceless drawable has zero-handle: %s", this.drawable.toString()));
                        }
                    }
                    if ((object = GLContextImpl.getCurrent()) != null) {
                        if (object == this) {
                            this.drawableUpdatedNotify();
                            bl4 = false;
                            if (TRACE_SWITCH) {
                                System.err.println(GLContextImpl.getThreadName() + ": GLContext.ContextSwitch[makeCurrent.X2]: KEEP - CONTEXT_CURRENT - " + this.getTraceSwitchMsg());
                            }
                            int n4 = 1;
                            return n4;
                        }
                        ((GLContext)object).release();
                    }
                    bl4 = 0 == (n2 = this.makeCurrentWithinLock(n3));
                }
                catch (RuntimeException runtimeException) {
                    bl4 = true;
                    throw runtimeException;
                }
                finally {
                    if (bl4) {
                        if (DEBUG_TRACE_SWITCH) {
                            System.err.println(GLContextImpl.getThreadName() + ": GLContext.ContextSwitch[makeCurrent.1]: Context lock.unlock() due to error, res " + GLContextImpl.makeCurrentResultToString(n2) + ", " + this.lock);
                        }
                        this.lock.unlock();
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                bl4 = true;
                throw runtimeException;
            }
            finally {
                if (bl4) {
                    this.drawable.unlockSurface();
                }
            }
        }
        if (0 != n2) {
            if (0L == this.drawable.getHandle() && !this.isSurfaceless) {
                if (this.hasRendererQuirk(22)) {
                    throw new GLException(String.format("Surfaceless not supported due to quirk %s: %s", GLRendererQuirks.toString(22), this.toString()));
                }
                if (DEBUG) {
                    System.err.println(GLContextImpl.getThreadName() + ": GLContext.makeCurrent: Surfaceless OK - validated");
                }
                this.isSurfaceless = true;
            }
            GLContextImpl.setCurrent(this);
            if (2 == n2) {
                this.glDebugHandler.init(this.isGLDebugEnabled());
                if (DEBUG_GL) {
                    this.setGL(GLPipelineFactory.create("com.jogamp.opengl.Debug", null, this.gl, null));
                    if (this.glDebugHandler.isEnabled()) {
                        this.glDebugHandler.addListener(new GLDebugMessageHandler.StdErrGLDebugListener(true));
                    }
                }
                if (TRACE_GL) {
                    this.setGL(GLPipelineFactory.create("com.jogamp.opengl.Trace", null, this.gl, new Object[]{System.err}));
                }
                bl = true;
            }
            if (bl) {
                this.associateDrawable(true);
            }
            this.contextMadeCurrent(true);
        }
        if (TRACE_SWITCH) {
            System.err.println(GLContextImpl.getThreadName() + ": GLContext.ContextSwitch[makeCurrent.X3]: SWITCH - " + GLContextImpl.makeCurrentResultToString(n2) + " - stateTracker.on " + this.glStateTracker.isEnabled() + " - " + this.getTraceSwitchMsg());
        }
        return n2;
    }

    private final GLContextImpl getOtherSharedMaster() {
        GLContextImpl gLContextImpl = (GLContextImpl)GLContextShareSet.getSharedMaster(this);
        return this != gLContextImpl ? gLContextImpl : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int makeCurrentWithinLock(int n2) throws GLException {
        if (!this.isCreated()) {
            Object object;
            boolean bl;
            GLContextImpl gLContextImpl;
            if (0 >= this.drawable.getSurfaceWidth() || 0 >= this.drawable.getSurfaceHeight()) {
                if (DEBUG_TRACE_SWITCH) {
                    System.err.println(GLContextImpl.getThreadName() + ": Create GL context REJECTED (zero surface size) for " + this.getClass().getName() + " - " + this.getTraceSwitchMsg());
                    System.err.println(this.drawable.toString());
                }
                return 0;
            }
            if (DEBUG_GL) {
                this.additionalCtxCreationFlags |= 0x20;
            }
            if (null != (gLContextImpl = this.getOtherSharedMaster()) && 1 >= gLContextImpl.drawable.lockSurface()) {
                throw new GLException("GLContextShareSet could not lock sharedMaster surface: " + gLContextImpl.drawable);
            }
            try {
                if (null != gLContextImpl) {
                    long l2 = gLContextImpl.getHandle();
                    if (0L == l2) {
                        throw new GLException("GLContextShareSet returned an invalid sharedMaster context: " + gLContextImpl);
                    }
                    bl = this.createImpl(l2);
                } else {
                    bl = this.createImpl(0L);
                }
                if (bl && this.hasNoDefaultVAO()) {
                    int[] nArray = new int[1];
                    object = this.gl.getRootGL();
                    GL2ES3 gL2ES3 = object.getGL2ES3();
                    gL2ES3.glGenVertexArrays(1, nArray, 0);
                    this.defaultVAO = nArray[0];
                    gL2ES3.glBindVertexArray(this.defaultVAO);
                }
            }
            finally {
                if (null != gLContextImpl) {
                    gLContextImpl.drawable.unlockSurface();
                }
            }
            if (DEBUG_TRACE_SWITCH) {
                System.err.println(GLContextImpl.getThreadName() + ": Create GL context " + (bl ? "OK" : "FAILED") + ": For " + this.getClass().getName() + " - " + this.getGLVersion() + " - " + this.getTraceSwitchMsg());
            }
            if (!bl) {
                return 0;
            }
            AbstractGraphicsConfiguration abstractGraphicsConfiguration = this.drawable.getNativeSurface().getGraphicsConfiguration();
            object = abstractGraphicsConfiguration.getScreen().getDevice();
            if (!GLContext.getAvailableGLVersionsSet((AbstractGraphicsDevice)object) && 0 == (this.ctxOptions & 8)) {
                boolean bl2;
                int n3;
                int n4 = this.ctxVersion.compareTo(Version3_0) <= 0 ? 2 : this.ctxVersion.getMajor();
                if (0 != (this.ctxOptions & 4)) {
                    n3 = 4;
                    bl2 = false;
                } else {
                    n3 = 2;
                    bl2 = true;
                }
                MappedGLVersion mappedGLVersion = GLContextImpl.mapAvailableGLVersion((AbstractGraphicsDevice)object, n4, n3, this.ctxVersion, this.ctxOptions, this.glRendererQuirks);
                if (bl2) {
                    GLContextImpl.mapAvailableGLVersion((AbstractGraphicsDevice)object, n4, 4, this.ctxVersion, this.ctxOptions, this.glRendererQuirks);
                    if (n4 >= 4) {
                        GLContextImpl.mapAvailableGLVersion((AbstractGraphicsDevice)object, 3, n3, this.ctxVersion, this.ctxOptions, this.glRendererQuirks);
                        GLContextImpl.mapAvailableGLVersion((AbstractGraphicsDevice)object, 3, 4, this.ctxVersion, this.ctxOptions, this.glRendererQuirks);
                    }
                    if (n4 >= 3) {
                        GLContextImpl.mapAvailableGLVersion((AbstractGraphicsDevice)object, 2, n3, this.ctxVersion, this.ctxOptions, this.glRendererQuirks);
                    }
                } else if (n4 >= 4) {
                    GLContextImpl.mapAvailableGLVersion((AbstractGraphicsDevice)object, 3, n3, this.ctxVersion, this.ctxOptions, this.glRendererQuirks);
                }
                GLContext.setAvailableGLVersionsSet((AbstractGraphicsDevice)object, true);
                if (DEBUG) {
                    System.err.println(GLContextImpl.getThreadName() + ": createContextOLD-MapGLVersions HAVE: " + mappedGLVersion);
                }
            }
            GLContextShareSet.contextCreated(this);
            return 2;
        }
        this.makeCurrentImpl();
        return 1;
    }

    protected abstract void makeCurrentImpl() throws GLException;

    protected void associateDrawable(boolean bl) {
        this.drawable.associateContext(this, bl);
    }

    protected void contextMadeCurrent(boolean bl) {
        this.drawable.contextMadeCurrent(this, bl);
    }

    protected abstract boolean createImpl(long var1) throws GLException;

    protected abstract long createContextARBImpl(long var1, boolean var3, int var4, int var5, int var6);

    protected abstract void destroyContextARBImpl(long var1);

    protected final boolean isCreateContextARBAvail(AbstractGraphicsDevice abstractGraphicsDevice) {
        return !GLProfile.disableOpenGLARBContext && !GLRendererQuirks.existStickyDeviceQuirk(abstractGraphicsDevice, 21);
    }

    protected final String getCreateContextARBAvailStr(AbstractGraphicsDevice abstractGraphicsDevice) {
        boolean bl = GLRendererQuirks.existStickyDeviceQuirk(abstractGraphicsDevice, 21);
        return "disabled " + GLProfile.disableOpenGLARBContext + ", quirk " + bl;
    }

    protected final long createContextARB(long l2, boolean bl) {
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = this.drawable.getNativeSurface().getGraphicsConfiguration();
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsConfiguration.getScreen().getDevice();
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)abstractGraphicsConfiguration.getChosenCapabilities();
        GLProfile gLProfile = gLCapabilitiesImmutable.getGLProfile();
        if (DEBUG) {
            System.err.println(GLContextImpl.getThreadName() + ": createContextARB-MapGLVersions is SET (" + abstractGraphicsDevice.getConnection() + "): " + GLContext.getAvailableGLVersionsSet(abstractGraphicsDevice));
        }
        if (!GLContext.getAvailableGLVersionsSet(abstractGraphicsDevice) && !this.mapGLVersions(abstractGraphicsDevice)) {
            return 0L;
        }
        int[] nArray = new int[]{0, 0};
        GLContext.getRequestMajorAndCompat(gLProfile, nArray);
        if (DEBUG) {
            System.err.println(GLContextImpl.getThreadName() + ": createContextARB-MapGLVersions requested " + gLProfile + " -> " + GLContext.getGLVersion(nArray[0], 0, nArray[1], null));
        }
        int[] nArray2 = new int[]{0};
        int[] nArray3 = new int[]{0};
        int[] nArray4 = new int[]{0};
        long l3 = 0L;
        if (GLContext.getAvailableGLVersion(abstractGraphicsDevice, nArray[0], nArray[1], nArray2, nArray3, nArray4)) {
            nArray4[0] = nArray4[0] | this.additionalCtxCreationFlags;
            if (DEBUG) {
                System.err.println(GLContextImpl.getThreadName() + ": createContextARB-MapGLVersions Mapped " + GLContext.getGLVersion(nArray2[0], nArray3[0], nArray4[0], null));
            }
            if (0L != (l3 = this.createContextARBImpl(l2, bl, nArray4[0], nArray2[0], nArray3[0])) && !this.setGLFunctionAvailability(true, nArray2[0], nArray3[0], nArray4[0], false, false)) {
                throw new InternalError("setGLFunctionAvailability !strictMatch failed");
            }
        }
        return l3;
    }

    protected static synchronized void setMappedGLVersionListener(MappedGLVersionListener mappedGLVersionListener) {
        mapGLVersionListener = mappedGLVersionListener;
    }

    protected static MappedGLVersion mapAvailableGLVersion(AbstractGraphicsDevice abstractGraphicsDevice, int n2, int n3, VersionNumber versionNumber, int n4, GLRendererQuirks gLRendererQuirks) {
        Integer n5 = GLContextImpl.mapAvailableGLVersion(abstractGraphicsDevice, n2, n3, versionNumber, n4);
        int[] nArray = new int[]{0};
        VersionNumber versionNumber2 = null != n5 ? GLContextImpl.decomposeBits(n5, nArray) : null;
        MappedGLVersion mappedGLVersion = new MappedGLVersion(abstractGraphicsDevice, n2, n3, versionNumber, n4, gLRendererQuirks, versionNumber2, nArray[0]);
        if (null != mapGLVersionListener) {
            mapGLVersionListener.glVersionMapped(mappedGLVersion);
        }
        return mappedGLVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Integer mapAvailableGLVersion(AbstractGraphicsDevice abstractGraphicsDevice, int n2, int n3, VersionNumber versionNumber, int n4) {
        GLContextImpl.validateProfileBits(n3, "profile");
        GLContextImpl.validateProfileBits(n4, "resCtp");
        if (GLRendererQuirks.existStickyDeviceQuirk(abstractGraphicsDevice, 23)) {
            n4 &= 0xFFFFBFFF;
        }
        if (DEBUG) {
            System.err.println(GLContextImpl.getThreadName() + ": createContextARB-MapGLVersions MAP " + abstractGraphicsDevice + ": " + n2 + " (" + GLContext.getGLProfile(new StringBuilder(), n3).toString() + ") -> " + GLContextImpl.getGLVersion(versionNumber.getMajor(), versionNumber.getMinor(), n4, null));
        }
        String string = GLContextImpl.getDeviceVersionAvailableKey(abstractGraphicsDevice, n2, n3);
        Integer n5 = GLContextImpl.composeBits(versionNumber.getMajor(), versionNumber.getMinor(), n4);
        IdentityHashMap identityHashMap = deviceVersionAvailable;
        synchronized (identityHashMap) {
            return deviceVersionAvailable.put(string, n5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void remapAvailableGLVersions(AbstractGraphicsDevice abstractGraphicsDevice, AbstractGraphicsDevice abstractGraphicsDevice2, boolean bl, int n2) {
        if (abstractGraphicsDevice == abstractGraphicsDevice2 || abstractGraphicsDevice.getUniqueID() == abstractGraphicsDevice2.getUniqueID()) {
            return;
        }
        IdentityHashMap identityHashMap = deviceVersionAvailable;
        synchronized (identityHashMap) {
            if (DEBUG) {
                System.err.println(GLContextImpl.getThreadName() + ": createContextARB-MapGLVersions REMAP " + abstractGraphicsDevice + " -> " + abstractGraphicsDevice2 + ", overwrite " + bl + ", ctpCriteria " + GLContextImpl.getGLProfile(new StringBuilder(), n2).toString());
            }
            IdentityHashMap<String, Integer> identityHashMap2 = new IdentityHashMap<String, Integer>();
            Set set = deviceVersionAvailable.keySet();
            for (String string : set) {
                boolean bl2;
                Object object;
                Integer n3 = (Integer)deviceVersionAvailable.get(string);
                if (null == n3) continue;
                if (DEBUG) {
                    int[] nArray = new int[]{0};
                    object = GLContextImpl.decomposeBits(n3, nArray);
                    System.err.println(" MapGLVersions REMAP VAL0 " + string + " == " + GLContext.getGLVersion(new StringBuilder(), (VersionNumber)object, nArray[0], null).toString());
                }
                identityHashMap2.put(string, n3);
                int n4 = string.lastIndexOf(45);
                if (0 >= n4) {
                    throw new InternalError("device-separator '-' at " + n4 + " of " + string);
                }
                object = string.substring(0, n4);
                if (!abstractGraphicsDevice.getUniqueID().equals(object)) continue;
                String string2 = string.substring(n4);
                String string3 = (abstractGraphicsDevice2.getUniqueID() + string2).intern();
                Integer n5 = (Integer)deviceVersionAvailable.get(string3);
                int n6 = GLContextImpl.getCTPFromBits(n3);
                boolean bl3 = bl2 = (bl || null == n5) && 0 != (n2 & n6);
                if (bl2) {
                    identityHashMap2.put(string3, n3);
                }
                if (!DEBUG) continue;
                if (bl2) {
                    System.err.println(" MapGLVersions REMAP NEW0 " + string3 + " -> (ditto)");
                } else {
                    System.err.println(" MapGLVersions REMAP NEW0 " + string3 + " (unchanged)");
                }
                if (null != n5) {
                    int[] nArray = new int[]{0};
                    VersionNumber versionNumber = GLContextImpl.decomposeBits(n5, nArray);
                    System.err.println(" MapGLVersions REMAP OLD1 " + string3 + " :: " + GLContext.getGLVersion(new StringBuilder(), versionNumber, nArray[0], null).toString());
                    continue;
                }
                System.err.println(" MapGLVersions REMAP OLD1 " + string3 + " :: (nil)");
            }
            deviceVersionAvailable.clear();
            deviceVersionAvailable.putAll(identityHashMap2);
            GLContext.setAvailableGLVersionsSet(abstractGraphicsDevice2, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean mapGLVersions(AbstractGraphicsDevice abstractGraphicsDevice) {
        IdentityHashMap<String, Integer> identityHashMap = GLContext.deviceVersionAvailable;
        synchronized (identityHashMap) {
            boolean bl = this.drawable.getFactory().hasOpenGLESSupport();
            boolean bl2 = this.drawable.getFactory().hasOpenGLDesktopSupport();
            boolean bl3 = this.drawable.getFactoryImpl().hasMajorMinorCreateContextARB();
            if (DEBUG) {
                System.err.println(GLContextImpl.getThreadName() + ": createContextARB-MapGLVersions START (GLDesktop " + bl2 + ", GLES " + bl + ", minorVersion " + bl3 + ") on " + abstractGraphicsDevice);
            }
            long l2 = DEBUG ? System.nanoTime() : 0L;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            boolean bl7 = false;
            boolean bl8 = false;
            boolean bl9 = false;
            boolean bl10 = false;
            boolean bl11 = false;
            boolean bl12 = false;
            if (bl && !GLProfile.disableOpenGLES) {
                if (!bl10) {
                    bl10 = this.createContextARBMapVersionsAvailable(abstractGraphicsDevice, 3, 8, bl3);
                    bl4 |= bl10;
                    if (bl10) {
                        if (0 == (0x40 & this.ctxOptions)) {
                            GLContextImpl.mapAvailableGLVersion(abstractGraphicsDevice, 2, 8, this.ctxVersion, this.ctxOptions, this.glRendererQuirks);
                            if (PROFILE_ALIASING) {
                                bl11 = true;
                            }
                        }
                        this.resetStates(false);
                    }
                }
                if (!bl11) {
                    bl11 = this.createContextARBMapVersionsAvailable(abstractGraphicsDevice, 2, 8, bl3);
                    bl4 |= bl11;
                    if (bl11) {
                        if (this.ctxVersion.getMajor() >= 3 && this.hasRendererQuirk(15)) {
                            GLContextImpl.mapAvailableGLVersion(abstractGraphicsDevice, 3, 8, this.ctxVersion, this.ctxOptions, this.glRendererQuirks);
                        }
                        this.resetStates(false);
                    }
                }
                if (!bl12) {
                    bl12 = this.createContextARBMapVersionsAvailable(abstractGraphicsDevice, 1, 8, bl3);
                    bl4 |= bl12;
                    if (bl12) {
                        this.resetStates(false);
                    }
                }
            }
            if (!(Platform.OSType.MACOS != Platform.getOSType() || Platform.getOSVersionNumber().compareTo(PlatformPropsImpl.OSXVersion.Mavericks) < 0 || !bl2 || GLProfile.disableOpenGLDesktop || GLProfile.disableOpenGLCore || bl8 || bl9)) {
                bl9 = this.createContextARBMapVersionsAvailable(abstractGraphicsDevice, 3, 4, bl3);
                bl4 |= bl9;
                if (bl9) {
                    boolean bl13;
                    boolean bl14 = bl13 = 0 == (0x40 & this.ctxOptions);
                    if (bl13 && this.ctxVersion.getMajor() >= 4) {
                        GLContextImpl.mapAvailableGLVersion(abstractGraphicsDevice, 4, 4, this.ctxVersion, this.ctxOptions, this.glRendererQuirks);
                        bl8 = true;
                        if (DEBUG) {
                            System.err.println(GLContextImpl.getThreadName() + ": createContextARB-MapGLVersions: Quirk Triggerd: " + GLRendererQuirks.toString(13) + ": cause: OS " + (Object)((Object)Platform.getOSType()) + ", OS Version " + Platform.getOSVersionNumber());
                        }
                    }
                    this.resetStates(false);
                }
            }
            if (bl2 && !GLProfile.disableOpenGLDesktop && !GLProfile.disableOpenGLCore) {
                if (!bl8) {
                    bl8 = this.createContextARBMapVersionsAvailable(abstractGraphicsDevice, 4, 4, bl3);
                    bl4 |= bl8;
                    if (bl8) {
                        if (0 == (0x40 & this.ctxOptions)) {
                            GLContextImpl.mapAvailableGLVersion(abstractGraphicsDevice, 3, 4, this.ctxVersion, this.ctxOptions, this.glRendererQuirks);
                            if (PROFILE_ALIASING) {
                                bl9 = true;
                            }
                        }
                        this.resetStates(false);
                    }
                }
                if (!bl9) {
                    bl9 = this.createContextARBMapVersionsAvailable(abstractGraphicsDevice, 3, 4, bl3);
                    bl4 |= bl9;
                    if (bl9) {
                        this.resetStates(false);
                    }
                }
            }
            if (bl2 && !GLProfile.disableOpenGLDesktop) {
                if (!bl5) {
                    bl5 = this.createContextARBMapVersionsAvailable(abstractGraphicsDevice, 4, 2, bl3);
                    bl4 |= bl5;
                    if (bl5) {
                        if (!bl8) {
                            GLContextImpl.mapAvailableGLVersion(abstractGraphicsDevice, 4, 4, this.ctxVersion, this.ctxOptions, this.glRendererQuirks);
                            bl8 = true;
                        }
                        if (!bl9) {
                            GLContextImpl.mapAvailableGLVersion(abstractGraphicsDevice, 3, 4, this.ctxVersion, this.ctxOptions, this.glRendererQuirks);
                            bl9 = true;
                        }
                        if (0 == (0x40 & this.ctxOptions)) {
                            GLContextImpl.mapAvailableGLVersion(abstractGraphicsDevice, 3, 2, this.ctxVersion, this.ctxOptions, this.glRendererQuirks);
                            GLContextImpl.mapAvailableGLVersion(abstractGraphicsDevice, 2, 2, this.ctxVersion, this.ctxOptions, this.glRendererQuirks);
                            if (PROFILE_ALIASING) {
                                bl6 = true;
                                bl7 = true;
                            }
                        }
                        this.resetStates(false);
                    }
                }
                if (!bl6) {
                    bl6 = this.createContextARBMapVersionsAvailable(abstractGraphicsDevice, 3, 2, bl3);
                    bl4 |= bl6;
                    if (bl6) {
                        if (!bl9) {
                            GLContextImpl.mapAvailableGLVersion(abstractGraphicsDevice, 3, 4, this.ctxVersion, this.ctxOptions, this.glRendererQuirks);
                            bl9 = true;
                        }
                        if (0 == (0x40 & this.ctxOptions)) {
                            GLContextImpl.mapAvailableGLVersion(abstractGraphicsDevice, 2, 2, this.ctxVersion, this.ctxOptions, this.glRendererQuirks);
                            if (PROFILE_ALIASING) {
                                bl7 = true;
                            }
                        }
                        this.resetStates(false);
                    }
                }
                if (!bl7) {
                    bl7 = this.createContextARBMapVersionsAvailable(abstractGraphicsDevice, 2, 2, bl3);
                    bl4 |= bl7;
                    if (bl7) {
                        this.resetStates(false);
                    }
                }
            }
            if (bl4) {
                GLContext.setAvailableGLVersionsSet(abstractGraphicsDevice, true);
            }
            if (DEBUG) {
                long l3 = System.nanoTime();
                System.err.println(GLContextImpl.getThreadName() + ": createContextARB-MapGLVersions END (success " + bl4 + ") on " + abstractGraphicsDevice + ", profileAliasing: " + PROFILE_ALIASING + ", total " + (double)(l3 - l2) / 1000000.0 + "ms");
                if (bl4) {
                    System.err.println(GLContext.dumpAvailableGLVersions(null).toString());
                }
            }
            return bl4;
        }
    }

    private final boolean createContextARBMapVersionsAvailable(AbstractGraphicsDevice abstractGraphicsDevice, int n2, int n3, boolean bl) {
        boolean bl2;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = 1 | n3;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if (bl) {
            if (8 == n3) {
                n7 = n2;
                n6 = GLContext.getMaxMinor(n8, n7);
                n5 = n2;
                n4 = 0;
            } else if (4 == n2) {
                n7 = 4;
                n6 = GLContext.getMaxMinor(n8, n7);
                n5 = 4;
                n4 = 0;
            } else if (3 == n2) {
                n7 = 3;
                n6 = GLContext.getMaxMinor(n8, n7);
                n5 = 3;
                n4 = 1;
            } else {
                n7 = 3;
                n6 = 0;
                n5 = 2;
                n4 = 0;
            }
        } else if (8 == n3) {
            n7 = n2;
            n6 = 0;
            n5 = n2;
            n4 = 0;
        } else if (4 == n2) {
            n7 = 4;
            n6 = 0;
            n5 = 4;
            n4 = 0;
        } else if (3 == n2) {
            n7 = 3;
            n6 = 1;
            n5 = 3;
            n4 = 1;
        } else {
            n7 = 2;
            n6 = 0;
            n5 = 2;
            n4 = 0;
        }
        long l2 = this.createContextARBVersions(0L, true, n8, n7, n6, n5, n4, nArray, nArray2);
        if (0L == l2 && 4 == n3 && !PROFILE_ALIASING) {
            n8 &= 0xFFFFFFFB;
            l2 = this.createContextARBVersions(0L, true, n8 |= 0x10, n7, n6, n5, n4, nArray, nArray2);
            if (0L == l2) {
                n8 &= 0xFFFFFFFB;
                n8 &= 0xFFFFFFEF;
                l2 = this.createContextARBVersions(0L, true, n8 |= 2, n7, n6, n5, n4, nArray, nArray2);
            }
        }
        if (0L != l2) {
            MappedGLVersion mappedGLVersion = GLContextImpl.mapAvailableGLVersion(abstractGraphicsDevice, n2, n3, this.ctxVersion, this.ctxOptions, this.glRendererQuirks);
            this.destroyContextARBImpl(l2);
            if (DEBUG) {
                System.err.println(GLContextImpl.getThreadName() + ": createContextARB-MapGLVersions HAVE " + mappedGLVersion.toString(new StringBuilder(), n5, n4, n7, n6).toString());
            }
            bl2 = true;
        } else {
            if (DEBUG) {
                System.err.println(GLContextImpl.getThreadName() + ": createContextARB-MapGLVersions NOPE " + abstractGraphicsDevice + ", " + n2 + " (" + GLContext.getGLProfile(new StringBuilder(), n3).toString() + ") [" + n7 + "." + n6 + " .. " + n5 + "." + n4 + "]");
            }
            bl2 = false;
        }
        return bl2;
    }

    private final long createContextARBVersions(long l2, boolean bl, int n2, int n3, int n4, int n5, int n6, int[] nArray, int[] nArray2) {
        nArray[0] = n3;
        nArray2[0] = n4;
        long l3 = 0L;
        int n7 = 0;
        do {
            if (DEBUG) {
                System.err.println(GLContextImpl.getThreadName() + ": createContextARBVersions." + ++n7 + ": share " + l2 + ", direct " + bl + ", version " + nArray[0] + "." + nArray2[0] + " [" + n3 + "." + n4 + " .. " + n5 + "." + n6 + "]");
            }
            if (0L == (l3 = this.createContextARBImpl(l2, bl, n2, nArray[0], nArray2[0]))) continue;
            if (this.setGLFunctionAvailability(true, nArray[0], nArray2[0], n2, true, true)) break;
            this.destroyContextARBImpl(l3);
            l3 = 0L;
        } while ((nArray[0] > n5 || nArray[0] == n5 && nArray2[0] > n6) && GLContext.decrementGLVersion(n2, nArray, nArray2));
        if (DEBUG) {
            System.err.println(GLContextImpl.getThreadName() + ": createContextARBVersions.X: ctx " + GLContextImpl.toHexString(l3) + ", share " + l2 + ", direct " + bl + ", version " + nArray[0] + "." + nArray2[0] + " [" + n3 + "." + n4 + " .. " + n5 + "." + n6 + "]");
        }
        return l3;
    }

    private final void setContextVersion(int n2, int n3, int n4, VersionNumberString versionNumberString, boolean bl) {
        if (0 == n4) {
            throw new GLException("Invalid GL Version " + n2 + "." + n3 + ", ctp " + GLContextImpl.toHexString(n4));
        }
        this.ctxVersion = new VersionNumber(n2, n3, 0);
        this.ctxVersionString = GLContextImpl.getGLVersion(n2, n3, n4, this.glVersion);
        this.ctxVendorVersion = versionNumberString;
        this.ctxOptions = n4;
        if (bl) {
            this.ctxGLSLVersion = VersionNumber.zeroVersion;
            if (this.hasGLSL()) {
                String string;
                String string2 = string = this.isGLES() ? null : this.glGetStringInt(35724);
                if (null != string) {
                    this.ctxGLSLVersion = new VersionNumber(string);
                    if (this.ctxGLSLVersion.getMajor() < 1) {
                        this.ctxGLSLVersion = VersionNumber.zeroVersion;
                    }
                }
                if (this.ctxGLSLVersion.isZero()) {
                    this.ctxGLSLVersion = GLContextImpl.getStaticGLSLVersionNumber(n2, n3, this.ctxOptions);
                }
            }
        }
    }

    private final boolean verifyInstance(GLProfile gLProfile, String string, Object object) {
        return ReflectionUtil.instanceOf(object, gLProfile.getGLImplBaseClassName() + string);
    }

    private final Object createInstance(AbstractGraphicsDevice abstractGraphicsDevice, int n2, int n3, int n4, boolean bl, Object[] objectArray) {
        String string = GLContext.getGLProfile(n2, n3, n4);
        GLProfile gLProfile = GLProfile.get(abstractGraphicsDevice, string);
        return ReflectionUtil.createInstance(gLProfile.getGLCtor(bl), objectArray);
    }

    private final boolean verifyInstance(AbstractGraphicsDevice abstractGraphicsDevice, int n2, int n3, int n4, String string, Object object) {
        String string2 = GLContext.getGLProfile(n2, n3, n4);
        GLProfile gLProfile = GLProfile.get(abstractGraphicsDevice, string2);
        return ReflectionUtil.instanceOf(object, gLProfile.getGLImplBaseClassName() + string);
    }

    private final GL createGL(AbstractGraphicsDevice abstractGraphicsDevice, int n2, int n3, int n4) {
        String string = GLContext.getGLProfile(n2, n3, n4);
        GLProfile gLProfile = GLProfile.get(abstractGraphicsDevice, string);
        GL gL = (GL)ReflectionUtil.createInstance(gLProfile.getGLCtor(true), gLProfile, this);
        return gL;
    }

    private void finalizeInit(GL gL) {
        Method method;
        block3: {
            method = null;
            try {
                method = ReflectionUtil.getMethod(gL.getClass(), "finalizeInit", new Class[0]);
            }
            catch (Throwable throwable) {
                if (!DEBUG) break block3;
                System.err.println("Caught " + throwable.getClass().getName() + ": " + throwable.getMessage());
                throwable.printStackTrace();
            }
        }
        if (null == method) {
            throw new InternalError("Missing 'void finalizeInit(ProcAddressTable)' in " + gL.getClass().getName());
        }
        ReflectionUtil.callMethod(gL, method, new Object[0]);
    }

    public final ProcAddressTable getGLProcAddressTable() {
        return this.glProcAddressTable;
    }

    public abstract ProcAddressTable getPlatformExtProcAddressTable();

    protected final String mapToRealGLFunctionName(String string) {
        String string2;
        Map<String, String> map = this.getFunctionNameMap();
        if (null != map && (string2 = map.get(string)) != null) {
            return string2;
        }
        return string;
    }

    protected abstract Map<String, String> getFunctionNameMap();

    protected final String mapToRealGLExtensionName(String string) {
        String string2;
        Map<String, String> map = this.getExtensionNameMap();
        if (null != map && (string2 = map.get(string)) != null) {
            return string2;
        }
        return string;
    }

    protected abstract Map<String, String> getExtensionNameMap();

    public final GLDynamicLookupHelper getGLDynamicLookupHelper() {
        return this.drawable.getFactoryImpl().getGLDynamicLookupHelper(this.ctxVersion.getMajor(), this.ctxOptions);
    }

    public final GLDynamicLookupHelper getGLDynamicLookupHelper(int n2, int n3) {
        return this.drawable.getFactoryImpl().getGLDynamicLookupHelper(n2, n3);
    }

    protected final void resetProcAddressTable(final ProcAddressTable procAddressTable, final GLDynamicLookupHelper gLDynamicLookupHelper) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                procAddressTable.reset(gLDynamicLookupHelper);
                return null;
            }
        });
    }

    protected abstract void updateGLXProcAddressTable(String var1, GLDynamicLookupHelper var2);

    private final boolean initGLRendererAndGLVersionStrings(int n2, int n3) {
        String string = this.glGetStringInt(7936);
        if (null == string) {
            if (DEBUG) {
                System.err.println("Warning: GL_VENDOR is NULL.");
                ExceptionUtils.dumpStack(System.err);
            }
            return false;
        }
        this.glVendor = string;
        String string2 = this.glGetStringInt(7937);
        if (null == string2) {
            if (DEBUG) {
                System.err.println("Warning: GL_RENDERER is NULL.");
                ExceptionUtils.dumpStack(System.err);
            }
            return false;
        }
        this.glRenderer = string2;
        this.glRendererLowerCase = this.glRenderer.toLowerCase();
        String string3 = this.glGetStringInt(7938);
        if (null == string3) {
            if (DEBUG) {
                System.err.println("Warning: GL_VERSION is NULL.");
                ExceptionUtils.dumpStack(System.err);
            }
            return false;
        }
        this.glVersion = string3;
        return true;
    }

    private final void getGLIntVersion(int[] nArray, int[] nArray2, int[] nArray3) {
        nArray[0] = 0;
        nArray2[0] = 0;
        this.glGetIntegervInt(33307, nArray, 0);
        this.glGetIntegervInt(33308, nArray2, 0);
        if (null != nArray3) {
            this.glGetIntegervInt(37158, nArray3, 0);
        }
    }

    private static final VersionNumber getGLVersionNumber(int n2, String string) {
        int[] nArray;
        int[] nArray2;
        GLVersionNumber gLVersionNumber;
        if (null != string && (gLVersionNumber = GLVersionNumber.create(string)).isValid() && GLContext.isValidGLVersion(n2, (nArray2 = new int[]{gLVersionNumber.getMajor()})[0], (nArray = new int[]{gLVersionNumber.getMinor()})[0])) {
            return new VersionNumber(nArray2[0], nArray[0], 0);
        }
        return null;
    }

    protected final int getCtxOptions() {
        return this.ctxOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean setGLFunctionAvailability(boolean bl, final int n2, int n3, final int n4, boolean bl2, boolean bl3) throws GLException {
        boolean bl4;
        boolean bl5;
        Object object;
        Object object2;
        boolean bl6;
        if (null != this.gl && null != this.glProcAddressTable && !bl) {
            return true;
        }
        if (1 < Bitfield.Util.bitCount(n4 & 0xE)) {
            String string = GLContextImpl.getGLProfile(new StringBuilder(), n4).toString();
            int n5 = n4 & 0xE;
            throw new GLException("Invalid GL Profile Request, only one can be set of ES, CORE and COMPAT. Has <" + string + ">, bits <" + Integer.toBinaryString(n5) + ">, count " + Bitfield.Util.bitCount(n5));
        }
        if (0 < n2 && !GLContext.isValidGLVersion(n4, n2, n3)) {
            throw new GLException("Invalid GL Version Request " + GLContext.getGLVersion(n2, n3, n4, null));
        }
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = this.drawable.getNativeSurface().getGraphicsConfiguration();
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsConfiguration.getScreen().getDevice();
        if (!this.glGetPtrInit) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    GLDynamicLookupHelper gLDynamicLookupHelper = GLContextImpl.this.getGLDynamicLookupHelper(n2, n4);
                    if (null != gLDynamicLookupHelper) {
                        gLDynamicLookupHelper.claimAllLinkPermission();
                        try {
                            GLContextImpl.this.glGetStringPtr = gLDynamicLookupHelper.dynamicLookupFunction("glGetString");
                            GLContextImpl.this.glGetIntegervPtr = gLDynamicLookupHelper.dynamicLookupFunction("glGetIntegerv");
                            GLContextImpl.this.glGetStringiPtr = gLDynamicLookupHelper.dynamicLookupFunction("glGetStringi");
                        }
                        finally {
                            gLDynamicLookupHelper.releaseAllLinkPermission();
                        }
                    }
                    return null;
                }
            });
            this.glGetPtrInit = true;
            if (DEBUG) {
                System.err.println(GLContextImpl.getThreadName() + ": GLContext.setGLFuncAvail: glGetStringi " + GLContextImpl.toHexString(this.glGetStringiPtr) + " (opt), glGetString " + GLContextImpl.toHexString(this.glGetStringPtr) + ", glGetIntegerv " + GLContextImpl.toHexString(this.glGetIntegervPtr));
            }
            if (0L == this.glGetStringPtr || 0L == this.glGetIntegervPtr) {
                String string = "Intialization of glGetString " + GLContextImpl.toHexString(this.glGetStringPtr) + ", glGetIntegerv " + GLContextImpl.toHexString(this.glGetIntegervPtr) + " failed. " + abstractGraphicsDevice + " - requested " + GLContext.getGLVersion(n2, n3, n4, null);
                if (bl2) {
                    if (DEBUG) {
                        System.err.println("Warning: setGLFunctionAvailability: " + string);
                    }
                    return false;
                }
                throw new GLException(string);
            }
        }
        if (!(bl6 = this.initGLRendererAndGLVersionStrings(n2, n4))) {
            String string = "Intialization of GL renderer strings failed. " + abstractGraphicsDevice + " - requested " + GLContext.getGLVersion(n2, n3, n4, null);
            if (bl2) {
                if (DEBUG) {
                    System.err.println("Warning: setGLFunctionAvailability: " + string);
                }
                return false;
            }
            throw new GLException(string);
        }
        VersionNumber versionNumber = GLContextImpl.getGLVersionNumber(n4, this.glVersion);
        if (DEBUG) {
            System.err.println(GLContextImpl.getThreadName() + ": GLContext.setGLFuncAvail: Given " + abstractGraphicsDevice + " - requested " + GLContext.getGLVersion(n2, n3, n4, this.glVersion) + ", has Number(Str) " + versionNumber);
        }
        boolean bl7 = bl6 = 0 != (8 & n4);
        if (DEBUG) {
            System.err.println(GLContextImpl.getThreadName() + ": GLContext.setGLFuncAvail: Pre version verification: requested " + GLContext.getGLVersion(n2, n3, n4, null) + ", drawable.glp " + this.drawable.getGLProfile() + ", strictMatch " + bl2 + ", glVersionsMapping " + bl3 + ", hasGLVersionByString " + versionNumber);
        }
        VersionNumber versionNumber2 = new VersionNumber(n2, n3, 0);
        int n6 = n2;
        int n7 = n3;
        int n8 = n4;
        if (n2 >= 3 || versionNumber.compareTo(Version3_0) >= 0) {
            object2 = new int[]{0};
            object = new int[]{0};
            if (bl6) {
                this.getGLIntVersion((int[])object2, (int[])object, null);
            } else {
                int[] nArray = new int[]{0};
                this.getGLIntVersion((int[])object2, (int[])object, nArray);
                if (0 != (1 & nArray[0])) {
                    n8 &= 0xFFFFFFFD;
                    n8 |= 4;
                } else if (0 != (2 & nArray[0])) {
                    n8 |= 2;
                    n8 &= 0xFFFFFFFB;
                }
            }
            if (0 == Bitfield.Util.bitCount(n8 & 0xE)) {
                n8 |= bl6 ? 8 : 2;
            }
            VersionNumber versionNumber3 = new VersionNumber(object2[0], object[0], 0);
            if (DEBUG) {
                System.err.println(GLContextImpl.getThreadName() + ": GLContext.setGLFuncAvail: Version verification (Int): String " + this.glVersion + ", Number(Int) " + versionNumber3 + " - " + GLContext.getGLVersion(object2[0], object[0], n8, null));
            }
            if (GLContext.isValidGLVersion(n8, versionNumber3.getMajor(), versionNumber3.getMinor())) {
                int n9 = versionNumber3.getMajor();
                if (bl2 && ((bl6 || n2 >= 3) && versionNumber3.compareTo(versionNumber2) < 0 || !bl6 && 0 != (n4 & 2) && 0 != (n8 & 4) || bl6 && (2 == n2 && (2 > n9 || n9 > 3) || (1 == n2 || 3 <= n2) && n2 != n9))) {
                    if (DEBUG) {
                        System.err.println(GLContextImpl.getThreadName() + ": GLContext.setGLFuncAvail.X: FAIL, GL version mismatch (Int): requested " + GLContext.getGLVersion(n2, n3, n4, null) + " -> has " + this.glVersion + ", " + versionNumber3 + " - " + GLContext.getGLVersion(object2[0], object[0], n8, null));
                    }
                    return false;
                }
                n6 = versionNumber3.getMajor();
                n7 = versionNumber3.getMinor();
                bl5 = true;
            } else {
                bl5 = false;
            }
        } else {
            bl5 = false;
        }
        if (bl5) {
            bl4 = true;
        } else {
            if (DEBUG) {
                System.err.println(GLContextImpl.getThreadName() + ": GLContext.setGLFuncAvail: Version verification (String): String " + this.glVersion + ", Number(Str) " + versionNumber);
            }
            if (0 == Bitfield.Util.bitCount(n8 & 0xE)) {
                n8 |= bl6 ? 8 : 2;
            }
            if (null != versionNumber) {
                int n10 = versionNumber.getMajor();
                if (bl2 && ((bl6 || n2 >= 3) && versionNumber.compareTo(versionNumber2) < 0 || !bl6 && 0 != (n4 & 2) && 0 != (n8 & 4) || bl6 && (2 == n2 && (2 > n10 || n10 > 3) || (1 == n2 || 3 <= n2) && n2 != n10))) {
                    if (DEBUG) {
                        System.err.println(GLContextImpl.getThreadName() + ": GLContext.setGLFuncAvail.X: FAIL, GL version mismatch (String): requested " + GLContext.getGLVersion(n2, n3, n4, null) + " -> has " + this.glVersion + ", " + versionNumber + " - " + GLContext.getGLVersion(versionNumber.getMajor(), versionNumber.getMinor(), n8, null));
                    }
                    return false;
                }
                if (bl2 && !bl5 && n2 >= 3) {
                    if (DEBUG) {
                        System.err.println(GLContextImpl.getThreadName() + ": GLContext.setGLFuncAvail.X: FAIL, GL3/ES3 version Int failed, String: requested " + GLContext.getGLVersion(n2, n3, n4, null) + " -> " + this.glVersion + ", " + versionNumber);
                    }
                    return false;
                }
                n6 = versionNumber.getMajor();
                n7 = versionNumber.getMinor();
                bl4 = true;
            } else {
                bl4 = false;
            }
        }
        if (bl2 && !bl4) {
            if (DEBUG) {
                System.err.println(GLContextImpl.getThreadName() + ": GLContext.setGLFuncAvail.X: FAIL, No GL version validation possible: requested " + GLContext.getGLVersion(n2, n3, n4, null) + " -> has " + GLContext.getGLVersion(n6, n7, n8, null) + " - " + this.glVersion);
            }
            return false;
        }
        if (DEBUG) {
            System.err.println(GLContextImpl.getThreadName() + ": GLContext.setGLFuncAvail: Post version verification: requested " + GLContext.getGLVersion(n2, n3, n4, null) + " -> has " + GLContext.getGLVersion(n6, n7, n8, null) + ", strictMatch " + bl2 + ", versionValidated " + bl4 + ", versionGL3IntOK " + bl5);
        }
        if (n6 < 2) {
            n8 &= 0xFFFFC3FF;
        }
        if (!this.isCurrentContextHardwareRasterizer()) {
            n8 |= 0x40;
        }
        object2 = GLVersionNumber.createVendorVersion(this.glVersion);
        this.setRendererQuirks(abstractGraphicsDevice, this.getDrawableImpl().getFactoryImpl(), n2, n3, n4, n6, n7, n8, (VersionNumberString)object2, bl3);
        if (this.glRendererQuirks.exist(6) && 0 != (n4 & 2) && (n2 > 3 || n2 == 3 && n3 >= 1)) {
            if (DEBUG) {
                System.err.println(GLContextImpl.getThreadName() + ": GLContext.setGLFuncAvail.X: FAIL, GL3CompatNonCompliant: " + GLContext.getGLVersion(n6, n7, n8, this.glVersion) + ", " + this.glRenderer);
            }
            return false;
        }
        if (this.glRendererQuirks.exist(6) && n2 > 0 && 0 != (n8 & 2) && (n6 > 3 || n6 == 3 && n7 >= 1)) {
            n6 = n2;
            n7 = n3;
            if (DEBUG) {
                System.err.println(GLContextImpl.getThreadName() + ": GLContext.setGLFuncAvail: GL3CompatNonCompliant: " + GLContext.getGLVersion(n6, n7, n8, this.glVersion) + ", " + this.glRenderer);
            }
        }
        this.contextFQN = GLContextImpl.getContextFQN(abstractGraphicsDevice, n6, n7, n8);
        if (DEBUG) {
            System.err.println(GLContextImpl.getThreadName() + ": GLContext.setGLFuncAvail.0 validated FQN: " + this.contextFQN + " - " + GLContext.getGLVersion(n6, n7, n8, this.glVersion));
        }
        if (null == (object = (Object)this.getGLDynamicLookupHelper(n6, n8))) {
            if (DEBUG) {
                System.err.println(GLContextImpl.getThreadName() + ": GLContext.setGLFuncAvail.X: FAIL, No GLDynamicLookupHelper for having: " + GLContext.getGLVersion(n6, n7, n8, null));
            }
            return false;
        }
        this.updateGLXProcAddressTable(this.contextFQN, (GLDynamicLookupHelper)object);
        Object object3 = this.drawable.getGLProfile();
        Object object4 = null;
        Object object5 = mappedContextTypeObjectLock;
        synchronized (object5) {
            object4 = mappedGLProcAddress.get(this.contextFQN);
            if (null != object4) {
                if (!this.verifyInstance(abstractGraphicsDevice, n6, n7, n8, "ProcAddressTable", object4)) {
                    throw new GLException("GLContext GL ProcAddressTable mapped key(" + this.contextFQN + " - " + GLContext.getGLVersion(n6, n7, n8, null) + ") -> " + GLContextImpl.toHexString(object4.hashCode()) + " not matching " + object4.getClass().getName());
                }
                if (!bl3 && !this.verifyInstance((GLProfile)object3, "ProcAddressTable", object4)) {
                    throw new GLException("GLContext GL ProcAddressTable mapped key(" + this.contextFQN + " - " + GLContext.getGLVersion(n6, n7, n8, null) + ") -> " + GLContextImpl.toHexString(object4.hashCode()) + ": " + object4.getClass().getName() + " not matching " + ((GLProfile)object3).getGLImplBaseClassName() + "/" + object3);
                }
            }
        }
        if (null != object4) {
            this.glProcAddressTable = object4;
            if (DEBUG) {
                if (bl3) {
                    System.err.println(GLContextImpl.getThreadName() + ": GLContext GL ProcAddressTable reusing key(" + this.contextFQN + " - " + GLContext.getGLVersion(n6, n7, n8, null) + ") -> " + GLContextImpl.toHexString(object4.hashCode()) + ": " + object4.getClass().getName());
                } else {
                    System.err.println(GLContextImpl.getThreadName() + ": GLContext GL ProcAddressTable reusing key(" + this.contextFQN + " - " + GLContext.getGLVersion(n6, n7, n8, null) + ") -> " + GLContextImpl.toHexString(object4.hashCode()) + ": " + object4.getClass().getName() + " -> " + ((GLProfile)object3).getGLImplBaseClassName());
                }
            }
        } else {
            this.glProcAddressTable = (ProcAddressTable)this.createInstance(abstractGraphicsDevice, n6, n7, n8, false, new Object[]{new GLProcAddressResolver()});
            this.resetProcAddressTable(this.glProcAddressTable, (GLDynamicLookupHelper)object);
            object5 = mappedContextTypeObjectLock;
            synchronized (object5) {
                mappedGLProcAddress.put(this.contextFQN, this.glProcAddressTable);
                if (DEBUG) {
                    if (bl3) {
                        System.err.println(GLContextImpl.getThreadName() + ": GLContext GL ProcAddressTable mapping key(" + this.contextFQN + " - " + GLContext.getGLVersion(n6, n7, n8, null) + ") -> " + GLContextImpl.toHexString(this.glProcAddressTable.hashCode()) + ": " + this.glProcAddressTable.getClass().getName());
                    } else {
                        System.err.println(GLContextImpl.getThreadName() + ": GLContext GL ProcAddressTable mapping key(" + this.contextFQN + " - " + GLContext.getGLVersion(n6, n7, n8, null) + ") -> " + GLContextImpl.toHexString(this.glProcAddressTable.hashCode()) + ": " + this.glProcAddressTable.getClass().getName() + " -> " + ((GLProfile)object3).getGLImplBaseClassName());
                    }
                }
            }
        }
        if (null == this.gl || !this.verifyInstance(abstractGraphicsDevice, n6, n7, n8, "Impl", this.gl)) {
            this.setGL(this.createGL(abstractGraphicsDevice, n6, n7, n8));
        }
        if (!bl3 && !this.verifyInstance((GLProfile)object3, "Impl", this.gl)) {
            throw new GLException("GLContext GL Object mismatch: " + GLContext.getGLVersion(n6, n7, n8, null) + ") -> : " + this.gl.getClass().getName() + " not matching " + ((GLProfile)object3).getGLImplBaseClassName() + "/" + object3);
        }
        object4 = mappedContextTypeObjectLock;
        synchronized (object4) {
            object3 = mappedExtensionAvailabilityCache.get(this.contextFQN);
        }
        if (null != object3) {
            this.extensionAvailability = object3;
            if (DEBUG) {
                System.err.println(GLContextImpl.getThreadName() + ": GLContext GL ExtensionAvailabilityCache reusing key(" + this.contextFQN + ") -> " + GLContextImpl.toHexString(object3.hashCode()) + " - entries: " + ((ExtensionAvailabilityCache)object3).getTotalExtensionCount());
            }
        } else {
            this.extensionAvailability = new ExtensionAvailabilityCache();
            this.setContextVersion(n6, n7, n8, (VersionNumberString)object2, false);
            this.extensionAvailability.reset(this);
            object4 = mappedContextTypeObjectLock;
            synchronized (object4) {
                mappedExtensionAvailabilityCache.put(this.contextFQN, this.extensionAvailability);
                if (DEBUG) {
                    System.err.println(GLContextImpl.getThreadName() + ": GLContext GL ExtensionAvailabilityCache mapping key(" + this.contextFQN + ") -> " + GLContextImpl.toHexString(this.extensionAvailability.hashCode()) + " - entries: " + this.extensionAvailability.getTotalExtensionCount());
                }
            }
        }
        if (bl6) {
            if (n6 >= 3) {
                n8 |= 0xC00;
                n8 |= 0x4000;
                if (n7 >= 2) {
                    n8 |= 0x3000;
                } else if (n7 >= 1) {
                    n8 |= 0x1000;
                }
            } else if (n6 >= 2) {
                n8 |= 0x400;
                n8 |= 0x4000;
            }
        } else if (n6 > 4 || n6 == 4 && n7 >= 5 || n6 > 3 || n6 == 3 && n7 >= 1) {
            if (this.isExtensionAvailable("GL_ARB_ES3_2_compatibility")) {
                n8 |= 0x3000;
            } else if (this.isExtensionAvailable("GL_ARB_ES3_1_compatibility")) {
                n8 |= 0x1000;
            }
            n8 |= 0xC00;
            n8 |= 0x4000;
        } else if (n6 > 4 || n6 == 4 && n7 >= 3 || (n6 > 3 || n6 == 3 && n7 >= 1) && this.isExtensionAvailable("GL_ARB_ES3_compatibility")) {
            n8 |= 0xC00;
            n8 |= 0x4000;
        } else if (this.isExtensionAvailable("GL_ARB_ES2_compatibility")) {
            n8 |= 0x400;
            n8 |= 0x4000;
        } else if (GLContextImpl.hasFBOImpl(n6, n8, this.extensionAvailability)) {
            n8 |= 0x4000;
        }
        if (bl6 && n6 == 1 || this.isExtensionAvailable("GL_OES_single_precision")) {
            n8 |= 0x8000;
        }
        if (this.glRendererQuirks.exist(23)) {
            n8 &= 0xFFFFBFFF;
        }
        this.setContextVersion(n6, n7, n8, (VersionNumberString)object2, true);
        this.finalizeInit(this.gl);
        this.setDefaultSwapInterval();
        int n11 = this.gl.glGetError();
        if (DEBUG) {
            System.err.println(GLContextImpl.getThreadName() + ": GLContext.setGLFuncAvail.X: OK " + this.contextFQN + " - " + GLContext.getGLVersion(this.ctxVersion.getMajor(), this.ctxVersion.getMinor(), this.ctxOptions, null) + " - glErr " + GLContextImpl.toHexString(n11));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final void addStickyQuirkAlways(AbstractGraphicsDevice abstractGraphicsDevice, GLRendererQuirks gLRendererQuirks, int n2, boolean bl) {
        gLRendererQuirks.addQuirk(n2);
        if (bl) {
            GLRendererQuirks.addStickyDeviceQuirk(abstractGraphicsDevice, n2);
            return;
        }
        Class<GLContextImpl> clazz = GLContextImpl.class;
        synchronized (GLContextImpl.class) {
            GLRendererQuirks.addStickyDeviceQuirk(abstractGraphicsDevice, n2);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    private static final void addStickyQuirkAtMapping(AbstractGraphicsDevice abstractGraphicsDevice, GLRendererQuirks gLRendererQuirks, int n2, boolean bl) {
        gLRendererQuirks.addQuirk(n2);
        if (bl) {
            GLRendererQuirks.addStickyDeviceQuirk(abstractGraphicsDevice, n2);
        }
    }

    private final void setRendererQuirks(AbstractGraphicsDevice abstractGraphicsDevice, GLDrawableFactoryImpl gLDrawableFactoryImpl, int n2, int n3, int n4, int n5, int n6, int n7, VersionNumberString versionNumberString, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        boolean bl6 = 0 == (n7 & 0x40);
        boolean bl7 = 0 != (n7 & 2);
        boolean bl8 = 0 != (n7 & 8);
        boolean bl9 = ".x11" == NativeWindowFactory.getNativeWindowType(true);
        boolean bl10 = Platform.getOSType() == Platform.OSType.WINDOWS;
        boolean bl11 = bl5 = this.glRenderer.contains("Mesa ") || this.glRenderer.contains("Gallium ") || this.glVersion.contains("Mesa ");
        if (!bl5) {
            bl4 = this.glVendor.contains("ATI Technologies") || this.glRenderer.startsWith("ATI ");
            bl3 = this.glVendor.contains("NVIDIA Corporation") || this.glRenderer.contains("NVIDIA ");
            bl2 = this.glVendor.startsWith("Intel");
        } else {
            bl4 = false;
            bl3 = false;
            bl2 = false;
        }
        GLRendererQuirks gLRendererQuirks = new GLRendererQuirks();
        if (bl8 && 2 == n2 && 2 < n5) {
            if (DEBUG) {
                System.err.println("Quirk: " + GLRendererQuirks.toString(15) + ": cause: ES req " + n2 + " and has 2 < " + n5);
            }
            GLContextImpl.addStickyQuirkAlways(abstractGraphicsDevice, gLRendererQuirks, 15, bl);
        }
        if (GLProfile.disableSurfacelessContext) {
            if (DEBUG) {
                System.err.println("Quirk: " + GLRendererQuirks.toString(22) + ": cause: disabled");
            }
            GLContextImpl.addStickyQuirkAlways(abstractGraphicsDevice, gLRendererQuirks, 22, bl);
        }
        if (GLProfile.disableOpenGLARBContext) {
            if (DEBUG) {
                System.err.println("Quirk: " + GLRendererQuirks.toString(21) + ": cause: disabled");
            }
            GLContextImpl.addStickyQuirkAlways(abstractGraphicsDevice, gLRendererQuirks, 21, bl);
        }
        if (Platform.getOSType() == Platform.OSType.MACOS) {
            if (DEBUG) {
                System.err.println("Quirk: " + GLRendererQuirks.toString(3) + ": cause: OS " + (Object)((Object)Platform.getOSType()));
            }
            gLRendererQuirks.addQuirk(3);
            if (DEBUG) {
                System.err.println("Quirk: " + GLRendererQuirks.toString(20) + ": cause: OS " + (Object)((Object)Platform.getOSType()));
            }
            gLRendererQuirks.addQuirk(20);
            if (Platform.getOSVersionNumber().compareTo(PlatformPropsImpl.OSXVersion.Mavericks) >= 0 && 3 == n2 && 4 == n5) {
                if (DEBUG) {
                    System.err.println("Quirk: " + GLRendererQuirks.toString(13) + ": cause: OS " + (Object)((Object)Platform.getOSType()) + ", OS Version " + Platform.getOSVersionNumber() + ", req " + n2 + "." + n3);
                }
                GLContextImpl.addStickyQuirkAtMapping(abstractGraphicsDevice, gLRendererQuirks, 13, bl);
            }
            if (bl3) {
                object3 = new VersionNumber(10, 7, 3);
                if (Platform.getOSVersionNumber().compareTo((VersionNumber)object3) < 0) {
                    if (DEBUG) {
                        System.err.println("Quirk: " + GLRendererQuirks.toString(7) + ": cause: OS " + (Object)((Object)Platform.getOSType()) + ", OS Version " + Platform.getOSVersionNumber() + ", Renderer " + this.glRenderer);
                    }
                    gLRendererQuirks.addQuirk(7);
                }
                if (Platform.getOSVersionNumber().compareTo(PlatformPropsImpl.OSXVersion.Lion) < 0) {
                    if (DEBUG) {
                        System.err.println("Quirk: " + GLRendererQuirks.toString(12) + ": cause: OS " + (Object)((Object)Platform.getOSType()) + ", OS Version " + Platform.getOSVersionNumber() + ", Renderer " + this.glRenderer);
                    }
                    gLRendererQuirks.addQuirk(12);
                }
            }
        } else if (bl10) {
            if (DEBUG) {
                System.err.println("Quirk: " + GLRendererQuirks.toString(1) + ": cause: OS " + (Object)((Object)Platform.getOSType()));
            }
            gLRendererQuirks.addQuirk(1);
            if (bl4) {
                object3 = new VersionNumber(5, 1, 0);
                object2 = new VersionNumber(12, 102, 3);
                if (versionNumberString.compareTo((VersionNumber)object2) < 0) {
                    if (DEBUG) {
                        System.err.println("Quirk: " + GLRendererQuirks.toString(10) + ": cause: OS " + (Object)((Object)Platform.getOSType()) + ", [Vendor " + this.glVendor + " or Renderer " + this.glRenderer + "], driverVersion " + versionNumberString);
                    }
                    gLRendererQuirks.addQuirk(10);
                }
                if (Platform.getOSVersionNumber().compareTo((VersionNumber)object3) <= 0) {
                    if (DEBUG) {
                        System.err.println("Quirk: " + GLRendererQuirks.toString(9) + ": cause: OS-Version " + (Object)((Object)Platform.getOSType()) + " " + Platform.getOSVersionNumber() + ", [Vendor " + this.glVendor + " or Renderer " + this.glRenderer + "]");
                    }
                    gLRendererQuirks.addQuirk(9);
                }
                if (versionNumberString.compareTo(VersionNumberString.zeroVersion) == 0 && ((VersionNumber)(object = new VersionNumber(this.glVersion))).getSub() <= 8787 && this.glRenderer.equals("ATI Radeon 3100 Graphics")) {
                    if (DEBUG) {
                        System.err.println("Quirk: " + GLRendererQuirks.toString(21) + ": cause: OS " + (Object)((Object)Platform.getOSType()) + ", [Vendor " + this.glVendor + ", Renderer " + this.glRenderer + " and Version " + this.glVersion + "]");
                    }
                    GLContextImpl.addStickyQuirkAtMapping(abstractGraphicsDevice, gLRendererQuirks, 21, bl);
                }
            } else if (bl2 && this.glRenderer.equals("Intel Bear Lake B")) {
                if (DEBUG) {
                    System.err.println("Quirk: " + GLRendererQuirks.toString(19) + ": cause: OS " + (Object)((Object)Platform.getOSType()) + ", [Vendor " + this.glVendor + " and Renderer " + this.glRenderer + "]");
                }
                gLRendererQuirks.addQuirk(19);
            }
        } else if (Platform.OSType.ANDROID == Platform.getOSType()) {
            if (this.glRenderer.contains("PowerVR")) {
                if (DEBUG) {
                    System.err.println("Quirk: " + GLRendererQuirks.toString(2) + ": cause: OS " + (Object)((Object)Platform.getOSType()) + ", Renderer " + this.glRenderer);
                }
                gLRendererQuirks.addQuirk(2);
            }
            if (this.glRenderer.contains("Immersion.16")) {
                if (DEBUG) {
                    System.err.println("Quirk: " + GLRendererQuirks.toString(14) + ": cause: OS " + (Object)((Object)Platform.getOSType()) + ", Renderer " + this.glRenderer);
                }
                gLRendererQuirks.addQuirk(14);
            }
        }
        if (bl9) {
            if (this.glRenderer.contains("Mesa ")) {
                if (this.glRenderer.contains("X11") && versionNumberString.compareTo(Version8_0) < 0) {
                    if (DEBUG) {
                        System.err.println("Quirk: " + GLRendererQuirks.toString(8) + ": cause: X11 Renderer=" + this.glRenderer + ", Version=[vendor " + versionNumberString + ", GL " + this.glVersion + "]");
                    }
                    gLRendererQuirks.addQuirk(8);
                }
            } else if (bl4) {
                if (DEBUG) {
                    System.err.println("Quirk: " + GLRendererQuirks.toString(8) + ": cause: X11 Renderer=" + this.glRenderer);
                }
                gLRendererQuirks.addQuirk(8);
            } else if (X11Util.getMarkAllDisplaysUnclosable()) {
                if (DEBUG) {
                    System.err.println("Quirk: " + GLRendererQuirks.toString(8) + ": cause: X11Util Downstream");
                }
                gLRendererQuirks.addQuirk(8);
            }
            if (bl3 && !bl8 && !(abstractGraphicsDevice instanceof EGLGraphicsDevice)) {
                if (DEBUG) {
                    System.err.print("Quirk: " + GLRendererQuirks.toString(22) + ": cause: !ES, !EGL, Vendor " + this.glVendor + ", X11 Renderer " + this.glRenderer + ", Version=[vendor " + versionNumberString + ", GL " + this.glVersion + "]");
                }
                GLContextImpl.addStickyQuirkAtMapping(abstractGraphicsDevice, gLRendererQuirks, 22, bl);
            }
        }
        if (bl5) {
            object3 = new VersionNumber(8, 0, 0);
            object2 = new VersionNumber(9, 2, 1);
            object = new VersionNumber(18, 0, 0);
            VersionNumber versionNumber = new VersionNumber(18, 2, 0);
            VersionNumber versionNumber2 = new VersionNumber(18, 2, 2);
            VersionNumber versionNumber3 = versionNumber2;
            if (versionNumberString.compareTo(versionNumber3) < 0) {
                if (DEBUG) {
                    System.err.println("Quirk: " + GLRendererQuirks.toString(4) + ": cause: Renderer " + this.glRenderer + " / Mesa-Version " + versionNumberString);
                }
                gLRendererQuirks.addQuirk(4);
            }
            if (versionNumberString.compareTo((VersionNumber)object) >= 0) {
                if (DEBUG) {
                    System.err.println("Quirks: " + GLRendererQuirks.toString(25) + ": cause: Renderer " + this.glRenderer + " / Mesa-Version " + versionNumberString);
                }
                gLRendererQuirks.addQuirk(25);
            }
            if (bl6) {
                if (versionNumberString.compareTo(versionNumber2) < 0) {
                    if (DEBUG) {
                        System.err.println("Quirk: " + GLRendererQuirks.toString(0) + ": cause: Renderer " + this.glRenderer + " / Mesa-Version " + versionNumberString);
                    }
                    gLRendererQuirks.addQuirk(0);
                }
            } else if (versionNumberString.compareTo((VersionNumber)object3) < 0) {
                if (DEBUG) {
                    System.err.println("Quirks: " + GLRendererQuirks.toString(18) + ", " + GLRendererQuirks.toString(11) + ": cause: Renderer " + this.glRenderer + " / Mesa-Version " + versionNumberString);
                }
                gLRendererQuirks.addQuirk(18);
                gLRendererQuirks.addQuirk(11);
            }
            if (bl7 && (n5 > 3 || n5 == 3 && n6 >= 1) && versionNumberString.compareTo(versionNumber) < 0) {
                if (DEBUG) {
                    System.err.println("Quirk: " + GLRendererQuirks.toString(6) + ": cause: Renderer " + this.glRenderer + " / Mesa-Version " + versionNumberString);
                }
                gLRendererQuirks.addQuirk(6);
            }
            if (this.glRenderer.contains("Intel(R)") && versionNumberString.compareTo((VersionNumber)object2) >= 0 && bl9) {
                if (DEBUG) {
                    System.err.println("Quirk: " + GLRendererQuirks.toString(14) + ": cause: X11 / Renderer " + this.glRenderer + " / Mesa-Version " + versionNumberString);
                }
                gLRendererQuirks.addQuirk(14);
            }
            if (this.glVendor.contains("nouveau")) {
                if (DEBUG) {
                    System.err.println("Quirk: " + GLRendererQuirks.toString(17) + ": cause: X11 / Renderer " + this.glRenderer + " / Vendor " + this.glVendor);
                }
                GLContextImpl.addStickyQuirkAtMapping(abstractGraphicsDevice, gLRendererQuirks, 17, bl);
            }
            if (bl10 && this.glRenderer.contains("SVGA3D") && versionNumberString.compareTo((VersionNumber)object3) < 0) {
                if (DEBUG) {
                    System.err.println("Quirk: " + GLRendererQuirks.toString(11) + ": cause: OS " + (Object)((Object)Platform.getOSType()) + " / Renderer " + this.glRenderer + " / Mesa-Version " + versionNumberString);
                }
                gLRendererQuirks.addQuirk(11);
            }
        }
        if (DEBUG) {
            System.err.println("Quirks local.0: " + gLRendererQuirks);
        }
        GLRendererQuirks.pushStickyDeviceQuirks(abstractGraphicsDevice, gLRendererQuirks);
        object3 = gLDrawableFactoryImpl.getDefaultDevice();
        if (!GLRendererQuirks.areSameStickyDevice((AbstractGraphicsDevice)object3, abstractGraphicsDevice)) {
            GLRendererQuirks.pushStickyDeviceQuirks((AbstractGraphicsDevice)object3, gLRendererQuirks);
        }
        if (bl8) {
            object2 = GLDrawableFactory.getFactory(true);
            if (null != gLDrawableFactoryImpl && !GLRendererQuirks.areSameStickyDevice((AbstractGraphicsDevice)(object = ((GLDrawableFactory)object2).getDefaultDevice()), abstractGraphicsDevice) && !GLRendererQuirks.areSameStickyDevice((AbstractGraphicsDevice)object, (AbstractGraphicsDevice)object3)) {
                GLRendererQuirks.pushStickyDeviceQuirks((AbstractGraphicsDevice)object, gLRendererQuirks);
            }
        }
        this.glRendererQuirks = gLRendererQuirks;
        if (DEBUG) {
            System.err.println("Quirks local.X: " + this.glRendererQuirks);
            System.err.println("Quirks sticky on " + abstractGraphicsDevice + ": " + GLRendererQuirks.getStickyDeviceQuirks(abstractGraphicsDevice));
        }
    }

    private static final boolean hasFBOImpl(int n2, int n3, ExtensionAvailabilityCache extensionAvailabilityCache) {
        return 0 != (n3 & 8) && n2 >= 2 || n2 >= 3 || null != extensionAvailabilityCache && (extensionAvailabilityCache.isExtensionAvailable("GL_ARB_ES2_compatibility") || extensionAvailabilityCache.isExtensionAvailable("GL_ARB_framebuffer_object") || extensionAvailabilityCache.isExtensionAvailable("GL_EXT_framebuffer_object") || extensionAvailabilityCache.isExtensionAvailable("GL_OES_framebuffer_object"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void removeCachedVersion(int n2, int n3, int n4) {
        int n5;
        Object object;
        if (!this.isCurrentContextHardwareRasterizer()) {
            n4 |= 0x40;
        }
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = this.drawable.getNativeSurface().getGraphicsConfiguration();
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsConfiguration.getScreen().getDevice();
        this.contextFQN = GLContextImpl.getContextFQN(abstractGraphicsDevice, n2, n3, n4);
        if (DEBUG) {
            System.err.println(GLContextImpl.getThreadName() + ": RM Context FQN: " + this.contextFQN + " - " + GLContext.getGLVersion(n2, n3, n4, null));
        }
        Object object2 = mappedContextTypeObjectLock;
        synchronized (object2) {
            object = mappedGLProcAddress.remove(this.contextFQN);
            if (DEBUG) {
                n5 = null != object ? object.hashCode() : 0;
                System.err.println(GLContextImpl.getThreadName() + ": RM GLContext GL ProcAddressTable mapping key(" + this.contextFQN + ") -> " + GLContextImpl.toHexString(n5));
            }
        }
        object2 = mappedContextTypeObjectLock;
        synchronized (object2) {
            object = mappedExtensionAvailabilityCache.remove(this.contextFQN);
            if (DEBUG) {
                n5 = null != object ? object.hashCode() : 0;
                System.err.println(GLContextImpl.getThreadName() + ": RM GLContext GL ExtensionAvailabilityCache mapping key(" + this.contextFQN + ") -> " + GLContextImpl.toHexString(n5));
            }
        }
    }

    private final boolean isCurrentContextHardwareRasterizer() {
        boolean bl = true;
        bl = !this.drawable.getChosenGLCapabilities().getHardwareAccelerated() ? false : !this.glRendererLowerCase.contains("software") && !this.glRendererLowerCase.contains("mesa x11") && !this.glRendererLowerCase.contains("softpipe") && !this.glRendererLowerCase.contains("llvmpipe");
        return bl;
    }

    protected abstract StringBuilder getPlatformExtensionsStringImpl();

    @Override
    public final boolean isFunctionAvailable(String string) {
        GLDynamicLookupHelper gLDynamicLookupHelper;
        ProcAddressTable procAddressTable;
        if (null != this.glProcAddressTable) {
            try {
                if (this.glProcAddressTable.isFunctionAvailable(string)) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (null != (procAddressTable = this.getPlatformExtProcAddressTable())) {
            try {
                if (procAddressTable.isFunctionAvailable(string)) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (null == (gLDynamicLookupHelper = this.getGLDynamicLookupHelper(this.ctxVersion.getMajor(), this.ctxOptions))) {
            throw new GLException("No GLDynamicLookupHelper for " + this);
        }
        final String string2 = GLNameResolver.normalizeVEN(GLNameResolver.normalizeARB(string, true), true);
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean run() {
                boolean bl = false;
                gLDynamicLookupHelper.claimAllLinkPermission();
                try {
                    int n2 = GLNameResolver.getFuncNamePermutationNumber(string2);
                    for (int i2 = 0; !bl && i2 < n2; ++i2) {
                        String string = GLNameResolver.getFuncNamePermutation(string2, i2);
                        try {
                            bl = gLDynamicLookupHelper.isFunctionAvailable(string);
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                finally {
                    gLDynamicLookupHelper.releaseAllLinkPermission();
                }
                return bl;
            }
        });
    }

    @Override
    public final boolean isExtensionAvailable(String string) {
        if (null != this.extensionAvailability) {
            return this.extensionAvailability.isExtensionAvailable(this.mapToRealGLExtensionName(string));
        }
        return false;
    }

    @Override
    public final int getPlatformExtensionCount() {
        return null != this.extensionAvailability ? this.extensionAvailability.getPlatformExtensionCount() : 0;
    }

    @Override
    public final String getPlatformExtensionsString() {
        if (null != this.extensionAvailability) {
            return this.extensionAvailability.getPlatformExtensionsString();
        }
        return null;
    }

    @Override
    public final int getGLExtensionCount() {
        return null != this.extensionAvailability ? this.extensionAvailability.getGLExtensionCount() : 0;
    }

    @Override
    public final String getGLExtensionsString() {
        if (null != this.extensionAvailability) {
            return this.extensionAvailability.getGLExtensionsString();
        }
        return null;
    }

    public final boolean isExtensionCacheInitialized() {
        if (null != this.extensionAvailability) {
            return this.extensionAvailability.isInitialized();
        }
        return false;
    }

    protected static String getContextFQN(AbstractGraphicsDevice abstractGraphicsDevice, int n2, int n3, int n4) {
        return abstractGraphicsDevice.getUniqueID() + "-" + GLContextImpl.toHexString(GLContextImpl.composeBits(n2, n3, n4 &= 0x3FF));
    }

    protected final String getContextFQN() {
        return this.contextFQN;
    }

    @Override
    public int getDefaultPixelDataType() {
        this.evalPixelDataType();
        return this.pixelDataType;
    }

    @Override
    public int getDefaultPixelDataFormat() {
        this.evalPixelDataType();
        return this.pixelDataFormat;
    }

    private final void evalPixelDataType() {
        if (!this.pixelDataEvaluated) {
            boolean bl = false;
            if (this.isGLES2Compatible() || this.isExtensionAvailable("GL_OES_read_format")) {
                int[] nArray = new int[]{0, 0};
                this.gl.glGetIntegerv(35739, nArray, 0);
                this.gl.glGetIntegerv(35738, nArray, 1);
                this.pixelDataFormat = nArray[0];
                this.pixelDataType = nArray[1];
                boolean bl2 = bl = 0 != this.pixelDataFormat && 0 != this.pixelDataType;
            }
            if (!bl) {
                this.pixelDataFormat = 6408;
                this.pixelDataType = 5121;
            }
            this.pixelDataEvaluated = true;
        }
    }

    @Override
    public final boolean setSwapInterval(int n2) throws GLException {
        this.validateCurrent();
        return this.setSwapIntervalNC(n2);
    }

    protected final boolean setSwapIntervalNC(int n2) throws GLException {
        Integer n3;
        if (!(this.drawableRetargeted && this.hasRendererQuirk(4) || null == (n3 = this.setSwapIntervalImpl2(n2)))) {
            this.currentSwapInterval = n3;
            return true;
        }
        return false;
    }

    protected abstract Integer setSwapIntervalImpl2(int var1);

    @Override
    public final int getSwapInterval() {
        return this.currentSwapInterval;
    }

    @Override
    protected final void setDefaultSwapInterval() {
        this.currentSwapInterval = 0;
        this.setSwapIntervalNC(1);
    }

    public final GLBufferObjectTracker getBufferObjectTracker() {
        return this.bufferObjectTracker;
    }

    public final GLBufferStateTracker getBufferStateTracker() {
        return this.bufferStateTracker;
    }

    public final GLStateTracker getGLStateTracker() {
        return this.glStateTracker;
    }

    public final boolean isOwner(Thread thread) {
        return this.lock.isOwner(thread);
    }

    public final boolean hasWaiters() {
        return this.lock.getQueueLength() > 0;
    }

    public final int getLockCount() {
        return this.lock.getHoldCount();
    }

    public final void setBoundFramebuffer(int n2, int n3) {
        if (0 > n3) {
            return;
        }
        switch (n2) {
            case 36009: 
            case 36160: {
                this.boundFBOTarget[0] = n3;
                break;
            }
            case 36008: {
                this.boundFBOTarget[1] = n3;
                break;
            }
        }
    }

    @Override
    public final int getBoundFramebuffer(int n2) {
        switch (n2) {
            case 36009: 
            case 36160: {
                return this.boundFBOTarget[0];
            }
            case 36008: {
                return this.boundFBOTarget[1];
            }
        }
        throw new InternalError("Invalid FBO target name: " + GLContextImpl.toHexString(n2));
    }

    @Override
    public final int getDefaultDrawFramebuffer() {
        return this.drawable.getDefaultDrawFramebuffer();
    }

    @Override
    public final int getDefaultReadFramebuffer() {
        return this.drawable.getDefaultReadFramebuffer();
    }

    @Override
    public final int getDefaultReadBuffer() {
        return this.drawable.getDefaultReadBuffer(this.gl, this.drawableRead != this.drawable);
    }

    @Override
    public final String getGLDebugMessageExtension() {
        return this.glDebugHandler.getExtension();
    }

    @Override
    public final boolean isGLDebugMessageEnabled() {
        return this.glDebugHandler.isEnabled();
    }

    @Override
    public final int getContextCreationFlags() {
        return this.additionalCtxCreationFlags;
    }

    @Override
    public final void setContextCreationFlags(int n2) {
        if (!this.isCreated()) {
            this.additionalCtxCreationFlags = n2 & 0x20;
        }
    }

    @Override
    public final boolean isGLDebugSynchronous() {
        return this.glDebugHandler.isSynchronous();
    }

    @Override
    public final void setGLDebugSynchronous(boolean bl) {
        this.glDebugHandler.setSynchronous(bl);
    }

    @Override
    public final void enableGLDebugMessage(boolean bl) throws GLException {
        if (!this.isCreated()) {
            this.additionalCtxCreationFlags = bl ? (this.additionalCtxCreationFlags |= 0x20) : (this.additionalCtxCreationFlags &= 0xFFFFFFDF);
        } else if (0 != (this.additionalCtxCreationFlags & 0x20) && null != this.getGLDebugMessageExtension()) {
            this.glDebugHandler.enable(bl);
        }
    }

    @Override
    public final void addGLDebugListener(GLDebugListener gLDebugListener) {
        this.glDebugHandler.addListener(gLDebugListener);
    }

    @Override
    public final void removeGLDebugListener(GLDebugListener gLDebugListener) {
        this.glDebugHandler.removeListener(gLDebugListener);
    }

    @Override
    public final void glDebugMessageControl(int n2, int n3, int n4, int n5, IntBuffer intBuffer, boolean bl) {
        if (this.glDebugHandler.isExtensionKHRARB()) {
            this.gl.getGL2ES2().glDebugMessageControl(n2, n3, n4, n5, intBuffer, bl);
        } else if (this.glDebugHandler.isExtensionAMD()) {
            this.gl.getGL2GL3().glDebugMessageEnableAMD(GLDebugMessage.translateARB2AMDCategory(n2, n3), n4, n5, intBuffer, bl);
        }
    }

    @Override
    public final void glDebugMessageControl(int n2, int n3, int n4, int n5, int[] nArray, int n6, boolean bl) {
        if (this.glDebugHandler.isExtensionKHRARB()) {
            this.gl.getGL2ES2().glDebugMessageControl(n2, n3, n4, n5, nArray, n6, bl);
        } else if (this.glDebugHandler.isExtensionAMD()) {
            this.gl.getGL2GL3().glDebugMessageEnableAMD(GLDebugMessage.translateARB2AMDCategory(n2, n3), n4, n5, nArray, n6, bl);
        }
    }

    @Override
    public final void glDebugMessageInsert(int n2, int n3, int n4, int n5, String string) {
        int n6;
        int n7 = n6 = null != string ? string.length() : 0;
        if (this.glDebugHandler.isExtensionKHRARB()) {
            this.gl.getGL2ES2().glDebugMessageInsert(n2, n3, n4, n5, n6, string);
        } else if (this.glDebugHandler.isExtensionAMD()) {
            this.gl.getGL2GL3().glDebugMessageInsertAMD(GLDebugMessage.translateARB2AMDCategory(n2, n3), n5, n4, n6, string);
        }
    }

    final String glGetStringiInt(int n2, int n3) {
        if (0L == this.glGetStringiPtr) {
            throw new InternalError("Not initialized: glGetStringiPtr " + GLContextImpl.toHexString(this.glGetStringiPtr));
        }
        return GLContextImpl.glGetStringiInt(n2, n3, this.glGetStringiPtr);
    }

    final boolean has_glGetStringiInt() {
        return 0L != this.glGetStringiPtr;
    }

    final String glGetStringInt(int n2) {
        if (0L == this.glGetStringPtr) {
            throw new InternalError("Not initialized: glGetStringPtr " + GLContextImpl.toHexString(this.glGetStringPtr));
        }
        return GLContextImpl.glGetStringInt(n2, this.glGetStringPtr);
    }

    final void glGetIntegervInt(int n2, int[] nArray, int n3) {
        if (0L == this.glGetIntegervPtr) {
            throw new InternalError("Not initialized: glGetIntegerv " + GLContextImpl.toHexString(this.glGetIntegervPtr));
        }
        GLContextImpl.glGetIntegervInt(n2, nArray, n3, this.glGetIntegervPtr);
    }

    private static native String glGetStringiInt(int var0, int var1, long var2);

    private static native String glGetStringInt(int var0, long var1);

    private static native void glGetIntegervInt(int var0, int[] var1, int var2, long var3);

    public static interface MappedGLVersionListener {
        public void glVersionMapped(MappedGLVersion var1);
    }

    public static class MappedGLVersion {
        public final AbstractGraphicsDevice device;
        public final int reqMajorVersion;
        public final int reqProfile;
        public final VersionNumber ctxVersion;
        public final int ctxOptions;
        public final GLRendererQuirks quirks;
        public final VersionNumber preCtxVersion;
        public final int preCtxOptions;

        public MappedGLVersion(AbstractGraphicsDevice abstractGraphicsDevice, int n2, int n3, VersionNumber versionNumber, int n4, GLRendererQuirks gLRendererQuirks, VersionNumber versionNumber2, int n5) {
            this.device = abstractGraphicsDevice;
            this.reqMajorVersion = n2;
            this.reqProfile = n3;
            this.ctxVersion = versionNumber;
            this.ctxOptions = n4;
            this.quirks = gLRendererQuirks;
            this.preCtxVersion = versionNumber2;
            this.preCtxOptions = n5;
        }

        public final String toString() {
            return this.toString(new StringBuilder(), -1, -1, -1, -1).toString();
        }

        public final StringBuilder toString(StringBuilder stringBuilder, int n2, int n3, int n4, int n5) {
            stringBuilder.append(this.device.toString()).append(" ").append(this.reqMajorVersion).append(" (");
            GLContextImpl.getGLProfile(stringBuilder, this.reqProfile).append(")");
            if (n2 >= 0 && n3 >= 0 && n4 >= 0 && n5 >= 0) {
                stringBuilder.append("[").append(n2).append(".").append(n3).append(" .. ").append(n4).append(".").append(n5).append("]");
            }
            stringBuilder.append(": [");
            if (null != this.preCtxVersion) {
                GLContextImpl.getGLVersion(stringBuilder, this.preCtxVersion, this.preCtxOptions, null);
            } else {
                stringBuilder.append("None");
            }
            stringBuilder.append("] -> [");
            GLContextImpl.getGLVersion(stringBuilder, this.ctxVersion, this.ctxOptions, null).append("]");
            return stringBuilder;
        }
    }
}

