/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.driver.x11;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.nio.Buffers;
import com.jogamp.nativewindow.AbstractGraphicsConfiguration;
import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.GraphicsConfigurationFactory;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.VisualIDHolder;
import com.jogamp.nativewindow.util.InsetsImmutable;
import com.jogamp.nativewindow.util.Point;
import com.jogamp.nativewindow.x11.X11GraphicsDevice;
import com.jogamp.nativewindow.x11.X11GraphicsScreen;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.MouseEvent;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import jogamp.nativewindow.x11.X11Lib;
import jogamp.nativewindow.x11.X11Util;
import jogamp.newt.DisplayImpl;
import jogamp.newt.PointerIconImpl;
import jogamp.newt.WindowImpl;
import jogamp.newt.driver.PNGIcon;
import jogamp.newt.driver.x11.DisplayDriver;
import jogamp.newt.driver.x11.ScreenDriver;

public class WindowDriver
extends WindowImpl {
    private static final String WINDOW_CLASS_NAME = "NewtWindow";
    private static final int X11_WHEEL_ONE_UP_BUTTON = 4;
    private static final int X11_WHEEL_ONE_DOWN_BUTTON = 5;
    private static final int X11_WHEEL_TWO_UP_BUTTON = 6;
    private static final int X11_WHEEL_TWO_DOWN_BUTTON = 7;
    private static final int defaultIconDataSize;
    private static final Buffer defaultIconData;
    volatile boolean tempFSAlwaysOnTop = false;
    private volatile long javaWindowHandle = 0L;
    private X11GraphicsDevice renderDevice;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void createNativeImpl() {
        ScreenDriver screenDriver = (ScreenDriver)this.getScreen();
        DisplayDriver displayDriver = (DisplayDriver)screenDriver.getDisplay();
        AbstractGraphicsDevice abstractGraphicsDevice = displayDriver.getGraphicsDevice();
        long l2 = X11Util.openDisplay(abstractGraphicsDevice.getConnection());
        if (0L == l2) {
            throw new RuntimeException("Error creating display(GfxCfg/Render): " + abstractGraphicsDevice.getConnection());
        }
        this.renderDevice = new X11GraphicsDevice(l2, 0, true);
        X11GraphicsScreen x11GraphicsScreen = new X11GraphicsScreen(this.renderDevice, screenDriver.getIndex());
        GraphicsConfigurationFactory graphicsConfigurationFactory = GraphicsConfigurationFactory.getFactory(displayDriver.getGraphicsDevice(), this.capsRequested);
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = graphicsConfigurationFactory.chooseGraphicsConfiguration(this.capsRequested, this.capsRequested, this.capabilitiesChooser, x11GraphicsScreen, 0);
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("X11Window.createNativeImpl() factory: " + graphicsConfigurationFactory + ", chosen config: " + abstractGraphicsConfiguration);
        }
        if (null == abstractGraphicsConfiguration) {
            throw new NativeWindowException("Error choosing GraphicsConfiguration creating window: " + this);
        }
        int n2 = abstractGraphicsConfiguration.getVisualID(VisualIDHolder.VIDType.NATIVE);
        if (0 == n2) {
            throw new NativeWindowException("Chosen Configuration w/o native visual ID: " + abstractGraphicsConfiguration);
        }
        this.setGraphicsConfiguration(abstractGraphicsConfiguration);
        int n3 = this.getReconfigureMask(0, true) & 0x47FF;
        abstractGraphicsDevice.lock();
        try {
            long[] lArray = this.CreateWindow(this.getParentWindowHandle(), abstractGraphicsDevice.getHandle(), screenDriver.getIndex(), n2, displayDriver.getJavaObjectAtom(), displayDriver.getWindowDeleteAtom(), displayDriver.getXiOpcode(), this.getX(), this.getY(), this.getWidth(), this.getHeight(), n3, defaultIconDataSize, defaultIconData, DEBUG_IMPLEMENTATION);
            if (null == lArray || 2 != lArray.length || 0L == lArray[0] || 0L == lArray[1]) {
                throw new NativeWindowException("Error creating window");
            }
            if (DEBUG_IMPLEMENTATION) {
                System.err.println("X11Window.createNativeImpl() handles " + WindowDriver.toHexString(lArray[0]) + ", " + WindowDriver.toHexString(lArray[1]));
            }
            this.setWindowHandle(lArray[0]);
            this.javaWindowHandle = lArray[1];
        }
        finally {
            abstractGraphicsDevice.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeNativeImpl() {
        if (0L != this.javaWindowHandle && null != this.getScreen()) {
            DisplayDriver displayDriver = (DisplayDriver)this.getScreen().getDisplay();
            AbstractGraphicsDevice abstractGraphicsDevice = displayDriver.getGraphicsDevice();
            abstractGraphicsDevice.lock();
            try {
                this.CloseWindow0(abstractGraphicsDevice.getHandle(), this.javaWindowHandle, displayDriver.getRandREventBase(), displayDriver.getRandRErrorBase(), displayDriver.getXiOpcode());
            }
            catch (Throwable throwable) {
                if (DEBUG_IMPLEMENTATION) {
                    Exception exception = new Exception("Warning: closeNativeImpl failed - " + Thread.currentThread().getName(), throwable);
                    exception.printStackTrace();
                }
            }
            finally {
                abstractGraphicsDevice.unlock();
                this.javaWindowHandle = 0L;
            }
        }
        if (null != this.renderDevice) {
            this.renderDevice.close();
            this.renderDevice = null;
        }
    }

    @Override
    protected final int getSupportedReconfigMaskImpl() {
        if (0L == this.javaWindowHandle) {
            return 32765;
        }
        return (0x4909 | WindowDriver.GetSupportedReconfigMask0(this.javaWindowHandle)) & 0xFFFF;
    }

    @Override
    protected boolean reconfigureWindowImpl(int n2, int n3, final int n4, final int n5, int n6) {
        int n7;
        int n8;
        InsetsImmutable insetsImmutable;
        if (0 == (0x10 & n6)) {
            insetsImmutable = this.getInsets();
            n8 = n2 - insetsImmutable.getLeftWidth();
            n7 = n3 - insetsImmutable.getTopHeight();
        } else {
            insetsImmutable = null;
            n8 = n2;
            n7 = n3;
        }
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("X11Window reconfig.0: " + n2 + "/" + n3 + " -> " + n8 + "/" + n7 + " " + n4 + "x" + n5 + ", insets " + insetsImmutable + ", " + WindowDriver.getReconfigStateMaskString(n6));
        }
        if (0 != (0x200000 & n6)) {
            if (0 != (0x800 & n6) && 0 == (0x20 & n6) && 0 == (0x40 & n6)) {
                this.tempFSAlwaysOnTop = true;
                n6 |= 0x20;
                if (DEBUG_IMPLEMENTATION) {
                    System.err.println("X11Window reconfig.2: temporary " + WindowDriver.getReconfigStateMaskString(n6));
                }
            } else {
                this.tempFSAlwaysOnTop = false;
            }
        }
        final int n9 = n6;
        this.runWithLockedDisplayDevice(new DisplayImpl.DisplayRunnable<Object>(){

            @Override
            public Object run(long l2) {
                WindowDriver.reconfigureWindow0(l2, WindowDriver.this.getScreenIndex(), WindowDriver.this.getParentWindowHandle(), WindowDriver.this.javaWindowHandle, n8, n7, n4, n5, n9);
                return null;
            }
        });
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("X11Window reconfig.X: " + this.getX() + "/" + this.getY() + " " + this.getWidth() + "x" + this.getHeight() + ", insets " + this.getInsets() + ", " + this.getStateMaskString());
        }
        return true;
    }

    @Override
    protected void focusChanged(boolean bl, boolean bl2) {
        if (this.isNativeValid() && this.isFullscreen() && !this.isAlwaysOnBottom() && this.tempFSAlwaysOnTop && this.hasFocus() != bl2) {
            final int n2 = this.getReconfigureMask(0x8000000, this.isVisible()) | (bl2 ? 32 : 0);
            if (DEBUG_IMPLEMENTATION) {
                System.err.println("X11Window reconfig.3 (focus): temporary " + WindowDriver.getReconfigStateMaskString(n2));
            }
            this.runWithLockedDisplayDevice(new DisplayImpl.DisplayRunnable<Object>(){

                @Override
                public Object run(long l2) {
                    WindowDriver.reconfigureWindow0(l2, WindowDriver.this.getScreenIndex(), WindowDriver.this.getParentWindowHandle(), WindowDriver.this.javaWindowHandle, WindowDriver.this.getX(), WindowDriver.this.getY(), WindowDriver.this.getWidth(), WindowDriver.this.getHeight(), n2);
                    return null;
                }
            });
        }
        super.focusChanged(bl, bl2);
    }

    protected void reparentNotify(long l2) {
        if (DEBUG_IMPLEMENTATION) {
            long l3 = this.getParentWindowHandle();
            System.err.println("Window.reparentNotify (" + WindowDriver.getThreadName() + "): " + WindowDriver.toHexString(l3) + " -> " + WindowDriver.toHexString(l2));
        }
    }

    @Override
    protected void requestFocusImpl(final boolean bl) {
        this.runWithLockedDisplayDevice(new DisplayImpl.DisplayRunnable<Object>(){

            @Override
            public Object run(long l2) {
                WindowDriver.requestFocus0(l2, WindowDriver.this.javaWindowHandle, bl);
                return null;
            }
        });
    }

    @Override
    protected void setTitleImpl(final String string) {
        this.runWithLockedDisplayDevice(new DisplayImpl.DisplayRunnable<Object>(){

            @Override
            public Object run(long l2) {
                WindowDriver.setTitle0(l2, WindowDriver.this.javaWindowHandle, string);
                return null;
            }
        });
    }

    @Override
    protected void setPointerIconImpl(final PointerIconImpl pointerIconImpl) {
        this.runWithLockedDisplayDevice(new DisplayImpl.DisplayRunnable<Object>(){

            @Override
            public Object run(long l2) {
                try {
                    WindowDriver.setPointerIcon0(l2, WindowDriver.this.javaWindowHandle, null != pointerIconImpl ? pointerIconImpl.validatedHandle() : 0L);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                return null;
            }
        });
    }

    @Override
    protected boolean setPointerVisibleImpl(final boolean bl) {
        return this.runWithLockedDisplayDevice(new DisplayImpl.DisplayRunnable<Boolean>(){

            @Override
            public Boolean run(long l2) {
                boolean bl2;
                PointerIconImpl pointerIconImpl = (PointerIconImpl)WindowDriver.this.getPointerIcon();
                if (bl && null != pointerIconImpl) {
                    WindowDriver.setPointerIcon0(l2, WindowDriver.this.javaWindowHandle, pointerIconImpl.validatedHandle());
                    bl2 = true;
                } else {
                    bl2 = WindowDriver.setPointerVisible0(l2, WindowDriver.this.javaWindowHandle, bl);
                }
                return bl2;
            }
        });
    }

    @Override
    protected boolean confinePointerImpl(final boolean bl) {
        return this.runWithLockedDisplayDevice(new DisplayImpl.DisplayRunnable<Boolean>(){

            @Override
            public Boolean run(long l2) {
                return WindowDriver.confinePointer0(l2, WindowDriver.this.javaWindowHandle, bl);
            }
        });
    }

    @Override
    protected void warpPointerImpl(final int n2, final int n3) {
        this.runWithLockedDisplayDevice(new DisplayImpl.DisplayRunnable<Object>(){

            @Override
            public Object run(long l2) {
                WindowDriver.warpPointer0(l2, WindowDriver.this.javaWindowHandle, n2, n3);
                return null;
            }
        });
    }

    @Override
    protected Point getLocationOnScreenImpl(final int n2, final int n3) {
        return this.runWithLockedDisplayDevice(new DisplayImpl.DisplayRunnable<Point>(){

            @Override
            public Point run(long l2) {
                return X11Lib.GetRelativeLocation(l2, WindowDriver.this.getScreenIndex(), WindowDriver.this.getWindowHandle(), 0L, n2, n3);
            }
        });
    }

    @Override
    protected final void doMouseEvent(boolean bl, boolean bl2, short s2, int n2, int n3, int n4, short s3, float[] fArray, float f2) {
        block0 : switch (s2) {
            case 203: {
                switch (s3) {
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        return;
                    }
                }
                break;
            }
            case 204: {
                boolean bl3 = 0 != (n2 & 1);
                switch (s3) {
                    case 4: {
                        s2 = (short)207;
                        s3 = 1;
                        fArray[bl3 ? 0 : 1] = 1.0f;
                        break block0;
                    }
                    case 5: {
                        s2 = (short)207;
                        s3 = 1;
                        fArray[bl3 ? 0 : 1] = -1.0f;
                        break block0;
                    }
                    case 6: {
                        s2 = (short)207;
                        s3 = 1;
                        fArray[0] = 1.0f;
                        n2 |= 1;
                        break block0;
                    }
                    case 7: {
                        s2 = (short)207;
                        s3 = 1;
                        fArray[0] = -1.0f;
                        n2 |= 1;
                    }
                }
            }
        }
        super.doMouseEvent(bl, bl2, s2, n2, n3, n4, s3, fArray, f2);
    }

    protected final void sendKeyEvent(short s2, int n2, short s3, short s4, char c2, String string) {
        char c3;
        boolean bl = KeyEvent.isModifierKey(s3);
        boolean bl2 = 0 != (0x20000000 & n2);
        char c4 = c3 = null != string ? string.charAt(0) : c2;
        if (!bl2 || !bl) {
            switch (s2) {
                case 300: {
                    super.sendKeyEvent((short)300, n2, s3, s4, c3);
                    break;
                }
                case 301: {
                    super.sendKeyEvent((short)301, n2, s3, s4, c3);
                }
            }
        }
    }

    public final void sendTouchScreenEvent(short s2, int n2, int n3, short[] sArray, int[] nArray, int[] nArray2, float[] fArray, float f2) {
        int n4 = sArray.length;
        MouseEvent.PointerType[] pointerTypeArray = new MouseEvent.PointerType[n4];
        for (int i2 = 0; i2 < n4; ++i2) {
            pointerTypeArray[i2] = MouseEvent.PointerType.TouchScreen;
        }
        this.doPointerEvent(false, false, pointerTypeArray, s2, n2, n3, true, sArray, nArray, nArray2, fArray, f2, new float[]{0.0f, 0.0f, 0.0f}, 1.0f);
    }

    @Override
    public final void sendKeyEvent(short s2, int n2, short s3, short s4, char c2) {
        throw new InternalError("XXX: Adapt Java Code to Native Code Changes");
    }

    @Override
    public final void enqueueKeyEvent(boolean bl, short s2, int n2, short s3, short s4, char c2) {
        throw new InternalError("XXX: Adapt Java Code to Native Code Changes");
    }

    private static final String getCurrentThreadName() {
        return Thread.currentThread().getName();
    }

    private static final void dumpStack() {
        ExceptionUtils.dumpStack(System.err);
    }

    private final <T> T runWithLockedDisplayDevice(DisplayImpl.DisplayRunnable<T> displayRunnable) {
        return ((DisplayDriver)this.getScreen().getDisplay()).runWithLockedDisplayDevice(displayRunnable);
    }

    protected static native boolean initIDs0();

    private long[] CreateWindow(long l2, long l3, int n2, int n3, long l4, long l5, int n4, int n5, int n6, int n7, int n8, int n9, int n10, Buffer buffer, boolean bl) {
        if (!Buffers.isDirect(buffer)) {
            throw new IllegalArgumentException("data buffer is not direct " + buffer);
        }
        return this.CreateWindow0(l2, l3, n2, n3, l4, l5, n4, n5, n6, n7, n8, n9, n10, buffer, Buffers.getDirectBufferByteOffset(buffer), true, bl);
    }

    private native long[] CreateWindow0(long var1, long var3, int var5, int var6, long var7, long var9, int var11, int var12, int var13, int var14, int var15, int var16, int var17, Object var18, int var19, boolean var20, boolean var21);

    private static native int GetSupportedReconfigMask0(long var0);

    private native void CloseWindow0(long var1, long var3, int var5, int var6, int var7);

    private static native void reconfigureWindow0(long var0, int var2, long var3, long var5, int var7, int var8, int var9, int var10, int var11);

    private static native void requestFocus0(long var0, long var2, boolean var4);

    private static native void setTitle0(long var0, long var2, String var4);

    private static native void setPointerIcon0(long var0, long var2, long var4);

    private static native boolean setPointerVisible0(long var0, long var2, boolean var4);

    private static native boolean confinePointer0(long var0, long var2, boolean var4);

    private static native void warpPointer0(long var0, long var2, int var4, int var5);

    static {
        ScreenDriver.initSingleton();
        int n2 = 0;
        int n3 = 0;
        ByteBuffer byteBuffer = null;
        if (PNGIcon.isAvailable()) {
            try {
                int[] nArray = new int[]{0};
                int[] nArray2 = new int[]{0};
                byteBuffer = PNGIcon.arrayToX11BGRAImages(NewtFactory.getWindowIcons(), nArray, nArray2);
                n2 = nArray[0];
                n3 = nArray2[0];
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        defaultIconDataSize = n2;
        defaultIconData = byteBuffer;
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("Def. Icon: data_size " + defaultIconDataSize + " * elem_size " + n3 + " = data " + defaultIconData);
        }
    }
}

