/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.driver.windows;

import com.jogamp.common.util.ArrayHashSet;
import com.jogamp.nativewindow.DefaultGraphicsScreen;
import com.jogamp.nativewindow.util.Rectangle;
import com.jogamp.newt.MonitorDevice;
import com.jogamp.newt.MonitorMode;
import com.jogamp.newt.Screen;
import jogamp.newt.MonitorModeProps;
import jogamp.newt.ScreenImpl;
import jogamp.newt.driver.windows.DisplayDriver;

public class ScreenDriver
extends ScreenImpl {
    @Override
    protected void createNativeImpl() {
        this.aScreen = new DefaultGraphicsScreen(this.getDisplay().getGraphicsDevice(), this.screen_idx);
    }

    @Override
    protected void closeNativeImpl() {
    }

    private final String getAdapterName(int n2) {
        return this.getAdapterName0(n2);
    }

    private final String getMonitorName(String string, int n2, boolean bl) {
        return this.getMonitorName0(string, n2, bl);
    }

    private final MonitorMode getMonitorModeImpl(MonitorModeProps.Cache cache, String string, int n2) {
        if (null == string) {
            return null;
        }
        int[] nArray = this.getMonitorMode0(string, n2);
        if (null == nArray || 0 >= nArray.length) {
            return null;
        }
        return MonitorModeProps.streamInMonitorMode(null, cache, nArray, 0);
    }

    private static final int getMonitorId(int n2, int n3) {
        if (n2 > 255) {
            throw new InternalError("Unsupported adapter idx > 0xff: " + n2);
        }
        if (n3 > 255) {
            throw new InternalError("Unsupported monitor idx > 0xff: " + n3);
        }
        return (n2 & 0xFF) << 8 | n3 & 0xFF;
    }

    private static final int getAdapterIndex(int n2) {
        return n2 >>> 8 & 0xFF;
    }

    private static final int getMonitorIndex(int n2) {
        return n2 & 0xFF;
    }

    @Override
    protected void collectNativeMonitorModesAndDevicesImpl(MonitorModeProps.Cache cache) {
        String string;
        ArrayHashSet<MonitorMode> arrayHashSet = new ArrayHashSet<MonitorMode>(false, 16, 0.75f);
        int n2 = 0;
        while (null != (string = this.getAdapterName(n2))) {
            int n3 = 0;
            while (null != this.getMonitorName(string, n3, true)) {
                MonitorMode monitorMode;
                MonitorMode monitorMode2;
                int n4 = 0;
                do {
                    if (null == (monitorMode2 = this.getMonitorModeImpl(cache, string, n4))) continue;
                    arrayHashSet.getOrAdd(monitorMode2);
                    ++n4;
                } while (null != monitorMode2);
                if (0 < n4 && null != (monitorMode = this.getMonitorModeImpl(cache, string, -1))) {
                    int[] nArray = this.getMonitorDevice0(n2, n3, ScreenDriver.getMonitorId(n2, n3));
                    MonitorModeProps.streamInMonitorDevice(cache, this, monitorMode, null, arrayHashSet, nArray, 0, null);
                    arrayHashSet = new ArrayHashSet(false, 16, 0.75f);
                }
                ++n3;
            }
            ++n2;
        }
    }

    @Override
    protected boolean updateNativeMonitorDeviceViewportImpl(MonitorDevice monitorDevice, float[] fArray, Rectangle rectangle, Rectangle rectangle2) {
        int n2 = monitorDevice.getId();
        int n3 = ScreenDriver.getAdapterIndex(n2);
        int n4 = ScreenDriver.getMonitorIndex(n2);
        String string = this.getAdapterName(n3);
        if (null != string && null != this.getMonitorName(string, n4, true)) {
            int[] nArray = this.getMonitorDevice0(n3, n4, ScreenDriver.getMonitorId(n3, n4));
            int n5 = 6;
            rectangle.set(nArray[n5++], nArray[n5++], nArray[n5++], nArray[n5++]);
            rectangle2.set(nArray[n5++], nArray[n5++], nArray[n5++], nArray[n5++]);
            return true;
        }
        return false;
    }

    @Override
    protected MonitorMode queryCurrentMonitorModeImpl(MonitorDevice monitorDevice) {
        return this.getMonitorModeImpl(null, this.getAdapterName(ScreenDriver.getAdapterIndex(monitorDevice.getId())), -1);
    }

    @Override
    protected boolean setCurrentMonitorModeImpl(MonitorDevice monitorDevice, MonitorMode monitorMode) {
        return this.setMonitorMode0(ScreenDriver.getAdapterIndex(monitorDevice.getId()), -1, -1, monitorMode.getSurfaceSize().getResolution().getWidth(), monitorMode.getSurfaceSize().getResolution().getHeight(), monitorMode.getSurfaceSize().getBitsPerPixel(), (int)monitorMode.getRefreshRate(), monitorMode.getFlags(), monitorMode.getRotation());
    }

    @Override
    protected int validateScreenIndex(int n2) {
        return 0;
    }

    @Override
    protected void calcVirtualScreenOriginAndSize(Rectangle rectangle, Rectangle rectangle2) {
        rectangle.set(this.getVirtualOriginX0(), this.getVirtualOriginY0(), this.getVirtualWidthImpl0(), this.getVirtualHeightImpl0());
        rectangle2.set(rectangle);
    }

    private native int getVirtualOriginX0();

    private native int getVirtualOriginY0();

    private native int getVirtualWidthImpl0();

    private native int getVirtualHeightImpl0();

    private static native void dumpMonitorInfo0();

    private native String getAdapterName0(int var1);

    private native String getMonitorName0(String var1, int var2, boolean var3);

    private native int[] getMonitorMode0(String var1, int var2);

    private native int[] getMonitorDevice0(int var1, int var2, int var3);

    private native boolean setMonitorMode0(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    static {
        DisplayDriver.initSingleton();
        if (Screen.DEBUG) {
            ScreenDriver.dumpMonitorInfo0();
        }
    }
}

