/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.driver.ios;

import com.jogamp.common.util.ArrayHashSet;
import com.jogamp.nativewindow.DefaultGraphicsScreen;
import com.jogamp.nativewindow.util.Rectangle;
import com.jogamp.newt.Display;
import com.jogamp.newt.MonitorDevice;
import com.jogamp.newt.MonitorMode;
import com.jogamp.opengl.math.FloatUtil;
import jogamp.nativewindow.ios.IOSUtil;
import jogamp.newt.MonitorModeProps;
import jogamp.newt.ScreenImpl;
import jogamp.newt.driver.ios.DisplayDriver;

public class ScreenDriver
extends ScreenImpl {
    @Override
    protected void createNativeImpl() {
        this.aScreen = new DefaultGraphicsScreen(this.getDisplay().getGraphicsDevice(), this.screen_idx);
    }

    @Override
    protected void closeNativeImpl() {
    }

    private MonitorMode getMonitorModeImpl(MonitorModeProps.Cache cache, int n2, int n3) {
        int[] nArray = this.getMonitorMode0(n2, n3);
        MonitorMode monitorMode = null == nArray || 0 >= nArray.length ? null : MonitorModeProps.streamInMonitorMode(null, cache, nArray, 0);
        return monitorMode;
    }

    @Override
    protected final void collectNativeMonitorModesAndDevicesImpl(MonitorModeProps.Cache cache) {
        CrtProps crtProps = new CrtProps();
        for (int i2 = 0; i2 < crtProps.count; ++i2) {
            MonitorMode monitorMode;
            int n2 = crtProps.crtIDs[i2];
            ArrayHashSet<MonitorMode> arrayHashSet = new ArrayHashSet<MonitorMode>(false, 16, 0.75f);
            int n3 = 0;
            while (null != (monitorMode = this.getMonitorModeImpl(cache, n2, n3))) {
                if (monitorMode.getSurfaceSize().getBitsPerPixel() >= 24) {
                    arrayHashSet.getOrAdd(monitorMode);
                }
                ++n3;
            }
            if (0 >= n3) {
                throw new InternalError("Could not gather single mode of device " + i2 + "/" + crtProps.count + " -> " + Display.toHexString(n2));
            }
            monitorMode = this.getMonitorModeImpl(cache, n2, -1);
            if (null == monitorMode) {
                throw new InternalError("Could not gather current mode of device " + i2 + "/" + crtProps.count + " -> " + Display.toHexString(n2) + ", but gathered " + n3 + " modes");
            }
            float f2 = crtProps.pixelScaleArray[i2];
            MonitorModeProps.streamInMonitorDevice(cache, this, monitorMode, new float[]{f2, f2}, arrayHashSet, crtProps.propsFixedArray[i2], 0, null);
        }
    }

    @Override
    protected boolean updateNativeMonitorDeviceViewportImpl(MonitorDevice monitorDevice, float[] fArray, Rectangle rectangle, Rectangle rectangle2) {
        float f2;
        CrtProps crtProps = new CrtProps();
        int n2 = monitorDevice.getId();
        if (0 == n2) {
            throw new IllegalArgumentException("Invalid monitor id " + Display.toHexString(n2));
        }
        int n3 = crtProps.getIndex(n2);
        if (0 > n3 || n3 >= crtProps.count) {
            throw new IndexOutOfBoundsException("monitor id " + n3 + " not within [0.." + (crtProps.count - 1) + "]");
        }
        int[] nArray = crtProps.propsFixedArray[n3];
        int n4 = 6;
        rectangle.set(nArray[n4++], nArray[n4++], nArray[n4++], nArray[n4++]);
        rectangle2.set(nArray[n4++], nArray[n4++], nArray[n4++], nArray[n4++]);
        fArray[0] = f2 = crtProps.pixelScaleArray[n3];
        fArray[1] = f2;
        return true;
    }

    @Override
    protected MonitorMode queryCurrentMonitorModeImpl(MonitorDevice monitorDevice) {
        return this.getMonitorModeImpl(null, monitorDevice.getId(), -1);
    }

    @Override
    protected boolean setCurrentMonitorModeImpl(MonitorDevice monitorDevice, MonitorMode monitorMode) {
        return this.setMonitorMode0(monitorDevice.getId(), monitorMode.getId(), monitorMode.getRotation());
    }

    @Override
    protected int validateScreenIndex(int n2) {
        return 0;
    }

    private native int[] getMonitorDeviceIds0();

    private native int[] getMonitorProps0(int var1);

    private native int[] getMonitorMode0(int var1, int var2);

    private native boolean setMonitorMode0(int var1, int var2, int var3);

    static {
        DisplayDriver.initSingleton();
    }

    class CrtProps {
        final int count;
        final int[] crtIDs;
        final float[] pixelScaleArray;
        final int[][] propsOrigArray;
        final int[][] propsFixedArray;

        CrtProps() {
            int n2;
            int n3;
            this.crtIDs = ScreenDriver.this.getMonitorDeviceIds0();
            this.count = this.crtIDs.length;
            this.pixelScaleArray = new float[this.count];
            this.propsOrigArray = new int[this.count][];
            this.propsFixedArray = new int[this.count][];
            for (n3 = 0; n3 < this.count; ++n3) {
                int n4 = this.crtIDs[n3];
                float f2 = IOSUtil.GetScreenPixelScaleByScreenIdx(n4);
                this.pixelScaleArray[n3] = FloatUtil.isZero(f2, 1.1920929E-7f) ? 1.0f : f2;
                this.propsOrigArray[n3] = ScreenDriver.this.getMonitorProps0(n4);
                if (null == this.propsOrigArray[n3]) {
                    throw new InternalError("Could not gather device props " + n3 + "/" + this.count + " -> " + Display.toHexString(n4));
                }
                n2 = this.propsOrigArray[n3].length;
                this.propsFixedArray[n3] = new int[n2];
                System.arraycopy(this.propsOrigArray[n3], 0, this.propsFixedArray[n3], 0, n2);
            }
            block1: for (n3 = 0; n3 < this.count; ++n3) {
                int n5;
                int[] nArray = this.propsFixedArray[n3];
                int n6 = nArray[6];
                n2 = nArray[7];
                float f3 = this.pixelScaleArray[n3];
                nArray[8] = (int)((float)nArray[8] * f3);
                nArray[9] = (int)((float)nArray[9] * f3);
                if (0 != n6) {
                    for (n5 = 0; n5 < this.count; ++n5) {
                        if (n5 == n3 || n6 != this.propsOrigArray[n5][8]) continue;
                        nArray[6] = (int)((float)nArray[6] * this.pixelScaleArray[n5]);
                        break;
                    }
                }
                if (0 == n2) continue;
                for (n5 = 0; n5 < this.count; ++n5) {
                    if (n5 == n3 || n2 != this.propsOrigArray[n5][9]) continue;
                    nArray[7] = (int)((float)nArray[7] * this.pixelScaleArray[n5]);
                    continue block1;
                }
            }
        }

        int getIndex(int n2) {
            for (int i2 = 0; i2 < this.count; ++i2) {
                if (n2 != this.crtIDs[i2]) continue;
                return i2;
            }
            return -1;
        }
    }
}

