/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.x11.awt;

import com.jogamp.nativewindow.AbstractGraphicsConfiguration;
import com.jogamp.nativewindow.AbstractGraphicsScreen;
import com.jogamp.nativewindow.CapabilitiesChooser;
import com.jogamp.nativewindow.CapabilitiesImmutable;
import com.jogamp.nativewindow.GraphicsConfigurationFactory;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.NativeWindowFactory;
import com.jogamp.nativewindow.ToolkitLock;
import com.jogamp.nativewindow.VisualIDHolder;
import com.jogamp.nativewindow.awt.AWTGraphicsConfiguration;
import com.jogamp.nativewindow.awt.AWTGraphicsDevice;
import com.jogamp.nativewindow.awt.AWTGraphicsScreen;
import com.jogamp.nativewindow.x11.X11GraphicsDevice;
import com.jogamp.nativewindow.x11.X11GraphicsScreen;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import jogamp.nativewindow.jawt.x11.X11SunJDKReflection;
import jogamp.nativewindow.x11.X11Lib;
import jogamp.nativewindow.x11.X11Util;

public class X11AWTGraphicsConfigurationFactory
extends GraphicsConfigurationFactory {
    public static void registerFactory() {
        GraphicsConfigurationFactory.registerFactory(AWTGraphicsDevice.class, CapabilitiesImmutable.class, new X11AWTGraphicsConfigurationFactory());
    }

    private X11AWTGraphicsConfigurationFactory() {
    }

    @Override
    protected AbstractGraphicsConfiguration chooseGraphicsConfigurationImpl(CapabilitiesImmutable capabilitiesImmutable, CapabilitiesImmutable capabilitiesImmutable2, CapabilitiesChooser capabilitiesChooser, AbstractGraphicsScreen abstractGraphicsScreen, int n2) {
        if (abstractGraphicsScreen != null && !(abstractGraphicsScreen instanceof AWTGraphicsScreen)) {
            throw new IllegalArgumentException("This GraphicsConfigurationFactory accepts only AWTGraphicsScreen objects");
        }
        if (null == abstractGraphicsScreen) {
            abstractGraphicsScreen = AWTGraphicsScreen.createDefault();
        }
        return X11AWTGraphicsConfigurationFactory.chooseGraphicsConfigurationStatic(capabilitiesImmutable, capabilitiesImmutable2, capabilitiesChooser, (AWTGraphicsScreen)abstractGraphicsScreen, n2);
    }

    public static AWTGraphicsConfiguration chooseGraphicsConfigurationStatic(CapabilitiesImmutable capabilitiesImmutable, CapabilitiesImmutable capabilitiesImmutable2, CapabilitiesChooser capabilitiesChooser, AWTGraphicsScreen aWTGraphicsScreen, int n2) {
        GraphicsConfiguration graphicsConfiguration;
        GraphicsConfigurationFactory graphicsConfigurationFactory;
        AbstractGraphicsConfiguration abstractGraphicsConfiguration;
        Object object;
        boolean bl;
        long l2;
        GraphicsDevice graphicsDevice;
        long l3;
        if (DEBUG) {
            System.err.println("X11AWTGraphicsConfigurationFactory: got " + aWTGraphicsScreen);
        }
        if (0L == (l3 = X11SunJDKReflection.graphicsDeviceGetDisplay(graphicsDevice = ((AWTGraphicsDevice)aWTGraphicsScreen.getDevice()).getGraphicsDevice()))) {
            l2 = X11Util.openDisplay(null);
            bl = true;
            if (DEBUG) {
                System.err.println(X11AWTGraphicsConfigurationFactory.getThreadName() + " - X11AWTGraphicsConfigurationFactory: Null AWT dpy, create local X11 display: " + X11AWTGraphicsConfigurationFactory.toHexString(l2));
            }
        } else {
            object = X11Lib.XDisplayString(l3);
            l2 = X11Util.openDisplay((String)object);
            bl = true;
            if (DEBUG) {
                System.err.println(X11AWTGraphicsConfigurationFactory.getThreadName() + " - X11AWTGraphicsConfigurationFactory: AWT dpy " + (String)object + " / " + X11AWTGraphicsConfigurationFactory.toHexString(l3) + ", create X11 display " + X11AWTGraphicsConfigurationFactory.toHexString(l2));
            }
        }
        object = NativeWindowFactory.getDefaultToolkitLock(".awt");
        X11GraphicsDevice x11GraphicsDevice = new X11GraphicsDevice(l2, 0, (ToolkitLock)object, bl);
        X11GraphicsScreen x11GraphicsScreen = new X11GraphicsScreen(x11GraphicsDevice, aWTGraphicsScreen.getIndex());
        if (DEBUG) {
            System.err.println("X11AWTGraphicsConfigurationFactory: made " + x11GraphicsScreen);
        }
        if ((abstractGraphicsConfiguration = (graphicsConfigurationFactory = GraphicsConfigurationFactory.getFactory(x11GraphicsDevice, capabilitiesImmutable)).chooseGraphicsConfiguration(capabilitiesImmutable, capabilitiesImmutable2, capabilitiesChooser, x11GraphicsScreen, n2)) == null) {
            throw new NativeWindowException("Unable to choose a GraphicsConfiguration (1): " + capabilitiesImmutable + ",\n\t" + capabilitiesChooser + "\n\t" + x11GraphicsScreen);
        }
        if (DEBUG) {
            System.err.println("X11AWTGraphicsConfigurationFactory: chosen config: " + abstractGraphicsConfiguration);
        }
        GraphicsConfiguration[] graphicsConfigurationArray = graphicsDevice.getConfigurations();
        int n3 = abstractGraphicsConfiguration.getVisualID(VisualIDHolder.VIDType.NATIVE);
        if (0 != n3) {
            for (int i2 = 0; i2 < graphicsConfigurationArray.length; ++i2) {
                GraphicsConfiguration graphicsConfiguration2 = graphicsConfigurationArray[i2];
                if (graphicsConfiguration2 == null || X11SunJDKReflection.graphicsConfigurationGetVisualID(graphicsConfiguration2) != n3) continue;
                if (DEBUG) {
                    System.err.println("Found matching AWT visual: 0x" + Integer.toHexString(n3) + " -> " + abstractGraphicsConfiguration);
                }
                return new AWTGraphicsConfiguration(aWTGraphicsScreen, abstractGraphicsConfiguration.getChosenCapabilities(), abstractGraphicsConfiguration.getRequestedCapabilities(), graphicsConfiguration2, abstractGraphicsConfiguration);
            }
        }
        if ((abstractGraphicsConfiguration = graphicsConfigurationFactory.chooseGraphicsConfiguration(capabilitiesImmutable = AWTGraphicsConfiguration.setupCapabilitiesRGBABits(capabilitiesImmutable, graphicsConfiguration = graphicsDevice.getDefaultConfiguration()), capabilitiesImmutable2, capabilitiesChooser, x11GraphicsScreen, n2)) == null) {
            throw new NativeWindowException("Unable to choose a GraphicsConfiguration (2): " + capabilitiesImmutable + ",\n\t" + capabilitiesChooser + "\n\t" + x11GraphicsScreen);
        }
        n3 = abstractGraphicsConfiguration.getVisualID(VisualIDHolder.VIDType.NATIVE);
        if (0 != n3) {
            for (int i3 = 0; i3 < graphicsConfigurationArray.length; ++i3) {
                graphicsConfiguration = graphicsConfigurationArray[i3];
                if (X11SunJDKReflection.graphicsConfigurationGetVisualID(graphicsConfiguration) != n3) continue;
                if (DEBUG) {
                    System.err.println("Found matching default AWT visual: 0x" + Integer.toHexString(n3) + " -> " + abstractGraphicsConfiguration);
                }
                return new AWTGraphicsConfiguration(aWTGraphicsScreen, abstractGraphicsConfiguration.getChosenCapabilities(), abstractGraphicsConfiguration.getRequestedCapabilities(), graphicsConfiguration, abstractGraphicsConfiguration);
            }
        }
        if (DEBUG) {
            System.err.println("Using default configuration");
        }
        graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        return new AWTGraphicsConfiguration(aWTGraphicsScreen, abstractGraphicsConfiguration.getChosenCapabilities(), abstractGraphicsConfiguration.getRequestedCapabilities(), graphicsConfiguration, abstractGraphicsConfiguration);
    }
}

