/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.windows;

import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.ProxySurface;
import com.jogamp.nativewindow.UpstreamSurfaceHookMutableSize;
import jogamp.nativewindow.windows.GDI;
import jogamp.nativewindow.windows.GDISurface;
import jogamp.nativewindow.windows.GDIUtil;

public class GDIDummyUpstreamSurfaceHook
extends UpstreamSurfaceHookMutableSize {
    public GDIDummyUpstreamSurfaceHook(int n2, int n3) {
        super(n2, n3);
    }

    @Override
    public final void create(ProxySurface proxySurface) {
        GDISurface gDISurface = (GDISurface)proxySurface;
        if (0L == gDISurface.getWindowHandle()) {
            long l2 = GDIUtil.CreateDummyWindow(0, 0, 64, 64);
            if (0L == l2) {
                throw new NativeWindowException("Error windowHandle 0, werr: " + GDI.GetLastError());
            }
            gDISurface.setWindowHandle(l2);
            gDISurface.addUpstreamOptionBits(64);
        }
        proxySurface.addUpstreamOptionBits(256);
    }

    @Override
    public final void destroy(ProxySurface proxySurface) {
        GDISurface gDISurface = (GDISurface)proxySurface;
        if (gDISurface.containsUpstreamOptionBits(64)) {
            if (0L == gDISurface.getWindowHandle()) {
                throw new InternalError("Owns upstream surface, but no GDI window: " + gDISurface);
            }
            GDI.ShowWindow(gDISurface.getWindowHandle(), 0);
            GDIUtil.DestroyDummyWindow(gDISurface.getWindowHandle());
            gDISurface.setWindowHandle(0L);
            gDISurface.clearUpstreamOptionBits(64);
        }
    }
}

