/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.windows;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.StructAccessor;
import com.jogamp.common.os.MachineDataInfo;
import java.nio.ByteBuffer;
import jogamp.common.os.MachineDataInfoRuntime;
import jogamp.nativewindow.windows.BITMAPINFOHEADER;
import jogamp.nativewindow.windows.RGBQUAD;

public class BITMAPINFO {
    StructAccessor accessor;
    private static final int mdIdx = MachineDataInfoRuntime.getStatic().ordinal();
    private final MachineDataInfo md;
    private static final int[] BITMAPINFO_size = new int[]{44, 44, 44, 44, 44, 44, 44, 44, 44, 44};
    private static final int[] bmiHeader_offset = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] bmiHeader_size = new int[]{40, 40, 40, 40, 40, 40, 40, 40, 40, 40};
    private static final int[] bmiColors_offset = new int[]{40, 40, 40, 40, 40, 40, 40, 40, 40, 40};
    private static final int[] bmiColors_size = new int[]{4, 4, 4, 4, 4, 4, 4, 4, 4, 4};

    public static int size() {
        return BITMAPINFO_size[mdIdx];
    }

    public static BITMAPINFO create() {
        return BITMAPINFO.create(Buffers.newDirectByteBuffer(BITMAPINFO.size()));
    }

    public static BITMAPINFO create(ByteBuffer byteBuffer) {
        return new BITMAPINFO(byteBuffer);
    }

    BITMAPINFO(ByteBuffer byteBuffer) {
        this.md = MachineDataInfo.StaticConfig.values()[BITMAPINFO.mdIdx].md;
        this.accessor = new StructAccessor(byteBuffer);
    }

    public ByteBuffer getBuffer() {
        return this.accessor.getBuffer();
    }

    public BITMAPINFOHEADER getBmiHeader() {
        return BITMAPINFOHEADER.create(this.accessor.slice(bmiHeader_offset[mdIdx], bmiHeader_size[mdIdx]));
    }

    public BITMAPINFO setBmiColors(RGBQUAD rGBQUAD) {
        int n2 = RGBQUAD.size();
        ByteBuffer byteBuffer = this.getBuffer();
        if (n2 > bmiColors_size[mdIdx]) {
            throw new IndexOutOfBoundsException("elemSize " + n2 + " > size " + bmiColors_size[mdIdx]);
        }
        int n3 = bmiColors_offset[mdIdx];
        int n4 = n3 + n2;
        if (n4 > byteBuffer.limit()) {
            throw new IndexOutOfBoundsException("bLimes " + n4 + " > buffer.limit " + byteBuffer.limit() + ", elemOff " + n3 + ", elemSize " + n2);
        }
        ByteBuffer byteBuffer2 = rGBQUAD.getBuffer();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (n3 >= n4) {
                throw new IndexOutOfBoundsException("elem-byte[0][" + i2 + "]: bOffset " + n3 + " >= bLimes " + n4 + ", elemSize " + n2);
            }
            byteBuffer.put(n3++, byteBuffer2.get(i2));
        }
        return this;
    }

    public RGBQUAD getBmiColors() {
        return RGBQUAD.create(this.accessor.slice(bmiColors_offset[mdIdx], RGBQUAD.size()));
    }
}

