/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.macosx;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.os.NativeLibrary;
import com.jogamp.common.util.Function;
import com.jogamp.common.util.FunctionTask;
import com.jogamp.common.util.InterruptedRuntimeException;
import com.jogamp.common.util.RunnableTask;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.util.Insets;
import com.jogamp.nativewindow.util.Point;
import java.security.AccessController;
import java.security.PrivilegedAction;
import jogamp.nativewindow.Debug;
import jogamp.nativewindow.NWJNILibLoader;
import jogamp.nativewindow.ToolkitProperties;

public class OSXUtil
implements ToolkitProperties {
    private static boolean isInit = false;
    private static final boolean DEBUG = Debug.debug("OSXUtil");
    private static final ThreadLocal<Boolean> tlsIsMainThread = new ThreadLocal();
    public static final int MAX_PIXELSCALE = 2;
    private static Runnable _nop = new Runnable(){

        @Override
        public void run() {
        }
    };

    public static synchronized void initSingleton() {
        if (!isInit) {
            boolean bl = Debug.debug("OSXUtil.MainThreadChecker");
            if (DEBUG || bl) {
                System.out.println("OSXUtil.initSingleton() - useMainThreadChecker " + bl);
            }
            if (!NWJNILibLoader.loadNativeWindow("macosx")) {
                throw new NativeWindowException("NativeWindow MacOSX native library load error.");
            }
            if (bl) {
                NativeLibrary nativeLibrary = AccessController.doPrivileged(new PrivilegedAction<NativeLibrary>(){

                    @Override
                    public NativeLibrary run() {
                        return NativeLibrary.open("/Applications/Xcode.app/Contents/Developer/usr/lib/libMainThreadChecker.dylib", false, false, OSXUtil.class.getClassLoader(), true);
                    }
                });
                if (null == nativeLibrary) {
                    System.err.println("Could not load /Applications/Xcode.app/Contents/Developer/usr/lib/libMainThreadChecker.dylib");
                } else {
                    System.err.println("Loaded " + nativeLibrary);
                }
            }
            if (!OSXUtil.initIDs0()) {
                throw new NativeWindowException("MacOSX: Could not initialized native stub");
            }
            isInit = true;
        }
    }

    public static void shutdown() {
    }

    public static boolean requiresToolkitLock() {
        return false;
    }

    public static final boolean hasThreadingIssues() {
        return false;
    }

    public static boolean isNSView(long l2) {
        return 0L != l2 ? OSXUtil.isNSView0(l2) : false;
    }

    public static boolean isNSWindow(long l2) {
        return 0L != l2 ? OSXUtil.isNSWindow0(l2) : false;
    }

    public static Point GetLocationOnScreen(long l2, int n2, int n3) {
        return (Point)OSXUtil.GetLocationOnScreen0(l2, n2, n3);
    }

    public static Insets GetInsets(long l2) {
        return (Insets)OSXUtil.GetInsets0(l2);
    }

    public static float GetScreenPixelScaleByDisplayID(int n2) {
        if (0 != n2) {
            return OSXUtil.GetScreenPixelScale1(n2);
        }
        return 1.0f;
    }

    public static float GetScreenPixelScale(long l2) {
        if (0L != l2) {
            return OSXUtil.GetScreenPixelScale2(l2);
        }
        return 1.0f;
    }

    public static float GetWindowPixelScale(long l2) {
        if (0L != l2) {
            return OSXUtil.GetWindowPixelScale1(l2);
        }
        return 1.0f;
    }

    public static void SetWindowPixelScale(long l2, float f2) {
        if (0L != l2) {
            OSXUtil.SetWindowPixelScale1(l2, f2);
        }
    }

    public static long CreateNSWindow(final int n2, final int n3, final int n4, final int n5) {
        final long[] lArray = new long[]{0L};
        OSXUtil.RunOnMainThread(true, false, new Runnable(){

            @Override
            public void run() {
                lArray[0] = OSXUtil.CreateNSWindow0(n2, n3, n4, n5);
            }
        });
        return lArray[0];
    }

    public static void DestroyNSWindow(long l2) {
        OSXUtil.DestroyNSWindow0(l2);
    }

    public static long GetNSView(long l2) {
        return OSXUtil.GetNSView0(l2);
    }

    public static long GetNSWindow(long l2) {
        return OSXUtil.GetNSWindow0(l2);
    }

    public static long CreateCALayer(int n2, int n3, float f2) {
        long l2 = OSXUtil.CreateCALayer0(n2, n3, f2);
        if (DEBUG) {
            System.err.println("OSXUtil.CreateCALayer: 0x" + Long.toHexString(l2) + " - " + Thread.currentThread().getName());
        }
        return l2;
    }

    public static void AddCASublayer(long l2, long l3, int n2, int n3, int n4, int n5, float f2, int n6) {
        if (0L == l2 || 0L == l3) {
            throw new IllegalArgumentException("rootCALayer 0x" + Long.toHexString(l2) + ", subCALayer 0x" + Long.toHexString(l3));
        }
        if (DEBUG) {
            System.err.println("OSXUtil.AttachCALayer: caLayerQuirks " + n6 + ", 0x" + Long.toHexString(l3) + " - " + Thread.currentThread().getName());
        }
        OSXUtil.AddCASublayer0(l2, l3, n2, n3, n4, n5, f2, n6);
    }

    public static void FixCALayerLayout(long l2, long l3, boolean bl, int n2, int n3, int n4, int n5, int n6) {
        if (0L == l2 && 0L == l3) {
            return;
        }
        OSXUtil.FixCALayerLayout0(l2, l3, bl, n2, n3, n4, n5, n6);
    }

    public static void SetCALayerPixelScale(long l2, long l3, float f2) {
        if (0L == l2 && 0L == l3) {
            return;
        }
        OSXUtil.SetCALayerPixelScale0(l2, l3, f2);
    }

    public static void RemoveCASublayer(long l2, long l3, boolean bl) {
        if (0L == l2 || 0L == l3) {
            throw new IllegalArgumentException("rootCALayer 0x" + Long.toHexString(l2) + ", subCALayer 0x" + Long.toHexString(l3));
        }
        if (DEBUG) {
            System.err.println("OSXUtil.DetachCALayer: 0x" + Long.toHexString(l3) + " - " + Thread.currentThread().getName());
        }
        OSXUtil.RemoveCASublayer0(l2, l3, bl);
    }

    public static void DestroyCALayer(long l2) {
        if (0L == l2) {
            throw new IllegalArgumentException("caLayer 0x" + Long.toHexString(l2));
        }
        if (DEBUG) {
            System.err.println("OSXUtil.DestroyCALayer: 0x" + Long.toHexString(l2) + " - " + Thread.currentThread().getName());
        }
        OSXUtil.DestroyCALayer0(l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void RunOnMainThread(boolean bl, boolean bl2, Runnable runnable) {
        if (OSXUtil.IsMainThread()) {
            runnable.run();
        } else {
            Object object = new Object();
            RunnableTask runnableTask = new RunnableTask(runnable, bl ? object : null, true, bl ? null : System.err);
            Object object2 = object;
            synchronized (object2) {
                OSXUtil.RunOnMainThread0(bl2, runnableTask);
                if (bl) {
                    while (runnableTask.isInQueue()) {
                        try {
                            object.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            throw new InterruptedRuntimeException(interruptedException);
                        }
                        Throwable throwable = runnableTask.getThrowable();
                        if (null == throwable) continue;
                        throw new RuntimeException(throwable);
                    }
                }
            }
        }
    }

    public static void RunLater(boolean bl, Runnable runnable, int n2) {
        OSXUtil.RunLater0(bl, false, new RunnableTask(runnable, null, true, System.err), n2);
    }

    public static void KickNSApp() {
        OSXUtil.KickNSApp0();
    }

    public static void WaitUntilFinish() {
        OSXUtil.RunOnMainThread(true, true, _nop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R, A> R RunOnMainThread(boolean bl, boolean bl2, Function<R, A> function, A ... AArray) {
        if (OSXUtil.IsMainThread()) {
            return function.eval(AArray);
        }
        Object object = new Object();
        FunctionTask<R, A> functionTask = new FunctionTask<R, A>(function, bl ? object : null, true, bl ? null : System.err);
        Object object2 = object;
        synchronized (object2) {
            functionTask.setArgs(AArray);
            OSXUtil.RunOnMainThread0(bl2, functionTask);
            if (bl) {
                while (functionTask.isInQueue()) {
                    try {
                        object.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        throw new InterruptedRuntimeException(interruptedException);
                    }
                    Throwable throwable = functionTask.getThrowable();
                    if (null == throwable) continue;
                    throw new RuntimeException(throwable);
                }
            }
        }
        return functionTask.getResult();
    }

    public static boolean IsMainThread() {
        Boolean bl = tlsIsMainThread.get();
        if (null == bl) {
            bl = new Boolean(OSXUtil.IsMainThread0());
            tlsIsMainThread.set(bl);
        }
        return bl;
    }

    public static int GetScreenRefreshRate(int n2) {
        return OSXUtil.GetScreenRefreshRate0(n2);
    }

    private static final String getCurrentThreadName() {
        return Thread.currentThread().getName();
    }

    private static final void dumpStack() {
        System.err.println("Stacktrace on thread " + Thread.currentThread().getName());
        ExceptionUtils.dumpStack(System.err);
    }

    private static native boolean initIDs0();

    private static native boolean isNSView0(long var0);

    private static native boolean isNSWindow0(long var0);

    private static native Object GetLocationOnScreen0(long var0, int var2, int var3);

    private static native Object GetInsets0(long var0);

    private static native float GetScreenPixelScale1(int var0);

    private static native float GetScreenPixelScale2(long var0);

    private static native float GetWindowPixelScale1(long var0);

    private static native void SetWindowPixelScale1(long var0, float var2);

    private static native long CreateNSWindow0(int var0, int var1, int var2, int var3);

    private static native void DestroyNSWindow0(long var0);

    private static native long GetNSView0(long var0);

    private static native long GetNSWindow0(long var0);

    private static native long CreateCALayer0(int var0, int var1, float var2);

    private static native void AddCASublayer0(long var0, long var2, int var4, int var5, int var6, int var7, float var8, int var9);

    private static native void FixCALayerLayout0(long var0, long var2, boolean var4, int var5, int var6, int var7, int var8, int var9);

    private static native void SetCALayerPixelScale0(long var0, long var2, float var4);

    private static native void RemoveCASublayer0(long var0, long var2, boolean var4);

    private static native void DestroyCALayer0(long var0);

    private static native void RunOnMainThread0(boolean var0, Runnable var1);

    private static native void RunLater0(boolean var0, boolean var1, Runnable var2, int var3);

    private static native void KickNSApp0();

    private static native boolean IsMainThread0();

    private static native int GetScreenRefreshRate0(int var0);
}

