/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.jawt.windows;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.util.UnsafeUtil;
import com.jogamp.nativewindow.AbstractGraphicsConfiguration;
import com.jogamp.nativewindow.awt.AWTGraphicsConfiguration;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import jogamp.nativewindow.jawt.JAWTUtil;

public class Win32SunJDKReflection {
    private static Class<?> win32GraphicsDeviceClass;
    private static Class<?> win32GraphicsConfigClass;
    private static Method win32GraphicsConfigGetConfigMethod;
    private static Method win32GraphicsConfigGetVisualMethod;
    private static boolean initialized;

    public static GraphicsConfiguration graphicsConfigurationGet(GraphicsDevice graphicsDevice, int n2) {
        if (!initialized) {
            return null;
        }
        try {
            return (GraphicsConfiguration)win32GraphicsConfigGetConfigMethod.invoke(null, graphicsDevice, n2);
        }
        catch (Exception exception) {
            if (JAWTUtil.DEBUG) {
                ExceptionUtils.dumpThrowable("Win32SunJDKReflection", exception);
            }
            return null;
        }
    }

    public static int graphicsConfigurationGetPixelFormatID(AbstractGraphicsConfiguration abstractGraphicsConfiguration) {
        try {
            if (abstractGraphicsConfiguration instanceof AWTGraphicsConfiguration) {
                return Win32SunJDKReflection.graphicsConfigurationGetPixelFormatID(((AWTGraphicsConfiguration)abstractGraphicsConfiguration).getAWTGraphicsConfiguration());
            }
            return 0;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static int graphicsConfigurationGetPixelFormatID(GraphicsConfiguration graphicsConfiguration) {
        if (!initialized) {
            return 0;
        }
        try {
            return (Integer)win32GraphicsConfigGetVisualMethod.invoke((Object)graphicsConfiguration, new Object[0]);
        }
        catch (Exception exception) {
            if (JAWTUtil.DEBUG) {
                ExceptionUtils.dumpThrowable("Win32SunJDKReflection", exception);
            }
            return 0;
        }
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return UnsafeUtil.doWithoutIllegalAccessLogger(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        block2: {
                            try {
                                win32GraphicsDeviceClass = Class.forName("sun.awt.Win32GraphicsDevice");
                                win32GraphicsConfigClass = Class.forName("sun.awt.Win32GraphicsConfig");
                                win32GraphicsConfigGetConfigMethod = win32GraphicsConfigClass.getDeclaredMethod("getConfig", win32GraphicsDeviceClass, Integer.TYPE);
                                win32GraphicsConfigGetConfigMethod.setAccessible(true);
                                win32GraphicsConfigGetVisualMethod = win32GraphicsConfigClass.getDeclaredMethod("getVisual", new Class[0]);
                                win32GraphicsConfigGetVisualMethod.setAccessible(true);
                                initialized = true;
                            }
                            catch (Exception exception) {
                                if (!JAWTUtil.DEBUG) break block2;
                                ExceptionUtils.dumpThrowable("Win32SunJDKReflection", exception);
                            }
                        }
                        return null;
                    }
                });
            }
        });
    }
}

