/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.ios;

import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.ProxySurface;
import com.jogamp.nativewindow.UpstreamSurfaceHookMutableSize;
import jogamp.nativewindow.ios.IOSUtil;

public class IOSDummyUpstreamSurfaceHook
extends UpstreamSurfaceHookMutableSize {
    long uiWindow = 0L;

    public IOSDummyUpstreamSurfaceHook(int n2, int n3) {
        super(n2, n3);
    }

    @Override
    public final void create(ProxySurface proxySurface) {
        if (0L == this.uiWindow && 0L == proxySurface.getSurfaceHandle()) {
            this.uiWindow = IOSUtil.CreateUIWindow(0, 0, 64, 64, false);
            if (0L == this.uiWindow) {
                throw new NativeWindowException("Error UI window 0");
            }
            long l2 = IOSUtil.GetUIView(this.uiWindow, true);
            if (0L == l2) {
                throw new NativeWindowException("Error UI view 0");
            }
            proxySurface.setSurfaceHandle(l2);
            proxySurface.addUpstreamOptionBits(64);
        }
        proxySurface.addUpstreamOptionBits(256);
    }

    @Override
    public final void destroy(ProxySurface proxySurface) {
        if (proxySurface.containsUpstreamOptionBits(64)) {
            if (0L == this.uiWindow || 0L == proxySurface.getSurfaceHandle()) {
                throw new InternalError("Owns upstream surface, but no IOS view/window: " + proxySurface + ", uiWindow 0x" + Long.toHexString(this.uiWindow));
            }
            IOSUtil.DestroyUIWindow(this.uiWindow);
            this.uiWindow = 0L;
            proxySurface.setSurfaceHandle(0L);
            proxySurface.clearUpstreamOptionBits(64);
        }
    }
}

