/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.drm;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.NativeWindowFactory;
import java.io.File;
import jogamp.nativewindow.Debug;
import jogamp.nativewindow.NWJNILibLoader;
import jogamp.nativewindow.ToolkitProperties;
import jogamp.nativewindow.drm.DRMLib;
import jogamp.nativewindow.drm.DrmMode;
import jogamp.nativewindow.drm.drmModeRes;

public class DRMUtil
implements ToolkitProperties {
    static final boolean DEBUG = Debug.debug("DRMUtil");
    private static final String driXLinux = "/dev/dri/card";
    private static volatile boolean isInit = false;
    private static int drmFd = -1;
    public static final int GBM_FORMAT_XRGB8888 = DRMUtil.fourcc_code('X', 'R', '2', '4');
    public static final int GBM_FORMAT_ARGB8888 = DRMUtil.fourcc_code('A', 'R', '2', '4');

    private static int openDrmDevice(String[] stringArray) {
        for (int i2 = 0; i2 < 100; ++i2) {
            String string;
            stringArray[0] = string = driXLinux + i2;
            File file = new File(string);
            if (!file.exists()) {
                if (DEBUG) {
                    System.err.println("DRMUtil.initSingleton(): drmDevice[" + string + "]: not existing");
                }
                return -1;
            }
            int n2 = DRMLib.drmOpenFile(string);
            if (0 > n2) continue;
            drmModeRes drmModeRes2 = DRMLib.drmModeGetResources(n2);
            if (DEBUG) {
                System.err.println("DRMUtil.initSingleton(): drmDevice[" + string + "]: fd " + n2 + ": has resources: " + (null != drmModeRes2));
            }
            if (null == drmModeRes2) {
                DRMLib.drmClose(n2);
                continue;
            }
            DRMLib.drmModeFreeResources(drmModeRes2);
            return n2;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void initSingleton() {
        if (isInit) return;
        Class<DRMUtil> clazz = DRMUtil.class;
        synchronized (DRMUtil.class) {
            if (isInit) return;
            isInit = true;
            if (DEBUG) {
                System.out.println("DRMUtil.initSingleton()");
            }
            if (!NWJNILibLoader.loadNativeWindow("drm")) {
                throw new NativeWindowException("NativeWindow DRM native library load error.");
            }
            String[] stringArray = new String[]{null};
            if (DRMUtil.initialize0(DEBUG)) {
                drmFd = DRMUtil.openDrmDevice(stringArray);
            }
            if (DEBUG) {
                System.err.println("DRMUtil.initSingleton(): OK " + (0 <= drmFd) + ", drmFd " + drmFd + "]");
                if (0 <= drmFd) {
                    DrmMode drmMode = DrmMode.create(drmFd, true);
                    drmMode.print(System.err);
                    drmMode.destroy();
                }
            }
            if (0 <= drmFd) return;
            throw new NativeWindowException("drmOpenFile(" + stringArray[0] + ") failed");
        }
    }

    public static int getDrmFd() {
        return drmFd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void shutdown() {
        if (!isInit) return;
        Class<DRMUtil> clazz = DRMUtil.class;
        synchronized (DRMUtil.class) {
            if (!isInit) return;
            boolean bl = NativeWindowFactory.isJVMShuttingDown();
            if (DEBUG) {
                System.err.println("DRMUtil.Display: Shutdown (JVM shutdown: " + bl + ")");
                if (DEBUG) {
                    ExceptionUtils.dumpStack(System.err);
                }
            }
            if (!bl) return;
            if (0 <= drmFd) {
                DRMLib.drmClose(drmFd);
                drmFd = -1;
            }
            isInit = false;
            DRMUtil.shutdown0();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static final boolean requiresToolkitLock() {
        return true;
    }

    public static final boolean hasThreadingIssues() {
        return false;
    }

    static int fourcc_code(char c2, char c3, char c4, char c5) {
        return c2 | c3 << 8 | c4 << 16 | c5 << 24;
    }

    private DRMUtil() {
    }

    private static final String getCurrentThreadName() {
        return Thread.currentThread().getName();
    }

    private static final void dumpStack() {
        ExceptionUtils.dumpStack(System.err);
    }

    private static native boolean initialize0(boolean var0);

    private static native void shutdown0();
}

