/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow;

public class SurfaceScaleUtils {
    private static final float EPSILON = 1.1920929E-7f;

    private static boolean isZero(float f2) {
        return Math.abs(f2) < 1.1920929E-7f;
    }

    public static int scale(int n2, float f2) {
        return (int)((float)n2 * f2 + 0.5f);
    }

    public static int scaleInv(int n2, float f2) {
        return (int)((float)n2 / f2 + 0.5f);
    }

    public static int[] scale(int[] nArray, int[] nArray2, float[] fArray) {
        nArray[0] = (int)((float)nArray2[0] * fArray[0] + 0.5f);
        nArray[1] = (int)((float)nArray2[1] * fArray[1] + 0.5f);
        return nArray;
    }

    public static int[] scaleInv(int[] nArray, int[] nArray2, float[] fArray) {
        nArray[0] = (int)((float)nArray2[0] / fArray[0] + 0.5f);
        nArray[1] = (int)((float)nArray2[1] / fArray[1] + 0.5f);
        return nArray;
    }

    public static float clampPixelScale(float f2, float f3, float f4) {
        if (SurfaceScaleUtils.isZero(f2 - 1.0f)) {
            return 1.0f;
        }
        if (SurfaceScaleUtils.isZero(f2 - 0.0f) || f2 > f4 || SurfaceScaleUtils.isZero(f2 - f4)) {
            return f4;
        }
        if (f2 < f3 || SurfaceScaleUtils.isZero(f2 - f3)) {
            return f3;
        }
        return f2;
    }

    public static float[] clampPixelScale(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4) {
        fArray[0] = SurfaceScaleUtils.clampPixelScale(fArray2[0], fArray3[0], fArray4[0]);
        fArray[1] = SurfaceScaleUtils.clampPixelScale(fArray2[1], fArray3[1], fArray4[1]);
        return fArray;
    }

    public static boolean setNewPixelScale(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, float[] fArray5, String string) {
        boolean bl;
        float f2 = SurfaceScaleUtils.clampPixelScale(fArray3[0], fArray4[0], fArray5[0]);
        float f3 = SurfaceScaleUtils.clampPixelScale(fArray3[1], fArray4[1], fArray5[1]);
        boolean bl2 = bl = f2 != fArray2[0] || f3 != fArray2[1];
        if (null != string) {
            System.err.println(string + ".setNewPixelScale: pre[" + fArray2[0] + ", " + fArray2[1] + "], req[" + fArray3[0] + ", " + fArray3[1] + "], min[" + fArray4[0] + ", " + fArray4[1] + "], max[" + fArray5[0] + ", " + fArray5[1] + "] -> result[" + f2 + ", " + f3 + "], changed " + bl);
        }
        fArray[0] = f2;
        fArray[1] = f3;
        return bl;
    }
}

