/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.tt.engine;

import jogamp.graph.font.typecast.ot.Mnemonic;

public class Parser {
    private final short[][] instructions = new short[3][];

    public int advanceIP(int n2) {
        int n3 = n2 >> 16;
        int n4 = n2 & 0xFFFF;
        ++n2;
        if (64 == this.instructions[n3][n4]) {
            short s2 = this.instructions[n3][++n4];
            n2 += s2 + 1;
        } else if (65 == this.instructions[n3][n4]) {
            short s3 = this.instructions[n3][++n4];
            n2 += s3 * 2 + 1;
        } else if (176 == (this.instructions[n3][n4] & 0xF8)) {
            short s4 = (short)((this.instructions[n3][n4] & 7) + 1);
            n2 += s4;
        } else if (184 == (this.instructions[n3][n4] & 0xF8)) {
            short s5 = (short)((this.instructions[n3][n4] & 7) + 1);
            n2 += s5 * 2;
        }
        return n2;
    }

    public int getISLength(int n2) {
        return this.instructions[n2].length;
    }

    public short getOpcode(int n2) {
        return this.instructions[n2 >> 16][n2 & 0xFFFF];
    }

    public short getPushCount(int n2) {
        short s2 = this.instructions[n2 >> 16][n2 & 0xFFFF];
        if (64 == s2 || 65 == s2) {
            return this.instructions[n2 >> 16][(n2 & 0xFFFF) + 1];
        }
        if (176 == (s2 & 0xF8) || 184 == (s2 & 0xF8)) {
            return (short)((s2 & 7) + 1);
        }
        return 0;
    }

    public int[] getPushData(int n2) {
        int[] nArray;
        block5: {
            short s2;
            int n3;
            int n4;
            int n5;
            block7: {
                block6: {
                    block4: {
                        n5 = this.getPushCount(n2);
                        nArray = new int[n5];
                        n4 = n2 >> 16;
                        n3 = n2 & 0xFFFF;
                        s2 = this.instructions[n4][n3];
                        if (64 != s2) break block4;
                        for (int i2 = 0; i2 < n5; ++i2) {
                            nArray[i2] = this.instructions[n4][n3 + i2 + 2];
                        }
                        break block5;
                    }
                    if (176 != (s2 & 0xF8)) break block6;
                    for (int i3 = 0; i3 < n5; ++i3) {
                        nArray[i3] = this.instructions[n4][n3 + i3 + 1];
                    }
                    break block5;
                }
                if (65 != s2) break block7;
                for (int i4 = 0; i4 < n5; ++i4) {
                    nArray[i4] = this.instructions[n4][n3 + i4 * 2 + 2] << 8 | this.instructions[n4][n3 + i4 * 2 + 3];
                }
                break block5;
            }
            if (184 != (s2 & 0xF8)) break block5;
            for (int i5 = 0; i5 < n5; ++i5) {
                nArray[i5] = this.instructions[n4][n3 + i5 * 2 + 1] << 8 | this.instructions[n4][n3 + i5 * 2 + 2];
            }
        }
        return nArray;
    }

    public int handleElse(int n2) {
        while (this.instructions[n2 >> 16][n2 & 0xFFFF] != 89) {
            n2 = this.advanceIP(n2);
        }
        return n2;
    }

    public int handleIf(boolean bl, int n2) {
        if (!bl) {
            while (this.instructions[n2 >> 16][n2 & 0xFFFF] != 27 && this.instructions[n2 >> 16][n2 & 0xFFFF] != 89) {
                n2 = this.advanceIP(n2);
            }
        }
        return n2;
    }

    public void setCvtProgram(short[] sArray) {
        this.instructions[1] = sArray;
    }

    public void setFontProgram(short[] sArray) {
        this.instructions[0] = sArray;
    }

    public void setGlyphProgram(short[] sArray) {
        this.instructions[2] = sArray;
    }

    public String toString() {
        int n2;
        int[] nArray;
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 0;
        while (n3 < this.instructions[0].length) {
            stringBuilder.append(Mnemonic.getMnemonic(this.getOpcode(n3)));
            if (this.getPushCount(n3) > 0) {
                nArray = this.getPushData(n3);
                for (n2 = 0; n2 < nArray.length; ++n2) {
                    stringBuilder.append(" ").append(nArray[n2]);
                }
            }
            stringBuilder.append("\n");
            n3 = this.advanceIP(n3);
        }
        stringBuilder.append("\n");
        n3 = 65536;
        while (n3 < (0x10000 | this.instructions[1].length)) {
            stringBuilder.append(Mnemonic.getMnemonic(this.getOpcode(n3)));
            if (this.getPushCount(n3) > 0) {
                nArray = this.getPushData(n3);
                for (n2 = 0; n2 < nArray.length; ++n2) {
                    stringBuilder.append(" ").append(nArray[n2]);
                }
            }
            stringBuilder.append("\n");
            n3 = this.advanceIP(n3);
        }
        stringBuilder.append("\n");
        n3 = 131072;
        while (n3 < (0x20000 | this.instructions[2].length)) {
            stringBuilder.append(Mnemonic.getMnemonic(this.getOpcode(n3)));
            if (this.getPushCount(n3) > 0) {
                nArray = this.getPushData(n3);
                for (n2 = 0; n2 < nArray.length; ++n2) {
                    stringBuilder.append(" ").append(nArray[n2]);
                }
            }
            stringBuilder.append("\n");
            n3 = this.advanceIP(n3);
        }
        return stringBuilder.toString();
    }
}

