/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInput;
import java.io.IOException;
import jogamp.graph.font.typecast.ot.table.DirectoryEntry;
import jogamp.graph.font.typecast.ot.table.MaxpTable;
import jogamp.graph.font.typecast.ot.table.Table;
import jogamp.graph.font.typecast.ot.table.VheaTable;

public class VmtxTable
implements Table {
    private final DirectoryEntry _de;
    private int[] _vMetrics = null;
    private short[] _topSideBearing = null;

    protected VmtxTable(DirectoryEntry directoryEntry, DataInput dataInput, VheaTable vheaTable, MaxpTable maxpTable) throws IOException {
        int n2;
        this._de = (DirectoryEntry)directoryEntry.clone();
        this._vMetrics = new int[vheaTable.getNumberOfLongVerMetrics()];
        for (n2 = 0; n2 < vheaTable.getNumberOfLongVerMetrics(); ++n2) {
            this._vMetrics[n2] = dataInput.readUnsignedByte() << 24 | dataInput.readUnsignedByte() << 16 | dataInput.readUnsignedByte() << 8 | dataInput.readUnsignedByte();
        }
        n2 = maxpTable.getNumGlyphs() - vheaTable.getNumberOfLongVerMetrics();
        this._topSideBearing = new short[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this._topSideBearing[i2] = dataInput.readShort();
        }
    }

    public int getAdvanceHeight(int n2) {
        if (this._vMetrics == null) {
            return 0;
        }
        if (n2 < this._vMetrics.length) {
            return this._vMetrics[n2] >> 16;
        }
        return this._vMetrics[this._vMetrics.length - 1] >> 16;
    }

    public short getTopSideBearing(int n2) {
        if (this._vMetrics == null) {
            return 0;
        }
        if (n2 < this._vMetrics.length) {
            return (short)(this._vMetrics[n2] & 0xFFFF);
        }
        return this._topSideBearing[n2 - this._vMetrics.length];
    }

    @Override
    public int getType() {
        return 1986884728;
    }

    public String toString() {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("'vmtx' Table - Vertical Metrics\n-------------------------------\n");
        stringBuilder.append("Size = ").append(this._de.getLength()).append(" bytes, ").append(this._vMetrics.length).append(" entries\n");
        for (n2 = 0; n2 < this._vMetrics.length; ++n2) {
            stringBuilder.append("        ").append(n2).append(". advHeight: ").append(this.getAdvanceHeight(n2)).append(", TSdBear: ").append(this.getTopSideBearing(n2)).append("\n");
        }
        for (n2 = 0; n2 < this._topSideBearing.length; ++n2) {
            stringBuilder.append("        TSdBear ").append(n2 + this._vMetrics.length).append(": ").append(this._topSideBearing[n2]).append("\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public DirectoryEntry getDirectoryEntry() {
        return this._de;
    }
}

