/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInput;
import java.io.IOException;

public class TTCHeader {
    public static final int ttcf = 1953784678;
    private final int ttcTag;
    private final int version;
    private final int directoryCount;
    private final int[] tableDirectory;
    private int dsigTag;
    private final int dsigLength;
    private final int dsigOffset;

    public TTCHeader(DataInput dataInput) throws IOException {
        this.ttcTag = dataInput.readInt();
        this.version = dataInput.readInt();
        this.directoryCount = dataInput.readInt();
        this.tableDirectory = new int[this.directoryCount];
        for (int i2 = 0; i2 < this.directoryCount; ++i2) {
            this.tableDirectory[i2] = dataInput.readInt();
        }
        if (this.version == 65536) {
            this.dsigTag = dataInput.readInt();
        }
        this.dsigLength = dataInput.readInt();
        this.dsigOffset = dataInput.readInt();
    }

    public int getDirectoryCount() {
        return this.directoryCount;
    }

    public int getTableDirectory(int n2) {
        return this.tableDirectory[n2];
    }

    public static boolean isTTC(DataInput dataInput) throws IOException {
        int n2 = dataInput.readInt();
        return n2 == 1953784678;
    }
}

