/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInputStream;
import java.io.IOException;
import jogamp.graph.font.typecast.ot.table.Script;
import jogamp.graph.font.typecast.ot.table.ScriptRecord;

public class ScriptList {
    private int _scriptCount = 0;
    private final ScriptRecord[] _scriptRecords;
    private final Script[] _scripts;

    protected ScriptList(DataInputStream dataInputStream, int n2) throws IOException {
        int n3;
        dataInputStream.reset();
        dataInputStream.skipBytes(n2);
        this._scriptCount = dataInputStream.readUnsignedShort();
        this._scriptRecords = new ScriptRecord[this._scriptCount];
        this._scripts = new Script[this._scriptCount];
        for (n3 = 0; n3 < this._scriptCount; ++n3) {
            this._scriptRecords[n3] = new ScriptRecord(dataInputStream);
        }
        for (n3 = 0; n3 < this._scriptCount; ++n3) {
            this._scripts[n3] = new Script(dataInputStream, n2 + this._scriptRecords[n3].getOffset());
        }
    }

    public int getScriptCount() {
        return this._scriptCount;
    }

    public ScriptRecord getScriptRecord(int n2) {
        return this._scriptRecords[n2];
    }

    public Script getScript(int n2) {
        return this._scripts[n2];
    }

    public Script findScript(String string) {
        if (string.length() != 4) {
            return null;
        }
        int n2 = string.charAt(0) << 24 | string.charAt(1) << 16 | string.charAt(2) << 8 | string.charAt(3);
        for (int i2 = 0; i2 < this._scriptCount; ++i2) {
            if (this._scriptRecords[i2].getTag() != n2) continue;
            return this._scripts[i2];
        }
        return null;
    }
}

