/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import jogamp.graph.font.typecast.ot.table.DirectoryEntry;
import jogamp.graph.font.typecast.ot.table.NameRecord;
import jogamp.graph.font.typecast.ot.table.Table;

public class NameTable
implements Table {
    private final DirectoryEntry _de;
    private final short _formatSelector;
    private final short _numberOfNameRecords;
    private final short _stringStorageOffset;
    private final NameRecord[] _records;

    protected NameTable(DirectoryEntry directoryEntry, DataInput dataInput) throws IOException {
        this._de = (DirectoryEntry)directoryEntry.clone();
        this._formatSelector = dataInput.readShort();
        this._numberOfNameRecords = dataInput.readShort();
        this._stringStorageOffset = dataInput.readShort();
        this._records = new NameRecord[this._numberOfNameRecords];
        for (int i2 = 0; i2 < this._numberOfNameRecords; ++i2) {
            this._records[i2] = new NameRecord(dataInput);
        }
        byte[] byArray = new byte[this._de.getLength() - this._stringStorageOffset];
        dataInput.readFully(byArray);
        for (int i3 = 0; i3 < this._numberOfNameRecords; ++i3) {
            this._records[i3].loadString(new DataInputStream(new ByteArrayInputStream(byArray)));
        }
    }

    public short getNumberOfNameRecords() {
        return this._numberOfNameRecords;
    }

    public NameRecord getRecord(int n2) {
        if (this._numberOfNameRecords > n2) {
            return this._records[n2];
        }
        return null;
    }

    public StringBuilder getRecordsRecordString(StringBuilder stringBuilder, int n2) {
        if (this._numberOfNameRecords > n2) {
            this._records[n2].getRecordString(stringBuilder);
        } else {
            stringBuilder.append("n/a");
        }
        return stringBuilder;
    }

    public StringBuilder getNamedRecordString(StringBuilder stringBuilder, short s2) {
        boolean bl = false;
        for (int i2 = 0; !bl && i2 < this._numberOfNameRecords; ++i2) {
            if (this._records[i2].getNameId() != s2) continue;
            this._records[i2].getRecordString(stringBuilder);
            bl = true;
        }
        if (!bl) {
            stringBuilder.append("n/a");
        }
        return stringBuilder;
    }

    @Override
    public int getType() {
        return 1851878757;
    }

    @Override
    public DirectoryEntry getDirectoryEntry() {
        return this._de;
    }
}

