/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInput;
import java.io.IOException;
import jogamp.graph.font.typecast.ot.table.DirectoryEntry;
import jogamp.graph.font.typecast.ot.table.MaxpTable;
import jogamp.graph.font.typecast.ot.table.Table;

public class HdmxTable
implements Table {
    private final DirectoryEntry _de;
    private final int _version;
    private final short _numRecords;
    private final int _sizeDeviceRecords;
    private final DeviceRecord[] _records;

    protected HdmxTable(DirectoryEntry directoryEntry, DataInput dataInput, MaxpTable maxpTable) throws IOException {
        this._de = (DirectoryEntry)directoryEntry.clone();
        this._version = dataInput.readUnsignedShort();
        this._numRecords = dataInput.readShort();
        this._sizeDeviceRecords = dataInput.readInt();
        this._records = new DeviceRecord[this._numRecords];
        for (int i2 = 0; i2 < this._numRecords; ++i2) {
            this._records[i2] = new DeviceRecord(maxpTable.getNumGlyphs(), dataInput);
        }
    }

    public int getNumberOfRecords() {
        return this._numRecords;
    }

    public DeviceRecord getRecord(int n2) {
        return this._records[n2];
    }

    @Override
    public int getType() {
        return 1751412088;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("'hdmx' Table - Horizontal Device Metrics\n----------------------------------------\n");
        stringBuilder.append("Size = ").append(this._de.getLength()).append(" bytes\n").append("\t'hdmx' version:         ").append(this._version).append("\n").append("\t# device records:       ").append(this._numRecords).append("\n").append("\tRecord length:          ").append(this._sizeDeviceRecords).append("\n");
        for (int i2 = 0; i2 < this._numRecords; ++i2) {
            stringBuilder.append("\tDevRec ").append(i2).append(": ppem = ").append(this._records[i2].getPixelSize()).append(", maxWid = ").append(this._records[i2].getMaxWidth()).append("\n");
            for (int i3 = 0; i3 < this._records[i2].getWidths().length; ++i3) {
                stringBuilder.append("    ").append(i3).append(".   ").append(this._records[i2].getWidths()[i3]).append("\n");
            }
            stringBuilder.append("\n\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public DirectoryEntry getDirectoryEntry() {
        return this._de;
    }

    public static class DeviceRecord {
        private final short _pixelSize;
        private final short _maxWidth;
        private final short[] _widths;

        protected DeviceRecord(int n2, DataInput dataInput) throws IOException {
            this._pixelSize = dataInput.readByte();
            this._maxWidth = dataInput.readByte();
            this._widths = new short[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                this._widths[i2] = dataInput.readByte();
            }
        }

        public short getPixelSize() {
            return this._pixelSize;
        }

        public short getMaxWidth() {
            return this._maxWidth;
        }

        public short[] getWidths() {
            return this._widths;
        }

        public short getWidth(int n2) {
            return this._widths[n2];
        }
    }
}

