/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import jogamp.graph.font.typecast.ot.table.DirectoryEntry;
import jogamp.graph.font.typecast.ot.table.GlyfCompositeDescript;
import jogamp.graph.font.typecast.ot.table.GlyfDescript;
import jogamp.graph.font.typecast.ot.table.GlyfSimpleDescript;
import jogamp.graph.font.typecast.ot.table.LocaTable;
import jogamp.graph.font.typecast.ot.table.MaxpTable;
import jogamp.graph.font.typecast.ot.table.Table;

public class GlyfTable
implements Table {
    private final DirectoryEntry _de;
    private final GlyfDescript[] _descript;

    protected GlyfTable(DirectoryEntry directoryEntry, DataInput dataInput, MaxpTable maxpTable, LocaTable locaTable) throws IOException {
        short s2;
        DataInputStream dataInputStream;
        int n2;
        int n3;
        this._de = (DirectoryEntry)directoryEntry.clone();
        this._descript = new GlyfDescript[maxpTable.getNumGlyphs()];
        byte[] byArray = new byte[directoryEntry.getLength()];
        dataInput.readFully(byArray);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        for (n3 = 0; n3 < maxpTable.getNumGlyphs(); ++n3) {
            n2 = locaTable.getOffset(n3 + 1) - locaTable.getOffset(n3);
            if (n2 > 0) {
                byteArrayInputStream.reset();
                byteArrayInputStream.skip(locaTable.getOffset(n3));
                dataInputStream = new DataInputStream(byteArrayInputStream);
                s2 = dataInputStream.readShort();
                if (s2 < 0) continue;
                this._descript[n3] = new GlyfSimpleDescript(this, n3, s2, dataInputStream);
                continue;
            }
            this._descript[n3] = null;
        }
        for (n3 = 0; n3 < maxpTable.getNumGlyphs(); ++n3) {
            n2 = locaTable.getOffset(n3 + 1) - locaTable.getOffset(n3);
            if (n2 <= 0) continue;
            byteArrayInputStream.reset();
            byteArrayInputStream.skip(locaTable.getOffset(n3));
            dataInputStream = new DataInputStream(byteArrayInputStream);
            s2 = dataInputStream.readShort();
            if (s2 >= 0) continue;
            this._descript[n3] = new GlyfCompositeDescript(this, n3, dataInputStream);
        }
    }

    public GlyfDescript getDescription(int n2) {
        if (n2 < this._descript.length) {
            return this._descript[n2];
        }
        return null;
    }

    @Override
    public int getType() {
        return 1735162214;
    }

    @Override
    public DirectoryEntry getDirectoryEntry() {
        return this._de;
    }
}

