/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInput;
import java.io.IOException;
import java.util.Arrays;
import jogamp.graph.font.typecast.ot.table.CmapFormat;
import jogamp.graph.font.typecast.ot.table.CmapIndexEntry;
import jogamp.graph.font.typecast.ot.table.DirectoryEntry;
import jogamp.graph.font.typecast.ot.table.Table;

public class CmapTable
implements Table {
    private final DirectoryEntry _de;
    private final int _version;
    private final int _numTables;
    private final CmapIndexEntry[] _entries;

    protected CmapTable(DirectoryEntry directoryEntry, DataInput dataInput) throws IOException {
        int n2;
        this._de = (DirectoryEntry)directoryEntry.clone();
        this._version = dataInput.readUnsignedShort();
        this._numTables = dataInput.readUnsignedShort();
        long l2 = 4L;
        this._entries = new CmapIndexEntry[this._numTables];
        for (n2 = 0; n2 < this._numTables; ++n2) {
            this._entries[n2] = new CmapIndexEntry(dataInput);
            l2 += 8L;
        }
        Arrays.sort(this._entries);
        n2 = 0;
        CmapFormat cmapFormat = null;
        for (int i2 = 0; i2 < this._numTables; ++i2) {
            if (this._entries[i2].getOffset() == n2) {
                this._entries[i2].setFormat(cmapFormat);
                continue;
            }
            if ((long)this._entries[i2].getOffset() > l2) {
                dataInput.skipBytes(this._entries[i2].getOffset() - (int)l2);
            } else if ((long)this._entries[i2].getOffset() != l2) {
                throw new IOException();
            }
            int n3 = dataInput.readUnsignedShort();
            cmapFormat = CmapFormat.create(n3, dataInput);
            n2 = this._entries[i2].getOffset();
            this._entries[i2].setFormat(cmapFormat);
            l2 += (long)cmapFormat.getLength();
        }
    }

    public int getVersion() {
        return this._version;
    }

    public int getNumTables() {
        return this._numTables;
    }

    public CmapIndexEntry getCmapIndexEntry(int n2) {
        return this._entries[n2];
    }

    public CmapFormat getCmapFormat(short s2, short s3) {
        for (int i2 = 0; i2 < this._numTables; ++i2) {
            if (this._entries[i2].getPlatformId() != s2 || this._entries[i2].getEncodingId() != s3) continue;
            return this._entries[i2].getFormat();
        }
        return null;
    }

    @Override
    public int getType() {
        return 1668112752;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("cmap\n");
        for (int i2 = 0; i2 < this._numTables; ++i2) {
            stringBuilder.append("\t").append(this._entries[i2].toString()).append("\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public DirectoryEntry getDirectoryEntry() {
        return this._de;
    }
}

