/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInput;
import java.io.IOException;
import jogamp.graph.font.typecast.ot.table.CmapFormat;

public class CmapFormat2
extends CmapFormat {
    private final int[] _subHeaderKeys = new int[256];
    private final SubHeader[] _subHeaders;
    private final int[] _glyphIndexArray;

    protected CmapFormat2(DataInput dataInput) throws IOException {
        super(dataInput);
        int n2;
        int n3;
        this._format = 2;
        int n4 = 6;
        int n5 = 0;
        for (n3 = 0; n3 < 256; ++n3) {
            this._subHeaderKeys[n3] = dataInput.readUnsignedShort();
            n5 = Math.max(n5, this._subHeaderKeys[n3]);
            n4 += 2;
        }
        n3 = n5 / 8 + 1;
        this._subHeaders = new SubHeader[n3];
        int n6 = 8 * n3 + 518;
        n5 = 0;
        for (n2 = 0; n2 < this._subHeaders.length; ++n2) {
            SubHeader subHeader = new SubHeader();
            subHeader._firstCode = dataInput.readUnsignedShort();
            subHeader._entryCount = dataInput.readUnsignedShort();
            subHeader._idDelta = dataInput.readShort();
            subHeader._idRangeOffset = dataInput.readUnsignedShort();
            subHeader._arrayIndex = ((n4 += 8) - 2 + subHeader._idRangeOffset - n6) / 2;
            n5 = Math.max(n5, subHeader._arrayIndex + subHeader._entryCount);
            this._subHeaders[n2] = subHeader;
        }
        this._glyphIndexArray = new int[n5];
        for (n2 = 0; n2 < this._glyphIndexArray.length; ++n2) {
            this._glyphIndexArray[n2] = dataInput.readUnsignedShort();
        }
    }

    @Override
    public int getRangeCount() {
        return this._subHeaders.length;
    }

    @Override
    public CmapFormat.Range getRange(int n2) throws ArrayIndexOutOfBoundsException {
        if (n2 < 0 || n2 >= this._subHeaders.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n3 = 0;
        if (n2 != 0) {
            for (int i2 = 0; i2 < 256; ++i2) {
                if (this._subHeaderKeys[i2] / 8 != n2) continue;
                n3 = i2 << 8;
                break;
            }
        }
        return new CmapFormat.Range(n3 | this._subHeaders[n2]._firstCode, n3 | this._subHeaders[n2]._firstCode + this._subHeaders[n2]._entryCount - 1);
    }

    @Override
    public int mapCharCode(int n2) {
        int n3 = 0;
        int n4 = n2 >> 8;
        if (n4 != 0) {
            n3 = this._subHeaderKeys[n4] / 8;
        }
        SubHeader subHeader = this._subHeaders[n3];
        int n5 = n2 & 0xFF;
        if (n5 < subHeader._firstCode || n5 >= subHeader._firstCode + subHeader._entryCount) {
            return 0;
        }
        int n6 = this._glyphIndexArray[subHeader._arrayIndex + (n5 - subHeader._firstCode)];
        if (n6 != 0) {
            n6 += subHeader._idDelta;
            n6 %= 65536;
        }
        return n6;
    }

    static class SubHeader {
        int _firstCode;
        int _entryCount;
        short _idDelta;
        int _idRangeOffset;
        int _arrayIndex;

        SubHeader() {
        }
    }
}

