/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast;

import com.jogamp.common.util.IntIntHashMap;
import com.jogamp.graph.curve.OutlineShape;
import com.jogamp.graph.font.Font;
import com.jogamp.opengl.math.geom.AABBox;

public final class TypecastGlyph
implements Font.Glyph {
    public static final short INVALID_ID = -1;
    public static final short MAX_ID = -2;
    private final char symbol;
    private final OutlineShape shape;
    private final short id;
    private final Metrics metrics;

    protected TypecastGlyph(Font font, char c2, short s2, AABBox aABBox, int n2, OutlineShape outlineShape) {
        this.symbol = c2;
        this.shape = outlineShape;
        this.id = s2;
        this.metrics = new Metrics(font, aABBox, n2);
    }

    @Override
    public final Font getFont() {
        return this.metrics.getFont();
    }

    @Override
    public final char getSymbol() {
        return this.symbol;
    }

    final AABBox getBBoxUnsized() {
        return this.metrics.getBBox();
    }

    @Override
    public final AABBox getBBox() {
        return this.metrics.getBBox();
    }

    public final Metrics getMetrics() {
        return this.metrics;
    }

    @Override
    public final short getID() {
        return this.id;
    }

    @Override
    public final float getScale(float f2) {
        return this.metrics.getScale(f2);
    }

    @Override
    public final AABBox getBBox(AABBox aABBox, float f2, float[] fArray) {
        return aABBox.copy(this.getBBox()).scale(this.getScale(f2), fArray);
    }

    protected final void addAdvance(float f2, float f3) {
        this.metrics.addAdvance(f2, f3);
    }

    @Override
    public final float getAdvance(float f2, boolean bl) {
        return this.metrics.getAdvance(f2, bl);
    }

    @Override
    public final OutlineShape getShape() {
        return this.shape;
    }

    @Override
    public final int hashCode() {
        int n2 = 31 + this.getFont().getName(3).hashCode();
        return (n2 << 5) - n2 + this.id;
    }

    public static final class Metrics {
        private final AABBox bbox;
        private final Advance advance;

        public Metrics(Font font, AABBox aABBox, float f2) {
            this.bbox = aABBox;
            this.advance = new Advance(font, f2);
        }

        public final void reset() {
            this.advance.reset();
        }

        public final Font getFont() {
            return this.advance.getFont();
        }

        public final float getScale(float f2) {
            return this.advance.getScale(f2);
        }

        public final AABBox getBBox() {
            return this.bbox;
        }

        public final void addAdvance(float f2, float f3) {
            this.advance.add(f2, f3);
        }

        public final float getAdvance(float f2, boolean bl) {
            return this.advance.get(f2, bl);
        }

        public final String toString() {
            return "\nMetrics:\n  bbox: " + this.bbox + this.advance;
        }
    }

    public static final class Advance {
        private final Font font;
        private final float advance;
        private final IntIntHashMap size2advanceI = new IntIntHashMap();

        public Advance(Font font, float f2) {
            this.font = font;
            this.advance = f2;
            this.size2advanceI.setKeyNotFoundValue(0);
        }

        public final void reset() {
            this.size2advanceI.clear();
        }

        public final Font getFont() {
            return this.font;
        }

        public final float getScale(float f2) {
            return this.font.getMetrics().getScale(f2);
        }

        public final void add(float f2, float f3) {
            this.size2advanceI.put(Float.floatToIntBits(f3), Float.floatToIntBits(f2));
        }

        public final float get(float f2, boolean bl) {
            int n2 = Float.floatToIntBits(f2);
            int n3 = this.size2advanceI.get(n2);
            if (0 != n3) {
                return Float.intBitsToFloat(n3);
            }
            float f3 = bl ? this.advance * this.getScale(f2) : (float)Math.round(this.advance * this.getScale(f2));
            this.size2advanceI.put(n2, Float.floatToIntBits(f3));
            return f3;
        }

        public final String toString() {
            return "\nAdvance:\n  advance: " + this.advance + "\n advances: \n" + this.size2advanceI;
        }
    }
}

