/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast;

import com.jogamp.common.util.IntObjectHashMap;
import com.jogamp.graph.curve.OutlineShape;
import com.jogamp.graph.font.Font;
import com.jogamp.graph.font.FontFactory;
import com.jogamp.graph.geom.SVertex;
import com.jogamp.graph.geom.Vertex;
import com.jogamp.opengl.math.geom.AABBox;
import jogamp.graph.font.typecast.TypecastGlyph;
import jogamp.graph.font.typecast.TypecastHMetrics;
import jogamp.graph.font.typecast.TypecastRenderer;
import jogamp.graph.font.typecast.ot.OTFont;
import jogamp.graph.font.typecast.ot.OTFontCollection;
import jogamp.graph.font.typecast.ot.OTGlyph;
import jogamp.graph.font.typecast.ot.table.CmapFormat;
import jogamp.graph.font.typecast.ot.table.CmapIndexEntry;
import jogamp.graph.font.typecast.ot.table.CmapTable;
import jogamp.graph.font.typecast.ot.table.HdmxTable;
import jogamp.graph.geom.plane.AffineTransform;

class TypecastFont
implements Font {
    static final boolean DEBUG = false;
    private static final Vertex.Factory<SVertex> vertexFactory = SVertex.factory();
    final OTFont font;
    private final CmapFormat cmapFormat;
    private final int cmapentries;
    private final IntObjectHashMap char2Glyph;
    private final TypecastHMetrics metrics;
    private final float[] tmpV3 = new float[3];

    public TypecastFont(OTFontCollection oTFontCollection) {
        int n2;
        this.font = oTFontCollection.getFont(0);
        CmapTable cmapTable = this.font.getCmapTable();
        CmapFormat[] cmapFormatArray = new CmapFormat[]{null, null, null, null};
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        for (n2 = 0; n2 < cmapTable.getNumTables(); ++n2) {
            CmapIndexEntry cmapIndexEntry = cmapTable.getCmapIndexEntry(n2);
            int n6 = cmapIndexEntry.getPlatformId();
            CmapFormat cmapFormat = cmapIndexEntry.getFormat();
            if (cmapFormatArray[n6] != null && cmapFormatArray[n6].getLength() >= cmapFormat.getLength()) continue;
            cmapFormatArray[n6] = cmapFormat;
            if (cmapFormat.getLength() <= n4) continue;
            n4 = cmapFormat.getLength();
            n3 = n6;
            n5 = cmapIndexEntry.getEncodingId();
        }
        if (0 <= n3) {
            this.cmapFormat = cmapFormatArray[n3];
        } else {
            CmapFormat cmapFormat = null;
            if (null == cmapFormat) {
                n3 = 3;
                n5 = 1;
                cmapFormat = cmapTable.getCmapFormat((short)n3, (short)n5);
            }
            if (null == cmapFormat) {
                n3 = 3;
                n5 = 0;
                cmapFormat = cmapTable.getCmapFormat((short)n3, (short)n5);
            }
            if (null == cmapFormat) {
                throw new RuntimeException("Cannot find a suitable cmap table for font " + this.font);
            }
            this.cmapFormat = cmapFormat;
        }
        n2 = 0;
        for (int i2 = 0; i2 < this.cmapFormat.getRangeCount(); ++i2) {
            CmapFormat.Range range = this.cmapFormat.getRange(i2);
            n2 += range.getEndCode() - range.getStartCode() + 1;
        }
        this.cmapentries = n2;
        this.char2Glyph = new IntObjectHashMap(this.cmapentries + this.cmapentries / 4);
        this.metrics = new TypecastHMetrics(this);
    }

    @Override
    public StringBuilder getName(StringBuilder stringBuilder, int n2) {
        return this.font.getName(n2, stringBuilder);
    }

    @Override
    public String getName(int n2) {
        return this.getName(null, n2).toString();
    }

    @Override
    public StringBuilder getAllNames(StringBuilder stringBuilder, String string) {
        return this.font.getAllNames(stringBuilder, string);
    }

    @Override
    public StringBuilder getFullFamilyName(StringBuilder stringBuilder) {
        stringBuilder = this.getName(stringBuilder, 1).append("-");
        this.getName(stringBuilder, 2);
        return stringBuilder;
    }

    @Override
    public float getAdvanceWidth(int n2, float f2) {
        return (float)this.font.getHmtxTable().getAdvanceWidth(n2) * this.metrics.getScale(f2);
    }

    @Override
    public final Font.Metrics getMetrics() {
        return this.metrics;
    }

    @Override
    public Font.Glyph getGlyph(char c2) {
        TypecastGlyph typecastGlyph = (TypecastGlyph)this.char2Glyph.get(c2);
        if (null == typecastGlyph) {
            OTGlyph oTGlyph;
            short s2 = (short)this.cmapFormat.mapCharCode(c2);
            if (0 == s2 && '\u0000' != c2) {
                switch (c2) {
                    case ' ': {
                        s2 = 3;
                        break;
                    }
                    case '\n': {
                        s2 = 2;
                        break;
                    }
                    default: {
                        s2 = 0;
                    }
                }
            }
            if (null == (oTGlyph = this.font.getGlyph(s2))) {
                oTGlyph = this.font.getGlyph(0);
            }
            if (null == oTGlyph) {
                throw new RuntimeException("Could not retrieve glyph for symbol: <" + c2 + "> " + c2 + " -> glyph id " + s2);
            }
            OutlineShape outlineShape = TypecastRenderer.buildShape(c2, oTGlyph, vertexFactory);
            typecastGlyph = new TypecastGlyph(this, c2, s2, oTGlyph.getBBox(), oTGlyph.getAdvanceWidth(), outlineShape);
            oTGlyph.clearPointData();
            HdmxTable hdmxTable = this.font.getHdmxTable();
            if (null != typecastGlyph && null != hdmxTable) {
                for (int i2 = 0; i2 < hdmxTable.getNumberOfRecords(); ++i2) {
                    HdmxTable.DeviceRecord deviceRecord = hdmxTable.getRecord(i2);
                    typecastGlyph.addAdvance(deviceRecord.getWidth(s2), deviceRecord.getPixelSize());
                }
            }
            this.char2Glyph.put(c2, typecastGlyph);
        }
        return typecastGlyph;
    }

    @Override
    public final float getPixelSize(float f2, float f3) {
        return f2 * f3 / 72.0f;
    }

    @Override
    public float getLineHeight(float f2) {
        Font.Metrics metrics = this.getMetrics();
        float f3 = metrics.getLineGap(f2);
        float f4 = metrics.getAscent(f2);
        float f5 = metrics.getDescent(f2);
        float f6 = f3 - f5 + f4;
        return -f6;
    }

    @Override
    public float getMetricWidth(CharSequence charSequence, float f2) {
        float f3 = 0.0f;
        int n2 = charSequence.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = charSequence.charAt(i2);
            if (c2 == '\n') {
                f3 = 0.0f;
                continue;
            }
            Font.Glyph glyph = this.getGlyph(c2);
            f3 += glyph.getAdvance(f2, false);
        }
        return (int)(f3 + 0.5f);
    }

    @Override
    public float getMetricHeight(CharSequence charSequence, float f2, AABBox aABBox) {
        int n2 = 0;
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            char c2 = charSequence.charAt(i2);
            if (c2 == ' ') continue;
            Font.Glyph glyph = this.getGlyph(c2);
            AABBox aABBox2 = glyph.getBBox(aABBox, f2, this.tmpV3);
            n2 = (int)Math.ceil(Math.max(aABBox2.getHeight(), (float)n2));
        }
        return n2;
    }

    @Override
    public AABBox getMetricBounds(CharSequence charSequence, float f2) {
        if (charSequence == null) {
            return new AABBox();
        }
        int n2 = charSequence.length();
        float f3 = this.getLineHeight(f2);
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = charSequence.charAt(i2);
            if (c2 == '\n') {
                f5 = Math.max(f6, f5);
                f6 = 0.0f;
                f4 += f3;
                continue;
            }
            Font.Glyph glyph = this.getGlyph(c2);
            f6 += glyph.getAdvance(f2, true);
        }
        if (f6 > 0.0f) {
            f4 += f3;
            f5 = Math.max(f6, f5);
        }
        return new AABBox(0.0f, 0.0f, 0.0f, f5, f4, 0.0f);
    }

    @Override
    public AABBox getPointsBounds(AffineTransform affineTransform, CharSequence charSequence, float f2, AffineTransform affineTransform2, AffineTransform affineTransform3) {
        if (charSequence == null) {
            return new AABBox();
        }
        int n2 = charSequence.length();
        float f3 = this.getLineHeight(f2);
        float f4 = this.getMetrics().getScale(f2);
        AABBox aABBox = new AABBox();
        AABBox aABBox2 = new AABBox();
        float f5 = 0.0f;
        float f6 = 0.0f;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = charSequence.charAt(i2);
            if ('\n' == c2) {
                f5 -= f3;
                f6 = 0.0f;
                continue;
            }
            if (c2 == ' ') {
                f6 += this.getAdvanceWidth(3, f2);
                continue;
            }
            if (null != affineTransform) {
                affineTransform2.setTransform(affineTransform);
            } else {
                affineTransform2.setToIdentity();
            }
            affineTransform2.translate(f6, f5, affineTransform3);
            affineTransform2.scale(f4, f4, affineTransform3);
            aABBox.reset();
            Font.Glyph glyph = this.getGlyph(c2);
            aABBox2.resize(affineTransform2.transform(glyph.getBBox(), aABBox));
            OutlineShape outlineShape = glyph.getShape();
            if (null == outlineShape) continue;
            f6 += glyph.getAdvance(f2, true);
        }
        return aABBox2;
    }

    @Override
    public final int getNumGlyphs() {
        return this.font.getNumGlyphs();
    }

    @Override
    public boolean isPrintableChar(char c2) {
        return FontFactory.isPrintableChar(c2);
    }

    @Override
    public String toString() {
        return this.getFullFamilyName(null).toString();
    }
}

