/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font;

import com.jogamp.common.util.IntObjectHashMap;
import com.jogamp.graph.font.Font;
import com.jogamp.graph.font.FontFactory;
import com.jogamp.graph.font.FontSet;
import com.jogamp.opengl.GLException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class JavaFontLoader
implements FontSet {
    private static final IntObjectHashMap fontMap = new IntObjectHashMap();
    private static final FontSet fontLoader = new JavaFontLoader();
    static final String[] availableFontFileNames = new String[]{"LucidaBrightRegular.ttf", "LucidaBrightItalic.ttf", "LucidaBrightDemiBold.ttf", "LucidaBrightDemiItalic.ttf", "LucidaSansRegular.ttf", "LucidaSansDemiBold.ttf", "LucidaTypewriterRegular.ttf", "LucidaTypewriterBold.ttf"};
    final String javaFontPath;

    public static FontSet get() {
        return fontLoader;
    }

    private JavaFontLoader() {
        String string = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("java.home");
            }
        });
        this.javaFontPath = null != string ? string + "/lib/fonts/" : null;
    }

    static boolean is(int n2, int n3) {
        return 0 != (n2 & n3);
    }

    @Override
    public Font getDefault() throws IOException {
        return this.get(0, 0);
    }

    @Override
    public Font get(int n2, int n3) throws IOException {
        if (null == this.javaFontPath) {
            throw new GLException("java font path undefined");
        }
        Font font = (Font)fontMap.get(n2 << 8 | n3);
        if (font != null) {
            return font;
        }
        if (JavaFontLoader.is(n3, 2)) {
            font = JavaFontLoader.is(n3, 4) ? this.abspath(availableFontFileNames[5], n2, n3) : this.abspath(availableFontFileNames[4], n2, n3);
            if (null != font) {
                fontMap.put(n2 << 8 | n3, font);
            }
            return font;
        }
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                if (JavaFontLoader.is(n3, 4)) {
                    if (JavaFontLoader.is(n3, 8)) {
                        font = this.abspath(availableFontFileNames[3], n2, n3);
                        break;
                    }
                    font = this.abspath(availableFontFileNames[2], n2, n3);
                    break;
                }
                if (JavaFontLoader.is(n3, 8)) {
                    font = this.abspath(availableFontFileNames[1], n2, n3);
                    break;
                }
                font = this.abspath(availableFontFileNames[0], n2, n3);
                break;
            }
            case 4: {
                font = JavaFontLoader.is(n3, 4) ? this.abspath(availableFontFileNames[7], n2, n3) : this.abspath(availableFontFileNames[6], n2, n3);
            }
        }
        return font;
    }

    Font abspath(String string, int n2, int n3) throws IOException {
        try {
            Font font = this.abspathImpl(this.javaFontPath + string, n2, n3);
            if (null != font) {
                return font;
            }
            throw new IOException(String.format("Problem loading font %s, file %s%s", string, this.javaFontPath, string));
        }
        catch (IOException iOException) {
            throw new IOException(String.format("Problem loading font %s, file %s%s", string, this.javaFontPath, string), iOException);
        }
    }

    private Font abspathImpl(final String string, int n2, int n3) throws IOException {
        Font font;
        final Exception[] exceptionArray = new Exception[]{null};
        final int[] nArray = new int[]{0};
        InputStream inputStream = AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                try {
                    File file = new File(string);
                    nArray[0] = (int)file.length();
                    return new BufferedInputStream(new FileInputStream(file), nArray[0]);
                }
                catch (Exception exception) {
                    exceptionArray[0] = exception;
                    return null;
                }
            }
        });
        if (null != exceptionArray[0]) {
            throw new IOException(exceptionArray[0]);
        }
        if (null != inputStream && null != (font = FontFactory.get(inputStream, nArray[0], true))) {
            fontMap.put(n2 << 8 | n3, font);
            return font;
        }
        return null;
    }
}

