/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.curve.tess;

import com.jogamp.graph.geom.Vertex;
import java.util.ArrayList;
import jogamp.graph.curve.tess.HEdge;

public class GraphVertex {
    private Vertex point;
    private ArrayList<HEdge> edges = null;
    private boolean boundaryContained = false;

    public GraphVertex(Vertex vertex) {
        this.point = vertex;
    }

    public Vertex getPoint() {
        return this.point;
    }

    public float getX() {
        return this.point.getX();
    }

    public float getY() {
        return this.point.getY();
    }

    public float getZ() {
        return this.point.getZ();
    }

    public float[] getCoord() {
        return this.point.getCoord();
    }

    public void setPoint(Vertex vertex) {
        this.point = vertex;
    }

    public ArrayList<HEdge> getEdges() {
        return this.edges;
    }

    public void setEdges(ArrayList<HEdge> arrayList) {
        this.edges = arrayList;
    }

    public void addEdge(HEdge hEdge) {
        if (this.edges == null) {
            this.edges = new ArrayList();
        }
        this.edges.add(hEdge);
    }

    public void removeEdge(HEdge hEdge) {
        if (this.edges == null) {
            return;
        }
        this.edges.remove(hEdge);
        if (this.edges.size() == 0) {
            this.edges = null;
        }
    }

    public HEdge findNextEdge(GraphVertex graphVertex) {
        for (int i2 = 0; i2 < this.edges.size(); ++i2) {
            HEdge hEdge = this.edges.get(i2);
            if (hEdge.getNext().getGraphPoint() != graphVertex) continue;
            return hEdge;
        }
        return null;
    }

    public HEdge findBoundEdge() {
        for (int i2 = 0; i2 < this.edges.size(); ++i2) {
            HEdge hEdge = this.edges.get(i2);
            if (hEdge.getType() != 3 && hEdge.getType() != 2) continue;
            return hEdge;
        }
        return null;
    }

    public HEdge findPrevEdge(GraphVertex graphVertex) {
        for (int i2 = 0; i2 < this.edges.size(); ++i2) {
            HEdge hEdge = this.edges.get(i2);
            if (hEdge.getPrev().getGraphPoint() != graphVertex) continue;
            return hEdge;
        }
        return null;
    }

    public boolean isBoundaryContained() {
        return this.boundaryContained;
    }

    public void setBoundaryContained(boolean bl) {
        this.boundaryContained = bl;
    }

    public String toString() {
        return "GraphVertex[contained " + this.boundaryContained + ", " + this.point + "]";
    }
}

