/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.curve.tess;

import com.jogamp.graph.curve.tess.Triangulator;
import com.jogamp.graph.geom.Outline;
import com.jogamp.graph.geom.Triangle;
import com.jogamp.graph.geom.Vertex;
import com.jogamp.opengl.math.VectorUtil;
import java.util.ArrayList;
import java.util.List;
import jogamp.graph.curve.tess.CDTriangulator2DExpAddOn;
import jogamp.graph.curve.tess.GraphOutline;
import jogamp.graph.curve.tess.GraphVertex;
import jogamp.graph.curve.tess.Loop;
import jogamp.opengl.Debug;

public class CDTriangulator2D
implements Triangulator {
    protected static final boolean DEBUG = Debug.debug("graph.curve.Triangulation");
    private static final boolean TEST_LINE_AA = Debug.debug("graph.curve.triangulation.LINE_AA");
    private static final boolean TEST_MARK_LINE = Debug.debug("graph.curve.triangulation.MARK_AA");
    private static final boolean TEST_ENABLED = TEST_LINE_AA || TEST_MARK_LINE;
    private final ArrayList<Loop> loops = new ArrayList();
    private int addedVerticeCount;
    private int maxTriID;

    public CDTriangulator2D() {
        this.reset();
    }

    @Override
    public final void reset() {
        this.maxTriID = 0;
        this.addedVerticeCount = 0;
        this.loops.clear();
    }

    @Override
    public final int getAddedVerticeCount() {
        return this.addedVerticeCount;
    }

    @Override
    public final void addCurve(List<Triangle> list, Outline outline, float f2) {
        Loop loop = null;
        if (!this.loops.isEmpty()) {
            loop = this.getContainerLoop(outline);
        }
        if (loop == null) {
            GraphOutline graphOutline = new GraphOutline(outline);
            GraphOutline graphOutline2 = this.extractBoundaryTriangles(list, graphOutline, false, f2);
            loop = new Loop(graphOutline2, VectorUtil.Winding.CCW);
            this.loops.add(loop);
        } else {
            GraphOutline graphOutline = new GraphOutline(outline);
            GraphOutline graphOutline3 = this.extractBoundaryTriangles(list, graphOutline, true, f2);
            loop.addConstraintCurve(graphOutline3);
        }
    }

    @Override
    public final void generate(List<Triangle> list) {
        block6: {
            float[] fArray;
            Triangle triangle;
            int n2;
            int n3;
            Object object;
            block7: {
                int n4 = this.loops.size();
                for (int i2 = 0; i2 < n4; ++i2) {
                    object = this.loops.get(i2);
                    n3 = 0;
                    n2 = ((Loop)object).computeLoopSize();
                    while (!((Loop)object).isSimplex()) {
                        triangle = n3 > n2 ? ((Loop)object).cut(false) : ((Loop)object).cut(true);
                        ++n3;
                        if (triangle != null) {
                            n3 = 0;
                            --n2;
                            triangle.setId(this.maxTriID++);
                            list.add(triangle);
                            if (DEBUG) {
                                System.err.println("CDTri.gen[" + i2 + "].0: " + triangle);
                            }
                        }
                        if (n3 <= n2 * 2) continue;
                        if (!DEBUG) break;
                        System.err.println("CDTri.gen[" + i2 + "].X: Triangulation not complete!");
                        break;
                    }
                    if ((triangle = ((Loop)object).cut(true)) == null) continue;
                    list.add(triangle);
                    if (!DEBUG) continue;
                    System.err.println("CDTri.gen[" + i2 + "].1: " + triangle);
                }
                if (!TEST_ENABLED) break block6;
                fArray = new float[2];
                object = new CDTriangulator2DExpAddOn();
                n3 = list.size();
                if (!TEST_MARK_LINE) break block7;
                for (n2 = 0; n2 < n3; ++n2) {
                    triangle = list.get(n2);
                    ((CDTriangulator2DExpAddOn)object).markLineInTriangle(triangle, fArray);
                }
                break block6;
            }
            if (!TEST_LINE_AA) break block6;
            for (n2 = 0; n2 < n3 - 1; n2 += 2) {
                triangle = list.get(n2);
                Triangle triangle2 = list.get(n2 + 1);
                ((CDTriangulator2DExpAddOn)object).processLineAA(n2, triangle, triangle2, fArray);
            }
        }
    }

    private GraphOutline extractBoundaryTriangles(List<Triangle> list, GraphOutline graphOutline, boolean bl, float f2) {
        GraphOutline graphOutline2 = new GraphOutline();
        ArrayList<GraphVertex> arrayList = graphOutline.getGraphPoint();
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            GraphVertex graphVertex = arrayList.get(i2);
            GraphVertex graphVertex2 = arrayList.get((i2 + n2 - 1) % n2);
            GraphVertex graphVertex3 = arrayList.get((i2 + 1) % n2);
            if (!graphVertex.getPoint().isOnCurve()) {
                Triangle triangle;
                boolean bl2;
                Vertex vertex = graphVertex2.getPoint().clone();
                Vertex vertex2 = graphVertex3.getPoint().clone();
                Vertex vertex3 = graphVertex.getPoint().clone();
                this.addedVerticeCount += 3;
                boolean[] blArray = new boolean[]{true, true, true};
                graphVertex2.setBoundaryContained(true);
                graphVertex.setBoundaryContained(true);
                graphVertex3.setBoundaryContained(true);
                if (VectorUtil.ccw(vertex, vertex3, vertex2)) {
                    bl2 = false;
                    triangle = new Triangle(vertex, vertex3, vertex2, blArray);
                } else {
                    bl2 = true;
                    triangle = new Triangle(vertex2, vertex3, vertex, blArray);
                }
                triangle.setId(this.maxTriID++);
                list.add(triangle);
                if (DEBUG) {
                    System.err.println(triangle);
                }
                if (bl || bl2) {
                    vertex.setTexCoord(0.0f, -0.1f, 0.0f);
                    vertex2.setTexCoord(1.0f, -0.1f, 0.0f);
                    vertex3.setTexCoord(0.5f, -f2 - 0.1f, 0.0f);
                    graphOutline2.addVertex(graphVertex);
                } else {
                    vertex.setTexCoord(0.0f, 0.1f, 0.0f);
                    vertex2.setTexCoord(1.0f, 0.1f, 0.0f);
                    vertex3.setTexCoord(0.5f, f2 + 0.1f, 0.0f);
                }
                if (!DEBUG) continue;
                System.err.println("CDTri.ebt[" + i2 + "].0: hole " + (bl || bl2) + " " + graphVertex + ", " + triangle);
                continue;
            }
            if (!graphVertex3.getPoint().isOnCurve() || !graphVertex2.getPoint().isOnCurve()) {
                graphVertex.setBoundaryContained(true);
            }
            graphOutline2.addVertex(graphVertex);
            if (!DEBUG) continue;
            System.err.println("CDTri.ebt[" + i2 + "].1: " + graphVertex);
        }
        return graphOutline2;
    }

    private Loop getContainerLoop(Outline outline) {
        ArrayList<Vertex> arrayList = outline.getVertices();
        for (int i2 = 0; i2 < this.loops.size(); ++i2) {
            Loop loop = this.loops.get(i2);
            for (int i3 = 0; i3 < arrayList.size(); ++i3) {
                if (!loop.checkInside(arrayList.get(i3))) continue;
                return loop;
            }
        }
        return null;
    }
}

