/*
 * Decompiled with CFR 0.152.
 */
package jogamp.common.util.locks;

import com.jogamp.common.util.locks.RecursiveThreadGroupLock;
import java.util.Arrays;
import jogamp.common.util.locks.RecursiveLockImpl01Unfairish;

public class RecursiveThreadGroupLockImpl01Unfairish
extends RecursiveLockImpl01Unfairish
implements RecursiveThreadGroupLock {
    public RecursiveThreadGroupLockImpl01Unfairish() {
        super(new ThreadGroupSync());
    }

    @Override
    public final boolean isOriginalOwner() {
        return this.isOriginalOwner(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isOriginalOwner(Thread thread) {
        RecursiveLockImpl01Unfairish.Sync sync = this.sync;
        synchronized (sync) {
            return ((ThreadGroupSync)this.sync).isOriginalOwner(thread);
        }
    }

    @Override
    public final void addOwner(Thread thread) throws RuntimeException, IllegalArgumentException {
        this.validateLocked();
        Thread thread2 = Thread.currentThread();
        ThreadGroupSync threadGroupSync = (ThreadGroupSync)this.sync;
        if (!threadGroupSync.isOriginalOwner(thread2)) {
            throw new IllegalArgumentException("Current thread is not the original owner: orig-owner: " + threadGroupSync.getOwner() + ", current " + thread2 + ": " + this.toString());
        }
        if (threadGroupSync.isOriginalOwner(thread)) {
            throw new IllegalArgumentException("Passed thread is original owner: " + thread + ", " + this.toString());
        }
        threadGroupSync.addOwner(thread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void unlock(Runnable runnable) {
        RecursiveLockImpl01Unfairish.Sync sync = this.sync;
        synchronized (sync) {
            Thread thread = Thread.currentThread();
            ThreadGroupSync threadGroupSync = (ThreadGroupSync)this.sync;
            if (threadGroupSync.getAddOwnerCount() > 0) {
                Thread thread2;
                if (TRACE_LOCK) {
                    System.err.println("--- LOCK XR (tg) " + this.toString() + ", cur " + this.threadName(thread) + " -> owner...");
                }
                if (threadGroupSync.isOriginalOwner(thread)) {
                    if (threadGroupSync.getHoldCount() - threadGroupSync.getAdditionalOwnerHoldCount() == 1) {
                        threadGroupSync.setWaitingOrigOwner(thread);
                        try {
                            while (threadGroupSync.getAdditionalOwnerHoldCount() > 0) {
                                try {
                                    this.sync.wait();
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                        }
                        finally {
                            threadGroupSync.setWaitingOrigOwner(null);
                            Thread.interrupted();
                        }
                        threadGroupSync.removeAllOwners();
                    }
                } else if (threadGroupSync.getAdditionalOwnerHoldCount() == 1 && null != (thread2 = threadGroupSync.getWaitingOrigOwner())) {
                    thread2.interrupt();
                }
            }
            if (TRACE_LOCK) {
                System.err.println("++ unlock(X): currentThread " + thread.getName() + ", lock: " + this.toString());
                System.err.println("--- LOCK X0 (tg) " + this.toString() + ", cur " + this.threadName(thread) + " -> unlock!");
            }
            super.unlock(runnable);
        }
    }

    @Override
    public final void removeOwner(Thread thread) throws RuntimeException, IllegalArgumentException {
        this.validateLocked();
        ((ThreadGroupSync)this.sync).removeOwner(thread);
    }

    @Override
    public String toString() {
        ThreadGroupSync threadGroupSync = (ThreadGroupSync)this.sync;
        int n2 = this.sync.getHoldCount();
        int n3 = threadGroupSync.getAdditionalOwnerHoldCount();
        return this.syncName() + "[count " + n2 + " [ add. " + n3 + ", orig " + (n2 - n3) + "], qsz " + this.sync.getQSz() + ", owner " + this.threadName(this.sync.getOwner()) + ", add.owner " + threadGroupSync.addOwnerToString() + "]";
    }

    static class ThreadGroupSync
    extends RecursiveLockImpl01Unfairish.SingleThreadSync {
        private int holdCountAdditionOwner = 0;
        private Thread[] threads = null;
        private int threadNum = 0;
        private Thread waitingOrigOwner = null;

        ThreadGroupSync() {
        }

        @Override
        public final void incrHoldCount(Thread thread) {
            super.incrHoldCount(thread);
            if (!this.isOriginalOwner(thread)) {
                ++this.holdCountAdditionOwner;
            }
        }

        @Override
        public final void decrHoldCount(Thread thread) {
            super.decrHoldCount(thread);
            if (!this.isOriginalOwner(thread)) {
                --this.holdCountAdditionOwner;
            }
        }

        public final int getAdditionalOwnerHoldCount() {
            return this.holdCountAdditionOwner;
        }

        public final boolean isOriginalOwner(Thread thread) {
            return super.isOwner(thread);
        }

        public final void setWaitingOrigOwner(Thread thread) {
            this.waitingOrigOwner = thread;
        }

        public final Thread getWaitingOrigOwner() {
            return this.waitingOrigOwner;
        }

        @Override
        public final boolean isOwner(Thread thread) {
            if (this.getExclusiveOwnerThread() == thread) {
                return true;
            }
            for (int i2 = this.threadNum - 1; 0 <= i2; --i2) {
                if (this.threads[i2] != thread) continue;
                return true;
            }
            return false;
        }

        public final int getAddOwnerCount() {
            return this.threadNum;
        }

        public final void addOwner(Thread thread) throws IllegalArgumentException {
            if (null == this.threads) {
                if (this.threadNum > 0) {
                    throw new InternalError("XXX");
                }
                this.threads = new Thread[4];
            }
            for (int i2 = this.threadNum - 1; 0 <= i2; --i2) {
                if (this.threads[i2] != thread) continue;
                throw new IllegalArgumentException("Thread already added: " + thread);
            }
            if (this.threadNum == this.threads.length) {
                this.threads = Arrays.copyOf(this.threads, this.threadNum * 2);
            }
            this.threads[this.threadNum] = thread;
            ++this.threadNum;
        }

        public final void removeAllOwners() {
            for (int i2 = this.threadNum - 1; 0 <= i2; --i2) {
                this.threads[i2] = null;
            }
            this.threadNum = 0;
        }

        public final void removeOwner(Thread thread) throws IllegalArgumentException {
            for (int i2 = 0; i2 < this.threadNum; ++i2) {
                if (this.threads[i2] != thread) continue;
                --this.threadNum;
                System.arraycopy(this.threads, i2 + 1, this.threads, i2, this.threadNum - i2);
                this.threads[this.threadNum] = null;
                return;
            }
            throw new IllegalArgumentException("Not an owner: " + thread);
        }

        String addOwnerToString() {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i2 = 0; i2 < this.threadNum; ++i2) {
                if (i2 > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(this.threads[i2].getName());
            }
            return stringBuilder.toString();
        }
    }
}

