/*
 * Decompiled with CFR 0.152.
 */
package jogamp.common.util;

import com.jogamp.common.util.Bitfield;

public class Int32ArrayBitfield
implements Bitfield {
    private static final int UNIT_SHIFT = 5;
    private final int[] storage;
    private final int bitSize;

    public Int32ArrayBitfield(int n2) {
        int n3 = Math.max(1, n2 + 31 >>> 5);
        this.storage = new int[n3];
        this.bitSize = n3 << 5;
    }

    @Override
    public int size() {
        return this.bitSize;
    }

    @Override
    public final void clearField(boolean bl) {
        int n2 = bl ? -1 : 0;
        for (int i2 = this.storage.length - 1; i2 >= 0; --i2) {
            this.storage[i2] = n2;
        }
    }

    private static final void check(int n2, int n3) throws IndexOutOfBoundsException {
        if (0 > n3 || n3 >= n2) {
            throw new IndexOutOfBoundsException("Bitnum should be within [0.." + (n2 - 1) + "], but is " + n3);
        }
    }

    @Override
    public final int get32(int n2, int n3) throws IndexOutOfBoundsException {
        if (0 > n3 || n3 > 32) {
            throw new IndexOutOfBoundsException("length should be within [0..32], but is " + n3);
        }
        Int32ArrayBitfield.check(this.bitSize - n3 + 1, n2);
        int n4 = n2 >>> 5;
        int n5 = 32 - (n2 - (n4 << 5));
        if (32 == n5) {
            int n6 = Bitfield.Util.getBitMask(n3);
            return n6 & this.storage[n4];
        }
        int n7 = Math.min(n3, n5);
        int n8 = (1 << n7) - 1;
        int n9 = n8 & this.storage[n4] >>> n2;
        int n10 = n3 - n7;
        if (n10 > 0) {
            int n11 = (1 << n10) - 1;
            return n9 | (n11 & this.storage[n4 + 1]) << n7;
        }
        return n9;
    }

    @Override
    public final void put32(int n2, int n3, int n4) throws IndexOutOfBoundsException {
        if (0 > n3 || n3 > 32) {
            throw new IndexOutOfBoundsException("length should be within [0..32], but is " + n3);
        }
        Int32ArrayBitfield.check(this.bitSize - n3 + 1, n2);
        int n5 = n2 >>> 5;
        int n6 = 32 - (n2 - (n5 << 5));
        if (32 == n6) {
            int n7 = Bitfield.Util.getBitMask(n3);
            this.storage[n5] = ~n7 & this.storage[n5] | n7 & n4;
        } else {
            int n8 = Math.min(n3, n6);
            int n9 = (1 << n8) - 1;
            this.storage[n5] = ~(n9 << n2) & this.storage[n5] | (n9 & n4) << n2;
            int n10 = n3 - n8;
            if (n10 > 0) {
                int n11 = (1 << n10) - 1;
                this.storage[n5 + 1] = ~n11 & this.storage[n5 + 1] | n11 & n4 >>> n8;
            }
        }
    }

    @Override
    public final int copy32(int n2, int n3, int n4) throws IndexOutOfBoundsException {
        int n5 = this.get32(n2, n4);
        this.put32(n3, n4, n5);
        return n5;
    }

    @Override
    public final boolean get(int n2) throws IndexOutOfBoundsException {
        Int32ArrayBitfield.check(this.bitSize, n2);
        int n3 = n2 >>> 5;
        int n4 = n2 - (n3 << 5);
        return 0 != (this.storage[n3] & 1 << n4);
    }

    @Override
    public final boolean put(int n2, boolean bl) throws IndexOutOfBoundsException {
        boolean bl2;
        Int32ArrayBitfield.check(this.bitSize, n2);
        int n3 = n2 >>> 5;
        int n4 = n2 - (n3 << 5);
        int n5 = 1 << n4;
        boolean bl3 = bl2 = 0 != (this.storage[n3] & n5);
        if (bl2 != bl) {
            if (bl) {
                int n6 = n3;
                this.storage[n6] = this.storage[n6] | n5;
            } else {
                int n7 = n3;
                this.storage[n7] = this.storage[n7] & ~n5;
            }
        }
        return bl2;
    }

    @Override
    public final void set(int n2) throws IndexOutOfBoundsException {
        Int32ArrayBitfield.check(this.bitSize, n2);
        int n3 = n2 >>> 5;
        int n4 = n2 - (n3 << 5);
        int n5 = 1 << n4;
        int n6 = n3;
        this.storage[n6] = this.storage[n6] | n5;
    }

    @Override
    public final void clear(int n2) throws IndexOutOfBoundsException {
        Int32ArrayBitfield.check(this.bitSize, n2);
        int n3 = n2 >>> 5;
        int n4 = n2 - (n3 << 5);
        int n5 = 1 << n4;
        int n6 = n3;
        this.storage[n6] = this.storage[n6] & ~n5;
    }

    @Override
    public final boolean copy(int n2, int n3) throws IndexOutOfBoundsException {
        Int32ArrayBitfield.check(this.bitSize, n2);
        Int32ArrayBitfield.check(this.bitSize, n3);
        int n4 = n2 >>> 5;
        int n5 = n2 - (n4 << 5);
        boolean bl = 0 != (this.storage[n4] & 1 << n5);
        n4 = n3 >>> 5;
        n5 = n3 - (n4 << 5);
        int n6 = 1 << n5;
        if (bl) {
            int n7 = n4;
            this.storage[n7] = this.storage[n7] | n6;
        } else {
            int n8 = n4;
            this.storage[n8] = this.storage[n8] & ~n6;
        }
        return bl;
    }

    @Override
    public int bitCount() {
        int n2 = 0;
        for (int i2 = this.storage.length - 1; i2 >= 0; --i2) {
            n2 += Bitfield.Util.bitCount(this.storage[i2]);
        }
        return n2;
    }
}

