/*
 * Decompiled with CFR 0.152.
 */
package jogamp.common.os.elf;

import com.jogamp.common.util.Bitstream;
import java.io.IOException;
import java.io.RandomAccessFile;

class IOUtils {
    static final long MAX_INT_VALUE = Integer.MAX_VALUE;

    IOUtils() {
    }

    static String toHexString(int n2) {
        return "0x" + Integer.toHexString(n2);
    }

    static String toHexString(long l2) {
        return "0x" + Long.toHexString(l2);
    }

    static int shortToInt(short s2) {
        return s2 & 0xFFFF;
    }

    static int long2Int(long l2) {
        if (Integer.MAX_VALUE < l2) {
            throw new IllegalArgumentException("Read uint32 value " + IOUtils.toHexString(l2) + " > int32-max " + IOUtils.toHexString(Integer.MAX_VALUE));
        }
        return (int)l2;
    }

    static void readBytes(RandomAccessFile randomAccessFile, byte[] byArray, int n2, int n3) throws IOException, IllegalArgumentException {
        randomAccessFile.readFully(byArray, n2, n3);
    }

    static void seek(RandomAccessFile randomAccessFile, long l2) throws IOException {
        randomAccessFile.seek(l2);
    }

    static int readUInt32(boolean bl, byte[] byArray, int n2) {
        int n3 = Bitstream.uint32LongToInt(Bitstream.readUInt32(bl, byArray, n2));
        if (0 > n3) {
            throw new IllegalArgumentException("Read uint32 value " + IOUtils.toHexString(n3) + " > int32-max " + IOUtils.toHexString(Integer.MAX_VALUE));
        }
        return n3;
    }

    static String getString(byte[] byArray, int n2, int n3, int[] nArray) throws IndexOutOfBoundsException {
        String string;
        int n4;
        Bitstream.checkBounds(byArray, n2, n3);
        for (n4 = 0; n4 < n3 && byArray[n4 + n2] != 0; ++n4) {
        }
        String string2 = string = 0 < n4 ? new String(byArray, n2, n4) : "";
        if (null != nArray) {
            nArray[0] = n2 + n4 + 1;
        }
        return string;
    }

    static int getStringCount(byte[] byArray, int n2, int n3) throws IndexOutOfBoundsException {
        Bitstream.checkBounds(byArray, n2, n3);
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            while (i2 < n3 && byArray[i2 + n2] != 0) {
                ++i2;
            }
            ++n4;
        }
        return n4;
    }

    public static String[] getStrings(byte[] byArray, int n2, int n3) throws IndexOutOfBoundsException {
        int n4 = IOUtils.getStringCount(byArray, n2, n3);
        String[] stringArray = new String[n4];
        int[] nArray = new int[]{n2};
        for (int i2 = 0; i2 < n4; ++i2) {
            stringArray[i2] = IOUtils.getString(byArray, nArray[0], n3 - nArray[0], nArray);
        }
        return stringArray;
    }
}

