/*
 * Decompiled with CFR 0.152.
 */
package jogamp.common.os.elf;

import com.jogamp.common.os.Platform;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import jogamp.common.os.elf.Ehdr_p2;
import jogamp.common.os.elf.ElfHeaderPart1;
import jogamp.common.os.elf.IOUtils;
import jogamp.common.os.elf.Section;
import jogamp.common.os.elf.SectionArmAttributes;
import jogamp.common.os.elf.SectionHeader;

public class ElfHeaderPart2 {
    public static final int EF_ARM_ABIMASK = -16777216;
    public static final int EF_ARM_ABISHIFT = 24;
    public static final int EF_ARM_ABI5 = 0x5000000;
    public static final int EF_ARM_BE8 = 0x800000;
    public static final int EF_ARM_GCCMASK = 0x400FFF;
    public static final int EF_ARM_ABI_FLOAT_HARD = 1024;
    public static final int EF_ARM_ABI_FLOAT_SOFT = 512;
    public final ElfHeaderPart1 eh1;
    public final Ehdr_p2 raw;
    public final String cpuName;
    public final Platform.CPUType cpuType;
    public final Platform.ABIType abiType;
    public final SectionHeader[] sht;

    public static ElfHeaderPart2 read(ElfHeaderPart1 elfHeaderPart1, RandomAccessFile randomAccessFile) throws IOException, IllegalArgumentException {
        return new ElfHeaderPart2(elfHeaderPart1, randomAccessFile);
    }

    ElfHeaderPart2(ElfHeaderPart1 elfHeaderPart1, RandomAccessFile randomAccessFile) throws IllegalArgumentException, IOException {
        this.eh1 = elfHeaderPart1;
        Object object = new byte[Ehdr_p2.size(elfHeaderPart1.machDesc.ordinal())];
        IOUtils.readBytes(randomAccessFile, object, 0, ((byte[])object).length);
        Object object2 = ByteBuffer.wrap(object, 0, ((byte[])object).length);
        this.raw = Ehdr_p2.create(elfHeaderPart1.machDesc.ordinal(), (ByteBuffer)object2);
        this.sht = this.readSectionHeaderTable(randomAccessFile);
        if (Platform.CPUFamily.ARM == elfHeaderPart1.cpuType.family && elfHeaderPart1.cpuType.is32Bit) {
            Object object3;
            Object object4;
            object = null;
            object2 = null;
            boolean bl = false;
            SectionHeader sectionHeader = this.getSectionHeader(0x70000003);
            if (ElfHeaderPart1.DEBUG) {
                System.err.println("ELF-2: Got ARM Attribs Section Header: " + sectionHeader);
            }
            if (null != sectionHeader) {
                SectionArmAttributes.Attribute attribute;
                SectionArmAttributes.Attribute attribute2;
                object4 = (SectionArmAttributes)sectionHeader.readSection(randomAccessFile);
                if (ElfHeaderPart1.DEBUG) {
                    System.err.println("ELF-2: Got ARM Attribs Section Block : " + object4);
                }
                if (null != (object3 = ((SectionArmAttributes)object4).get(SectionArmAttributes.Tag.CPU_name)) && object3.isNTBS()) {
                    object = object3.getNTBS();
                }
                if (null != (attribute2 = ((SectionArmAttributes)object4).get(SectionArmAttributes.Tag.CPU_raw_name)) && attribute2.isNTBS()) {
                    object2 = attribute2.getNTBS();
                }
                if (null != (attribute = ((SectionArmAttributes)object4).get(SectionArmAttributes.Tag.ABI_VFP_args))) {
                    bl = SectionArmAttributes.abiVFPArgsAcceptsVFPVariant(attribute.getULEB128());
                }
            }
            object4 = null != object && object.length() > 0 ? object.toLowerCase().replace(' ', '-') : (null != object2 && ((String)object2).length() > 0 ? ((String)object2).toLowerCase().replace(' ', '-') : elfHeaderPart1.cpuName);
            object3 = ElfHeaderPart2.queryCPUTypeSafe((String)object4);
            if (null == object3 && null == (object3 = ElfHeaderPart2.queryCPUTypeSafe((String)(object4 = "arm-" + (String)object4))) && null == (object3 = ElfHeaderPart2.queryCPUTypeSafe((String)(object4 = elfHeaderPart1.cpuName)))) {
                throw new InternalError("XXX: " + (String)object4 + ", " + elfHeaderPart1);
            }
            this.cpuName = object4;
            this.cpuType = object3;
            if (ElfHeaderPart1.DEBUG) {
                System.err.println("ELF-2: abiARM cpuName " + (String)object4 + "[armCpuName " + (String)object + ", armCpuRawName " + (String)object2 + "] -> " + this.cpuName + " -> " + (Object)((Object)this.cpuType) + ", abiVFPArgsAcceptsVFPVariant " + bl);
            }
            this.abiType = this.cpuType.is32Bit ? (bl ? Platform.ABIType.EABI_GNU_ARMHF : Platform.ABIType.EABI_GNU_ARMEL) : elfHeaderPart1.abiType;
        } else {
            this.cpuName = elfHeaderPart1.cpuName;
            this.cpuType = elfHeaderPart1.cpuType;
            this.abiType = elfHeaderPart1.abiType;
        }
        if (ElfHeaderPart1.DEBUG) {
            System.err.println("ELF-2: cpuName " + this.cpuName + " -> " + (Object)((Object)this.cpuType) + ", " + (Object)((Object)this.abiType));
        }
    }

    private static Platform.CPUType queryCPUTypeSafe(String string) {
        Platform.CPUType cPUType;
        block2: {
            cPUType = null;
            try {
                cPUType = Platform.CPUType.query(string);
            }
            catch (Throwable throwable) {
                if (!ElfHeaderPart1.DEBUG) break block2;
                System.err.println("ELF-2: queryCPUTypeSafe(" + string + "): " + throwable.getMessage());
            }
        }
        return cPUType;
    }

    public final short getSize() {
        return this.raw.getE_ehsize();
    }

    public final int getFlags() {
        return this.raw.getE_flags();
    }

    public byte getArmABI() {
        return (byte)((0xFF000000 & this.raw.getE_flags()) >> 24 & 0xFF);
    }

    public int getArmLegacyGCCFlags() {
        int n2 = this.raw.getE_flags();
        return 0 != (0xFF000000 & n2) ? 0x400FFF & n2 : 0;
    }

    public byte getArmFloatMode() {
        int n2 = this.raw.getE_flags();
        if (0 != (0xFF000000 & n2)) {
            if ((0x400 & n2) != 0) {
                return 2;
            }
            if ((0x200 & n2) != 0) {
                return 1;
            }
        }
        return 0;
    }

    public final SectionHeader getSectionHeader(int n2) {
        for (int i2 = 0; i2 < this.sht.length; ++i2) {
            SectionHeader sectionHeader = this.sht[i2];
            if (sectionHeader.getType() != n2) continue;
            return sectionHeader;
        }
        return null;
    }

    public final SectionHeader getSectionHeader(String string) {
        for (int i2 = 0; i2 < this.sht.length; ++i2) {
            SectionHeader sectionHeader = this.sht[i2];
            if (!sectionHeader.getName().equals(string)) continue;
            return sectionHeader;
        }
        return null;
    }

    public final String toString() {
        byte by = this.getArmABI();
        String string = 0 != by ? ", arm[abi " + by + ", lGCC " + this.getArmLegacyGCCFlags() + ", float " + this.getArmFloatMode() + "]" : "";
        return "ELF-2[" + (Object)((Object)this.cpuType) + ", " + (Object)((Object)this.abiType) + ", flags[" + IOUtils.toHexString(this.getFlags()) + string + "], sh-num " + this.sht.length + "]";
    }

    final SectionHeader[] readSectionHeaderTable(RandomAccessFile randomAccessFile) throws IOException, IllegalArgumentException {
        int n2;
        SectionHeader[] sectionHeaderArray;
        int n3;
        Object object;
        Object object2;
        long l2 = this.raw.getE_shoff();
        if (0L == l2) {
            return new SectionHeader[0];
        }
        IOUtils.seek(randomAccessFile, l2);
        short s2 = this.raw.getE_shstrndx();
        short s3 = this.raw.getE_shentsize();
        if (0 == this.raw.getE_shnum()) {
            object2 = new byte[s3];
            IOUtils.readBytes(randomAccessFile, (byte[])object2, 0, s3);
            object = new SectionHeader(this, (byte[])object2, 0, s3, 0);
            n3 = (int)((SectionHeader)object).raw.getSh_size();
            if (0 >= n3) {
                throw new IllegalArgumentException("EHdr sh_num == 0 and 1st SHdr size == 0");
            }
            sectionHeaderArray = new SectionHeader[n3];
            sectionHeaderArray[0] = object;
            n2 = 1;
        } else {
            n3 = this.raw.getE_shnum();
            sectionHeaderArray = new SectionHeader[n3];
            n2 = 0;
        }
        while (n2 < n3) {
            object2 = new byte[s3];
            IOUtils.readBytes(randomAccessFile, (byte[])object2, 0, s3);
            sectionHeaderArray[n2] = new SectionHeader(this, (byte[])object2, 0, s3, n2);
            ++n2;
        }
        if (0 != s2) {
            if (IOUtils.shortToInt((short)-256) <= s2) {
                throw new InternalError("TODO strndx: -256 < " + s2);
            }
            object2 = sectionHeaderArray[s2];
            if (3 != ((SectionHeader)object2).getType()) {
                throw new IllegalArgumentException("Ref. string Shdr[" + s2 + "] is of type " + ((SectionHeader)object2).raw.getSh_type());
            }
            object = ((SectionHeader)object2).readSection(randomAccessFile);
            for (n2 = 0; n2 < n3; ++n2) {
                sectionHeaderArray[n2].initName((Section)object, sectionHeaderArray[n2].raw.getSh_name());
            }
        }
        return sectionHeaderArray;
    }
}

