/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.core.util;

import com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class Fields {
    public static Field locate(Class definedIn, Class fieldType, boolean isStatic) {
        AccessibleObject field = null;
        try {
            Field[] fields = definedIn.getDeclaredFields();
            for (int i2 = 0; i2 < fields.length; ++i2) {
                if (Modifier.isStatic(fields[i2].getModifiers()) != isStatic || !fieldType.isAssignableFrom(fields[i2].getType())) continue;
                field = fields[i2];
            }
            if (field != null && !field.isAccessible()) {
                ((Field)field).setAccessible(true);
            }
        }
        catch (SecurityException e2) {
        }
        catch (NoClassDefFoundError e3) {
            // empty catch block
        }
        return field;
    }

    public static Field find(Class type, String name) {
        try {
            Field result = type.getDeclaredField(name);
            if (!result.isAccessible()) {
                result.setAccessible(true);
            }
            return result;
        }
        catch (NoSuchFieldException e2) {
            throw new IllegalArgumentException("Could not access " + type.getName() + "." + name + " field: " + e2.getMessage());
        }
        catch (NoClassDefFoundError e3) {
            throw new ObjectAccessException("Could not access " + type.getName() + "." + name + " field: " + e3.getMessage());
        }
    }

    public static void write(Field field, Object instance, Object value) {
        try {
            field.set(instance, value);
        }
        catch (IllegalAccessException e2) {
            throw new ObjectAccessException("Could not write " + field.getType().getName() + "." + field.getName() + " field", e2);
        }
        catch (NoClassDefFoundError e3) {
            throw new ObjectAccessException("Could not write " + field.getType().getName() + "." + field.getName() + " field", e3);
        }
    }

    public static Object read(Field field, Object instance) {
        try {
            return field.get(instance);
        }
        catch (IllegalAccessException e2) {
            throw new ObjectAccessException("Could not read " + field.getType().getName() + "." + field.getName() + " field", e2);
        }
        catch (NoClassDefFoundError e3) {
            throw new ObjectAccessException("Could not read " + field.getType().getName() + "." + field.getName() + " field", e3);
        }
    }
}

