/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.core.util;

import com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import com.thoughtworks.xstream.core.util.Primitives;
import com.thoughtworks.xstream.core.util.TypedNull;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.List;

public class DependencyInjectionFactory {
    public static Object newInstance(Class type, Object[] dependencies) {
        return DependencyInjectionFactory.newInstance(type, dependencies, null);
    }

    public static Object newInstance(Class type, Object[] dependencies, BitSet usedDependencies) {
        if (dependencies != null && dependencies.length > 63) {
            throw new IllegalArgumentException("More than 63 arguments are not supported");
        }
        Constructor<?> bestMatchingCtor = null;
        ArrayList<Object> matchingDependencies = new ArrayList<Object>();
        List possibleMatchingDependencies = null;
        long usedDeps = 0L;
        long possibleUsedDeps = 0L;
        if (dependencies != null && dependencies.length > 0) {
            Constructor<?>[] ctors = type.getConstructors();
            if (ctors.length > 1) {
                Arrays.sort(ctors, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        return ((Constructor)o2).getParameterTypes().length - ((Constructor)o1).getParameterTypes().length;
                    }
                });
            }
            TypedValue[] typedDependencies = new TypedValue[dependencies.length];
            for (int i2 = 0; i2 < dependencies.length; ++i2) {
                Object dependency = dependencies[i2];
                Class depType = dependency.getClass();
                if (depType.isPrimitive()) {
                    depType = Primitives.box(depType);
                } else if (depType == TypedNull.class) {
                    depType = ((TypedNull)dependency).getType();
                    dependency = null;
                }
                typedDependencies[i2] = new TypedValue(depType, dependency);
            }
            Constructor<?> possibleCtor = null;
            int arity = Integer.MAX_VALUE;
            for (int i3 = 0; bestMatchingCtor == null && i3 < ctors.length; ++i3) {
                int j2;
                Constructor<?> constructor = ctors[i3];
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                if (parameterTypes.length > dependencies.length) continue;
                if (parameterTypes.length == 0) {
                    if (possibleCtor != null) break;
                    bestMatchingCtor = constructor;
                    break;
                }
                if (arity > parameterTypes.length) {
                    if (possibleCtor != null) continue;
                    arity = parameterTypes.length;
                }
                for (j2 = 0; j2 < parameterTypes.length; ++j2) {
                    if (!parameterTypes[j2].isPrimitive()) continue;
                    parameterTypes[j2] = Primitives.box(parameterTypes[j2]);
                }
                matchingDependencies.clear();
                usedDeps = 0L;
                j2 = 0;
                int k2 = 0;
                while (j2 < parameterTypes.length && parameterTypes.length + k2 - j2 <= typedDependencies.length) {
                    if (parameterTypes[j2].isAssignableFrom(typedDependencies[k2].type)) {
                        matchingDependencies.add(typedDependencies[k2].value);
                        usedDeps |= 1L << k2;
                        if (++j2 == parameterTypes.length) {
                            bestMatchingCtor = constructor;
                            break;
                        }
                    }
                    ++k2;
                }
                if (bestMatchingCtor != null) continue;
                boolean possible = true;
                TypedValue[] deps = new TypedValue[typedDependencies.length];
                System.arraycopy(typedDependencies, 0, deps, 0, deps.length);
                matchingDependencies.clear();
                usedDeps = 0L;
                for (int j3 = 0; j3 < parameterTypes.length; ++j3) {
                    int assignable = -1;
                    for (int k3 = 0; k3 < deps.length; ++k3) {
                        if (deps[k3] == null) continue;
                        if (deps[k3].type == parameterTypes[j3]) {
                            assignable = k3;
                            break;
                        }
                        if (!parameterTypes[j3].isAssignableFrom(deps[k3].type) || assignable >= 0 && (deps[assignable].type == deps[k3].type || !deps[assignable].type.isAssignableFrom(deps[k3].type))) continue;
                        assignable = k3;
                    }
                    if (assignable >= 0) {
                        matchingDependencies.add(deps[assignable].value);
                        usedDeps |= 1L << assignable;
                    } else {
                        possible = false;
                        break;
                    }
                    deps[assignable] = null;
                }
                if (!possible || possibleCtor != null && usedDeps >= possibleUsedDeps) continue;
                possibleCtor = constructor;
                possibleMatchingDependencies = (List)matchingDependencies.clone();
                possibleUsedDeps = usedDeps;
            }
            if (bestMatchingCtor == null) {
                if (possibleCtor == null) {
                    usedDeps = 0L;
                    throw new ObjectAccessException("Cannot construct " + type.getName() + ", none of the dependencies match any constructor's parameters");
                }
                bestMatchingCtor = possibleCtor;
                matchingDependencies.clear();
                matchingDependencies.addAll(possibleMatchingDependencies);
                usedDeps = possibleUsedDeps;
            }
        }
        try {
            Object instance = bestMatchingCtor == null ? type.newInstance() : bestMatchingCtor.newInstance(matchingDependencies.toArray());
            if (usedDependencies != null) {
                usedDependencies.clear();
                int i4 = 0;
                long l2 = 1L;
                while (l2 < usedDeps) {
                    if ((usedDeps & l2) > 0L) {
                        usedDependencies.set(i4);
                    }
                    l2 <<= 1;
                    ++i4;
                }
            }
            return instance;
        }
        catch (InstantiationException e2) {
            throw new ObjectAccessException("Cannot construct " + type.getName(), e2);
        }
        catch (IllegalAccessException e3) {
            throw new ObjectAccessException("Cannot construct " + type.getName(), e3);
        }
        catch (InvocationTargetException e4) {
            throw new ObjectAccessException("Cannot construct " + type.getName(), e4);
        }
        catch (SecurityException e5) {
            throw new ObjectAccessException("Cannot construct " + type.getName(), e5);
        }
        catch (ExceptionInInitializerError e6) {
            throw new ObjectAccessException("Cannot construct " + type.getName(), e6);
        }
    }

    private static class TypedValue {
        final Class type;
        final Object value;

        public TypedValue(Class type, Object value) {
            this.type = type;
            this.value = value;
        }

        public String toString() {
            return this.type.getName() + ":" + this.value;
        }
    }
}

