/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.reflection;

import com.thoughtworks.xstream.converters.reflection.FieldDictionary;
import com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.WeakHashMap;
import sun.misc.Unsafe;

public class Sun14ReflectionProvider
extends PureJavaReflectionProvider {
    private static final Unsafe unsafe;
    private static final Exception exception;
    private transient Map fieldOffsetCache;

    public Sun14ReflectionProvider() {
    }

    public Sun14ReflectionProvider(FieldDictionary dic) {
        super(dic);
    }

    public Object newInstance(Class type) {
        if (exception != null) {
            throw new ObjectAccessException("Cannot construct " + type.getName(), exception);
        }
        try {
            return unsafe.allocateInstance(type);
        }
        catch (SecurityException e2) {
            throw new ObjectAccessException("Cannot construct " + type.getName(), e2);
        }
        catch (InstantiationException e3) {
            throw new ObjectAccessException("Cannot construct " + type.getName(), e3);
        }
        catch (IllegalArgumentException e4) {
            throw new ObjectAccessException("Cannot construct " + type.getName(), e4);
        }
    }

    public void writeField(Object object, String fieldName, Object value, Class definedIn) {
        this.write(this.fieldDictionary.field(object.getClass(), fieldName, definedIn), object, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void write(Field field, Object object, Object value) {
        if (exception != null) {
            throw new ObjectAccessException("Could not set field " + object.getClass() + "." + field.getName(), exception);
        }
        try {
            long offset = this.getFieldOffset(field);
            Class<?> type = field.getType();
            if (type.isPrimitive()) {
                if (type.equals(Integer.TYPE)) {
                    unsafe.putInt(object, offset, (Integer)value);
                    return;
                } else if (type.equals(Long.TYPE)) {
                    unsafe.putLong(object, offset, (Long)value);
                    return;
                } else if (type.equals(Short.TYPE)) {
                    unsafe.putShort(object, offset, (Short)value);
                    return;
                } else if (type.equals(Character.TYPE)) {
                    unsafe.putChar(object, offset, ((Character)value).charValue());
                    return;
                } else if (type.equals(Byte.TYPE)) {
                    unsafe.putByte(object, offset, (Byte)value);
                    return;
                } else if (type.equals(Float.TYPE)) {
                    unsafe.putFloat(object, offset, ((Float)value).floatValue());
                    return;
                } else if (type.equals(Double.TYPE)) {
                    unsafe.putDouble(object, offset, (Double)value);
                    return;
                } else {
                    if (!type.equals(Boolean.TYPE)) throw new ObjectAccessException("Could not set field " + object.getClass() + "." + field.getName() + ": Unknown type " + type);
                    unsafe.putBoolean(object, offset, (Boolean)value);
                }
                return;
            } else {
                unsafe.putObject(object, offset, value);
            }
            return;
        }
        catch (IllegalArgumentException e2) {
            throw new ObjectAccessException("Could not set field " + object.getClass() + "." + field.getName(), e2);
        }
    }

    private synchronized long getFieldOffset(Field f2) {
        Long l2 = (Long)this.fieldOffsetCache.get(f2);
        if (l2 == null) {
            l2 = new Long(unsafe.objectFieldOffset(f2));
            this.fieldOffsetCache.put(f2, l2);
        }
        return l2;
    }

    protected void validateFieldAccess(Field field) {
    }

    private Object readResolve() {
        this.init();
        return this;
    }

    protected void init() {
        super.init();
        this.fieldOffsetCache = new WeakHashMap();
    }

    static {
        Unsafe u2 = null;
        Exception ex = null;
        try {
            Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            u2 = (Unsafe)unsafeField.get(null);
        }
        catch (SecurityException e2) {
            ex = e2;
        }
        catch (NoSuchFieldException e3) {
            ex = e3;
        }
        catch (IllegalArgumentException e4) {
            ex = e4;
        }
        catch (IllegalAccessException e5) {
            ex = e5;
        }
        exception = ex;
        unsafe = u2;
    }
}

