/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util.texture;

import com.jogamp.common.util.IOUtil;
import com.jogamp.nativewindow.util.Dimension;
import com.jogamp.nativewindow.util.PixelFormat;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2GL3;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.util.GLPixelBuffer;
import com.jogamp.opengl.util.GLPixelStorageModes;
import com.jogamp.opengl.util.PNGPixelRect;
import com.jogamp.opengl.util.texture.ImageType;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.spi.DDSImage;
import com.jogamp.opengl.util.texture.spi.JPEGImage;
import com.jogamp.opengl.util.texture.spi.NetPbmTextureWriter;
import com.jogamp.opengl.util.texture.spi.SGIImage;
import com.jogamp.opengl.util.texture.spi.TGAImage;
import com.jogamp.opengl.util.texture.spi.TextureProvider;
import com.jogamp.opengl.util.texture.spi.TextureWriter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jogamp.opengl.Debug;

public class TextureIO {
    public static final String DDS = "dds";
    public static final String SGI = "sgi";
    public static final String SGI_RGB = "rgb";
    public static final String GIF = "gif";
    public static final String JPG = "jpg";
    public static final String PNG = "png";
    public static final String TGA = "tga";
    public static final String TIFF = "tiff";
    public static final String PAM = "pam";
    public static final String PPM = "ppm";
    private static final boolean DEBUG;
    private static boolean texRectEnabled;
    private static List<TextureProvider> textureProviders;
    private static Map<ImageType, TextureProvider> imageType2TextureProvider;
    private static List<TextureWriter> textureWriters;

    public static TextureData newTextureData(GLProfile gLProfile, File file, boolean bl, String string) throws IOException {
        if (string == null) {
            string = IOUtil.getFileSuffix(file);
        }
        return TextureIO.newTextureDataImpl(gLProfile, file, 0, 0, bl, string);
    }

    public static TextureData newTextureData(GLProfile gLProfile, InputStream inputStream, boolean bl, String string) throws IOException {
        return TextureIO.newTextureDataImpl(gLProfile, inputStream, 0, 0, bl, string);
    }

    public static TextureData newTextureData(GLProfile gLProfile, URL uRL, boolean bl, String string) throws IOException {
        if (string == null) {
            string = IOUtil.getFileSuffix(uRL.getPath());
        }
        return TextureIO.newTextureDataImpl(gLProfile, uRL, 0, 0, bl, string);
    }

    public static TextureData newTextureData(GLProfile gLProfile, File file, int n2, int n3, boolean bl, String string) throws IOException, IllegalArgumentException {
        if (n2 == 0 || n3 == 0) {
            throw new IllegalArgumentException("internalFormat and pixelFormat must be non-zero");
        }
        if (string == null) {
            string = IOUtil.getFileSuffix(file);
        }
        return TextureIO.newTextureDataImpl(gLProfile, file, n2, n3, bl, string);
    }

    public static TextureData newTextureData(GLProfile gLProfile, InputStream inputStream, int n2, int n3, boolean bl, String string) throws IOException, IllegalArgumentException {
        if (n2 == 0 || n3 == 0) {
            throw new IllegalArgumentException("internalFormat and pixelFormat must be non-zero");
        }
        return TextureIO.newTextureDataImpl(gLProfile, inputStream, n2, n3, bl, string);
    }

    public static TextureData newTextureData(GLProfile gLProfile, URL uRL, int n2, int n3, boolean bl, String string) throws IOException, IllegalArgumentException {
        if (n2 == 0 || n3 == 0) {
            throw new IllegalArgumentException("internalFormat and pixelFormat must be non-zero");
        }
        if (string == null) {
            string = IOUtil.getFileSuffix(uRL.getPath());
        }
        return TextureIO.newTextureDataImpl(gLProfile, uRL, n2, n3, bl, string);
    }

    public static Texture newTexture(TextureData textureData) throws GLException, IllegalArgumentException {
        return TextureIO.newTexture(GLContext.getCurrentGL(), textureData);
    }

    public static Texture newTexture(GL gL, TextureData textureData) throws GLException, IllegalArgumentException {
        if (textureData == null) {
            throw new IllegalArgumentException("Null TextureData");
        }
        return new Texture(gL, textureData);
    }

    public static Texture newTexture(File file, boolean bl) throws IOException, GLException {
        GL gL = GLContext.getCurrentGL();
        GLProfile gLProfile = gL.getGLProfile();
        TextureData textureData = TextureIO.newTextureData(gLProfile, file, bl, IOUtil.getFileSuffix(file));
        Texture texture = TextureIO.newTexture(gL, textureData);
        textureData.flush();
        return texture;
    }

    public static Texture newTexture(InputStream inputStream, boolean bl, String string) throws IOException, GLException {
        GL gL = GLContext.getCurrentGL();
        GLProfile gLProfile = gL.getGLProfile();
        TextureData textureData = TextureIO.newTextureData(gLProfile, inputStream, bl, string);
        Texture texture = TextureIO.newTexture(gL, textureData);
        textureData.flush();
        return texture;
    }

    public static Texture newTexture(URL uRL, boolean bl, String string) throws IOException, GLException {
        if (string == null) {
            string = IOUtil.getFileSuffix(uRL.getPath());
        }
        GL gL = GLContext.getCurrentGL();
        GLProfile gLProfile = gL.getGLProfile();
        TextureData textureData = TextureIO.newTextureData(gLProfile, uRL, bl, string);
        Texture texture = TextureIO.newTexture(gL, textureData);
        textureData.flush();
        return texture;
    }

    public static Texture newTexture(int n2) {
        return new Texture(n2);
    }

    public static void write(Texture texture, File file) throws IOException, GLException {
        if (texture.getTarget() != 3553) {
            throw new GLException("Only GL_TEXTURE_2D textures are supported");
        }
        GL gL = GLContext.getCurrentGL();
        if (!gL.isGL2GL3()) {
            throw new GLException("Implementation only supports GL2GL3 (Use GLReadBufferUtil and the TextureData variant), have: " + gL);
        }
        GL2GL3 gL2GL3 = gL.getGL2GL3();
        texture.bind(gL2GL3);
        int n2 = TextureIO.glGetTexLevelParameteri(gL2GL3, 3553, 0, 4099);
        int n3 = TextureIO.glGetTexLevelParameteri(gL2GL3, 3553, 0, 4096);
        int n4 = TextureIO.glGetTexLevelParameteri(gL2GL3, 3553, 0, 4097);
        int n5 = TextureIO.glGetTexLevelParameteri(gL2GL3, 3553, 0, 4101);
        TextureData textureData = null;
        if (n2 == 33776 || n2 == 33777 || n2 == 33778 || n2 == 33779) {
            int n6 = TextureIO.glGetTexLevelParameteri(gL2GL3, 3553, 0, 34464);
            ByteBuffer byteBuffer = ByteBuffer.allocate(n6);
            gL2GL3.glGetCompressedTexImage(3553, 0, byteBuffer);
            textureData = new TextureData(gL2GL3.getGLProfile(), n2, n3, n4, n5, n2, 5121, false, true, true, byteBuffer, null);
        } else {
            int n7 = 0;
            int n8 = 0;
            switch (n2) {
                case 6407: 
                case 32849: 
                case 32992: {
                    n7 = 3;
                    n8 = 6407;
                    break;
                }
                case 6408: 
                case 32768: 
                case 32856: 
                case 32993: {
                    n7 = 4;
                    n8 = 6408;
                    break;
                }
                default: {
                    throw new IOException("Unsupported texture internal format 0x" + Integer.toHexString(n2));
                }
            }
            GLPixelStorageModes gLPixelStorageModes = new GLPixelStorageModes();
            gLPixelStorageModes.setPackAlignment(gL2GL3, 1);
            ByteBuffer byteBuffer = ByteBuffer.allocate((n3 + 2 * n5) * (n4 + 2 * n5) * n7);
            if (DEBUG) {
                System.out.println("Allocated buffer of size " + byteBuffer.remaining() + " for fetched image (" + (n8 == 6407 ? "GL_RGB" : "GL_RGBA") + ")");
            }
            gL2GL3.glGetTexImage(3553, 0, n8, 5121, byteBuffer);
            gLPixelStorageModes.restore(gL2GL3);
            textureData = new TextureData(gL2GL3.getGLProfile(), n2, n3, n4, n5, n8, 5121, false, false, false, byteBuffer, null);
            if (DEBUG) {
                System.out.println("data.getPixelFormat() = " + (textureData.getPixelFormat() == 6407 ? "GL_RGB" : "GL_RGBA"));
            }
        }
        TextureIO.write(textureData, file);
    }

    public static void write(TextureData textureData, File file) throws IOException, GLException {
        for (TextureWriter textureWriter : textureWriters) {
            if (!textureWriter.write(file, textureData)) continue;
            return;
        }
        throw new IOException("No suitable texture writer found for " + file.getAbsolutePath());
    }

    public static void addTextureProvider(TextureProvider textureProvider) {
        textureProviders.add(0, textureProvider);
        ImageType[] imageTypeArray = textureProvider.getImageTypes();
        if (null != imageTypeArray) {
            for (int i2 = 0; i2 < imageTypeArray.length; ++i2) {
                imageType2TextureProvider.put(imageTypeArray[i2], textureProvider);
            }
        }
    }

    public static void addTextureWriter(TextureWriter textureWriter) {
        textureWriters.add(0, textureWriter);
    }

    public static void setTexRectEnabled(boolean bl) {
        texRectEnabled = bl;
    }

    public static boolean isTexRectEnabled() {
        return texRectEnabled;
    }

    private static TextureData newTextureDataImpl(GLProfile gLProfile, InputStream inputStream, int n2, int n3, boolean bl, String string) throws IOException {
        TextureData textureData;
        block6: {
            if (inputStream == null) {
                throw new IOException("Stream was null");
            }
            if (!(inputStream instanceof BufferedInputStream)) {
                inputStream = new BufferedInputStream(inputStream);
            }
            try {
                TextureProvider textureProvider;
                ImageType imageType = new ImageType(inputStream);
                if (imageType.isDefined() && null != (textureProvider = imageType2TextureProvider.get(imageType)) && (textureData = textureProvider.newTextureData(gLProfile, inputStream, n2, n3, bl, imageType.type)) != null) {
                    textureData.srcImageType = imageType;
                    return textureData;
                }
            }
            catch (IOException iOException) {
                if (!DEBUG) break block6;
                System.err.println("Caught " + iOException.getMessage());
                iOException.printStackTrace();
            }
        }
        string = TextureIO.toLowerCase(string);
        for (TextureProvider textureProvider : textureProviders) {
            textureData = textureProvider.newTextureData(gLProfile, inputStream, n2, n3, bl, string);
            if (textureData == null) continue;
            ImageType[] imageTypeArray = textureProvider.getImageTypes();
            textureData.srcImageType = null != imageTypeArray ? imageTypeArray[0] : null;
            return textureData;
        }
        throw new IOException("No suitable reader for given stream");
    }

    private static TextureData newTextureDataImpl(GLProfile gLProfile, File file, int n2, int n3, boolean bl, String string) throws IOException {
        if (file == null) {
            throw new IOException("File was null");
        }
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));){
            TextureData textureData = TextureIO.newTextureDataImpl(gLProfile, bufferedInputStream, n2, n3, bl, string != null ? string : IOUtil.getFileSuffix(file));
            return textureData;
        }
    }

    private static TextureData newTextureDataImpl(GLProfile gLProfile, URL uRL, int n2, int n3, boolean bl, String string) throws IOException {
        if (uRL == null) {
            throw new IOException("URL was null");
        }
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());){
            TextureData textureData = TextureIO.newTextureDataImpl(gLProfile, bufferedInputStream, n2, n3, bl, string);
            return textureData;
        }
    }

    private static int glGetTexLevelParameteri(GL2GL3 gL2GL3, int n2, int n3, int n4) {
        int[] nArray = new int[1];
        gL2GL3.glGetTexLevelParameteriv(n2, 0, n4, nArray, 0);
        return nArray[0];
    }

    private static String toLowerCase(String string) {
        if (string == null) {
            return null;
        }
        return string.toLowerCase();
    }

    static {
        block9: {
            Object object;
            block8: {
                DEBUG = Debug.debug("TextureIO");
                texRectEnabled = true;
                textureProviders = new ArrayList<TextureProvider>();
                imageType2TextureProvider = new HashMap<ImageType, TextureProvider>();
                textureWriters = new ArrayList<TextureWriter>();
                if (GLProfile.isAWTAvailable()) {
                    try {
                        object = (TextureProvider)Class.forName("com.jogamp.opengl.util.texture.spi.awt.IIOTextureProvider").newInstance();
                        TextureIO.addTextureProvider((TextureProvider)object);
                    }
                    catch (Exception exception) {
                        if (!DEBUG) break block8;
                        exception.printStackTrace();
                    }
                }
            }
            TextureIO.addTextureProvider(new DDSTextureProvider());
            TextureIO.addTextureProvider(new SGITextureProvider());
            TextureIO.addTextureProvider(new TGATextureProvider());
            TextureIO.addTextureProvider(new JPGTextureProvider());
            TextureIO.addTextureProvider(new PNGTextureProvider());
            if (GLProfile.isAWTAvailable()) {
                try {
                    object = (TextureWriter)Class.forName("com.jogamp.opengl.util.texture.spi.awt.IIOTextureWriter").newInstance();
                    TextureIO.addTextureWriter((TextureWriter)object);
                }
                catch (Exception exception) {
                    if (DEBUG) {
                        exception.printStackTrace();
                    }
                }
                catch (Error error) {
                    if (!DEBUG) break block9;
                    error.printStackTrace();
                }
            }
        }
        TextureIO.addTextureWriter(new DDSTextureWriter());
        TextureIO.addTextureWriter(new SGITextureWriter());
        TextureIO.addTextureWriter(new TGATextureWriter());
        TextureIO.addTextureWriter(new NetPbmTextureWriter());
        TextureIO.addTextureWriter(new PNGTextureWriter());
    }

    static class PNGTextureWriter
    implements TextureWriter {
        PNGTextureWriter() {
        }

        @Override
        public boolean write(File file, TextureData textureData) throws IOException {
            if (TextureIO.PNG.equals(IOUtil.getFileSuffix(file))) {
                GLPixelBuffer.GLPixelAttributes gLPixelAttributes = textureData.getPixelAttributes();
                int n2 = gLPixelAttributes.format;
                int n3 = gLPixelAttributes.type;
                int n4 = gLPixelAttributes.pfmt.comp.bytesPerPixel();
                PixelFormat pixelFormat = gLPixelAttributes.pfmt;
                if (!(1 != n4 && 3 != n4 && 4 != n4 || n3 != 5120 && n3 != 5121)) {
                    Buffer buffer = textureData.getBuffer();
                    if (null == buffer) {
                        buffer = textureData.getMipmapData()[0];
                    }
                    if (null == buffer) {
                        throw new IOException("Pixel storage buffer is null");
                    }
                    Dimension dimension = new Dimension(textureData.getWidth(), textureData.getHeight());
                    if (buffer instanceof ByteBuffer) {
                        ByteBuffer byteBuffer = (ByteBuffer)buffer;
                        byteBuffer.rewind();
                        PNGPixelRect pNGPixelRect = new PNGPixelRect(pixelFormat, dimension, 0, !textureData.getMustFlipVertically(), byteBuffer, -1.0, -1.0);
                        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(IOUtil.getFileOutputStream(file, true));
                        pNGPixelRect.write(bufferedOutputStream, true);
                        return true;
                    }
                    if (buffer instanceof IntBuffer) {
                        IntBuffer intBuffer = (IntBuffer)buffer;
                        intBuffer.rewind();
                        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(IOUtil.getFileOutputStream(file, true));
                        PNGPixelRect.write(pixelFormat, dimension, 0, !textureData.getMustFlipVertically(), intBuffer, -1.0, -1.0, bufferedOutputStream, true);
                        return true;
                    }
                    throw new IOException("PNG writer doesn't support pixel storage buffer of type " + buffer.getClass().getName());
                }
                throw new IOException("PNG writer doesn't support this pixel format 0x" + Integer.toHexString(n2) + " / type 0x" + Integer.toHexString(n2) + " (only GL_RGB/A, GL_BGR/A + bytes)");
            }
            return false;
        }
    }

    static class TGATextureWriter
    implements TextureWriter {
        TGATextureWriter() {
        }

        @Override
        public boolean write(File file, TextureData textureData) throws IOException {
            if (TextureIO.TGA.equals(IOUtil.getFileSuffix(file))) {
                GLPixelBuffer.GLPixelAttributes gLPixelAttributes = textureData.getPixelAttributes();
                int n2 = gLPixelAttributes.format;
                int n3 = gLPixelAttributes.type;
                if (!(n2 != 6407 && n2 != 6408 && n2 != 32992 && n2 != 32993 || n3 != 5120 && n3 != 5121)) {
                    ByteBuffer byteBuffer = (ByteBuffer)textureData.getBuffer();
                    if (null == byteBuffer) {
                        byteBuffer = (ByteBuffer)textureData.getMipmapData()[0];
                    }
                    byteBuffer.rewind();
                    if (n2 == 6407 || n2 == 6408) {
                        int n4 = n2 == 6407 ? 3 : 4;
                        for (int i2 = 0; i2 < byteBuffer.remaining(); i2 += n4) {
                            byte by = byteBuffer.get(i2 + 0);
                            byte by2 = byteBuffer.get(i2 + 2);
                            byteBuffer.put(i2 + 0, by2);
                            byteBuffer.put(i2 + 2, by);
                        }
                    }
                    TGAImage tGAImage = TGAImage.createFromData(textureData.getWidth(), textureData.getHeight(), n2 == 6408 || n2 == 32993, false, byteBuffer);
                    tGAImage.write(file);
                    return true;
                }
                throw new IOException("TGA writer doesn't support this pixel format 0x" + Integer.toHexString(n2) + " / type 0x" + Integer.toHexString(n2) + " (only GL_RGB/A, GL_BGR/A + bytes)");
            }
            return false;
        }
    }

    static class SGITextureWriter
    implements TextureWriter {
        SGITextureWriter() {
        }

        @Override
        public boolean write(File file, TextureData textureData) throws IOException {
            String string = IOUtil.getFileSuffix(file);
            if (TextureIO.SGI.equals(string) || TextureIO.SGI_RGB.equals(string)) {
                GLPixelBuffer.GLPixelAttributes gLPixelAttributes = textureData.getPixelAttributes();
                int n2 = gLPixelAttributes.format;
                int n3 = gLPixelAttributes.type;
                if (!(n2 != 6407 && n2 != 6408 || n3 != 5120 && n3 != 5121)) {
                    byte[] byArray;
                    ByteBuffer byteBuffer;
                    ByteBuffer byteBuffer2 = byteBuffer = textureData.getBuffer() != null ? (ByteBuffer)textureData.getBuffer() : (ByteBuffer)textureData.getMipmapData()[0];
                    if (byteBuffer.hasArray()) {
                        byArray = byteBuffer.array();
                    } else {
                        byteBuffer.rewind();
                        byArray = new byte[byteBuffer.remaining()];
                        byteBuffer.get(byArray);
                        byteBuffer.rewind();
                    }
                    SGIImage sGIImage = SGIImage.createFromData(textureData.getWidth(), textureData.getHeight(), n2 == 6408, byArray);
                    sGIImage.write(file, false);
                    return true;
                }
                throw new IOException("SGI writer doesn't support this pixel format / type (only GL_RGB/A + bytes)");
            }
            return false;
        }
    }

    static class DDSTextureWriter
    implements TextureWriter {
        DDSTextureWriter() {
        }

        @Override
        public boolean write(File file, TextureData textureData) throws IOException {
            if (TextureIO.DDS.equals(IOUtil.getFileSuffix(file))) {
                GLPixelBuffer.GLPixelAttributes gLPixelAttributes = textureData.getPixelAttributes();
                int n2 = gLPixelAttributes.format;
                int n3 = gLPixelAttributes.type;
                if (n3 != 5120 && n3 != 5121) {
                    throw new IOException("DDS writer only supports byte / unsigned byte textures");
                }
                int n4 = 0;
                switch (n2) {
                    case 6407: {
                        n4 = 20;
                        break;
                    }
                    case 6408: {
                        n4 = 21;
                        break;
                    }
                    case 33776: {
                        n4 = 827611204;
                        break;
                    }
                    case 33777: {
                        throw new IOException("RGBA DXT1 not yet supported");
                    }
                    case 33778: {
                        n4 = 861165636;
                        break;
                    }
                    case 33779: {
                        n4 = 894720068;
                        break;
                    }
                    default: {
                        throw new IOException("Unsupported pixel format 0x" + Integer.toHexString(n2) + " by DDS writer");
                    }
                }
                ByteBuffer[] byteBufferArray = null;
                if (textureData.getMipmapData() != null) {
                    byteBufferArray = new ByteBuffer[textureData.getMipmapData().length];
                    for (int i2 = 0; i2 < byteBufferArray.length; ++i2) {
                        byteBufferArray[i2] = (ByteBuffer)textureData.getMipmapData()[i2];
                    }
                } else {
                    byteBufferArray = new ByteBuffer[]{(ByteBuffer)textureData.getBuffer()};
                }
                DDSImage dDSImage = DDSImage.createFromData(n4, textureData.getWidth(), textureData.getHeight(), byteBufferArray);
                dDSImage.write(file);
                return true;
            }
            return false;
        }
    }

    static class JPGTextureProvider
    implements TextureProvider {
        private static final ImageType[] imageTypes = new ImageType[]{new ImageType("jpg")};

        JPGTextureProvider() {
        }

        @Override
        public final ImageType[] getImageTypes() {
            return imageTypes;
        }

        @Override
        public TextureData newTextureData(GLProfile gLProfile, InputStream inputStream, int n2, int n3, boolean bl, String string) throws IOException {
            if (TextureIO.JPG.equals(string) || TextureIO.JPG.equals(ImageType.Util.getFileSuffix(inputStream))) {
                JPEGImage jPEGImage = JPEGImage.read(inputStream);
                if (n3 == 0) {
                    n3 = jPEGImage.getGLFormat();
                }
                if (n2 == 0) {
                    n2 = gLProfile.isGL2ES3() ? (jPEGImage.getBytesPerPixel() == 4 ? 32856 : 32849) : (jPEGImage.getBytesPerPixel() == 4 ? 6408 : 6407);
                }
                return new TextureData(gLProfile, n2, jPEGImage.getWidth(), jPEGImage.getHeight(), 0, n3, jPEGImage.getGLType(), bl, false, false, jPEGImage.getData(), null);
            }
            return null;
        }
    }

    static class PNGTextureProvider
    implements TextureProvider {
        private static final ImageType[] imageTypes = new ImageType[]{new ImageType("png")};

        PNGTextureProvider() {
        }

        @Override
        public final ImageType[] getImageTypes() {
            return imageTypes;
        }

        @Override
        public TextureData newTextureData(GLProfile gLProfile, InputStream inputStream, int n2, int n3, boolean bl, String string) throws IOException {
            if (TextureIO.PNG.equals(string) || TextureIO.PNG.equals(ImageType.Util.getFileSuffix(inputStream))) {
                PNGPixelRect pNGPixelRect = PNGPixelRect.read(inputStream, null, true, 0, true);
                GLPixelBuffer.GLPixelAttributes gLPixelAttributes = new GLPixelBuffer.GLPixelAttributes(gLProfile, pNGPixelRect.getPixelformat(), false);
                if (0 == n3) {
                    n3 = gLPixelAttributes.format;
                }
                if (0 == n2) {
                    boolean bl2;
                    boolean bl3 = bl2 = 4 == gLPixelAttributes.pfmt.comp.bytesPerPixel();
                    n2 = gLProfile.isGL2ES3() ? (bl2 ? 32856 : 32849) : (bl2 ? 6408 : 6407);
                }
                return new TextureData(gLProfile, n2, pNGPixelRect.getSize().getWidth(), pNGPixelRect.getSize().getHeight(), 0, n3, gLPixelAttributes.type, bl, false, false, pNGPixelRect.getPixels(), null);
            }
            return null;
        }
    }

    static class TGATextureProvider
    implements TextureProvider {
        private static final ImageType[] imageTypes = new ImageType[]{new ImageType("tga")};

        TGATextureProvider() {
        }

        @Override
        public final ImageType[] getImageTypes() {
            return imageTypes;
        }

        @Override
        public TextureData newTextureData(GLProfile gLProfile, InputStream inputStream, int n2, int n3, boolean bl, String string) throws IOException {
            if (TextureIO.TGA.equals(string)) {
                TGAImage tGAImage = TGAImage.read(gLProfile, inputStream);
                if (n3 == 0) {
                    n3 = tGAImage.getGLFormat();
                }
                if (n2 == 0) {
                    n2 = gLProfile.isGL2ES3() ? (tGAImage.getBytesPerPixel() == 4 ? 32856 : 32849) : (tGAImage.getBytesPerPixel() == 4 ? 6408 : 6407);
                }
                return new TextureData(gLProfile, n2, tGAImage.getWidth(), tGAImage.getHeight(), 0, n3, 5121, bl, false, false, tGAImage.getData(), null);
            }
            return null;
        }
    }

    static class SGITextureProvider
    implements TextureProvider {
        private static final ImageType[] imageTypes = new ImageType[]{new ImageType("rgb")};

        SGITextureProvider() {
        }

        @Override
        public final ImageType[] getImageTypes() {
            return imageTypes;
        }

        @Override
        public TextureData newTextureData(GLProfile gLProfile, InputStream inputStream, int n2, int n3, boolean bl, String string) throws IOException {
            if (TextureIO.SGI.equals(string) || TextureIO.SGI_RGB.equals(string) || TextureIO.SGI.equals(ImageType.Util.getFileSuffix(inputStream)) || TextureIO.SGI_RGB.equals(ImageType.Util.getFileSuffix(inputStream))) {
                SGIImage sGIImage = SGIImage.read(inputStream);
                if (n3 == 0) {
                    n3 = sGIImage.getFormat();
                }
                if (n2 == 0) {
                    n2 = sGIImage.getFormat();
                }
                return new TextureData(gLProfile, n2, sGIImage.getWidth(), sGIImage.getHeight(), 0, n3, 5121, bl, false, false, ByteBuffer.wrap(sGIImage.getData()), null);
            }
            return null;
        }
    }

    static class DDSTextureProvider
    implements TextureProvider {
        private static final ImageType[] imageTypes = new ImageType[]{new ImageType("dds")};

        DDSTextureProvider() {
        }

        @Override
        public final ImageType[] getImageTypes() {
            return imageTypes;
        }

        @Override
        public TextureData newTextureData(GLProfile gLProfile, InputStream inputStream, int n2, int n3, boolean bl, String string) throws IOException {
            if (TextureIO.DDS.equals(string) || TextureIO.DDS.equals(ImageType.Util.getFileSuffix(inputStream))) {
                byte[] byArray = IOUtil.copyStream2ByteArray(inputStream);
                ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
                DDSImage dDSImage = DDSImage.read(byteBuffer);
                return this.newTextureData(gLProfile, dDSImage, n2, n3, bl);
            }
            return null;
        }

        private TextureData newTextureData(GLProfile gLProfile, final DDSImage dDSImage, int n2, int n3, boolean bl) {
            TextureData textureData;
            DDSImage.ImageInfo imageInfo = dDSImage.getMipMap(0);
            if (n3 == 0) {
                switch (dDSImage.getPixelFormat()) {
                    case 20: {
                        n3 = 6407;
                        break;
                    }
                    default: {
                        n3 = 6408;
                    }
                }
            }
            if (imageInfo.isCompressed()) {
                switch (imageInfo.getCompressionFormat()) {
                    case 827611204: {
                        n2 = 33776;
                        break;
                    }
                    case 861165636: {
                        n2 = 33778;
                        break;
                    }
                    case 894720068: {
                        n2 = 33779;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unsupported DDS compression format \"" + DDSImage.getCompressionFormatName(imageInfo.getCompressionFormat()) + "\"");
                    }
                }
            }
            if (n2 == 0) {
                switch (dDSImage.getPixelFormat()) {
                    case 20: {
                        n3 = 6407;
                        break;
                    }
                    default: {
                        n3 = 6408;
                    }
                }
            }
            TextureData.Flusher flusher = new TextureData.Flusher(){

                @Override
                public void flush() {
                    dDSImage.close();
                }
            };
            if (bl && dDSImage.getNumMipMaps() > 0) {
                Buffer[] bufferArray = new Buffer[dDSImage.getNumMipMaps()];
                for (int i2 = 0; i2 < dDSImage.getNumMipMaps(); ++i2) {
                    bufferArray[i2] = dDSImage.getMipMap(i2).getData();
                }
                textureData = new TextureData(gLProfile, n2, imageInfo.getWidth(), imageInfo.getHeight(), 0, n3, 5121, imageInfo.isCompressed(), true, bufferArray, flusher);
            } else {
                bl = false;
                textureData = new TextureData(gLProfile, n2, imageInfo.getWidth(), imageInfo.getHeight(), 0, n3, 5121, bl, imageInfo.isCompressed(), true, imageInfo.getData(), flusher);
            }
            return textureData;
        }
    }
}

