/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util.awt;

import com.jogamp.common.util.IntObjectHashMap;
import com.jogamp.nativewindow.util.PixelFormat;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.util.GLPixelBuffer;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.nio.Buffer;
import java.nio.IntBuffer;
import java.util.Iterator;

public class AWTGLPixelBuffer
extends GLPixelBuffer {
    private static final GLPixelBuffer.GLPixelAttributes awtPixelAttributesIntBGRA = new GLPixelBuffer.GLPixelAttributes(32993, 5121);
    private static final GLPixelBuffer.GLPixelAttributes awtPixelAttributesIntRGBA = new GLPixelBuffer.GLPixelAttributes(6408, 5121);
    public final BufferedImage image;
    private final PixelFormat.Composition hostPixelComp;
    private final int awtFormat;

    public AWTGLPixelBuffer(PixelFormat.Composition composition, GLPixelBuffer.GLPixelAttributes gLPixelAttributes, boolean bl, int n2, int n3, int n4, int n5, BufferedImage bufferedImage, Buffer buffer, boolean bl2) {
        super(gLPixelAttributes, bl, n3, n4, n5, buffer, bl2);
        this.image = bufferedImage;
        this.hostPixelComp = composition;
        this.awtFormat = n2;
    }

    public final PixelFormat.Composition getHostPixelComp() {
        return this.hostPixelComp;
    }

    public final int getAWTFormat() {
        return this.awtFormat;
    }

    @Override
    public void dispose() {
        this.image.flush();
        super.dispose();
    }

    public BufferedImage getAlignedImage(int n2, int n3) throws IllegalArgumentException {
        if (n2 * n3 > this.image.getWidth() * this.image.getHeight()) {
            throw new IllegalArgumentException("Requested size exceeds image size: " + n2 + "x" + n3 + " > " + this.image.getWidth() + "x" + this.image.getHeight());
        }
        if (n2 == this.image.getWidth() && n3 == this.image.getHeight()) {
            return this.image;
        }
        ColorModel colorModel = this.image.getColorModel();
        WritableRaster writableRaster = this.image.getRaster();
        DataBuffer dataBuffer = writableRaster.getDataBuffer();
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
        SinglePixelPackedSampleModel singlePixelPackedSampleModel2 = new SinglePixelPackedSampleModel(dataBuffer.getDataType(), n2, n3, n2, singlePixelPackedSampleModel.getBitMasks());
        WritableRaster writableRaster2 = Raster.createWritableRaster(singlePixelPackedSampleModel2, dataBuffer, null);
        return new BufferedImage(colorModel, writableRaster2, colorModel.isAlphaPremultiplied(), null);
    }

    public final boolean isDataBufferSource(BufferedImage bufferedImage) {
        DataBuffer dataBuffer = this.image.getRaster().getDataBuffer();
        DataBuffer dataBuffer2 = bufferedImage.getRaster().getDataBuffer();
        return dataBuffer2 == dataBuffer;
    }

    @Override
    public StringBuilder toString(StringBuilder stringBuilder) {
        stringBuilder = super.toString(stringBuilder);
        stringBuilder.append(", allowRowStride ").append(this.allowRowStride).append(", image [").append(this.image.getWidth()).append("x").append(this.image.getHeight()).append(", ").append(this.image.toString()).append("]");
        return stringBuilder;
    }

    @Override
    public String toString() {
        return "AWTGLPixelBuffer[" + this.toString(null).toString() + "]";
    }

    public static class SingleAWTGLPixelBufferProvider
    extends AWTGLPixelBufferProvider
    implements GLPixelBuffer.SingletonGLPixelBufferProvider {
        private final IntObjectHashMap bufferMap = new IntObjectHashMap(8);

        private static int getHashCode(PixelFormat.Composition composition, GLPixelBuffer.GLPixelAttributes gLPixelAttributes, boolean bl) {
            int n2 = composition.hashCode();
            n2 = (n2 << 5) - n2 + gLPixelAttributes.hashCode();
            return n2;
        }

        public SingleAWTGLPixelBufferProvider(boolean bl) {
            super(bl);
        }

        @Override
        public AWTGLPixelBuffer allocate(GL gL, PixelFormat.Composition composition, GLPixelBuffer.GLPixelAttributes gLPixelAttributes, boolean bl, int n2, int n3, int n4, int n5) {
            int n6;
            AWTGLPixelBuffer aWTGLPixelBuffer;
            if (null == composition) {
                composition = gLPixelAttributes.pfmt.comp;
            }
            if (null == (aWTGLPixelBuffer = (AWTGLPixelBuffer)this.bufferMap.get(n6 = SingleAWTGLPixelBufferProvider.getHashCode(composition, gLPixelAttributes, bl))) || aWTGLPixelBuffer.requiresNewBuffer(gL, n2, n3, n5)) {
                if (null != aWTGLPixelBuffer) {
                    aWTGLPixelBuffer.dispose();
                }
                aWTGLPixelBuffer = this.allocateImpl(composition, gLPixelAttributes, bl, this.getAWTFormat(gL.getGLProfile(), composition.componentCount()), n2, n3, n4, n5);
                this.bufferMap.put(n6, aWTGLPixelBuffer);
            }
            return aWTGLPixelBuffer;
        }

        private AWTGLPixelBuffer allocateImpl(PixelFormat.Composition composition, GLPixelBuffer.GLPixelAttributes gLPixelAttributes, boolean bl, int n2, int n3, int n4, int n5, int n6) {
            BufferedImage bufferedImage = new BufferedImage(n3, n4, n2);
            int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
            IntBuffer intBuffer = IntBuffer.wrap(nArray);
            return new AWTGLPixelBuffer(composition, gLPixelAttributes, bl, n2, n3, n4, n5, bufferedImage, intBuffer, this.getAllowRowStride());
        }

        @Override
        public AWTGLPixelBuffer getSingleBuffer(PixelFormat.Composition composition, GLPixelBuffer.GLPixelAttributes gLPixelAttributes, boolean bl) {
            return (AWTGLPixelBuffer)this.bufferMap.get(SingleAWTGLPixelBufferProvider.getHashCode(composition, gLPixelAttributes, bl));
        }

        @Override
        public AWTGLPixelBuffer initSingleton(GLProfile gLProfile, int n2, boolean bl, int n3, int n4, int n5) {
            GLPixelBuffer.GLPixelAttributes gLPixelAttributes = this.getAttributes(gLProfile, n2);
            PixelFormat pixelFormat = this.getAWTPixelFormat(gLProfile, n2);
            int n6 = this.getAWTFormat(gLProfile, n2);
            int n7 = SingleAWTGLPixelBufferProvider.getHashCode(pixelFormat.comp, gLPixelAttributes, bl);
            AWTGLPixelBuffer aWTGLPixelBuffer = (AWTGLPixelBuffer)this.bufferMap.get(n7);
            if (null != aWTGLPixelBuffer) {
                return null;
            }
            aWTGLPixelBuffer = this.allocateImpl(pixelFormat.comp, gLPixelAttributes, bl, n6, n3, n4, n5, 0);
            this.bufferMap.put(n7, aWTGLPixelBuffer);
            return aWTGLPixelBuffer;
        }

        @Override
        public void dispose() {
            Iterator<IntObjectHashMap.Entry> iterator = this.bufferMap.iterator();
            while (iterator.hasNext()) {
                AWTGLPixelBuffer aWTGLPixelBuffer = (AWTGLPixelBuffer)iterator.next().value;
                aWTGLPixelBuffer.dispose();
            }
            this.bufferMap.clear();
        }
    }

    public static class AWTGLPixelBufferProvider
    implements GLPixelBuffer.GLPixelBufferProvider {
        private final boolean allowRowStride;

        public AWTGLPixelBufferProvider(boolean bl) {
            this.allowRowStride = bl;
        }

        @Override
        public boolean getAllowRowStride() {
            return this.allowRowStride;
        }

        @Override
        public GLPixelBuffer.GLPixelAttributes getAttributes(GL gL, int n2, boolean bl) {
            return gL.isGLES() ? awtPixelAttributesIntRGBA : awtPixelAttributesIntBGRA;
        }

        public GLPixelBuffer.GLPixelAttributes getAttributes(GLProfile gLProfile, int n2) {
            return gLProfile.isGLES() ? awtPixelAttributesIntRGBA : awtPixelAttributesIntBGRA;
        }

        @Override
        public PixelFormat.Composition getHostPixelComp(GLProfile gLProfile, int n2) {
            return this.getAWTPixelFormat((GLProfile)gLProfile, (int)n2).comp;
        }

        public int getAWTFormat(GLProfile gLProfile, int n2) {
            if (4 == n2) {
                return gLProfile.isGLES() ? 4 : 2;
            }
            return gLProfile.isGLES() ? 4 : 1;
        }

        public PixelFormat getAWTPixelFormat(GLProfile gLProfile, int n2) {
            if (4 == n2) {
                return gLProfile.isGLES() ? PixelFormat.RGBx8888 : PixelFormat.BGRA8888;
            }
            return gLProfile.isGLES() ? PixelFormat.RGBx8888 : PixelFormat.BGRx8888;
        }

        @Override
        public AWTGLPixelBuffer allocate(GL gL, PixelFormat.Composition composition, GLPixelBuffer.GLPixelAttributes gLPixelAttributes, boolean bl, int n2, int n3, int n4, int n5) {
            if (null == composition) {
                throw new IllegalArgumentException("Null hostPixComp");
            }
            int n6 = this.getAWTFormat(gL.getGLProfile(), composition.componentCount());
            BufferedImage bufferedImage = new BufferedImage(n2, n3, n6);
            int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
            IntBuffer intBuffer = IntBuffer.wrap(nArray);
            return new AWTGLPixelBuffer(composition, gLPixelAttributes, bl, n6, n2, n3, n4, bufferedImage, intBuffer, this.allowRowStride);
        }
    }
}

