/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.util.PropertyAccess;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES3;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.JoglVersion;
import java.util.Arrays;
import jogamp.opengl.Debug;

public class FBObject {
    protected static final boolean DEBUG;
    private static final int USER_MAX_TEXTURE_SIZE;
    private static final boolean FBOResizeQuirk = false;
    private boolean initialized = false;
    private boolean fullFBOSupport = false;
    private boolean rgba8Avail = false;
    private boolean depth24Avail = false;
    private boolean depth32Avail = false;
    private boolean stencil01Avail = false;
    private boolean stencil04Avail = false;
    private boolean stencil08Avail = false;
    private boolean stencil16Avail = false;
    private boolean packedDepthStencilAvail = false;
    private int maxColorAttachments = -1;
    private int maxSamples = -1;
    private int maxTextureSize = 0;
    private int maxRenderbufferSize = 0;
    private int width = 0;
    private int height = 0;
    private int samples = 0;
    private int vStatus = -1;
    private boolean ignoreStatus = false;
    private int fbName = 0;
    private boolean bound = false;
    private int colorbufferCount = 0;
    private int textureAttachmentCount = 0;
    private Colorbuffer[] colorbufferAttachments = null;
    private RenderAttachment depth = null;
    private RenderAttachment stencil = null;
    private boolean modified = true;
    private FBObject samplingSink = null;
    private Colorbuffer samplingColorSink = null;
    private boolean samplingSinkDirty = true;
    public static final int DEFAULT_BITS = 0;
    public static final int REQUESTED_BITS = -1;
    public static final int CHOSEN_BITS = -2;
    public static final int MAXIMUM_BITS = -3;

    static String toHexString(int n2) {
        return "0x" + Integer.toHexString(n2);
    }

    public static final TextureAttachment createColorTextureAttachment(GL gL, boolean bl, int n2, int n3) {
        return FBObject.createColorTextureAttachment(gL, bl, n2, n3, 9728, 9728, 33071, 33071);
    }

    public static final TextureAttachment createColorTextureAttachment(GL gL, boolean bl, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8;
        int n9;
        int n10;
        if (gL.isGLES3()) {
            n10 = bl ? 32856 : 32849;
            n9 = bl ? 6408 : 6407;
            n8 = 5121;
        } else if (gL.isGLES()) {
            n10 = bl ? 6408 : 6407;
            n9 = bl ? 6408 : 6407;
            n8 = 5121;
        } else {
            n10 = bl ? 32856 : 32849;
            n9 = bl ? 32993 : 6407;
            n8 = bl ? 33639 : 5121;
        }
        return FBObject.createColorTextureAttachment(n10, n2, n3, n9, n8, n4, n5, n6, n7);
    }

    public static final TextureAttachment createColorTextureAttachment(GL gL, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9;
        int n10;
        boolean bl = FBObject.hasAlpha(n2);
        if (gL.isGLES()) {
            n10 = bl ? 6408 : 6407;
            n9 = 5121;
        } else {
            n10 = bl ? 32993 : 6407;
            n9 = bl ? 33639 : 5121;
        }
        return FBObject.createColorTextureAttachment(n2, n3, n4, n10, n9, n5, n6, n7, n8);
    }

    public static final TextureAttachment createColorTextureAttachment(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        return new TextureAttachment(Attachment.Type.COLOR_TEXTURE, n2, n3, n4, n5, n6, n7, n8, n9, n10, 0);
    }

    private static boolean hasAlpha(int n2) {
        switch (n2) {
            case 4: 
            case 6408: 
            case 32854: 
            case 32856: 
            case 32993: {
                return true;
            }
        }
        return false;
    }

    private final void validateColorAttachmentPointRange(int n2) {
        if (!this.initialized) {
            throw new GLException("FBO not initialized");
        }
        if (this.maxColorAttachments != this.colorbufferAttachments.length) {
            throw new InternalError(String.format("maxColorAttachments %d, array.length %d", this.maxColorAttachments, this.colorbufferAttachments.length));
        }
        if (0 > n2 || n2 >= this.maxColorAttachments) {
            throw new IllegalArgumentException(String.format("attachment point out of range: %d, should be within [0..%d], %s", n2, this.maxColorAttachments - 1, this.toString()));
        }
    }

    private final void validateAddColorAttachment(int n2, Colorbuffer colorbuffer) {
        this.validateColorAttachmentPointRange(n2);
        if (null != this.colorbufferAttachments[n2]) {
            throw new IllegalStateException(String.format("Cannot attach %s at %d, attachment point already in use by %s, %s", colorbuffer.toString(), n2, this.colorbufferAttachments[n2].toString(), this.toString()));
        }
    }

    private final void addColorAttachment(int n2, Colorbuffer colorbuffer, boolean bl) {
        Colorbuffer colorbuffer2 = this.colorbufferAttachments[n2];
        if (bl) {
            this.validateColorAttachmentPointRange(n2);
            if (null == colorbuffer) {
                throw new IllegalArgumentException("Colorbuffer is null");
            }
            if (null != colorbuffer2) {
                throw new IllegalStateException(String.format("Cannot attach %s at %d, attachment point already in use by %s, %s", colorbuffer.toString(), n2, colorbuffer2.toString(), this.toString()));
            }
        }
        this.colorbufferAttachments[n2] = colorbuffer;
        ++this.colorbufferCount;
        if (colorbuffer.isTextureAttachment()) {
            ++this.textureAttachmentCount;
        }
        this.modified = true;
    }

    private final void removeColorAttachment(int n2, Colorbuffer colorbuffer) {
        this.validateColorAttachmentPointRange(n2);
        if (null == colorbuffer) {
            throw new IllegalArgumentException("Colorbuffer is null");
        }
        Colorbuffer colorbuffer2 = this.colorbufferAttachments[n2];
        if (colorbuffer2 != colorbuffer) {
            throw new IllegalStateException(String.format("Cannot detach %s at %d, slot is holding other: %s, %s", colorbuffer.toString(), n2, colorbuffer2.toString(), this.toString()));
        }
        this.colorbufferAttachments[n2] = null;
        --this.colorbufferCount;
        if (colorbuffer.isTextureAttachment()) {
            --this.textureAttachmentCount;
        }
        this.modified = true;
    }

    public final Colorbuffer getColorbuffer(int n2) {
        this.validateColorAttachmentPointRange(n2);
        return this.colorbufferAttachments[n2];
    }

    public final int getColorbufferAttachmentPoint(Colorbuffer colorbuffer) {
        for (int i2 = 0; i2 < this.colorbufferAttachments.length; ++i2) {
            if (this.colorbufferAttachments[i2] != colorbuffer) continue;
            return i2;
        }
        return -1;
    }

    public final Colorbuffer getColorbuffer(Colorbuffer colorbuffer) {
        int n2 = this.getColorbufferAttachmentPoint(colorbuffer);
        return n2 >= 0 ? this.getColorbuffer(n2) : null;
    }

    public final boolean hasAttachmentUsingAlpha() {
        Attachment attachment;
        int n2 = this.getColorbufferCount();
        boolean bl = false;
        for (int i2 = 0; i2 < n2 && null != (attachment = (Attachment)((Object)this.getColorbuffer(i2))); ++i2) {
            if (!FBObject.hasAlpha(attachment.format)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void init(GL gL, int n2, int n3, int n4) throws IllegalStateException, GLException {
        if (this.initialized) {
            throw new IllegalStateException("FBO already initialized");
        }
        if (!gL.hasBasicFBOSupport()) {
            throw new GLException("FBO not supported w/ context: " + gL.getContext() + ", " + this);
        }
        this.fullFBOSupport = gL.hasFullFBOSupport();
        this.rgba8Avail = gL.isGL2ES3() || gL.isExtensionAvailable("GL_OES_rgb8_rgba8");
        this.depth24Avail = this.fullFBOSupport || gL.isExtensionAvailable("GL_OES_depth24");
        this.depth32Avail = this.fullFBOSupport || gL.isExtensionAvailable("GL_OES_depth32");
        this.stencil01Avail = this.fullFBOSupport || gL.isExtensionAvailable("GL_OES_stencil1");
        this.stencil04Avail = this.fullFBOSupport || gL.isExtensionAvailable("GL_OES_stencil4");
        this.stencil08Avail = this.fullFBOSupport || gL.isExtensionAvailable("GL_OES_stencil8");
        this.stencil16Avail = this.fullFBOSupport;
        this.packedDepthStencilAvail = this.fullFBOSupport || gL.isExtensionAvailable("GL_OES_packed_depth_stencil") || gL.isExtensionAvailable("GL_EXT_packed_depth_stencil");
        boolean bl = gL.isExtensionAvailable("GL_NV_fbo_color_attachments");
        int[] nArray = new int[1];
        FBObject.checkPreGLError(gL);
        int n5 = 1;
        this.maxColorAttachments = 1;
        if (this.fullFBOSupport || bl) {
            try {
                nArray[0] = 0;
                gL.glGetIntegerv(36063, nArray, 0);
                n5 = 1 <= nArray[0] ? nArray[0] : 1;
            }
            catch (GLException gLException) {
                gLException.printStackTrace();
            }
        }
        this.maxColorAttachments = n5 <= 8 ? n5 : 8;
        this.colorbufferAttachments = new Colorbuffer[this.maxColorAttachments];
        this.colorbufferCount = 0;
        this.textureAttachmentCount = 0;
        this.maxSamples = gL.getMaxRenderbufferSamples();
        gL.glGetIntegerv(3379, nArray, 0);
        int n6 = nArray[0];
        this.maxTextureSize = 0 < USER_MAX_TEXTURE_SIZE ? USER_MAX_TEXTURE_SIZE : n6;
        gL.glGetIntegerv(34024, nArray, 0);
        this.maxRenderbufferSize = nArray[0];
        this.width = 0 < n2 ? n2 : 1;
        this.height = 0 < n3 ? n3 : 1;
        int n7 = this.samples = n4 <= this.maxSamples ? n4 : this.maxSamples;
        if (DEBUG) {
            System.err.println("FBObject.init() START: " + this.width + "x" + this.height + ", " + n4 + " -> " + this.samples + " samples");
            System.err.println("fullFBOSupport:           " + this.fullFBOSupport);
            System.err.println("maxColorAttachments:      " + this.maxColorAttachments + "/" + n5 + " [capped/real]");
            System.err.println("maxSamples:               " + this.maxSamples);
            System.err.println("maxTextureSize:           " + n6 + " -> " + this.maxTextureSize);
            System.err.println("maxRenderbufferSize:      " + this.maxRenderbufferSize);
            System.err.println("rgba8:                    " + this.rgba8Avail);
            System.err.println("depth24:                  " + this.depth24Avail);
            System.err.println("depth32:                  " + this.depth32Avail);
            System.err.println("stencil01:                " + this.stencil01Avail);
            System.err.println("stencil04:                " + this.stencil04Avail);
            System.err.println("stencil08:                " + this.stencil08Avail);
            System.err.println("stencil16:                " + this.stencil16Avail);
            System.err.println("packedDepthStencil:       " + this.packedDepthStencilAvail);
            System.err.println("NV_fbo_color_attachments: " + bl);
            System.err.println(gL.getContext().getGLVersion());
            System.err.println(JoglVersion.getGLStrings(gL, null, false).toString());
        }
        FBObject.checkPreGLError(gL);
        if (this.width > this.maxRenderbufferSize || this.height > this.maxRenderbufferSize) {
            throw new GLException("Size " + this.width + "x" + this.height + " exceeds on of the maxima renderbuffer size " + this.maxRenderbufferSize + ": \n\t" + this);
        }
        this.modified = true;
        this.samplingSinkDirty = true;
        gL.glGenFramebuffers(1, nArray, 0);
        this.fbName = nArray[0];
        if (0 == this.fbName) {
            throw new GLException("null framebuffer");
        }
        gL.glBindFramebuffer(36160, this.fbName);
        this.checkNoError(gL, gL.glGetError(), "FBObject Init.bindFB");
        if (!gL.glIsFramebuffer(this.fbName)) {
            this.checkNoError(gL, 1281, "FBObject Init.isFB");
        }
        this.bound = true;
        this.initialized = true;
        this.vStatus = 36055;
        if (DEBUG) {
            System.err.println("FBObject.init() END: " + this);
            ExceptionUtils.dumpStack(System.err);
        }
    }

    public final boolean reset(GL gL, int n2, int n3, int n4) throws GLException, IllegalStateException {
        if (!this.initialized) {
            throw new IllegalStateException("FBO not initialized");
        }
        int n5 = n4 = n4 <= this.maxSamples ? n4 : this.maxSamples;
        if (n2 != this.width || n3 != this.height || n4 != this.samples) {
            int n6;
            if (0 >= n2) {
                n2 = 1;
            }
            if (0 >= n3) {
                n3 = 1;
            }
            if (this.textureAttachmentCount > 0 && (n2 > 2 + this.maxTextureSize || n3 > 2 + this.maxTextureSize)) {
                throw new GLException("Size " + n2 + "x" + n3 + " exceeds on of the maximum texture size " + this.maxTextureSize + ": \n\t" + this);
            }
            if (n2 > this.maxRenderbufferSize || n3 > this.maxRenderbufferSize) {
                throw new GLException("Size " + n2 + "x" + n3 + " exceeds on of the maxima renderbuffer size " + this.maxRenderbufferSize + ": \n\t" + this);
            }
            if (DEBUG) {
                System.err.println("FBObject.reset - START - " + this.width + "x" + this.height + ", " + this.samples + " -> " + n2 + "x" + n3 + ", " + n4 + "; " + this);
            }
            boolean bl = this.isBound();
            if (0 < this.samples && 0 < n4 || 0 == this.samples && 0 == n4) {
                n6 = 0;
            } else if (0 == this.samples && 0 < n4) {
                n6 = 1;
            } else if (0 < this.samples && 0 == n4) {
                n6 = -1;
            } else {
                throw new IllegalArgumentException("Error in sampleCount change: " + this.samples + " -> " + n4);
            }
            this.width = n2;
            this.height = n3;
            this.samples = n4;
            this.modified = true;
            this.samplingSinkDirty = true;
            this.detachAllImpl(gL, true, true, n6);
            this.resetSamplingSink(gL);
            if (!bl) {
                this.unbind(gL);
            }
            if (DEBUG) {
                System.err.println("FBObject.reset - END - wasBound, " + bl + ", " + this);
            }
            return true;
        }
        return false;
    }

    private final void resetSizeImpl(GL gL, int n2, int n3) {
        if (DEBUG) {
            System.err.println("FBObject.resetSize - START - " + this.width + "x" + this.height + ", " + this.samples + " -> " + n2 + "x" + n3);
        }
        this.width = n2;
        this.height = n3;
        this.modified = true;
        this.samplingSinkDirty = true;
        this.detachAllImpl(gL, true, true, 0);
        if (DEBUG) {
            System.err.println("FBObject.resetSize - END - " + this);
        }
    }

    private void validateAttachmentSize(Attachment attachment) {
        int n2 = attachment.getWidth();
        int n3 = attachment.getHeight();
        if (attachment instanceof TextureAttachment && (n2 > 2 + this.maxTextureSize || n3 > 2 + this.maxTextureSize)) {
            throw new GLException("Size " + n2 + "x" + n3 + " of " + attachment + " exceeds on of the maximum texture size " + this.maxTextureSize + ": \n\t" + this);
        }
        if (n2 > this.maxRenderbufferSize || n3 > this.maxRenderbufferSize) {
            throw new GLException("Size " + n2 + "x" + n3 + " of " + attachment + " exceeds on of the maxima renderbuffer size " + this.maxRenderbufferSize + ": \n\t" + this);
        }
    }

    public final void formatToGLCapabilities(GLCapabilities gLCapabilities) {
        Colorbuffer colorbuffer;
        gLCapabilities.setSampleBuffers(this.samples > 0);
        gLCapabilities.setNumSamples(this.samples);
        gLCapabilities.setDepthBits(0);
        gLCapabilities.setStencilBits(0);
        Colorbuffer colorbuffer2 = colorbuffer = this.samples > 0 ? this.getSamplingSink() : this.getColorbuffer(0);
        if (null != colorbuffer) {
            colorbuffer.formatToGLCapabilities(gLCapabilities, this.rgba8Avail);
        }
        if (null != this.depth) {
            this.depth.formatToGLCapabilities(gLCapabilities, this.rgba8Avail);
        }
        if (null != this.stencil && this.stencil != this.depth) {
            this.stencil.formatToGLCapabilities(gLCapabilities, this.rgba8Avail);
        }
    }

    public final int getStatus() {
        return this.vStatus;
    }

    public final String getStatusString() {
        return FBObject.getStatusString(this.vStatus);
    }

    public static final String getStatusString(int n2) {
        switch (n2) {
            case -1: {
                return "NOT A FBO";
            }
            case 36053: {
                return "OK";
            }
            case 36054: {
                return "FBO incomplete attachment\n";
            }
            case 36055: {
                return "FBO missing attachment";
            }
            case 36057: {
                return "FBO attached images must have same dimensions";
            }
            case 36058: {
                return "FBO attached images must have same format";
            }
            case 36059: {
                return "FBO missing draw buffer";
            }
            case 36060: {
                return "FBO missing read buffer";
            }
            case 36182: {
                return "FBO missing multisample buffer";
            }
            case 36264: {
                return "FBO missing layer targets";
            }
            case 36061: {
                return "Unsupported FBO format";
            }
            case 33305: {
                return "FBO undefined";
            }
            case 0: {
                return "FBO implementation fault";
            }
        }
        return "FBO incomplete, implementation ERROR " + FBObject.toHexString(n2);
    }

    public final boolean isStatusValid() {
        switch (this.vStatus) {
            case 36053: {
                return true;
            }
            case 36054: 
            case 36055: 
            case 36057: 
            case 36058: 
            case 36059: 
            case 36060: 
            case 36182: 
            case 36264: {
                if (0 != this.colorbufferCount && null != this.depth) break;
                return true;
            }
        }
        if (DEBUG) {
            System.err.println("Framebuffer " + this.fbName + " is incomplete, status = " + FBObject.toHexString(this.vStatus) + " : " + FBObject.getStatusString(this.vStatus));
        }
        return false;
    }

    private static int checkPreGLError(GL gL) {
        int n2 = gL.glGetError();
        if (DEBUG && 0 != n2) {
            System.err.println("Pre-existing GL error: " + FBObject.toHexString(n2));
            ExceptionUtils.dumpStack(System.err);
        }
        return n2;
    }

    private final boolean checkNoError(GL gL, int n2, String string) throws GLException {
        if (0 != n2) {
            if (null != gL) {
                this.destroy(gL);
            }
            if (null != string) {
                throw new GLException(string + " GL Error " + FBObject.toHexString(n2) + " of " + this.toString());
            }
            return false;
        }
        return true;
    }

    private final void checkInitialized() throws GLException {
        if (!this.initialized) {
            throw new GLException("FBO not initialized, call init(GL) first.");
        }
    }

    public final TextureAttachment attachTexture2D(GL gL, int n2, boolean bl) throws GLException {
        return this.attachColorbuffer(gL, n2, FBObject.createColorTextureAttachment(gL, bl, this.width, this.height)).getTextureAttachment();
    }

    public final TextureAttachment attachTexture2D(GL gL, int n2, boolean bl, int n3, int n4, int n5, int n6) throws GLException {
        return this.attachColorbuffer(gL, n2, FBObject.createColorTextureAttachment(gL, bl, this.width, this.height, n3, n4, n5, n6)).getTextureAttachment();
    }

    public final TextureAttachment attachTexture2D(GL gL, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) throws GLException {
        return this.attachColorbuffer(gL, n2, FBObject.createColorTextureAttachment(n3, this.width, this.height, n4, n5, n6, n7, n8, n9)).getTextureAttachment();
    }

    public final ColorAttachment createColorAttachment(boolean bl) {
        int n2 = this.rgba8Avail ? (bl ? 32856 : 32849) : (bl ? 32854 : 36194);
        return FBObject.createColorAttachment(n2, this.samples, this.width, this.height);
    }

    public static final ColorAttachment createColorAttachment(int n2, int n3, int n4, int n5) {
        return new ColorAttachment(n2, n3, n4, n5, 0);
    }

    public static final RenderAttachment createRenderAttachment(Attachment.Type type, int n2, int n3, int n4, int n5) {
        return new RenderAttachment(type, n2, n3, n4, n5, 0);
    }

    public final ColorAttachment attachColorbuffer(GL gL, int n2, boolean bl) throws GLException {
        return this.attachColorbuffer(gL, n2, this.createColorAttachment(bl)).getColorAttachment();
    }

    public final ColorAttachment attachColorbuffer(GL gL, int n2, int n3) throws GLException, IllegalArgumentException {
        Attachment.Type type = Attachment.Type.determine(n3);
        if (Attachment.Type.COLOR != type) {
            throw new IllegalArgumentException("colorformat invalid: " + FBObject.toHexString(n3) + ", " + this);
        }
        return this.attachColorbuffer(gL, n2, FBObject.createColorAttachment(n3, this.samples, this.width, this.height)).getColorAttachment();
    }

    public final Colorbuffer attachColorbuffer(GL gL, int n2, Colorbuffer colorbuffer) throws GLException {
        this.bind(gL);
        return this.attachColorbufferImpl(gL, n2, colorbuffer);
    }

    private final Colorbuffer attachColorbufferImpl(GL gL, int n2, Colorbuffer colorbuffer) throws GLException {
        this.validateAddColorAttachment(n2, colorbuffer);
        this.validateAttachmentSize((Attachment)((Object)colorbuffer));
        boolean bl = colorbuffer.initialize(gL);
        this.addColorAttachment(n2, colorbuffer, false);
        if (colorbuffer.isTextureAttachment()) {
            TextureAttachment textureAttachment = colorbuffer.getTextureAttachment();
            if (this.samples > 0) {
                this.removeColorAttachment(n2, textureAttachment);
                if (bl) {
                    textureAttachment.free(gL);
                }
                throw new GLException("Texture2D not supported w/ MSAA. If you have enabled MSAA with exisiting texture attachments, you may want to detach them via detachAllTexturebuffer(gl).");
            }
            gL.glFramebufferTexture2D(36160, 36064 + n2, 3553, textureAttachment.getName(), 0);
            if (!this.ignoreStatus) {
                this.updateStatus(gL);
                if (!this.isStatusValid()) {
                    this.detachColorbuffer(gL, n2, true);
                    throw new GLException("attachTexture2D " + textureAttachment + " at " + n2 + " failed: " + this.getStatusString() + ", " + this);
                }
            }
        } else {
            ColorAttachment colorAttachment = colorbuffer.getColorAttachment();
            gL.glFramebufferRenderbuffer(36160, 36064 + n2, 36161, colorAttachment.getName());
            if (!this.ignoreStatus) {
                this.updateStatus(gL);
                if (!this.isStatusValid()) {
                    this.detachColorbuffer(gL, n2, true);
                    throw new GLException("attachColorbuffer " + colorAttachment + " at " + n2 + " failed: " + this.getStatusString() + ", " + this);
                }
            }
        }
        if (DEBUG) {
            System.err.println("FBObject.attachColorbuffer.X: [attachmentPoint " + n2 + ", colbuf " + colorbuffer + "]: " + this);
        }
        return colorbuffer;
    }

    private final int getDepthIFormat(int n2) {
        if (32 <= n2 && this.depth32Avail) {
            return 33191;
        }
        if (24 <= n2 && (this.depth24Avail || this.depth32Avail)) {
            if (this.depth24Avail) {
                return 33190;
            }
            return 33191;
        }
        return 33189;
    }

    private final int getStencilIFormat(int n2) {
        if (16 <= n2 && this.stencil16Avail) {
            return 36169;
        }
        if (8 <= n2 && (this.stencil08Avail || this.stencil16Avail)) {
            if (this.stencil08Avail) {
                return 36168;
            }
            return 36169;
        }
        if (4 <= n2 && (this.stencil04Avail || this.stencil08Avail || this.stencil16Avail)) {
            if (this.stencil04Avail) {
                return 36167;
            }
            if (this.stencil08Avail) {
                return 36168;
            }
            return 36169;
        }
        if (1 <= n2 && (this.stencil01Avail || this.stencil04Avail || this.stencil08Avail || this.stencil16Avail)) {
            if (this.stencil01Avail) {
                return 36166;
            }
            if (this.stencil04Avail) {
                return 36167;
            }
            if (this.stencil08Avail) {
                return 36168;
            }
            return 36169;
        }
        throw new GLException("stencil buffer n/a");
    }

    public final void attachRenderbuffer(GL gL, Attachment.Type type, int n2) throws GLException, IllegalArgumentException {
        int n3;
        GLCapabilitiesImmutable gLCapabilitiesImmutable;
        int n4;
        int n5;
        if (-3 > n2) {
            throw new IllegalArgumentException("reqBits out of range, shall be >= -3");
        }
        if (-3 == n2) {
            n5 = 32;
            n4 = 16;
        } else if (-2 == n2) {
            gLCapabilitiesImmutable = gL.getContext().getGLDrawable().getChosenGLCapabilities();
            n5 = gLCapabilitiesImmutable.getDepthBits();
            n4 = gLCapabilitiesImmutable.getStencilBits();
        } else if (-1 == n2) {
            gLCapabilitiesImmutable = gL.getContext().getGLDrawable().getRequestedGLCapabilities();
            n5 = gLCapabilitiesImmutable.getDepthBits();
            n4 = gLCapabilitiesImmutable.getStencilBits();
        } else if (0 == n2) {
            n5 = 24;
            n4 = 8;
        } else {
            n5 = n2;
            n4 = n2;
        }
        int n6 = -1;
        switch (type) {
            case DEPTH: {
                n3 = this.getDepthIFormat(n5);
                break;
            }
            case STENCIL: {
                n3 = this.getStencilIFormat(n4);
                break;
            }
            case DEPTH_STENCIL: {
                if (this.packedDepthStencilAvail) {
                    n3 = 35056;
                    break;
                }
                n3 = this.getDepthIFormat(n5);
                n6 = this.getStencilIFormat(n4);
                break;
            }
            default: {
                throw new IllegalArgumentException("only depth/stencil types allowed, was " + (Object)((Object)type) + ", " + this);
            }
        }
        this.attachRenderbufferImpl(gL, type, n3);
        if (0 <= n6) {
            this.attachRenderbufferImpl(gL, Attachment.Type.STENCIL, n6);
        }
    }

    public final void attachRenderbuffer(GL gL, int n2) throws GLException, IllegalArgumentException {
        Attachment.Type type = Attachment.Type.determine(n2);
        if (Attachment.Type.DEPTH != type && Attachment.Type.STENCIL != type && Attachment.Type.DEPTH_STENCIL != type) {
            throw new IllegalArgumentException("renderformat invalid: " + FBObject.toHexString(n2) + ", " + this);
        }
        this.attachRenderbufferImpl(gL, type, n2);
    }

    protected final void attachRenderbufferImpl(GL gL, Attachment.Type type, int n2) throws GLException {
        if (null != this.depth && (Attachment.Type.DEPTH == type || Attachment.Type.DEPTH_STENCIL == type)) {
            throw new GLException("FBO depth buffer already attached (rb " + this.depth + "), type is " + (Object)((Object)type) + ", " + FBObject.toHexString(n2) + ", " + this);
        }
        if (null != this.stencil && (Attachment.Type.STENCIL == type || Attachment.Type.DEPTH_STENCIL == type)) {
            throw new GLException("FBO stencil buffer already attached (rb " + this.stencil + "), type is " + (Object)((Object)type) + ", " + FBObject.toHexString(n2) + ", " + this);
        }
        this.bind(gL);
        this.attachRenderbufferImpl2(gL, type, n2);
    }

    private final void attachRenderbufferImpl2(GL gL, Attachment.Type type, int n2) throws GLException {
        if (Attachment.Type.DEPTH == type) {
            if (null == this.depth) {
                this.depth = FBObject.createRenderAttachment(Attachment.Type.DEPTH, n2, this.samples, this.width, this.height);
            } else {
                this.depth.setSize(this.width, this.height);
                this.depth.setSamples(this.samples);
            }
            this.validateAttachmentSize(this.depth);
            this.depth.initialize(gL);
        } else if (Attachment.Type.STENCIL == type) {
            if (null == this.stencil) {
                this.stencil = FBObject.createRenderAttachment(Attachment.Type.STENCIL, n2, this.samples, this.width, this.height);
            } else {
                this.stencil.setSize(this.width, this.height);
                this.stencil.setSamples(this.samples);
            }
            this.validateAttachmentSize(this.stencil);
            this.stencil.initialize(gL);
        } else if (Attachment.Type.DEPTH_STENCIL == type) {
            if (null == this.depth) {
                if (null != this.stencil) {
                    throw new InternalError("XXX: DEPTH_STENCIL, depth was null, stencil not: " + this.toString());
                }
                this.depth = FBObject.createRenderAttachment(Attachment.Type.DEPTH_STENCIL, n2, this.samples, this.width, this.height);
            } else {
                this.depth.setSize(this.width, this.height);
                this.depth.setSamples(this.samples);
            }
            this.validateAttachmentSize(this.depth);
            this.depth.initialize(gL);
            this.stencil = this.depth;
        }
        if (Attachment.Type.DEPTH == type) {
            gL.glFramebufferRenderbuffer(36160, 36096, 36161, this.depth.getName());
        } else if (Attachment.Type.STENCIL == type) {
            gL.glFramebufferRenderbuffer(36160, 36128, 36161, this.stencil.getName());
        } else if (Attachment.Type.DEPTH_STENCIL == type) {
            gL.glFramebufferRenderbuffer(36160, 36096, 36161, this.depth.getName());
            gL.glFramebufferRenderbuffer(36160, 36128, 36161, this.stencil.getName());
        }
        this.modified = true;
        if (!this.ignoreStatus) {
            this.updateStatus(gL);
            if (!this.isStatusValid()) {
                this.detachRenderbuffer(gL, type, true);
                throw new GLException("renderbuffer [attachmentType " + (Object)((Object)type) + ", iformat " + FBObject.toHexString(n2) + "] failed: " + this.getStatusString() + ", " + this.toString());
            }
        }
        if (DEBUG) {
            System.err.println("FBObject.attachRenderbuffer.X: [attachmentType " + (Object)((Object)type) + ", iformat " + FBObject.toHexString(n2) + "]: " + this);
        }
    }

    public final Colorbuffer detachColorbuffer(GL gL, int n2, boolean bl) throws IllegalArgumentException {
        this.bind(gL);
        Colorbuffer colorbuffer = this.detachColorbufferImpl(gL, n2, bl ? DetachAction.DISPOSE : DetachAction.NONE, 0);
        if (null == colorbuffer) {
            throw new IllegalArgumentException("ColorAttachment at " + n2 + ", not attached, " + this);
        }
        if (DEBUG) {
            System.err.println("FBObject.detachColorbuffer.X: [attachmentPoint " + n2 + ", dispose " + bl + "]: " + colorbuffer + ", " + this);
        }
        return colorbuffer;
    }

    private final Colorbuffer detachColorbufferImpl(GL gL, int n2, DetachAction detachAction, int n3) {
        Colorbuffer colorbuffer = this.colorbufferAttachments[n2];
        if (null == colorbuffer) {
            return null;
        }
        this.removeColorAttachment(n2, colorbuffer);
        if (colorbuffer.isTextureAttachment()) {
            TextureAttachment textureAttachment = colorbuffer.getTextureAttachment();
            if (0 != textureAttachment.getName()) {
                gL.glFramebufferTexture2D(36160, 36064 + n2, 3553, 0, 0);
                gL.glBindTexture(3553, 0);
                switch (detachAction) {
                    case DISPOSE: 
                    case RECREATE: {
                        textureAttachment.free(gL);
                        break;
                    }
                }
            }
            if (DetachAction.RECREATE == detachAction) {
                Attachment attachment;
                if (0 < n3) {
                    attachment = this.createColorAttachment(FBObject.hasAlpha(textureAttachment.format));
                } else {
                    textureAttachment.setSize(this.width, this.height);
                    attachment = textureAttachment;
                }
                this.attachColorbufferImpl(gL, n2, (Colorbuffer)((Object)attachment));
            }
        } else {
            ColorAttachment colorAttachment = colorbuffer.getColorAttachment();
            if (0 != colorAttachment.getName()) {
                gL.glFramebufferRenderbuffer(36160, 36064 + n2, 36161, 0);
                switch (detachAction) {
                    case DISPOSE: 
                    case RECREATE: {
                        colorAttachment.free(gL);
                        break;
                    }
                }
            }
            if (DetachAction.RECREATE == detachAction) {
                Attachment attachment;
                if (0 <= n3 || null == this.samplingColorSink) {
                    colorAttachment.setSize(this.width, this.height);
                    colorAttachment.setSamples(this.samples);
                    attachment = colorAttachment;
                } else if (this.samplingColorSink.isTextureAttachment()) {
                    TextureAttachment textureAttachment = this.samplingColorSink.getTextureAttachment();
                    attachment = FBObject.createColorTextureAttachment(textureAttachment.format, this.width, this.height, textureAttachment.dataFormat, textureAttachment.dataType, textureAttachment.magFilter, textureAttachment.minFilter, textureAttachment.wrapS, textureAttachment.wrapT);
                } else {
                    attachment = FBObject.createColorAttachment(this.samplingColorSink.getFormat(), 0, this.width, this.height);
                }
                this.attachColorbuffer(gL, n2, (Colorbuffer)((Object)attachment));
            }
        }
        return colorbuffer;
    }

    private final void freeAllColorbufferImpl(GL gL) {
        for (int i2 = 0; i2 < this.maxColorAttachments; ++i2) {
            Attachment attachment;
            Colorbuffer colorbuffer = this.colorbufferAttachments[i2];
            if (null == colorbuffer) {
                return;
            }
            if (colorbuffer.isTextureAttachment()) {
                attachment = colorbuffer.getTextureAttachment();
                if (0 != attachment.getName()) {
                    gL.glFramebufferTexture2D(36160, 36064 + i2, 3553, 0, 0);
                    gL.glBindTexture(3553, 0);
                }
                ((TextureAttachment)attachment).free(gL);
                continue;
            }
            attachment = colorbuffer.getColorAttachment();
            if (0 != attachment.getName()) {
                gL.glFramebufferRenderbuffer(36160, 36064 + i2, 36161, 0);
            }
            ((RenderAttachment)attachment).free(gL);
        }
    }

    public final void detachRenderbuffer(GL gL, Attachment.Type type, boolean bl) throws IllegalArgumentException {
        this.bind(gL);
        RenderAttachment renderAttachment = this.detachRenderbufferImpl(gL, type, bl ? DetachAction.DISPOSE : DetachAction.NONE);
        if (null == renderAttachment) {
            throw new IllegalArgumentException("RenderAttachment type " + (Object)((Object)type) + ", not attached, " + this);
        }
        if (DEBUG) {
            System.err.println("FBObject.detachRenderbuffer.X: [attachmentType " + (Object)((Object)type) + ", dispose " + bl + "]: " + this);
        }
    }

    public final boolean isDepthStencilPackedFormat() {
        boolean bl;
        boolean bl2 = bl = null != this.depth && null != this.stencil && this.depth.format == this.stencil.format;
        if (bl) {
            if (this.depth.getName() != this.stencil.getName()) {
                throw new InternalError("depth/stencil packed format not sharing: depth " + this.depth + ", stencil " + this.stencil);
            }
            if (this.depth != this.stencil) {
                throw new InternalError("depth/stencil packed format not a shared reference: depth " + this.depth + ", stencil " + this.stencil);
            }
        }
        return bl;
    }

    private final RenderAttachment detachRenderbufferImpl(GL gL, Attachment.Type type, DetachAction detachAction) throws IllegalArgumentException {
        RenderAttachment renderAttachment;
        switch (type) {
            case DEPTH_STENCIL: 
            case DEPTH: 
            case STENCIL: {
                break;
            }
            default: {
                throw new IllegalArgumentException("only depth/stencil types allowed, was " + (Object)((Object)type) + ", " + this);
            }
        }
        if (null == this.depth && null == this.stencil) {
            return null;
        }
        boolean bl = this.isDepthStencilPackedFormat();
        if (bl) {
            type = Attachment.Type.DEPTH_STENCIL;
        }
        switch (type) {
            case DEPTH: {
                renderAttachment = this.depth;
                if (null == renderAttachment) break;
                int n2 = renderAttachment.format;
                if (0 != renderAttachment.getName()) {
                    gL.glFramebufferRenderbuffer(36160, 36096, 36161, 0);
                    switch (detachAction) {
                        case DISPOSE: 
                        case RECREATE: {
                            renderAttachment.free(gL);
                            break;
                        }
                    }
                }
                if (DetachAction.RECREATE == detachAction) {
                    this.attachRenderbufferImpl2(gL, type, n2);
                    break;
                }
                this.depth = null;
                break;
            }
            case STENCIL: {
                renderAttachment = this.stencil;
                if (null == renderAttachment) break;
                int n3 = renderAttachment.format;
                if (0 != renderAttachment.getName()) {
                    gL.glFramebufferRenderbuffer(36160, 36128, 36161, 0);
                    switch (detachAction) {
                        case DISPOSE: 
                        case RECREATE: {
                            renderAttachment.free(gL);
                            break;
                        }
                    }
                }
                if (DetachAction.RECREATE == detachAction) {
                    this.attachRenderbufferImpl2(gL, type, n3);
                    break;
                }
                this.stencil = null;
                break;
            }
            case DEPTH_STENCIL: {
                int n4;
                renderAttachment = this.depth;
                if (null != renderAttachment) {
                    n4 = renderAttachment.format;
                    if (0 != renderAttachment.getName()) {
                        gL.glFramebufferRenderbuffer(36160, 36096, 36161, 0);
                        if (bl) {
                            gL.glFramebufferRenderbuffer(36160, 36128, 36161, 0);
                        }
                        switch (detachAction) {
                            case DISPOSE: 
                            case RECREATE: {
                                renderAttachment.free(gL);
                                break;
                            }
                        }
                    }
                    if (DetachAction.RECREATE == detachAction) {
                        this.attachRenderbufferImpl2(gL, bl ? Attachment.Type.DEPTH_STENCIL : Attachment.Type.DEPTH, n4);
                    } else {
                        this.depth = null;
                        if (bl) {
                            this.stencil = null;
                        }
                    }
                }
                if (bl || null == this.stencil) break;
                n4 = this.stencil.format;
                if (0 != this.stencil.getName()) {
                    gL.glFramebufferRenderbuffer(36160, 36128, 36161, 0);
                    switch (detachAction) {
                        case DISPOSE: 
                        case RECREATE: {
                            this.stencil.free(gL);
                            break;
                        }
                    }
                }
                if (DetachAction.RECREATE == detachAction) {
                    this.attachRenderbufferImpl2(gL, Attachment.Type.STENCIL, n4);
                    break;
                }
                this.stencil = null;
                break;
            }
            default: {
                throw new InternalError("XXX");
            }
        }
        this.modified = true;
        return renderAttachment;
    }

    private final void freeAllRenderbufferImpl(GL gL) throws IllegalArgumentException {
        boolean bl = this.isDepthStencilPackedFormat();
        if (null != this.depth && 0 != this.depth.getName()) {
            gL.glFramebufferRenderbuffer(36160, 36096, 36161, 0);
            if (bl) {
                gL.glFramebufferRenderbuffer(36160, 36128, 36161, 0);
            }
            this.depth.free(gL);
        }
        if (!bl && null != this.stencil && 0 != this.stencil.getName()) {
            gL.glFramebufferRenderbuffer(36160, 36128, 36161, 0);
            this.stencil.free(gL);
        }
    }

    public final void detachAll(GL gL) {
        if (null != this.samplingSink) {
            this.samplingSink.detachAll(gL);
        }
        this.detachAllImpl(gL, true, false, 0);
    }

    public final void detachAllColorbuffer(GL gL) {
        if (null != this.samplingSink) {
            this.samplingSink.detachAllColorbuffer(gL);
        }
        this.detachAllImpl(gL, false, false, 0);
    }

    public final void detachAllTexturebuffer(GL gL) {
        if (!this.isInitialized()) {
            return;
        }
        if (null != this.samplingSink) {
            this.samplingSink.detachAllTexturebuffer(gL);
        }
        this.bind(gL);
        for (int i2 = 0; i2 < this.maxColorAttachments; ++i2) {
            if (!this.colorbufferAttachments[i2].isTextureAttachment()) continue;
            this.detachColorbufferImpl(gL, i2, DetachAction.DISPOSE, 0);
        }
        if (DEBUG) {
            System.err.println("FBObject.detachAllTexturebuffer.X: " + this);
        }
    }

    public final void detachAllRenderbuffer(GL gL) {
        if (!this.isInitialized()) {
            return;
        }
        if (null != this.samplingSink) {
            this.samplingSink.detachAllRenderbuffer(gL);
        }
        this.bind(gL);
        this.detachRenderbufferImpl(gL, Attachment.Type.DEPTH_STENCIL, DetachAction.DISPOSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void detachAllImpl(GL gL, boolean bl, boolean bl2, int n2) {
        if (!this.isInitialized()) {
            return;
        }
        this.ignoreStatus = bl2;
        try {
            this.bind(gL);
            for (int i2 = 0; i2 < this.maxColorAttachments; ++i2) {
                this.detachColorbufferImpl(gL, i2, bl2 ? DetachAction.RECREATE : DetachAction.DISPOSE, n2);
            }
            if (!bl2 && this.colorbufferCount > 0) {
                throw new InternalError("Non zero ColorAttachments " + this);
            }
            if (bl) {
                this.detachRenderbufferImpl(gL, Attachment.Type.DEPTH_STENCIL, bl2 ? DetachAction.RECREATE : DetachAction.DISPOSE);
            }
            if (this.ignoreStatus) {
                this.updateStatus(gL);
                if (!this.isStatusValid()) {
                    throw new GLException("detachAllImpl failed: " + this.getStatusString() + ", " + this);
                }
            }
        }
        finally {
            this.ignoreStatus = false;
        }
        if (DEBUG) {
            System.err.println("FBObject.detachAll.X: [resetNonColorbuffer " + bl + ", recreate " + bl2 + "]: " + this);
        }
    }

    public final void destroy(GL gL) {
        if (!this.initialized) {
            return;
        }
        if (DEBUG) {
            System.err.println("FBObject.destroy.0: " + this);
        }
        if (null != this.samplingSink && this.samplingSink.isInitialized()) {
            this.samplingSink.destroy(gL);
        }
        this.detachAllImpl(gL, true, false, 0);
        int n2 = this.fbName;
        this.fbName = 0;
        int[] nArray = new int[1];
        if (0 != n2) {
            nArray[0] = n2;
            gL.glDeleteFramebuffers(1, nArray, 0);
        }
        this.initialized = false;
        this.bound = false;
        if (DEBUG) {
            System.err.println("FBObject.destroy.X: " + this);
        }
    }

    private final boolean sampleSinkSizeMismatch() {
        return this.samplingSink.getWidth() != this.width || this.samplingSink.getHeight() != this.height;
    }

    private final boolean sampleSinkDepthStencilMismatch() {
        if (null != this.depth && (null == this.samplingSink.depth || this.depth.format != this.samplingSink.depth.format) || null == this.depth && null != this.samplingSink.depth) {
            return true;
        }
        return null != this.stencil && (null == this.samplingSink.stencil || this.stencil.format != this.samplingSink.stencil.format) || null == this.stencil && null != this.samplingSink.stencil;
    }

    private final boolean sampleSinkExFormatMismatch(GL gL) {
        if (null != this.samplingColorSink && this.getColorbufferCount() > 0 && gL.isGL2ES3()) {
            Attachment attachment = (Attachment)((Object)this.getColorbuffer(0));
            return null != attachment && attachment.format != this.samplingColorSink.getFormat();
        }
        return false;
    }

    public final boolean resetSamplingSink(GL gL) throws GLException {
        boolean bl;
        boolean bl2;
        if (DEBUG) {
            System.err.println("FBObject.resetSamplingSink.0");
            ExceptionUtils.dumpStack(System.err);
        }
        if (0 == this.samples) {
            boolean bl3;
            if (null != this.samplingSink) {
                if (this.samplingSink.initialized) {
                    this.samplingSink.detachAll(gL);
                }
                this.samplingSink = null;
                this.samplingColorSink = null;
                bl3 = true;
            } else {
                bl3 = false;
            }
            this.modified = false;
            if (DEBUG) {
                System.err.println("FBObject.resetSamplingSink.X1: zero samples, mod " + bl3 + "\n\tTHIS " + this);
            }
            return bl3;
        }
        boolean bl4 = false;
        if (null == this.samplingSink) {
            this.samplingSink = new FBObject();
            this.samplingSink.init(gL, this.width, this.height, 0);
            this.samplingColorSink = null;
            bl4 = true;
        } else {
            if (!this.samplingSink.initialized) {
                throw new InternalError("InitState Mismatch: samplingSink set, but not initialized " + this.samplingSink);
            }
            if (null == this.samplingColorSink || 0 == this.samplingColorSink.getName()) {
                throw new InternalError("InitState Mismatch: samplingColorSink set, but not initialized " + this.samplingColorSink + ", " + this.samplingSink);
            }
        }
        if (DEBUG) {
            System.err.println("FBObject.resetSamplingSink.1: mod " + bl4 + "\n\tTHIS " + this + ",\n\tSINK " + this.samplingSink);
        }
        boolean bl5 = this.sampleSinkExFormatMismatch(gL);
        boolean bl6 = this.sampleSinkSizeMismatch();
        boolean bl7 = this.sampleSinkDepthStencilMismatch();
        if (bl4) {
            if (bl5 || bl6) {
                throw new InternalError("InitState Mismatch: Matching exFormat " + !bl5 + ", size " + !bl6 + ", " + this);
            }
        } else if (!(bl5 || bl6 || bl7)) {
            if (DEBUG) {
                System.err.println("FBObject.resetSamplingSink.X2: Matching: exFormat " + !bl5 + ", size " + !bl6 + ", depthStencil " + !bl7 + ", mod " + bl4);
            }
            this.samplingSink.modified = false;
            this.modified = false;
            return bl4;
        }
        if (this.isBound()) {
            this.markUnbound();
            bl2 = true;
        } else {
            bl2 = false;
        }
        if (DEBUG) {
            System.err.println("FBObject.resetSamplingSink.2: wasBound " + bl2 + ", matching: exFormat " + !bl5 + ", size " + !bl6 + ", depthStencil " + !bl7);
        }
        bl4 = true;
        if (bl7) {
            this.samplingSink.detachAllRenderbuffer(gL);
        }
        boolean bl8 = bl = null == this.samplingColorSink || this.samplingColorSink.isTextureAttachment();
        if (bl5) {
            this.samplingSink.detachAllColorbuffer(gL);
            this.samplingColorSink = null;
        } else if (bl6) {
            this.samplingSink.resetSizeImpl(gL, this.width, this.height);
            this.samplingColorSink = this.samplingSink.getColorbuffer(0);
        }
        if (null == this.samplingColorSink) {
            Colorbuffer colorbuffer = this.getColorbuffer(0);
            if (null != colorbuffer) {
                this.samplingColorSink = bl ? FBObject.createColorTextureAttachment(gL, colorbuffer.getFormat(), this.width, this.height, 9728, 9728, 33071, 33071) : FBObject.createColorAttachment(colorbuffer.getFormat(), 0, this.width, this.height);
                this.samplingSink.attachColorbuffer(gL, 0, this.samplingColorSink);
            } else {
                boolean bl9 = this.hasAttachmentUsingAlpha();
                this.samplingColorSink = bl ? this.samplingSink.attachTexture2D(gL, 0, bl9) : this.samplingSink.attachColorbuffer(gL, 0, bl9);
            }
        }
        if (bl7) {
            this.samplingSink.attachRenderbuffer(gL, this.depth.format);
            if (null != this.stencil && !this.isDepthStencilPackedFormat()) {
                this.samplingSink.attachRenderbuffer(gL, this.stencil.format);
            }
        }
        bl5 = this.sampleSinkExFormatMismatch(gL);
        bl6 = this.sampleSinkSizeMismatch();
        bl7 = this.sampleSinkDepthStencilMismatch();
        if (bl5 || bl6 || bl7) {
            throw new InternalError("Samples sink mismatch after reset: \n\tTHIS " + this + ",\n\t SINK " + this.samplingSink + "\n\t Mismatch. Matching: exFormat " + !bl5 + ", size " + !bl6 + ", depthStencil " + !bl7);
        }
        this.samplingSink.modified = false;
        this.samplingSink.unbind(gL);
        this.modified = false;
        if (bl2) {
            this.bind(gL);
        }
        if (DEBUG) {
            System.err.println("FBObject.resetSamplingSink.XX: END mod " + bl4 + "\n\tTHIS " + this + ",\n\tSINK " + this.samplingSink + "\n\t Matching: exFormat " + !bl5 + ", size " + !bl6 + ", depthStencil " + !bl7);
        }
        return bl4;
    }

    public FBObject setSamplingSink(FBObject fBObject) throws IllegalStateException, GLException {
        FBObject fBObject2 = this.samplingSink;
        if (null == fBObject) {
            this.samplingSink = null;
            this.samplingColorSink = null;
        } else if (this.samples > 0) {
            if (!fBObject.isInitialized()) {
                throw new IllegalStateException("SamplingSink not initialized: " + fBObject);
            }
            if (fBObject.getNumSamples() > 0) {
                throw new GLException("SamplingSink FBO cannot use MSAA itself: " + fBObject);
            }
            this.samplingSink = fBObject;
            this.samplingColorSink = fBObject.getColorbuffer(0);
        } else {
            throw new GLException("Setting SamplingSink for non MSAA FBO not allowed: " + this);
        }
        this.modified = true;
        this.samplingSinkDirty = true;
        return fBObject2;
    }

    public final void bind(GL gL) throws GLException {
        if (!this.bound || this.fbName != gL.getBoundFramebuffer(36160)) {
            this.checkInitialized();
            if (this.fullFBOSupport) {
                gL.glBindFramebuffer(36009, this.getWriteFramebuffer());
                gL.glBindFramebuffer(36008, this.getReadFramebuffer());
            } else {
                gL.glBindFramebuffer(36160, this.getWriteFramebuffer());
            }
            this.bound = true;
            this.samplingSinkDirty = true;
        }
    }

    public final void unbind(GL gL) throws GLException {
        if (this.bound) {
            if (this.fullFBOSupport) {
                gL.glBindFramebuffer(36009, 0);
                gL.glBindFramebuffer(36008, 0);
            } else {
                gL.glBindFramebuffer(36160, 0);
            }
            this.bound = false;
        }
    }

    public final void markUnbound() {
        this.bound = false;
    }

    public final boolean isBound(GL gL) {
        this.bound = this.bound && this.fbName == gL.getBoundFramebuffer(36160);
        return this.bound;
    }

    public final boolean isBound() {
        return this.bound;
    }

    public final void syncSamplingSink(GL gL) {
        this.markUnbound();
        if (this.samples > 0 && this.samplingSinkDirty) {
            boolean bl;
            this.samplingSinkDirty = false;
            if (this.isModified()) {
                this.resetSamplingSink(gL);
            }
            boolean bl2 = bl = DEBUG || GLContext.DEBUG_GL;
            if (bl) {
                FBObject.checkPreGLError(gL);
            }
            gL.glBindFramebuffer(36008, this.fbName);
            gL.glBindFramebuffer(36009, this.samplingSink.getWriteFramebuffer());
            ((GL2ES3)gL).glBlitFramebuffer(0, 0, this.width, this.height, 0, 0, this.width, this.height, 16384, 9728);
            if (bl) {
                this.checkNoError(null, gL.glGetError(), "FBObject syncSampleSink");
            }
        } else {
            this.modified = false;
        }
        if (this.fullFBOSupport) {
            gL.glBindFramebuffer(36009, 0);
            gL.glBindFramebuffer(36008, 0);
        } else {
            gL.glBindFramebuffer(36160, 0);
        }
    }

    public final void use(GL gL, TextureAttachment textureAttachment) throws IllegalArgumentException {
        this.syncSamplingSink(gL);
        if (null != textureAttachment) {
            gL.glBindTexture(3553, textureAttachment.getName());
        }
    }

    public final void unuse(GL gL) {
        this.unbind(gL);
        gL.glBindTexture(3553, 0);
    }

    public final boolean hasFullFBOSupport() throws GLException {
        this.checkInitialized();
        return this.fullFBOSupport;
    }

    public final boolean supportsRGBA8() throws GLException {
        this.checkInitialized();
        return this.rgba8Avail;
    }

    public final boolean supportsDepth(int n2) throws GLException {
        this.checkInitialized();
        switch (n2) {
            case 16: {
                return true;
            }
            case 24: {
                return this.depth24Avail;
            }
            case 32: {
                return this.depth32Avail;
            }
        }
        return false;
    }

    public final boolean supportsStencil(int n2) throws GLException {
        this.checkInitialized();
        switch (n2) {
            case 1: {
                return this.stencil01Avail;
            }
            case 4: {
                return this.stencil04Avail;
            }
            case 8: {
                return this.stencil08Avail;
            }
            case 16: {
                return this.stencil16Avail;
            }
        }
        return false;
    }

    public final boolean supportsPackedDepthStencil() throws GLException {
        this.checkInitialized();
        return this.packedDepthStencilAvail;
    }

    public final int getMaxColorAttachments() throws GLException {
        this.checkInitialized();
        return this.maxColorAttachments;
    }

    public final int getMaxTextureSize() throws GLException {
        this.checkInitialized();
        return this.maxTextureSize;
    }

    public final int getMaxRenderbufferSize() throws GLException {
        this.checkInitialized();
        return this.maxRenderbufferSize;
    }

    public final int getMaxSamples() throws GLException {
        this.checkInitialized();
        return this.maxSamples;
    }

    public final boolean isInitialized() {
        return this.initialized;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getNumSamples() {
        return this.samples;
    }

    public final int getWriteFramebuffer() {
        return this.fbName;
    }

    public final int getReadFramebuffer() {
        return 0 < this.samples ? (null != this.samplingSink ? this.samplingSink.getReadFramebuffer() : 0) : this.fbName;
    }

    public final int getDefaultReadBuffer() {
        return 36064;
    }

    public final int getColorbufferCount() {
        return this.colorbufferCount;
    }

    public final int getTextureAttachmentCount() {
        return this.textureAttachmentCount;
    }

    public final RenderAttachment getStencilAttachment() {
        return this.stencil;
    }

    public final RenderAttachment getDepthAttachment() {
        return this.depth;
    }

    public final FBObject getSamplingSinkFBO() {
        return this.samplingSink;
    }

    public final Colorbuffer getSamplingSink() {
        return this.samplingColorSink;
    }

    public final boolean isSamplingBufferDirty() {
        return this.samplingSinkDirty;
    }

    public final boolean isModified() {
        return this.modified || null != this.samplingSink && this.samplingSink.modified;
    }

    int objectHashCode() {
        return super.hashCode();
    }

    public final String toString() {
        String string = null != this.colorbufferAttachments ? Arrays.asList(this.colorbufferAttachments).toString() : null;
        return "FBO[name r/w " + this.fbName + "/" + this.getReadFramebuffer() + ", init " + this.initialized + ", bound " + this.bound + ", size " + this.width + "x" + this.height + ", samples " + this.samples + "/" + this.maxSamples + ", modified " + this.modified + "/" + this.isModified() + ", depth " + this.depth + ", stencil " + this.stencil + ", colorbuffer attachments: " + this.colorbufferCount + "/" + this.maxColorAttachments + ", with " + this.textureAttachmentCount + " textures: " + string + ", msaa[" + this.samplingColorSink + ", hasSink " + (null != this.samplingSink) + ", dirty " + this.samplingSinkDirty + "], state " + this.getStatusString() + ", obj " + FBObject.toHexString(this.objectHashCode()) + "]";
    }

    private final void updateStatus(GL gL) {
        this.vStatus = 0 == this.fbName ? -1 : gL.glCheckFramebufferStatus(36160);
    }

    static {
        Debug.initSingleton();
        DEBUG = Debug.debug("FBObject");
        USER_MAX_TEXTURE_SIZE = PropertyAccess.getIntProperty("jogl.debug.FBObject.MaxTextureSize", true, 0);
    }

    public static class TextureAttachment
    extends Attachment
    implements Colorbuffer {
        public final int dataFormat;
        public final int dataType;
        public final int magFilter;
        public final int minFilter;
        public final int wrapS;
        public final int wrapT;
        private final Attachment.StorageDefinition defStorageDefinition = new Attachment.StorageDefinition(){

            @Override
            public void setStorage(GL gL, Attachment attachment) {
                gL.glTexImage2D(3553, 0, format, this.getWidth(), this.getHeight(), 0, dataFormat, dataType, null);
            }
        };

        public TextureAttachment(Attachment.Type type, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
            super(TextureAttachment.validateType(type), n2, n3, n4, n11);
            this.setStorageDefinition(this.defStorageDefinition);
            this.dataFormat = n5;
            this.dataType = n6;
            this.magFilter = n7;
            this.minFilter = n8;
            this.wrapS = n9;
            this.wrapT = n10;
        }

        private static Attachment.Type validateType(Attachment.Type type) {
            switch (type) {
                case COLOR_TEXTURE: 
                case DEPTH_TEXTURE: 
                case STENCIL_TEXTURE: {
                    return type;
                }
            }
            throw new IllegalArgumentException("Invalid type: " + (Object)((Object)type));
        }

        @Override
        public boolean initialize(GL gL) throws GLException {
            boolean bl;
            boolean bl2 = bl = 0 == this.getName();
            if (bl) {
                boolean bl3;
                boolean bl4 = bl3 = DEBUG || GLContext.DEBUG_GL;
                if (bl3) {
                    FBObject.checkPreGLError(gL);
                }
                int[] nArray = new int[]{-1};
                gL.glGenTextures(1, nArray, 0);
                if (0 == nArray[0]) {
                    throw new GLException("null texture, " + this);
                }
                this.setName(nArray[0]);
                gL.glBindTexture(3553, nArray[0]);
                if (0 < this.magFilter) {
                    gL.glTexParameteri(3553, 10240, this.magFilter);
                }
                if (0 < this.minFilter) {
                    gL.glTexParameteri(3553, 10241, this.minFilter);
                }
                if (0 < this.wrapS) {
                    gL.glTexParameteri(3553, 10242, this.wrapS);
                }
                if (0 < this.wrapT) {
                    gL.glTexParameteri(3553, 10243, this.wrapT);
                }
                if (bl3) {
                    boolean bl5 = true;
                    int n2 = gL.glGetError();
                    if (0 == n2) {
                        bl5 = false;
                        this.setStorage(gL);
                        n2 = gL.glGetError();
                    }
                    if (0 != n2) {
                        gL.glDeleteTextures(1, nArray, 0);
                        this.setName(0);
                        throw new GLException("GL Error " + FBObject.toHexString(n2) + " while creating (pre TexImage2D " + bl5 + ") " + this);
                    }
                } else {
                    this.setStorage(gL);
                }
                if (DEBUG) {
                    System.err.println("Attachment.init.X: " + this);
                }
            }
            return bl;
        }

        @Override
        public void free(GL gL) {
            int[] nArray = new int[]{this.getName()};
            if (0 != nArray[0]) {
                if (DEBUG) {
                    System.err.println("Attachment.free.0: " + this);
                }
                gL.glDeleteTextures(1, nArray, 0);
                this.setName(0);
            }
        }

        @Override
        public final boolean isTextureAttachment() {
            return true;
        }

        @Override
        public final TextureAttachment getTextureAttachment() {
            return this;
        }

        @Override
        public final ColorAttachment getColorAttachment() {
            throw new GLException("Not a ColorAttachment, but TextureAttachment");
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + "[type " + (Object)((Object)this.type) + ", target GL_TEXTURE_2D, level 0, format " + FBObject.toHexString(this.format) + ", " + this.getWidth() + "x" + this.getHeight() + ", border 0, dataFormat " + FBObject.toHexString(this.dataFormat) + ", dataType " + FBObject.toHexString(this.dataType) + "; min/mag " + FBObject.toHexString(this.minFilter) + "/" + FBObject.toHexString(this.magFilter) + ", wrap S/T " + FBObject.toHexString(this.wrapS) + "/" + FBObject.toHexString(this.wrapT) + "; name " + FBObject.toHexString(this.getName()) + ", obj " + FBObject.toHexString(this.objectHashCode()) + "]";
        }
    }

    public static class ColorAttachment
    extends RenderAttachment
    implements Colorbuffer {
        public ColorAttachment(int n2, int n3, int n4, int n5, int n6) {
            super(Attachment.Type.COLOR, n2, n3, n4, n5, n6);
        }

        @Override
        public final boolean isTextureAttachment() {
            return false;
        }

        @Override
        public final TextureAttachment getTextureAttachment() {
            throw new GLException("Not a TextureAttachment, but ColorAttachment");
        }

        @Override
        public final ColorAttachment getColorAttachment() {
            return this;
        }
    }

    public static class RenderAttachment
    extends Attachment {
        private int samples;
        private final Attachment.StorageDefinition defStorageDefinition = new Attachment.StorageDefinition(){

            @Override
            public void setStorage(GL gL, Attachment attachment) {
                if (samples > 0) {
                    gL.glRenderbufferStorageMultisample(36161, samples, format, this.getWidth(), this.getHeight());
                } else {
                    gL.glRenderbufferStorage(36161, format, this.getWidth(), this.getHeight());
                }
            }
        };

        public RenderAttachment(Attachment.Type type, int n2, int n3, int n4, int n5, int n6) {
            super(RenderAttachment.validateType(type), n2, n4, n5, n6);
            this.setStorageDefinition(this.defStorageDefinition);
            this.samples = n3;
        }

        public final int getSamples() {
            return this.samples;
        }

        final void setSamples(int n2) {
            this.samples = n2;
        }

        private static Attachment.Type validateType(Attachment.Type type) {
            switch (type) {
                case DEPTH_STENCIL: 
                case DEPTH: 
                case STENCIL: 
                case COLOR: {
                    return type;
                }
            }
            throw new IllegalArgumentException("Invalid type: " + (Object)((Object)type));
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof RenderAttachment)) {
                return false;
            }
            return super.equals(object) && this.samples == ((RenderAttachment)object).samples;
        }

        @Override
        public int hashCode() {
            int n2 = super.hashCode();
            n2 = (n2 << 5) - n2 + this.samples;
            return n2;
        }

        @Override
        public boolean initialize(GL gL) throws GLException {
            boolean bl;
            boolean bl2 = bl = 0 == this.getName();
            if (bl) {
                int n2;
                boolean bl3;
                boolean bl4 = bl3 = DEBUG || GLContext.DEBUG_GL;
                if (bl3) {
                    FBObject.checkPreGLError(gL);
                }
                int[] nArray = new int[]{-1};
                gL.glGenRenderbuffers(1, nArray, 0);
                this.setName(nArray[0]);
                gL.glBindRenderbuffer(36161, this.getName());
                this.setStorage(gL);
                if (bl3 && 0 != (n2 = gL.glGetError())) {
                    gL.glDeleteRenderbuffers(1, nArray, 0);
                    this.setName(0);
                    throw new GLException("GL Error " + FBObject.toHexString(n2) + " while creating " + this);
                }
                if (DEBUG) {
                    System.err.println("Attachment.init.X: " + this);
                }
            }
            return bl;
        }

        @Override
        public void free(GL gL) {
            int[] nArray = new int[]{this.getName()};
            if (0 != nArray[0]) {
                if (DEBUG) {
                    System.err.println("Attachment.free.0: " + this);
                }
                gL.glDeleteRenderbuffers(1, nArray, 0);
                this.setName(0);
            }
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + "[type " + (Object)((Object)this.type) + ", format " + FBObject.toHexString(this.format) + ", samples " + this.samples + ", " + this.getWidth() + "x" + this.getHeight() + ", name " + FBObject.toHexString(this.getName()) + ", obj " + FBObject.toHexString(this.objectHashCode()) + "]";
        }
    }

    public static abstract class Attachment {
        public final Type type;
        public final int format;
        private int width;
        private int height;
        private int name;
        private StorageDefinition storageDefinition;

        protected Attachment(Type type, int n2, int n3, int n4, int n5) {
            this.type = type;
            this.format = n2;
            this.width = n3;
            this.height = n4;
            this.name = n5;
        }

        public void setStorageDefinition(StorageDefinition storageDefinition) {
            this.storageDefinition = storageDefinition;
        }

        protected final void setStorage(GL gL) {
            this.storageDefinition.setStorage(gL, this);
        }

        public final void formatToGLCapabilities(GLCapabilities gLCapabilities, boolean bl) {
            int n2;
            switch (this.format) {
                case 4: 
                case 6408: {
                    n2 = bl ? 32856 : 32854;
                    break;
                }
                case 3: 
                case 6407: {
                    n2 = bl ? 32849 : 36194;
                    break;
                }
                default: {
                    n2 = this.format;
                }
            }
            switch (n2) {
                case 32854: {
                    gLCapabilities.setRedBits(4);
                    gLCapabilities.setGreenBits(4);
                    gLCapabilities.setBlueBits(4);
                    gLCapabilities.setAlphaBits(4);
                    break;
                }
                case 32855: {
                    gLCapabilities.setRedBits(5);
                    gLCapabilities.setGreenBits(5);
                    gLCapabilities.setBlueBits(5);
                    gLCapabilities.setAlphaBits(1);
                    break;
                }
                case 36194: {
                    gLCapabilities.setRedBits(5);
                    gLCapabilities.setGreenBits(6);
                    gLCapabilities.setBlueBits(5);
                    gLCapabilities.setAlphaBits(0);
                    break;
                }
                case 32849: {
                    gLCapabilities.setRedBits(8);
                    gLCapabilities.setGreenBits(8);
                    gLCapabilities.setBlueBits(8);
                    gLCapabilities.setAlphaBits(0);
                    break;
                }
                case 32856: {
                    gLCapabilities.setRedBits(8);
                    gLCapabilities.setGreenBits(8);
                    gLCapabilities.setBlueBits(8);
                    gLCapabilities.setAlphaBits(8);
                    break;
                }
                case 33189: {
                    gLCapabilities.setDepthBits(16);
                    break;
                }
                case 33190: {
                    gLCapabilities.setDepthBits(24);
                    break;
                }
                case 33191: {
                    gLCapabilities.setDepthBits(32);
                    break;
                }
                case 36166: {
                    gLCapabilities.setStencilBits(1);
                    break;
                }
                case 36167: {
                    gLCapabilities.setStencilBits(4);
                    break;
                }
                case 36168: {
                    gLCapabilities.setStencilBits(8);
                    break;
                }
                case 35056: {
                    gLCapabilities.setDepthBits(24);
                    gLCapabilities.setStencilBits(8);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("format invalid: " + FBObject.toHexString(this.format));
                }
            }
        }

        public final int getFormat() {
            return this.format;
        }

        public final int getWidth() {
            return this.width;
        }

        public final int getHeight() {
            return this.height;
        }

        final void setSize(int n2, int n3) {
            this.width = n2;
            this.height = n3;
        }

        public final int getName() {
            return this.name;
        }

        final void setName(int n2) {
            this.name = n2;
        }

        public abstract boolean initialize(GL var1) throws GLException;

        public abstract void free(GL var1) throws GLException;

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Attachment)) {
                return false;
            }
            Attachment attachment = (Attachment)object;
            return this.type == attachment.type && this.format == attachment.format && this.width == attachment.width && this.height == attachment.height && this.name == attachment.name;
        }

        public int hashCode() {
            int n2 = 31 + this.type.ordinal();
            n2 = (n2 << 5) - n2 + this.format;
            n2 = (n2 << 5) - n2 + this.width;
            n2 = (n2 << 5) - n2 + this.height;
            n2 = (n2 << 5) - n2 + this.name;
            return n2;
        }

        int objectHashCode() {
            return super.hashCode();
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[type " + (Object)((Object)this.type) + ", format " + FBObject.toHexString(this.format) + ", " + this.width + "x" + this.height + "; name " + FBObject.toHexString(this.name) + ", obj " + FBObject.toHexString(this.objectHashCode()) + "]";
        }

        public static Type getType(int n2, int n3) {
            if (36064 <= n2 && n2 < 36064 + n3) {
                return Type.COLOR;
            }
            switch (n2) {
                case 36096: {
                    return Type.DEPTH;
                }
                case 36128: {
                    return Type.STENCIL;
                }
            }
            throw new IllegalArgumentException("Invalid attachment point " + FBObject.toHexString(n2));
        }

        public static interface StorageDefinition {
            public void setStorage(GL var1, Attachment var2);
        }

        public static enum Type {
            NONE,
            DEPTH,
            STENCIL,
            DEPTH_STENCIL,
            COLOR,
            COLOR_TEXTURE,
            DEPTH_TEXTURE,
            STENCIL_TEXTURE;


            public static Type determine(int n2) throws IllegalArgumentException {
                switch (n2) {
                    case 32849: 
                    case 32854: 
                    case 32855: 
                    case 32856: 
                    case 36194: {
                        return COLOR;
                    }
                    case 33189: 
                    case 33190: 
                    case 33191: {
                        return DEPTH;
                    }
                    case 36166: 
                    case 36167: 
                    case 36168: {
                        return STENCIL;
                    }
                    case 35056: {
                        return DEPTH_STENCIL;
                    }
                }
                throw new IllegalArgumentException("format invalid: " + FBObject.toHexString(n2));
            }
        }
    }

    public static interface Colorbuffer {
        public boolean initialize(GL var1) throws GLException;

        public void free(GL var1) throws GLException;

        public void formatToGLCapabilities(GLCapabilities var1, boolean var2);

        public boolean isTextureAttachment();

        public TextureAttachment getTextureAttachment();

        public ColorAttachment getColorAttachment();

        public int getFormat();

        public int getWidth();

        public int getHeight();

        public int getName();
    }

    private static enum DetachAction {
        NONE,
        DISPOSE,
        RECREATE;

    }
}

